/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.etf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.etf.ProfileBase;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.ETF.Profile;
import org.omg.ETF._ConnectionLocalBase;

public abstract class ConnectionBase
extends _ConnectionLocalBase
implements Configurable {
    protected boolean connected = false;
    protected ByteArrayOutputStream b_out = null;
    protected int finalTimeout = 20000;
    protected ProfileBase profile = null;
    protected Logger logger;
    protected org.jacorb.config.Configuration configuration;
    protected String connection_info;
    protected ORB orb;

    protected ConnectionBase() {
    }

    protected ConnectionBase(ConnectionBase other) {
        this.b_out = other.b_out;
        this.connection_info = other.connection_info;
        this.finalTimeout = other.finalTimeout;
        this.profile = other.profile;
    }

    public void configure(Configuration config) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)config;
        this.orb = this.configuration.getORB();
        this.logger = this.configuration.getNamedLogger(this.configuration.getLoggerName(this.getClass()));
        if (this.configuration.getAttributeAsBoolean("jacorb.debug.dump_outgoing_messages", false)) {
            this.b_out = new ByteArrayOutputStream();
        }
        this.finalTimeout = this.configuration.getAttributeAsInteger("jacorb.connection.timeout_after_closeconnection", 20000);
    }

    protected abstract void setTimeout(int var1);

    protected abstract int getTimeout();

    public Profile get_server_profile() {
        return this.profile;
    }

    public synchronized boolean is_connected() {
        return this.connected;
    }

    public void turnOnFinalTimeout() {
        this.setTimeout(this.finalTimeout);
    }

    protected abstract COMM_FAILURE handleCommFailure(IOException var1);

    protected COMM_FAILURE to_COMM_FAILURE(IOException exception) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Caught exception", exception);
        }
        return new COMM_FAILURE("IOException: " + exception.toString());
    }

    public boolean wait_next_data(long time_out) {
        throw new NO_IMPLEMENT();
    }

    public boolean supports_callback() {
        return true;
    }

    public boolean use_handle_time_out() {
        return false;
    }

    protected final String getLocalhost() {
        String localhost;
        try {
            localhost = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhe) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Unable to resolve local host - using default 127.0.0.1");
            }
            localhost = "127.0.0.1";
        }
        return localhost;
    }
}

