/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.iiop;

import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.etf.FactoriesBase;
import org.jacorb.orb.iiop.ClientIIOPConnection;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPListener;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.CORBA.INTERNAL;
import org.omg.ETF.Profile;

public class IIOPFactories
extends FactoriesBase {
    public int profile_tag() {
        return 0;
    }

    public Profile decode_corbaloc(String corbaloc) {
        int colon = corbaloc.indexOf(58);
        String token = corbaloc.substring(0, colon).toLowerCase();
        if (token.length() == 0 || "iiop".equals(token) || "ssliop".equals(token)) {
            IIOPProfile result = new IIOPProfile(corbaloc);
            try {
                result.configure(this.configuration);
            }
            catch (ConfigurationException e2) {
                throw new INTERNAL("ConfigurationException: " + e2);
            }
            return result;
        }
        return null;
    }

    public int match_tag(String address) {
        if (address == null) {
            return -1;
        }
        int colon = address.indexOf(58);
        String token = address.substring(0, colon).toLowerCase();
        if ("iiop".equals(token) || "ssliop".equals(token)) {
            return colon + 1;
        }
        return -1;
    }

    static {
        connectionClz = ClientIIOPConnection.class;
        listenerClz = IIOPListener.class;
        profileClz = IIOPProfile.class;
        addressClz = IIOPAddress.class;
    }
}

