/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.portableInterceptor;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ServantDelegate;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.portableInterceptor.RequestInfoImpl;
import org.jacorb.poa.POA;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.Dynamic.Parameter;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableServer.Servant;

public class ServerRequestInfoImpl
extends RequestInfoImpl
implements ServerRequestInfo {
    private byte[] adapter_id = null;
    private String[] adapter_name = null;
    private String target_most_derived_interface = null;
    private Servant servant = null;
    private final ORB orb;
    private final String operation;
    private final boolean response_expected;
    private final int requestId;
    private final byte[] objectId;
    public final ServerRequest request;
    public Any sending_exception = null;

    public ServerRequestInfoImpl(ORB orb, ServerRequest request, Servant servant) {
        this.orb = orb;
        this.request = request;
        this.operation = request.operation();
        this.response_expected = request.responseExpected();
        this.sync_scope = request.syncScope();
        this.requestId = request.requestId();
        this.objectId = request.objectId();
        if (servant != null) {
            this.setServant(servant);
        }
        this.setRequestServiceContexts(request.getServiceContext());
        Logger logger = orb.getConfiguration().getNamedLogger("jacorb.orb.interceptors");
        if (logger.isDebugEnabled()) {
            logger.debug("Found service contexts with IDs of " + this.request_ctx.keySet().toString());
        }
        this.sending_exception = orb.create_any();
    }

    public ServerRequestInfoImpl(ORB orb, ServiceContext[] contexts, Servant servant, byte[] objectId, String operation, boolean response_expected, short sync_scope) {
        this.orb = orb;
        this.operation = operation;
        this.response_expected = response_expected;
        this.sync_scope = sync_scope;
        this.objectId = objectId;
        this.requestId = 0;
        this.request = null;
        if (servant != null) {
            this.setServant(servant);
        }
        if (contexts != null) {
            this.setRequestServiceContexts(contexts);
        }
        this.sending_exception = orb.create_any();
    }

    public final void setServant(Servant servant) {
        this.servant = servant;
        POA poa = (POA)servant._poa();
        this.adapter_id = poa.getPOAId();
        String[] all_ifs = servant._all_interfaces(poa, servant._object_id());
        this.target_most_derived_interface = all_ifs[0];
        ArrayList<String> al = new ArrayList<String>();
        for (POA parent = poa; parent != null; parent = (POA)parent.the_parent()) {
            al.add(parent.the_name());
        }
        int size = al.size();
        this.adapter_name = new String[size];
        int j2 = 0;
        int i2 = size - 1;
        while (i2 >= 0) {
            this.adapter_name[j2] = (String)al.get(i2);
            --i2;
            ++j2;
        }
    }

    public void update() {
        if (this.request != null) {
            SystemException sys_ex;
            Any user_ex;
            if (!this.request.streamBased() && (user_ex = this.request.except()) != null) {
                this.sending_exception = user_ex;
            }
            if ((sys_ex = this.request.getSystemException()) != null) {
                SystemExceptionHelper.insert(this.sending_exception, sys_ex);
            }
            this.forward_reference = this.request.getForwardReference();
        }
    }

    public void updateException(Throwable ex) {
        if (ex instanceof SystemException) {
            SystemExceptionHelper.insert(this.sending_exception, (SystemException)ex);
            this.setReplyStatus((short)1);
        } else if (ex instanceof ForwardRequest) {
            this.forward_reference = ((ForwardRequest)ex).forward;
            this.setReplyStatus((short)3);
        } else if (ex instanceof UserException) {
            SystemExceptionHelper.insert(this.sending_exception, new UNKNOWN("Received UserException " + ex));
            this.setReplyStatus((short)2);
        }
    }

    public Iterator getReplyServiceContexts() {
        return this.reply_ctx.values().iterator();
    }

    public Object target() {
        return this.servant._this_object();
    }

    public Parameter[] arguments() {
        if (this.caller_op != 1 && this.caller_op != 2) {
            throw new BAD_INV_ORDER("The attribute \"arguments\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        if (this.arguments == null) {
            throw new NO_RESOURCES("Stream-based skeletons/stubs do not support this op", 1, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.arguments;
    }

    public TypeCode[] exceptions() {
        throw new NO_RESOURCES("This feature is not supported on the server side", 1, CompletionStatus.COMPLETED_MAYBE);
    }

    public Any result() {
        if (this.caller_op != 2) {
            throw new BAD_INV_ORDER("The attribute \"result\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        Any result = null;
        try {
            if (this.request != null) {
                result = this.request.result();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            throw new NO_RESOURCES("Stream-based skeletons/stubs do not support this op", 1, CompletionStatus.COMPLETED_MAYBE);
        }
        return result;
    }

    public short sync_scope() {
        return this.sync_scope;
    }

    public short reply_status() {
        if (this.caller_op == 1 || this.caller_op == 0) {
            throw new BAD_INV_ORDER("The attribute \"reply_status\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.reply_status;
    }

    public Object forward_reference() {
        if (this.caller_op == 4 || this.reply_status != 3) {
            throw new BAD_INV_ORDER("The attribute \"forward_reference\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.forward_reference;
    }

    public ServiceContext get_reply_service_context(int id) {
        if (this.caller_op == 1 || this.caller_op == 0) {
            throw new BAD_INV_ORDER("The operation \"get_reply_service_context\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        return super.get_reply_service_context(id);
    }

    public String operation() {
        return this.operation;
    }

    public int request_id() {
        return this.requestId;
    }

    public boolean response_expected() {
        return this.response_expected;
    }

    public Any sending_exception() {
        if (this.caller_op != 3) {
            throw new BAD_INV_ORDER("The attribute \"sending_exception\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.sending_exception;
    }

    public byte[] object_id() {
        if (this.caller_op == 0) {
            throw new BAD_INV_ORDER("The attribute \"object_id\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.objectId;
    }

    public byte[] adapter_id() {
        if (this.caller_op == 0) {
            throw new BAD_INV_ORDER("The attribute \"adapter_id\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.adapter_id;
    }

    public String orb_id() {
        if (this.caller_op == 0) {
            throw new BAD_INV_ORDER("The attribute \"orb_id\" is currently invalid!", 14, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.orb.id();
    }

    public String server_id() {
        if (this.caller_op == 0) {
            throw new NO_RESOURCES("The attribute \"server_id\" is not available", 1, CompletionStatus.COMPLETED_MAYBE);
        }
        throw new BAD_INV_ORDER("The attribute \"server_id\" is currently invalid!", 14, CompletionStatus.COMPLETED_MAYBE);
    }

    public String[] adapter_name() {
        if (this.caller_op == 0) {
            throw new BAD_INV_ORDER("The attribute \"adapter_name\" is currently invalid!", 14, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.adapter_name;
    }

    public String target_most_derived_interface() {
        if (this.caller_op == 0) {
            throw new BAD_INV_ORDER("The attribute \"target_most_derived_interface\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.target_most_derived_interface;
    }

    public Policy get_server_policy(int type) {
        if (!this.orb.hasPolicyFactoryForType(type)) {
            throw new INV_POLICY("No PolicyFactory for type " + type + " has been registered!", 2, CompletionStatus.COMPLETED_MAYBE);
        }
        try {
            ServantDelegate delegate = (ServantDelegate)this.servant._get_delegate();
            return delegate._get_policy(this.servant._this_object(), type);
        }
        catch (INV_POLICY e2) {
            e2.minor = 2;
            throw e2;
        }
    }

    public void set_slot(int id, Any data) throws InvalidSlot {
        this.current.set_slot(id, data);
    }

    public boolean target_is_a(String id) {
        if (this.caller_op == 0) {
            throw new BAD_INV_ORDER("The operation \"target_is_a\" is currently invalid!", 10, CompletionStatus.COMPLETED_MAYBE);
        }
        return this.servant._is_a(id);
    }

    public void add_reply_service_context(ServiceContext service_context, boolean replace) {
        Integer _id = ObjectUtil.newInteger(service_context.context_id);
        if (!replace && this.reply_ctx.containsKey(_id)) {
            throw new BAD_INV_ORDER("The ServiceContext with id " + _id.toString() + " has already been set!", 11, CompletionStatus.COMPLETED_MAYBE);
        }
        this.reply_ctx.put(_id, service_context);
    }
}

