/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.util.tracing;

import java.util.Hashtable;
import org.jacorb.util.tracing.Request;
import org.jacorb.util.tracing.TraceData;
import org.jacorb.util.tracing.TraceTreeNode;
import org.jacorb.util.tracing.TracingServicePOA;
import org.jacorb.util.tracing.TracingServicePackage.NoSuchRequestId;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class TracingServiceImpl
extends TracingServicePOA {
    private int pointIds = 0;
    private Hashtable traces = new Hashtable();

    public synchronized int get_id() {
        return this.pointIds++;
    }

    public TraceData getTrace(Request source) throws NoSuchRequestId {
        if (source.originator >= this.pointIds) {
            System.out.println(">>>>>>>>>EXCEPTION!!! - getTrace()");
            throw new NoSuchRequestId();
        }
        System.out.println("getTrace for tracer: " + source.originator + ", rid: " + source.rid);
        Long key = new Long(source.rid);
        TraceTreeNode t2 = (TraceTreeNode)this.traces.get(key);
        if (t2 == null) {
            return new TraceData(new TraceData[0], 0, "", 0L, 0L);
        }
        TraceData result = new TraceData(new TraceData[t2.subtraces.size()], t2.tracer_id, t2.operation, t2.client_time, t2.server_time);
        for (int i2 = 0; i2 < t2.subtraces.size(); ++i2) {
            Request r2 = (Request)t2.subtraces.elementAt(i2);
            result.subtrace[i2] = this.getTrace(r2);
        }
        return result;
    }

    public void logTraceAtPoint(Request origin, String operation, long client_time, long server_time) throws NoSuchRequestId {
        if (origin.originator >= this.pointIds) {
            System.out.println(">>>>>>>>>EXCEPTION!!! - logTraceAtPoint()");
            throw new NoSuchRequestId();
        }
        System.out.println("logTraceAtPoint for tracer: " + origin.originator + ", rid: " + origin.rid);
        Long key = new Long(origin.rid);
        TraceTreeNode t2 = (TraceTreeNode)this.traces.get(key);
        if (t2 == null) {
            t2 = new TraceTreeNode(origin.originator);
            this.traces.put(key, t2);
        }
        t2.operation = operation;
        t2.client_time = client_time;
        t2.server_time = server_time;
    }

    public void registerSubTrace(Request original, Request nested) throws NoSuchRequestId {
        System.out.println("registerSubTrace for tracer: " + original.originator + ", rid: " + original.rid);
        if (original.originator >= this.pointIds || nested.originator >= this.pointIds) {
            System.out.println(">>>>>>>>>EXCEPTION!!! - registerSubTrace()");
            throw new NoSuchRequestId();
        }
        Long key = new Long(original.rid);
        TraceTreeNode t2 = (TraceTreeNode)this.traces.get(key);
        if (t2 == null) {
            t2 = new TraceTreeNode(original.originator);
            this.traces.put(key, t2);
        }
        t2.subtraces.addElement(nested);
    }

    public static void main(String[] args) {
        ORB orb = ORB.init(args, null);
        try {
            POA poa = POAHelper.narrow(orb.resolve_initial_references("RootPOA"));
            poa.the_POAManager().activate();
            Object o2 = poa.servant_to_reference(new TracingServiceImpl());
            NamingContextExt nc = NamingContextExtHelper.narrow(orb.resolve_initial_references("NameService"));
            nc.bind(nc.to_name("tracing.service"), o2);
            poa.the_POAManager().activate();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        orb.run();
    }
}

