/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.com.coli;

import se.ericsson.cello.emt.sshsftpservice.EmSsh;
import se.ericsson.cello.emt.sshsftpservice.SshSftpService;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coli.ColiCongestionException;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coli.ColiException;
import se.ericsson.wcdma.rbs.cabinetviewer.com.coli.ColiSession;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.launch.LauncherData;

public class ColiSessionImpl
implements ColiSession {
    private SshSftpService sshSftpService;
    private String title;
    private EmSsh ssh;

    public ColiSessionImpl(LauncherData launcherData) throws ColiException {
        try {
            this.sshSftpService = (SshSftpService)launcherData.launcher.runResource("/cello/emas/sshservcfg.xml", launcherData.ipAddress, launcherData.properties, null);
            this.title = launcherData.cabinetViewer.toString();
        }
        catch (LauncherException launcherException) {
            throw new ColiException("Unable to start SSH SFTP Service", (Exception)((Object)launcherException));
        }
    }

    @Override
    public void connect() throws ColiException {
        if (this.sshSftpService == null) {
            throw new ColiException("Unable to connect, the SSH SFTP Service has not been started");
        }
        if (this.ssh == null || !this.ssh.isOpen()) {
            try {
                Trace.observation(this, "Opening connection to the ssh session");
                this.ssh = this.sshSftpService.getSsh(this.title);
            }
            catch (Exception exception) {
                throw new ColiException("Unable to connect to the node", exception);
            }
        }
    }

    @Override
    public void disconnect() throws ColiException {
        if (this.ssh != null && this.ssh.isOpen()) {
            Trace.observation(this, "Closing connection to the ssh session");
            this.ssh.exit();
        }
    }

    @Override
    public String send(String string, int n) throws ColiException, ColiCongestionException {
        String string2;
        if (this.ssh == null || !this.ssh.isOpen()) {
            throw new ColiException("Not connected to node");
        }
        Trace.observation(this, "Cmd: " + string);
        try {
            string2 = this.ssh.send(string, (long)n);
            Trace.observation(this, "Result for command " + string + ":\n" + string2);
        }
        catch (Exception exception) {
            Trace.error(this, "Unable to send command " + string, exception);
            throw new ColiException("Unable to send command " + string, exception);
        }
        return string2;
    }
}

