/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Test;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.TestableObject;

public class TestWindow
extends JFrame
implements ChangeListener {
    final Test tester;
    private TestableObject current = null;
    private JButton lockButton = null;
    private JButton unlockButton = null;
    private JButton testButton = null;
    private JButton removeButton = null;
    private ActionListener lockListener = null;
    private ActionListener unlockListener = null;
    private ActionListener testListener = null;
    private ActionListener removeListener = null;
    private MouseListener mouseListener = null;
    private SelectionListener selectionListener = null;
    private JTable table = null;
    final List ongoingTests;

    public TestWindow(Test test) {
        this.tester = test;
        this.ongoingTests = new LinkedList();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.makeTablePanel(), "Center");
        this.getContentPane().add((Component)this.makeButtonsPanel(), "South");
        this.setDefaultCloseOperation(1);
        this.setTitle("Hw Test");
        this.packAndCentralize();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.refreshSelectedRow();
    }

    public void show(Operable operable) {
        int n = this.lookup(operable.getViewableObjectName());
        if (n == -1) {
            TestableObject testableObject = new TestableObject(this.tester, operable);
            testableObject.addChangeListener(this);
            this.ongoingTests.add(testableObject);
            n = this.ongoingTests.size() - 1;
        }
        this.highlight(n);
        this.setVisible(true);
        this.setState(0);
    }

    private void highlight(int n) {
        this.disableAll();
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.table.setRowSelectionInterval(n, n);
        this.current = (TestableObject)this.ongoingTests.get(n);
        this.current.highlight();
    }

    private int lookup(String string) {
        for (int i = 0; i < this.ongoingTests.size(); ++i) {
            if (!((TestableObject)this.ongoingTests.get(i)).getBoardName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void enableLock() {
        this.lockButton.setEnabled(true);
    }

    public void disableLock() {
        this.lockButton.setEnabled(false);
    }

    public void enableUnlock() {
        this.unlockButton.setEnabled(true);
    }

    public void disableUnlock() {
        this.unlockButton.setEnabled(false);
    }

    public void enableTest() {
        this.testButton.setEnabled(true);
    }

    public void disableTest() {
        this.testButton.setEnabled(false);
    }

    public void enableRemove() {
        this.removeButton.setEnabled(true);
    }

    public void disableRemove() {
        this.removeButton.setEnabled(false);
    }

    private void disableAll() {
        this.lockButton.setEnabled(false);
        this.unlockButton.setEnabled(false);
        this.testButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    public void removeTest(TestableObject testableObject) {
        int n = this.lookup(testableObject.getBoardName());
        testableObject.unsubscribeCSNotifications();
        this.ongoingTests.remove(n);
        ((AbstractTableModel)this.table.getModel()).fireTableDataChanged();
        this.table.clearSelection();
    }

    private JPanel makeTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.table = new JTable(new TableModel());
        this.table.setName("HwTestTable");
        this.table.setPreferredScrollableViewportSize(new Dimension(600, 120));
        this.table.setShowGrid(false);
        this.setPreferredSizeForEachColumn(this.table);
        this.table.setSelectionMode(0);
        this.mouseListener = new MouseListener();
        this.table.addMouseListener(this.mouseListener);
        this.selectionListener = new SelectionListener();
        this.table.getSelectionModel().addListSelectionListener(this.selectionListener);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.getViewport().setBackground(Color.white);
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    public void cleanUp() {
        this.lockButton.removeActionListener(this.lockListener);
        this.unlockButton.removeActionListener(this.unlockListener);
        this.testButton.removeActionListener(this.testListener);
        this.removeButton.removeActionListener(this.removeListener);
        this.table.removeMouseListener(this.mouseListener);
        this.table.getSelectionModel().removeListSelectionListener(this.selectionListener);
        this.dispose();
    }

    private JPanel makeButtonsPanel() {
        this.lockButton = new JButton("Lock");
        this.lockButton.setToolTipText("Locks the board in order to prepare it for testing");
        this.lockListener = new LockListener();
        this.lockButton.addActionListener(this.lockListener);
        this.setButtonSize(this.lockButton);
        this.unlockButton = new JButton("Unlock");
        this.unlockButton.setToolTipText("Unlocks the board in order to let the traffic back on");
        this.unlockListener = new UnlockListener();
        this.unlockButton.addActionListener(this.unlockListener);
        this.setButtonSize(this.unlockButton);
        this.testButton = new JButton("Test");
        this.testButton.setToolTipText("Starts testing the board");
        this.testListener = new TestListener();
        this.testButton.addActionListener(this.testListener);
        this.setButtonSize(this.testButton);
        this.removeButton = new JButton("Remove");
        this.removeButton.setToolTipText("Removes the entry from the table");
        this.removeListener = new RemoveListener();
        this.removeButton.addActionListener(this.removeListener);
        this.setButtonSize(this.removeButton);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(this.lockButton);
        jPanel.add(this.unlockButton);
        jPanel.add(this.testButton);
        jPanel.add(this.removeButton);
        return jPanel;
    }

    private void setButtonSize(JButton jButton) {
        Dimension dimension = new Dimension(85, 30);
        jButton.setMinimumSize(dimension);
        jButton.setPreferredSize(dimension);
        jButton.setMaximumSize(dimension);
        jButton.setSize(dimension);
    }

    private void packAndCentralize() {
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getWidth()) / 2;
        int n2 = (dimension.height - this.getHeight()) / 2;
        this.setLocation(n, n2);
    }

    private void setPreferredSizeForEachColumn(JTable jTable) {
        TableColumn tableColumn = null;
        for (int i = 0; i < jTable.getModel().getColumnCount(); ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(60);
                continue;
            }
            tableColumn.setPreferredWidth(120);
        }
    }

    private void refreshSelectedRow() {
        int n = this.table.getSelectedRow();
        this.highlight(n);
    }

    class TableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{"Board", "Result", "Administrative state"};
        final Object[][] data = new Object[0][];

        TableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return TestWindow.this.ongoingTests.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TestableObject testableObject = (TestableObject)TestWindow.this.ongoingTests.get(n);
            switch (n2) {
                case 0: {
                    return testableObject.getBoardName();
                }
                case 1: {
                    return testableObject.getTestResult();
                }
                case 2: {
                    return testableObject.getAdministrativeState();
                }
            }
            return null;
        }
    }

    class SelectionListener
    implements ListSelectionListener {
        SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = TestWindow.this.table.getSelectedRow();
            if (n != -1) {
                TestWindow.this.current = (TestableObject)TestWindow.this.ongoingTests.get(n);
                TestWindow.this.current.highlight();
            }
        }
    }

    class MouseListener
    extends MouseAdapter {
        MouseListener() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            TestWindow.this.refreshSelectedRow();
        }
    }

    class RemoveListener
    implements ActionListener {
        RemoveListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TestWindow.this.disableAll();
            TestWindow.this.current.removeChangeListener(TestWindow.this);
            TestWindow.this.removeTest(TestWindow.this.current);
        }
    }

    class TestListener
    implements ActionListener {
        TestListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TestWindow.this.disableAll();
            TestWindow.this.current.test();
            TestWindow.this.refreshSelectedRow();
        }
    }

    class UnlockListener
    implements ActionListener {
        UnlockListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TestWindow.this.disableAll();
            TestWindow.this.current.unlock();
            TestWindow.this.refreshSelectedRow();
        }
    }

    class LockListener
    implements ActionListener {
        LockListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TestWindow.this.disableAll();
            TestWindow.this.current.lock();
            TestWindow.this.refreshSelectedRow();
        }
    }
}

