/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.actions;

import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.wcdma.rbs.cabinetviewer.NealManager;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CachedMo;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.AdminStateHelper;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.CabinetViewerAction;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.Operable;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public class Unlock
extends CabinetViewerAction {
    private static final String ACTION_DISPLAY_NAME_UNLOCK = "Unlock";
    protected Mo mo = null;
    protected String ldn = null;
    private String msg = null;

    public Unlock(Operable operable, String string) {
        super(operable, ACTION_DISPLAY_NAME_UNLOCK, "");
        this.ldn = string;
        this.mo = this.cmService.getMo(string);
    }

    public Unlock(Operable operable) {
        super(operable, ACTION_DISPLAY_NAME_UNLOCK, "");
        this.init();
    }

    public Unlock() {
        super(ACTION_DISPLAY_NAME_UNLOCK, "");
    }

    @Override
    public void setOperable(Operable operable) {
        super.setOperable(operable);
        this.init();
    }

    private void init() {
        this.ldn = this.operable.getTargetMoLdnForLockUnlock();
        if (this.ldn != null) {
            this.mo = this.cmService.getMo(this.ldn);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.confirmUnlock()) {
            this.performUnlockAction();
        }
    }

    protected String getLdn() {
        return this.ldn;
    }

    protected Mo getMo() {
        return this.mo;
    }

    private boolean confirmUnlock() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isConfirmTechnicianPresent(this.ldn)) {
            this.msg = this.getTechnicianPresentMessage("unlock");
            if (this.isStartWithoutGui()) {
                return true;
            }
            this.showError(this.msg, null);
            return false;
        }
        if (this.isMixedModeRadio((VoData)((Object)this.operable))) {
            stringBuffer.append("Mixed mode radio is used.\n");
        }
        stringBuffer.append("Are you sure you want to unlock ");
        stringBuffer.append(this.getViewableObjectName());
        stringBuffer.append("?");
        this.msg = stringBuffer.toString();
        if (this.isStartWithoutGui()) {
            return true;
        }
        return JOptionPane.showConfirmDialog(null, this.msg, ACTION_DISPLAY_NAME_UNLOCK, 0, 3) == 0;
    }

    private boolean isMixedModeRadio(VoData voData) {
        String[] stringArray = voData.getLdns("Sector*");
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            CachedMo cachedMo = this.operable.getCvSession().getCacheManager().getCachedMo(stringArray[i]);
            if (!cachedMo.getMoType().equals("Sector") && !cachedMo.getMoType().equals("SectorEquipmentFunction")) continue;
            Boolean bl = (Boolean)cachedMo.getAttribute("mixedModeRadio");
            if (bl == null) {
                return false;
            }
            if (!bl.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private void performUnlockAction() {
        Object object;
        Transaction transaction = null;
        try {
            object = this.getCmService();
            Mo mo = this.getMo();
            NameValue nameValue = object.getNameValueFactory().create("administrativeState", 1);
            transaction = object.createTransaction();
            mo.setAttribute(nameValue, transaction);
            transaction.commit();
            Trace.observation(this, "Unlock: " + this.operable.getViewableObjectName());
        }
        catch (Exception exception) {
            if (exception.getMessage().contains("technician present")) {
                this.showError(this.getTechnicianPresentMessage("unlock"), exception);
            } else if (NealManager.isCausedByNodeRestarting(exception)) {
                this.showConnectionError(exception);
            } else {
                this.showOperationError(exception);
            }
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                Trace.error(this, "Rollback failed. " + exception2);
            }
        }
        if (!this.isStartWithoutGui()) {
            object = new AdminStateHelper(this.mo, 0, this.operable);
            ((Thread)object).start();
        }
    }

    @Override
    protected void addOptions(JPanel jPanel, GridBagConstraints gridBagConstraints) {
    }

    @Override
    protected String getText() {
        return null;
    }

    public String getMsg() {
        return this.msg;
    }

    @Override
    protected void performTheAction() {
    }
}

