/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LED;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LedGroup;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.LedGroupManager;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoDataListener;

public class LedPanel
extends JPanel
implements VoDataListener {
    final VoData voData;
    private boolean update;
    private LedGroup ledGroup;
    private Map<String, LED> leds;

    public LedPanel(VoData voData) {
        this.voData = voData;
        new LedGroupManager(this, voData);
        this.update = true;
        this.initialize();
    }

    public void cleanUp() {
        this.update = false;
        if (this.leds != null) {
            Collection<LED> collection = this.leds.values();
            for (LED lED : collection) {
                lED.dispose();
            }
            this.leds.clear();
        }
        this.removeAll();
    }

    private void initialize() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.addLedsIfApplicable();
        this.updateIcons();
        this.voData.addVoDataListener(this);
    }

    private void addLedsIfApplicable() {
        if (this.leds != null) {
            int n = 0;
            boolean bl = this.voData.getSpecificType().equalsIgnoreCase("FAN");
            List list = this.ledGroup.getSortedLeds();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                LED lED = (LED)iterator.next();
                String string = lED.getColorName();
                if (this.displayLed(lED, list)) {
                    if ((string == null || string.equalsIgnoreCase("YELLOW")) && bl) continue;
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridx = 0;
                    gridBagConstraints.gridy = n++;
                    this.add((Component)lED, gridBagConstraints);
                    continue;
                }
                iterator.remove();
            }
        }
    }

    private boolean displayLed(LED lED, List list) {
        boolean bl = true;
        if (lED.getStatusType() == 0) {
            for (LED lED2 : list) {
                if (lED2.equals(lED) || lED2.getPosition() != lED.getPosition()) continue;
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void setBackground(Color color) {
        if (this.leds != null) {
            Collection<LED> collection = this.leds.values();
            for (LED lED : collection) {
                lED.setBackground(color);
                lED.repaint();
            }
        }
    }

    private void updateIcons() {
        if (!this.update) {
            return;
        }
        if (this.leds != null) {
            Collection<LED> collection = this.leds.values();
            for (LED lED : collection) {
                lED.update(lED.getStatusType());
            }
        }
    }

    @Override
    public void voDataChanged(VoData voData, int n) {
        if (this.ledGroup != null) {
            this.ledGroup.updateLedGroup(this.voData);
            this.updateIcons();
        }
    }

    public void setLedGroup(LedGroup ledGroup) {
        this.ledGroup = ledGroup;
        this.leds = ledGroup.getLeds();
        this.addLedsIfApplicable();
        this.updateIcons();
    }

    public LedGroup getLedGroup() {
        return this.ledGroup;
    }
}

