/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;

public class VTextIcon
implements Icon,
PropertyChangeListener {
    static final int POSITION_NORMAL = 0;
    static final int POSITION_TOP_RIGHT = 1;
    static final int POSITION_FAR_TOP_RIGHT = 2;
    public static final int ROTATE_DEFAULT = 0;
    public static final int ROTATE_NONE = 1;
    public static final int ROTATE_LEFT = 2;
    public static final int ROTATE_RIGHT = 4;
    static final String sDrawsInTopRight = "\u3041\u3043\u3045\u3047\u3049\u3063\u3083\u3085\u3087\u308e\u30a1\u30a3\u30a5\u30a7\u30a9\u30c3\u30e3\u30e5\u30e7\u30ee\u30f5\u30f6";
    static final String sDrawsInFarTopRight = "\u3001\u3002";
    static final int DEFAULT_CJK = 1;
    static final int LEGAL_ROMAN = 7;
    static final int DEFAULT_ROMAN = 4;
    static final int LEGAL_MUST_ROTATE = 6;
    static final int DEFAULT_MUST_ROTATE = 2;
    static final double NINETY_DEGREES = Math.toRadians(90.0);
    static final int kBufferSpace = 5;
    String fLabel;
    String[] fCharStrings;
    int[] fCharWidths;
    int[] fPosition;
    int fWidth;
    int fHeight;
    int fCharHeight;
    int fDescent;
    int fRotation;
    Component fComponent;

    public VTextIcon(Component component, String string) {
        this(component, string, 0);
    }

    public VTextIcon(Component component, String string, int n) {
        this.fComponent = component;
        this.fLabel = string;
        this.fRotation = VTextIcon.verifyRotation(string, n);
        this.calcDimensions();
        this.fComponent.addPropertyChangeListener(this);
    }

    public void setLabel(String string) {
        this.fLabel = string;
        this.fRotation = VTextIcon.verifyRotation(string, this.fRotation);
        this.recalcDimensions();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("font".equals(string)) {
            this.recalcDimensions();
        }
    }

    void recalcDimensions() {
        int n = this.getIconWidth();
        int n2 = this.getIconHeight();
        this.calcDimensions();
        if (n != this.getIconWidth() || n2 != this.getIconHeight()) {
            this.fComponent.invalidate();
        }
    }

    void calcDimensions() {
        FontMetrics fontMetrics = this.fComponent.getFontMetrics(this.fComponent.getFont());
        this.fCharHeight = fontMetrics.getAscent() + fontMetrics.getDescent();
        this.fDescent = fontMetrics.getDescent();
        if (this.fRotation == 1) {
            int n = this.fLabel.length();
            char[] cArray = new char[n];
            this.fLabel.getChars(0, n, cArray, 0);
            this.fWidth = 0;
            this.fCharStrings = new String[n];
            this.fCharWidths = new int[n];
            this.fPosition = new int[n];
            for (int i = 0; i < n; ++i) {
                char c = cArray[i];
                this.fCharWidths[i] = fontMetrics.charWidth(c);
                if (this.fCharWidths[i] > this.fWidth) {
                    this.fWidth = this.fCharWidths[i];
                }
                this.fCharStrings[i] = new String(cArray, i, 1);
                this.fPosition[i] = sDrawsInTopRight.indexOf(c) >= 0 ? 1 : (sDrawsInFarTopRight.indexOf(c) >= 0 ? 2 : 0);
            }
            this.fHeight = this.fCharHeight * n + this.fDescent;
        } else {
            this.fWidth = this.fCharHeight;
            this.fHeight = fontMetrics.stringWidth(this.fLabel) + 10;
        }
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        graphics.setColor(component.getForeground());
        if (this.fRotation == 1) {
            int n3 = n2 + this.fCharHeight;
            for (int i = 0; i < this.fCharStrings.length; ++i) {
                switch (this.fPosition[i]) {
                    case 0: {
                        graphics.drawString(this.fCharStrings[i], n + (this.fWidth - this.fCharWidths[i]) / 2, n3);
                        break;
                    }
                    case 1: {
                        int n4 = this.fCharHeight / 3;
                        graphics.drawString(this.fCharStrings[i], n + n4 / 2, n3 - n4);
                        break;
                    }
                    case 2: {
                        int n4 = this.fCharHeight - this.fCharHeight / 3;
                        graphics.drawString(this.fCharStrings[i], n + n4 / 2, n3 - n4);
                        break;
                    }
                }
                n3 += this.fCharHeight;
            }
        } else if (this.fRotation == 2) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(n + this.fWidth, n2 + this.fHeight);
            graphics2D.rotate(-NINETY_DEGREES);
            graphics2D.drawString(this.fLabel, 5, -this.fDescent);
            graphics2D.rotate(NINETY_DEGREES);
            graphics.translate(-(n + this.fWidth), -(n2 + this.fHeight));
        } else if (this.fRotation == 4) {
            graphics.translate(n, n2);
            ((Graphics2D)graphics).rotate(NINETY_DEGREES);
            graphics.drawString(this.fLabel, 5, -this.fDescent);
            ((Graphics2D)graphics).rotate(-NINETY_DEGREES);
            graphics.translate(-n, -n2);
        }
    }

    @Override
    public int getIconWidth() {
        return this.fWidth;
    }

    @Override
    public int getIconHeight() {
        return this.fHeight;
    }

    public static int verifyRotation(String string, int n) {
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        int n3 = string.length();
        char[] cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        for (n2 = 0; n2 < n3; ++n2) {
            char c = cArray[n2];
            if (c >= '\u4e00' && c <= '\u9fff' || c >= '\u3400' && c <= '\u4dff' || c >= '\uf900' && c <= '\ufaff' || c >= '\u3040' && c <= '\u309f' || c >= '\u30a0' && c <= '\u30ff') {
                bl = true;
            }
            if (!(c >= '\u0590' && c <= '\u05ff' || c >= '\u0600' && c <= '\u06ff') && (c < '\u0700' || c > '\u074f')) continue;
            bl2 = true;
        }
        if (bl) {
            return 1;
        }
        int n4 = n2 = bl2 ? 6 : 7;
        if ((n & n2) > 0) {
            return n;
        }
        return bl2 ? 2 : 4;
    }
}

