/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.state;

import java.net.URL;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.state.StateImageJLabel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.info.state.StateViewable;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoDataListener;

public class AdminStateJLabel
extends StateImageJLabel
implements VoDataListener {
    public static final int LOCKED = 0;
    public static final int UNLOCKED = 1;
    public static final int SHUTTING_DOWN = 2;
    private ImageIcon imageIcon;

    public AdminStateJLabel(VoData voData) {
        this(voData, -1);
    }

    public AdminStateJLabel(VoData voData, int n) {
        super(voData, n);
        voData.addVoDataListener(this);
    }

    @Override
    protected void setStateMapping() {
        Map map = this.getStateMapping();
        map.put(-1, "Unavailable");
        map.put(0, "Locked");
        map.put(1, "Unlocked");
        map.put(2, "Shutting down");
        map.put("Unavailable", -1);
        map.put("Locked", 0);
        map.put("Unlocked", 1);
        map.put("Shutting down", 2);
    }

    @Override
    protected void createImageIcon() {
        String string = null;
        String string2 = null;
        switch (this.getCurrentState()) {
            case -1: {
                string = "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/state/EmptyImage.gif";
                break;
            }
            case 0: {
                string = "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/state/AdminStateLocked.gif";
                break;
            }
            case 1: {
                string = "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/state/EmptyImage.gif";
                break;
            }
            case 2: {
                string = "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/state/AdminStateLocked.gif";
                break;
            }
            default: {
                string = "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/state/EmptyImage.gif";
            }
        }
        string2 = IMAGE_LOCATION_IN_VOB + string;
        URL uRL = this.getClass().getResource(string);
        this.imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon(string2);
        this.setIcon(this.imageIcon);
    }

    private void updateToolTipText() {
        int n = this.getCurrentState();
        String string = this.getStateMapping().get(n).toString();
        switch (n) {
            case 0: {
                this.setToolTipText(string);
                break;
            }
            case 2: {
                this.setToolTipText(string);
                break;
            }
            default: {
                JComponent jComponent;
                VoData voData = this.getVoData();
                if (voData == null || (jComponent = (JComponent)this.getParent()) == null) break;
                String string2 = jComponent.getToolTipText();
                this.setToolTipText(string2);
            }
        }
    }

    @Override
    public void voDataChanged(VoData voData, int n) {
        Object object = ((StateViewable)((Object)voData)).getAdminState();
        this.updateCurrentState(object);
        this.updateToolTipText();
        this.repaint();
    }
}

