/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.info;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.info.InfoView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.info.Item;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.info.UseItem;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoData;

public abstract class AbstractGroup
implements InfoView {
    private String groupName;
    private String label;
    private LinkedHashMap<String, Item> itemsHash;

    public AbstractGroup(String string) {
        this.groupName = string;
        this.itemsHash = new LinkedHashMap();
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void addItem(String string, Item item) {
        this.itemsHash.put(string, item);
    }

    @Override
    public Item getItem(String string) {
        Item item = this.itemsHash.get(string);
        this.updateUseItemRef(item);
        return item;
    }

    protected void updateUseItemRef(Item item) {
        UseItem useItem;
        Item item2;
        if (item instanceof UseItem && (item2 = (useItem = (UseItem)item).getUseItemRef()) == null) {
            String string = useItem.getUseItemName();
            Item item3 = this.getItem(string);
            useItem.setUseItemRef(item3);
        }
    }

    @Override
    public int getNoOfItems() {
        return this.itemsHash.size();
    }

    @Override
    public List<Item> getItems() {
        if (this.itemsHash.isEmpty()) {
            return null;
        }
        ArrayList<Item> arrayList = new ArrayList<Item>();
        for (Item item : this.itemsHash.values()) {
            this.updateUseItemRef(item);
            arrayList.add(item);
        }
        return arrayList;
    }

    @Override
    public String getGroupLabel() {
        return this.label;
    }

    @Override
    public void setGroupLabel(String string) {
        this.label = string;
    }

    @Override
    public boolean isApplicable(VoData voData) {
        for (Item item : this.itemsHash.values()) {
            Object object = item.getValue(voData);
            if (object != null && object.equals("Not Applicable")) continue;
            return true;
        }
        return false;
    }
}

