/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.OverlayLayout;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import se.ericsson.wcdma.rbs.cabinetviewer.common.ErrorDialog;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.About;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.AlarmSuppressionAction;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.CabinetViewerAction;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.ClearTechnicianPresent;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.NodeRefresh;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.actions.StopRefresh;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.alarmlist.AlarmListApplication;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.cabinet.PhysicalView;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow.BlinkingLed;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow.MainWindowController;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow.StatusNotifListener;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.mainwindow.TaskbarManager;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.provider.ResourcesPathProvider;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.ViewableObject;

public class MainWindowView
extends JFrame
implements StatusNotifListener {
    private JMenuBar menuBar;
    JMenu fileMenu;
    JMenu viewMenu;
    JMenu alarmMenu;
    JMenu helpMenu;
    private JSplitPane splitPane;
    private JPanel actionsPanel;
    private JScrollPane browserScroller = null;
    private JPanel detailsPanel = null;
    private JPanel statusBar = null;
    private MainWindowController controller;
    private JTabbedPane tabs = null;
    private JPanel jpStatus = new JPanel();
    private JLabel jStatusLabel = new JLabel();
    private JProgressBar jProgress = new JProgressBar();
    private JMenuItem itemStopRefresh;
    private JMenuItem itemAlarmSuppressionON;
    private JMenuItem itemAlarmSuppressionOFF;
    private JLabel connectionStatus;
    private BlinkingLed connectedLed;
    private TaskbarManager taskbarManager;
    private Component physicalView;
    private AlarmListApplication alarmList = null;
    private JLayeredPane layeredPhysicalViewContainer;
    private JPanel iconBar = null;
    private JLabel technicianPresentStatus;
    private ImageIcon technicianPresentIcon;
    private ImageIcon emptyImageIcon;
    private Boolean technicianPresentSupported = false;
    private Boolean alarmSuppressedModeSupported;

    public MainWindowView(MainWindowController mainWindowController) {
        this.controller = mainWindowController;
        this.alarmSuppressedModeSupported = this.controller.supportsAlarmSuppressed();
        this.initialise();
    }

    public void initialise() {
        this.initializeTechnicianPresent();
        this.initializeJMenuBar();
        this.initializeIconBar();
        this.browserScroller = new JScrollPane();
        this.browserScroller.setColumnHeaderView(this.iconBar);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
        this.browserScroller.setCorner("UPPER_RIGHT_CORNER", jPanel);
        this.browserScroller.setName("leftSplitPanel");
        this.detailsPanel = new JPanel(new BorderLayout());
        this.splitPane = new JSplitPane(1, this.browserScroller, this.detailsPanel);
        this.splitPane.setAutoscrolls(true);
        this.splitPane.setContinuousLayout(false);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setResizeWeight(0.0);
        int n = this.splitPane.getDividerSize();
        if (n < 10) {
            this.splitPane.setDividerSize(10);
        }
        this.splitPane.setBackground(Color.white);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.splitPane, "Center");
        jPanel2.add((Component)this.makeStatusBar(), "South");
        container.add((Component)jPanel2, "Center");
        this.updateToolbar();
        this.taskbarManager = new TaskbarManager(this.controller);
        this.layeredPhysicalViewContainer = new JLayeredPane(){

            @Override
            public boolean isOptimizedDrawingEnabled() {
                return false;
            }
        };
        this.layeredPhysicalViewContainer.setLayout(new OverlayLayout(this.layeredPhysicalViewContainer));
        container.add((Component)this.taskbarManager.getTaskbar(), "North");
    }

    private void initializeTechnicianPresent() {
        this.technicianPresentSupported = this.controller.supportsTechnicianPresent();
        if (this.technicianPresentSupported.booleanValue()) {
            this.controller.startTechnicianPresentValuePolling();
        }
    }

    private void initializeIconBar() {
        this.iconBar = new JPanel(new GridBagLayout());
        this.technicianPresentIcon = this.makeTechnicianPresentIcon();
        this.emptyImageIcon = this.makeEmptyImageIcon();
        this.technicianPresentStatus = new JLabel();
        if (this.technicianPresentSupported.booleanValue()) {
            Boolean bl = this.controller.getTechnicianPresentAttributeValue();
            if (bl != null) {
                this.setTechnicianPresent(bl);
            }
        } else {
            this.setTechnicianPresent(false);
        }
        this.iconBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
    }

    protected void setTechnicianPresent(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 10, 2, 550);
        this.technicianPresentStatus.setName("TechnicianPresentStatusIcon");
        if (bl) {
            this.technicianPresentStatus.setIcon(this.technicianPresentIcon);
            this.technicianPresentStatus.setToolTipText("Note: Technician Present at this site");
        } else {
            this.technicianPresentStatus.setIcon(this.emptyImageIcon);
            this.technicianPresentStatus.setToolTipText("");
        }
        this.iconBar.add((Component)this.technicianPresentStatus, gridBagConstraints);
        this.iconBar.repaint();
    }

    private void initializeJMenuBar() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("NE");
        this.fileMenu.setMnemonic('N');
        this.viewMenu = new JMenu("View");
        this.viewMenu.setMnemonic('V');
        this.alarmMenu = new JMenu("Alarm");
        this.alarmMenu.setMnemonic('A');
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic('H');
        JMenuItem jMenuItem = new JMenuItem("Clear Technician Present", 67);
        this.itemAlarmSuppressionON = new JMenuItem("Alarm Suppressed Mode ON");
        this.itemAlarmSuppressionOFF = new JMenuItem("Alarm Suppressed Mode OFF");
        JMenuItem jMenuItem2 = new JMenuItem("Exit", 120);
        JMenuItem jMenuItem3 = new JMenuItem("Refresh All", 82);
        this.itemStopRefresh = new JMenuItem("Stop Refresh", 83);
        this.itemStopRefresh.setEnabled(false);
        JMenuItem jMenuItem4 = new JMenuItem("Alarm list", 65);
        JMenuItem jMenuItem5 = new JMenuItem("About", 65);
        if (this.alarmSuppressedModeSupported.booleanValue()) {
            this.itemAlarmSuppressionON.addActionListener(new ActionListener(){
                AlarmSuppressionAction alarmSuppressAction;
                {
                    this.alarmSuppressAction = new AlarmSuppressionAction(MainWindowView.this.controller.getPhysicalView().getController().findCabinetRbsVo());
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.alarmSuppressAction.actionPerformed(actionEvent);
                    MainWindowView.this.controller.enableMenuItemAlarmSuppression();
                }
            });
            this.itemAlarmSuppressionOFF.addActionListener(new ActionListener(){
                AlarmSuppressionAction alarmSuppressAction;
                {
                    this.alarmSuppressAction = new AlarmSuppressionAction(MainWindowView.this.controller.getPhysicalView().getController().findCabinetRbsVo());
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = MainWindowView.this.controller.getTechnicianPresentAttributeValue();
                    if (bl) {
                        String string = "Cabinet Viewer error";
                        String string2 = "Alarm suppressed mode can not be turned off.";
                        String string3 = "Alarm suppressed mode can not be turned off while technician is present.";
                        ErrorDialog errorDialog = new ErrorDialog(MainWindowView.this.controller.getMainWindow(), string, true, string2, string3);
                        errorDialog.setVisible(true);
                    } else {
                        this.alarmSuppressAction.actionPerformed(actionEvent);
                        MainWindowView.this.controller.enableMenuItemAlarmSuppression();
                    }
                }
            });
            this.fileMenu.addMenuListener(new MenuListener(){
                AlarmSuppressionAction alarmSuppressAction;
                {
                    this.alarmSuppressAction = new AlarmSuppressionAction(MainWindowView.this.controller.getPhysicalView().getController().findCabinetRbsVo());
                }

                @Override
                public void menuSelected(MenuEvent menuEvent) {
                    MainWindowView.this.controller.enableMenuItemAlarmSuppression();
                }

                @Override
                public void menuDeselected(MenuEvent menuEvent) {
                }

                @Override
                public void menuCanceled(MenuEvent menuEvent) {
                }
            });
        }
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainWindowView.this.controller.getCvSession().getCvSessionController().exit();
            }
        });
        jMenuItem3.addActionListener(new NodeRefresh(this.controller.getPhysicalView()));
        this.itemStopRefresh.addActionListener(new StopRefresh(this.controller.getPhysicalView().getController()));
        if (this.technicianPresentSupported.booleanValue()) {
            jMenuItem.addActionListener(new ActionListener(){
                ViewableObject cabinetRbsVo;
                CabinetViewerAction clearTP;
                {
                    this.cabinetRbsVo = MainWindowView.this.controller.getPhysicalView().getController().findCabinetRbsVo();
                    this.clearTP = new ClearTechnicianPresent(this.cabinetRbsVo);
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.clearTP.actionPerformed(actionEvent);
                    if (!MainWindowView.this.controller.isTechnicianPresent().booleanValue()) {
                        MainWindowView.this.controller.updateTpStatus(false);
                    }
                }
            });
        }
        jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainWindowView.this.alarmList == null) {
                    MainWindowView.this.alarmList = new AlarmListApplication(MainWindowView.this.controller);
                }
                AlarmListApplication.startEmasAlarmListApplication(MainWindowView.this.alarmList);
            }
        });
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                About about = new About();
                about.actionPerformed(actionEvent);
            }
        });
        if (this.technicianPresentSupported.booleanValue()) {
            jMenuItem.setEnabled(false);
            this.fileMenu.add(jMenuItem);
            Boolean bl = this.controller.getTechnicianPresentAttributeValue();
            if (bl != null) {
                this.enableClearTechnicianPresent(bl);
            }
        }
        if (this.alarmSuppressedModeSupported.booleanValue()) {
            this.fileMenu.add(this.itemAlarmSuppressionON);
            this.fileMenu.add(this.itemAlarmSuppressionOFF);
        }
        this.fileMenu.add(jMenuItem2);
        this.viewMenu.add(jMenuItem3);
        this.viewMenu.add(this.itemStopRefresh);
        this.alarmMenu.add(jMenuItem4);
        this.helpMenu.add(jMenuItem5);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.viewMenu);
        this.menuBar.add(this.alarmMenu);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
    }

    protected void enableClearTechnicianPresent(boolean bl) {
        if (!this.isReadOnlyMode()) {
            this.fileMenu.getItem(0).setEnabled(bl);
        }
    }

    private boolean isReadOnlyMode() {
        return this.controller.getCvSession().getAccessLevel() != 1;
    }

    protected JMenuItem getItemAlarmSuppressionON() {
        return this.itemAlarmSuppressionON;
    }

    protected JMenuItem getItemAlarmSuppressionOFF() {
        return this.itemAlarmSuppressionOFF;
    }

    protected AlarmListApplication getAlarmList() {
        return this.alarmList;
    }

    public TaskbarManager getTaskbarManager() {
        return this.taskbarManager;
    }

    public void initializeSectorViewer(JComponent jComponent) {
        this.taskbarManager.createSectorMenu();
        this.layeredPhysicalViewContainer.add(jComponent);
        this.layeredPhysicalViewContainer.moveToFront(jComponent);
        this.validate();
    }

    public void updateToolbar() {
        if (this.actionsPanel == null) {
            this.actionsPanel = new JPanel(new GridBagLayout());
        }
        this.actionsPanel.setName("Actions");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.actionsPanel.removeAll();
        this.actionsPanel.repaint();
        JButton[] jButtonArray = this.controller.getActionManager().getAllActionsAsButtons();
        for (int i = 0; i < jButtonArray.length; ++i) {
            gridBagConstraints.insets = i == 0 ? new Insets(20, 3, 0, 3) : new Insets(3, 3, 0, 3);
            this.actionsPanel.add((Component)jButtonArray[i], gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 100.0;
        this.actionsPanel.add((Component)new JPanel(), gridBagConstraints);
        this.actionsPanel.repaint();
    }

    public void setLeftPane(Component component) {
        this.physicalView = component;
        this.layeredPhysicalViewContainer.add(this.physicalView, JLayeredPane.FRAME_CONTENT_LAYER);
        this.browserScroller.setViewportView(this.layeredPhysicalViewContainer);
        this.splitPane.setDividerLocation(this.browserScroller.getPreferredSize().width + 10);
    }

    public void setRightPane(Component[] componentArray, String string) {
        int n = this.splitPane.getDividerLocation();
        JTabbedPane jTabbedPane = this.makeComponentForContents(componentArray);
        JLabel jLabel = this.makeComponentForLatestRefreshTime(string);
        this.detailsPanel.removeAll();
        this.detailsPanel.add((Component)this.actionsPanel, "East");
        this.detailsPanel.add((Component)jTabbedPane, "Center");
        this.detailsPanel.add((Component)jLabel, "South");
        this.detailsPanel.repaint();
        this.detailsPanel.validate();
        this.splitPane.setDividerLocation(n);
    }

    private JTabbedPane makeComponentForContents(Component[] componentArray) {
        int n = 0;
        if (this.tabs != null) {
            n = this.tabs.getSelectedIndex();
        }
        this.tabs = new JTabbedPane();
        this.tabs.setName("summaryTabpane");
        for (int i = 0; i < componentArray.length; ++i) {
            JScrollPane jScrollPane = null;
            JScrollPane jScrollPane2 = new JScrollPane(componentArray[i]);
            if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true")) {
                jScrollPane2.setName(componentArray[i].getName() + "ScrollPane");
            } else {
                jScrollPane2.setName(componentArray[i].getName());
            }
            jScrollPane = jScrollPane2;
            if (System.getProperty("AUT_GUI_TESTS_RUNNING", "false").equals("true")) {
                this.tabs.add((Component)jScrollPane, componentArray[i].getName());
                continue;
            }
            this.tabs.add(jScrollPane);
        }
        this.tabs.setSelectedIndex(n);
        return this.tabs;
    }

    private JLabel makeComponentForLatestRefreshTime(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" Latest refresh ");
        stringBuffer.append(string);
        JLabel jLabel = this.makeInformationStrip(stringBuffer.toString());
        jLabel.setName("LatestRefreshTimeLabel");
        return jLabel;
    }

    public void packAndCentralize() {
        this.pack();
        int n = this.getWidth();
        int n2 = 0;
        if (this.physicalView != null) {
            n2 = this.physicalView.getMinimumSize().height;
            n2 += this.menuBar.getHeight() + this.iconBar.getHeight() + this.taskbarManager.getTaskbar().getHeight() + this.statusBar.getHeight() + 35;
        } else {
            n2 = this.getHeight();
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = (dimension.width - n) / 2;
        int n4 = (dimension.height - n2) / 2;
        if (n3 < 0) {
            n3 = 0;
            n = dimension.width;
        }
        if (n4 < 0) {
            n4 = 0;
            n2 = (int)((double)dimension.height * 0.95);
        }
        this.setBounds(n3, n4, n, n2);
    }

    private JPanel makeStatusBar() {
        this.statusBar = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        jLabel.setIcon(this.makeEricssonIcon());
        jPanel.add(jLabel);
        this.statusBar.add((Component)jPanel, "West");
        JPanel jPanel2 = new JPanel();
        this.connectionStatus = this.makeInformationStrip("Connection status:");
        this.showConnected(true);
        jPanel2.add(this.connectionStatus);
        this.connectedLed = new BlinkingLed(Color.GREEN);
        this.connectedLed.setToolTipText("OK");
        this.connectionStatus.setToolTipText("OK");
        jPanel2.add(this.connectedLed);
        this.statusBar.add((Component)jPanel2, "East");
        this.jStatusLabel.setText("Processing...   ");
        this.jpStatus.setLayout(new BorderLayout());
        this.jStatusLabel.setPreferredSize(new Dimension(250, 20));
        this.jpStatus.add((Component)this.jStatusLabel, "West");
        this.jpStatus.add((Component)this.jProgress, "Center");
        this.jpStatus.add((Component)new JLabel("  "), "East");
        this.jProgress.setForeground(SystemColor.activeCaption);
        this.jProgress.setStringPainted(true);
        this.jStatusLabel.setVisible(false);
        this.jProgress.setVisible(false);
        Dimension dimension = new Dimension(261, 19);
        this.jpStatus.setPreferredSize(dimension);
        this.jpStatus.setVisible(true);
        this.statusBar.add((Component)this.jpStatus, "Center");
        return this.statusBar;
    }

    private JLabel makeInformationStrip(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Color.black);
        jLabel.setFont(new Font(null, 0, 11));
        return jLabel;
    }

    private ImageIcon makeEricssonIcon() {
        String string = ResourcesPathProvider.IMAGE_LOCATION_IN_VOB + "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/Ericsson.gif";
        URL uRL = this.getClass().getResource("/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/Ericsson.gif");
        ImageIcon imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon(string);
        return imageIcon;
    }

    private ImageIcon makeTechnicianPresentIcon() {
        String string = ResourcesPathProvider.IMAGE_LOCATION_IN_VOB + "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/TechnicianPresent_20px.png";
        URL uRL = this.getClass().getResource("/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/TechnicianPresent_20px.png");
        ImageIcon imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon(string);
        return imageIcon;
    }

    private ImageIcon makeEmptyImageIcon() {
        String string = ResourcesPathProvider.IMAGE_LOCATION_IN_VOB + "/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/EmptyImage.gif";
        URL uRL = this.getClass().getResource("/se/ericsson/wcdma/rbs/cabinetviewer/gui/resources/images/TechnicianPresent_20px_empty.png");
        ImageIcon imageIcon = uRL != null ? new ImageIcon(uRL) : new ImageIcon(string);
        return imageIcon;
    }

    @Override
    public void showStatus() {
        this.jProgress.setVisible(true);
        this.jStatusLabel.setVisible(true);
        this.jProgress.repaint();
        this.jStatusLabel.repaint();
    }

    @Override
    public void hideStatus() {
        this.jStatusLabel.setVisible(false);
        this.jProgress.setVisible(false);
        this.jProgress.repaint();
        this.jStatusLabel.repaint();
    }

    public void showConnected(boolean bl) {
        if (this.connectedLed == null) {
            return;
        }
        if (bl) {
            this.connectionStatus.setToolTipText("OK");
            this.connectedLed.setToolTipText("OK");
            this.connectedLed.setColor(Color.GREEN);
            this.connectedLed.haltBlink();
        } else {
            this.connectionStatus.setToolTipText("Connection lost.");
            this.connectedLed.setToolTipText("Connection lost.");
            this.connectedLed.setColor(Color.RED);
            this.connectedLed.startBlink();
        }
    }

    @Override
    public void setStatusMessage(String string) {
        this.jStatusLabel.setText(string + "  ");
    }

    @Override
    public void setProgressMaximum(int n) {
        int n2 = this.jProgress.getValue();
        this.jProgress.setMaximum(n);
        this.jProgress.setValue(n2);
    }

    @Override
    public int getProgressMaximum() {
        return this.jProgress.getMaximum();
    }

    @Override
    public void setProgressValue(int n) {
        this.jProgress.setValue(n);
    }

    @Override
    public void stepProgress() {
        this.jProgress.setValue(this.jProgress.getValue() + 1);
        if (this.jProgress.getValue() >= this.jProgress.getMaximum()) {
            this.hideStatus();
        }
    }

    public void stop() {
        this.connectedLed.stopThread();
    }

    public JScrollPane getBrowserScroller() {
        return this.browserScroller;
    }

    @Override
    public void setStopRefreshEnabled(boolean bl) {
        Trace.observation("Setting stopRefreshEnabled to " + Boolean.toString(bl));
        ((PhysicalView)this.physicalView).setStopRefreshEnabled(bl);
        this.itemStopRefresh.setEnabled(bl);
    }
}

