/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer;

import java.util.Arrays;
import java.util.List;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CacheManager;
import se.ericsson.wcdma.rbs.cabinetviewer.cache.CachedMo;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.ViewableObject;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.VoTemplate;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer.AbstractSectorViewerModel;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer.SectorBranchData;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.sectorviewer.SectorNamesComparator;

public abstract class AbstractSectorViewerManager {
    protected final CacheManager cacheMan;
    protected final List<CachedMo> listOfsectorMo;
    protected final String[] branchNames;
    protected AbstractSectorViewerModel model = null;
    private String[] sectorNames = null;
    final SectorBranchData.RADIO_STANDARD radio_standard;

    public AbstractSectorViewerManager(CacheManager cacheManager, List<CachedMo> list, SectorBranchData.RADIO_STANDARD rADIO_STANDARD, String[] stringArray) {
        this.cacheMan = cacheManager;
        this.listOfsectorMo = list;
        this.branchNames = stringArray;
        this.radio_standard = rADIO_STANDARD;
        if (list != null && !list.isEmpty()) {
            Trace.observation(this, "SectorViewerManager found an " + (Object)((Object)rADIO_STANDARD) + "-node");
        }
        this.setSectorNames(list);
    }

    public AbstractSectorViewerModel getSectorViewerModel() {
        return this.model;
    }

    public String[] getSectorNames() {
        return this.sectorNames;
    }

    public String[] getBranchNames() {
        return this.branchNames;
    }

    protected void setSectorNames(List list) {
        int n = list.size();
        this.sectorNames = new String[n];
        for (int i = 0; i < n; ++i) {
            CachedMo cachedMo = (CachedMo)list.get(i);
            this.sectorNames[i] = cachedMo.getName();
        }
        Arrays.sort(this.sectorNames, new SectorNamesComparator());
    }

    protected abstract void setInitialData();

    public abstract void doMatching(List<VoTemplate> var1, List<ViewableObject> var2);

    protected void traceObservation() {
        for (String string : this.sectorNames) {
            if (this.branchNames == null) continue;
            if (this.branchNames.length == 0) {
                this.traceObservation(string, "");
                continue;
            }
            for (String string2 : this.branchNames) {
                this.traceObservation(string, string2);
            }
        }
    }

    private void traceObservation(String string, String string2) {
        List<CachedMo> list;
        String string3 = string;
        if (!"".equals(string2)) {
            string3 = string3 + ":" + string2;
        }
        if ((list = this.model.getListOfCachedMos(string, string2)) == null || list.isEmpty()) {
            Trace.observation(this, "No discovered equipment for  Sector Viewer with name: " + string3);
            return;
        }
        Trace.observation(this, "Discovered equipment for  Sector Viewer with name: " + string3);
        for (CachedMo cachedMo : list) {
            Trace.observation(this, "    " + cachedMo.getLdn());
        }
    }
}

