/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JPanel;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import se.ericsson.wcdma.rbs.cabinetviewer.common.Trace;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.FormPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.gui.infopanels.ViewFormPanel;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary.AbstractSummary;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary.ConverterElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary.FormPanelElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary.TabbedPanelElement;
import se.ericsson.wcdma.rbs.cabinetviewer.vib.xml.model.summary.TablePanelElement;

public class SummaryElement
extends AbstractSummary {
    private List<ConverterElement> converters = new ArrayList<ConverterElement>();
    private List<FormPanelElement> formPanels = new ArrayList<FormPanelElement>();
    private List<TabbedPanelElement> tabbedPanels = new ArrayList<TabbedPanelElement>();
    private List<TablePanelElement> tablePanels = new ArrayList<TablePanelElement>();
    private boolean isMultiConfig;
    Hashtable convertersHash;

    public SummaryElement(Node node, boolean bl) {
        super(node);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("converter")) {
                this.converters.add(new ConverterElement(node2));
                continue;
            }
            if (string.equals("formPanel")) {
                this.formPanels.add(new FormPanelElement(node2, bl));
                continue;
            }
            if (string.equals("tabbedPanel")) {
                this.tabbedPanels.add(new TabbedPanelElement(node2));
                continue;
            }
            if (!string.equals("tablePanel")) continue;
            this.tablePanels.add(new TablePanelElement(node2));
        }
    }

    public JPanel[] createSummaryPanels(Hashtable hashtable) {
        Object object;
        this.convertersHash = hashtable;
        int n = this.formPanels.size() + this.tabbedPanels.size() + this.tablePanels.size();
        JPanel[] jPanelArray = new JPanel[n];
        int n2 = 0;
        for (ConverterElement abstractSummary : this.converters) {
            object = abstractSummary.getConverter();
            if (object != null) {
                String string = abstractSummary.getName();
                if (string != null) {
                    hashtable.put(string, object);
                    continue;
                }
                Trace.warning(this, "There is an error in \"Summary.xml\". The name of the Converter is NOT correctly  specified!");
                continue;
            }
            Trace.warning(this, "There is an error in \"Summary.xml\". A Converter is NOT correctly specified!");
        }
        for (FormPanelElement formPanelElement : this.formPanels) {
            object = formPanelElement.getInfoPanel(hashtable);
            if (object instanceof ViewFormPanel) {
                jPanelArray[n2++] = (ViewFormPanel)object;
                continue;
            }
            if (!(object instanceof FormPanel)) continue;
            jPanelArray[n2++] = (FormPanel)object;
        }
        for (TabbedPanelElement tabbedPanelElement : this.tabbedPanels) {
            object = tabbedPanelElement.getTabbedFormPanel(hashtable);
            jPanelArray[n2++] = object;
        }
        for (TablePanelElement tablePanelElement : this.tablePanels) {
            object = tablePanelElement.getTablePanel();
            jPanelArray[n2++] = object;
        }
        return jPanelArray;
    }
}

