/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pdhsdhtrans;

import enea.ose.system.Signal;
import enea.ose.system.UnlinkedSignal;
import se.ericsson.cello.common.fropxy.FroLockInd;
import se.ericsson.cello.common.fropxy.MoEventable;
import se.ericsson.cello.common.fropxy.MoNotifiable;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroNotLockedException;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoNotPossibleToReserveException;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.pdhsdhtrans.AtmPortBuildIF;
import se.ericsson.cello.pdhsdhtrans.Ds0BundleBuildIF;
import se.ericsson.cello.pdhsdhtrans.E1PhysPathTermMo;
import se.ericsson.cello.pdhsdhtrans.ExchangeTerminalMoImpl;
import se.ericsson.cello.pdhsdhtrans.ImaReservable;
import se.ericsson.cello.pdhsdhtrans.PDHPhysPathTermInfo;
import se.ericsson.cello.pdhsdhtrans.PhysPathTermConstants;
import se.ericsson.cello.pdhsdhtrans.PhysPathTermRepositoryImpl;
import se.ericsson.cello.pdhsdhtrans.PhysValidator;
import se.ericsson.cello.pdhsdhtrans.TrafficReservable;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE1MiAutoLockInd;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE1MiCreateRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE1MiDeleteRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE1MiGetAttributeRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE1MiLockRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE1MiNoCRCMFEInd;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE1MiSetAttributeRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE1MiShutDownRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE1MiUnlockRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE1Proxy;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.sync.PDHSyncReference;
import se.ericsson.cello.sync.SyncReservable;
import se.ericsson.cello.transaction.Coordinator;

public class E1PhysPathTermMoImpl
extends CelloMao
implements E1PhysPathTermMo,
PhysPathTermConstants,
MoNotifiable,
MoEventable,
PDHPhysPathTermInfo,
TrafficReservable,
SyncReservable,
ImaReservable,
PDHSyncReference {
    private MoData data;
    private StringAttribute userLabel;
    private IntegerAttribute phyPortFroId;
    private ReferenceAttribute reservedByTraffic;
    private ReferenceAttribute reservedBySync;
    private ReferenceAttribute reservedByImaLink;
    private static PhyE1Proxy phyE1Proxy = PhyE1Proxy.instance();
    private static NotificationSender notificationSender = NotificationSender.instance();
    private static PhysPathTermRepositoryImpl repository = PhysPathTermRepositoryImpl.instance();
    private static final String PHY_PORT_FRO_ID = "phyPortFroId";
    private static final int MO_DATA_REVISION_2_5_1 = 0;
    private static final int MO_DATA_REVISION_2_6 = 1;
    private static final int MO_DATA_REVISION_311 = 3000;
    private static final int MO_DATA_REVISION_3111 = 3001;
    private static final int MO_DATA_REVISION_3400 = 3400;
    private static final int MO_DATA_REVISION_3500 = 3500;
    private static final int MO_DATA_REVISION_LATEST = 3500;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"E1PhysPathTerm", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"ExchangeTerminal");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"E1PhysPathTerm", (int)128, (int)0);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"lineNo", (AttrList)attrList, (boolean)true, (int)0, (int)0, (int)Integer.MAX_VALUE, (String)"E1PhysPathTerm");
        PhysValidator.checkPhysPath(managedObject, "E1PhysPathTerm", n, coordinator);
        E1PhysPathTermMoImpl.checkNumberOfPhysPaths();
        int n2 = E1PhysPathTermMoImpl.checkAndGetLoopback(attrList);
        int n3 = E1PhysPathTermMoImpl.checkAndGetAdministrativeState(attrList);
        int n4 = E1PhysPathTermMoImpl.checkAndGetCrc4Mode(attrList);
        int n5 = E1PhysPathTermMoImpl.checkAndGetIdlePattern(attrList);
        int n6 = E1PhysPathTermMoImpl.checkAndGetDegDegThr(attrList);
        int n7 = E1PhysPathTermMoImpl.checkAndGetDegDegM(attrList);
        boolean bl = E1PhysPathTermMoImpl.checkAndGetRdiReporting(attrList);
        boolean bl2 = E1PhysPathTermMoImpl.checkAndGetAisReporting(attrList);
        int n8 = E1PhysPathTermMoImpl.checkAndGetShutDownTimeout(attrList);
        E1PhysPathTermMoImpl.checkOtherAttributes(attrList);
        return new E1PhysPathTermMoImpl(managedObject, string, string2, n, n2, n3, n4, n5, n6, n7, bl, bl2, n8, coordinator);
    }

    private E1PhysPathTermMoImpl(ManagedObject managedObject, String string, String string2, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2, int n8, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "E1PhysPathTerm", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true, string2);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.reservedByTraffic = new ReferenceAttribute("reservedByTraffic", false);
        this.reservedByTraffic.setValue(null);
        this.data.registerPersistentAttr((Attribute)this.reservedByTraffic);
        this.reservedBySync = new ReferenceAttribute("reservedBySync", false);
        this.reservedBySync.setValue(null);
        this.data.registerPersistentAttr((Attribute)this.reservedBySync);
        this.reservedByImaLink = new ReferenceAttribute("reservedByImaLink", false);
        this.reservedByImaLink.setValue(null);
        this.data.registerPersistentAttr((Attribute)this.reservedByImaLink);
        if (n3 != 0 && n2 != 0) {
            throw new FroNotLockedException("E1PhysPathTerm", "AdministrativeState need to be locked when creating with loopback enabled");
        }
        PhysValidator.checkPhysPathIdlePattern(this, n5, "E1PhysPathTerm", coordinator);
        int n9 = ((ExchangeTerminalMoImpl)managedObject).getFroId(coordinator);
        int n10 = this.createPhyE1PortFro(coordinator, n9, n, n6, n7, MaoFroTypeConverter.boolean2int((boolean)bl2), MaoFroTypeConverter.boolean2int((boolean)bl), n5, n4, n2, n3, n8);
        this.phyPortFroId = new IntegerAttribute(PHY_PORT_FRO_ID, false, n10);
        this.data.registerPersistentAttr((Attribute)this.phyPortFroId);
        phyE1Proxy.registerForNotifications(coordinator, this, this.phyPortFroId.getValue(coordinator));
        this.data.setRevision(3500);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        repository.register(n10, this, coordinator);
    }

    public E1PhysPathTermMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3500);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(PHY_PORT_FRO_ID);
        moDataRecoveryHelper.assertAttribute("reservedByTraffic");
        moDataRecoveryHelper.assertAttribute("reservedBySync");
        moDataRecoveryHelper.assertAttribute("reservedByImaLink");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.phyPortFroId = (IntegerAttribute)this.data.getAttribute(PHY_PORT_FRO_ID);
        this.reservedByTraffic = (ReferenceAttribute)this.data.getAttribute("reservedByTraffic");
        this.reservedBySync = (ReferenceAttribute)this.data.getAttribute("reservedBySync");
        this.reservedByImaLink = (ReferenceAttribute)this.data.getAttribute("reservedByImaLink");
        phyE1Proxy.registerForNotifications(null, this, this.phyPortFroId.getValue(null));
        repository.register(this.phyPortFroId.getValue(null), this);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.reservedByTraffic.getValue(coordinator) != null || this.reservedBySync.getValue(coordinator) != null || this.reservedByImaLink.getValue(coordinator) != null) {
            throw new MoReservedNotDeletableException("E1PhysPathTerm");
        }
        this.sendDelete(coordinator);
        phyE1Proxy.deregisterForNotifications(coordinator, this.phyPortFroId.getValue(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
        repository.remove(this.phyPortFroId.getValue(coordinator), coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"E1PhysPathTerm", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return this.getPhyE1Attribute(coordinator, 2);
    }

    public int getLineNo(Coordinator coordinator) throws MoAccessException {
        return this.getPhyE1Attribute(coordinator, 21) + 1;
    }

    public int getSyncState(Coordinator coordinator) throws MoAccessException {
        return this.getPhyE1Attribute(coordinator, 34);
    }

    public ManagedObject getReservedByTraffic(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.reservedByTraffic.getValue(coordinator);
    }

    public ManagedObject getReservedBySync(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.reservedBySync.getValue(coordinator);
    }

    public ManagedObject getReservedByImaLink(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.reservedByImaLink.getValue(coordinator);
    }

    public int getLoopback(Coordinator coordinator) throws MoAccessException {
        return this.getPhyE1Attribute(coordinator, 22);
    }

    public void setLoopback(int n, Coordinator coordinator) throws MoAccessException {
        if (this.getAdministrativeState(coordinator) != 0 && n != 0) {
            throw new FroNotLockedException("E1PhysPathTerm", "AdministrativeState need to be locked when setting with loopback enabled");
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new ValueOutOfRangeException("loopback", "E1PhysPathTerm");
        }
        this.setPhyE1Attributes(coordinator, 22, n);
        String[] stringArray = new String[]{"loopback"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        return this.getPhyE1Attribute(coordinator, 1);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n == 0) {
            this.lockE1PhyPort(coordinator);
        } else if (n == 1) {
            this.unlockE1PhyPort(coordinator);
        } else if (n == 2) {
            this.shutDownE1PhyPort(coordinator);
        } else {
            throw new ValueOutOfRangeException("administrativeState", "E1PhysPathTerm");
        }
        String[] stringArray = new String[]{"administrativeState"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return AvailConverter.convert((int)this.getPhyE1Attribute(coordinator, 3));
    }

    public int getPmEs(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmEs", coordinator);
    }

    public int getPmSes(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmSes", coordinator);
    }

    public int getPmUas(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmUas", coordinator);
    }

    public int getCrc4Mode(Coordinator coordinator) throws MoAccessException {
        return this.getPhyE1Attribute(coordinator, 28);
    }

    public void setCrc4Mode(int n, Coordinator coordinator) throws MoAccessException {
        if (n < 0 || n > 2) {
            throw new ValueOutOfRangeException("crc4Mode", "E1PhysPathTerm");
        }
        this.setPhyE1Attributes(coordinator, 28, n);
        String[] stringArray = new String[]{"crc4Mode"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getIdlePattern(Coordinator coordinator) throws MoAccessException {
        return this.getPhyE1Attribute(coordinator, 29);
    }

    public void setIdlePattern(int n, Coordinator coordinator) throws MoAccessException {
        if (n != 0 && n != 1 && n != 2) {
            throw new ValueOutOfRangeException("idlePattern", "E1PhysPathTerm");
        }
        if (n != 0) {
            PhysValidator.checkPhysPathIdlePattern(this, n, "E1PhysPathTerm", coordinator);
        }
        this.setPhyE1Attributes(coordinator, 29, n);
        String[] stringArray = new String[]{"idlePattern"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getDegDegThr(Coordinator coordinator) throws MoAccessException {
        return this.getPhyE1Attribute(coordinator, 24);
    }

    public void setDegDegThr(int n, Coordinator coordinator) throws MoAccessException {
        if (n < 0 || n > 100) {
            throw new ValueOutOfRangeException("degDegThr", "E1PhysPathTerm");
        }
        this.setPhyE1Attributes(coordinator, 24, n);
        String[] stringArray = new String[]{"degDegThr"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getDegDegM(Coordinator coordinator) throws MoAccessException {
        return this.getPhyE1Attribute(coordinator, 25);
    }

    public void setDegDegM(int n, Coordinator coordinator) throws MoAccessException {
        if (n < 2 || n > 10) {
            throw new ValueOutOfRangeException("degDegThr", "E1PhysPathTerm");
        }
        this.setPhyE1Attributes(coordinator, 25, n);
        String[] stringArray = new String[]{"degDegM"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public boolean getRdiReporting(Coordinator coordinator) throws MoAccessException {
        return MaoFroTypeConverter.int2boolean((int)this.getPhyE1Attribute(coordinator, 27));
    }

    public void setRdiReporting(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setPhyE1Attributes(coordinator, 27, MaoFroTypeConverter.boolean2int((boolean)bl));
        String[] stringArray = new String[]{"rdiReporting"};
        Object[] objectArray = new Object[]{bl};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public boolean getAisReporting(Coordinator coordinator) throws MoAccessException {
        return MaoFroTypeConverter.int2boolean((int)this.getPhyE1Attribute(coordinator, 26));
    }

    public void setAisReporting(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setPhyE1Attributes(coordinator, 26, MaoFroTypeConverter.boolean2int((boolean)bl));
        String[] stringArray = new String[]{"aisReporting"};
        Object[] objectArray = new Object[]{bl};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getShutDownTimeout(Coordinator coordinator) throws MoAccessException {
        return this.getPhyE1Attribute(coordinator, 35);
    }

    public void setShutDownTimeout(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkIntegerAttribute((String)"shutDownTimeout", (int)n, (int)0, (int)100000, (String)"E1PhysPathTerm");
        this.setPhyE1Attributes(coordinator, 35, n);
        String[] stringArray = new String[]{"shutDownTimeout"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public String getType() {
        return "E1PhysPathTerm";
    }

    private static void checkTransaction(Coordinator coordinator) throws TransactionRequiredException {
        if (coordinator == null) {
            throw new TransactionRequiredException();
        }
    }

    private static void checkNumberOfPhysPaths() throws MoAccessException {
        String[] stringArray = new String[]{"E1PhysPathTerm", "J1PhysPathTerm", "T1PhysPathTerm"};
        MoAttributeValidator.checkNumberOfMoTypes((String)"E1PhysPathTerm", (String[])stringArray, (int)900);
    }

    private static int checkAndGetLoopback(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("loopback");
        if (n == -1) {
            return 0;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("loopback", "E1PhysPathTerm");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 < 0 || n2 > 2) {
            throw new ValueOutOfRangeException("loopback", "E1PhysPathTerm");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static int checkAndGetAdministrativeState(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("administrativeState");
        if (n == -1) {
            return 0;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("administrativeState", "E1PhysPathTerm");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new ValueOutOfRangeException("administrativeState", "E1PhysPathTerm");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static int checkAndGetCrc4Mode(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("crc4Mode");
        if (n == -1) {
            return 1;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("crc4Mode", "E1PhysPathTerm");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 < 0 || n2 > 2) {
            throw new ValueOutOfRangeException("crc4Mode", "E1PhysPathTerm");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static int checkAndGetIdlePattern(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("idlePattern");
        if (n == -1) {
            return 0;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("idlePattern", "E1PhysPathTerm");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 < 0 || n2 > 2) {
            throw new ValueOutOfRangeException("idlePattern", "E1PhysPathTerm");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static int checkAndGetDegDegThr(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("degDegThr");
        if (n == -1) {
            return 30;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("degDegThr", "E1PhysPathTerm");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 < 0 || n2 > 100) {
            throw new ValueOutOfRangeException("degDegThr", "E1PhysPathTerm");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static int checkAndGetDegDegM(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("degDegM");
        if (n == -1) {
            return 7;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("degDegM", "E1PhysPathTerm");
        }
        int n2 = (Integer)attrList.getValue(n);
        if (n2 < 2 || n2 > 10) {
            throw new ValueOutOfRangeException("degDegM", "E1PhysPathTerm");
        }
        attrList.removeElementAt(n);
        return n2;
    }

    private static boolean checkAndGetRdiReporting(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("rdiReporting");
        if (n == -1) {
            return false;
        }
        if (!(attrList.getValue(n) instanceof Boolean)) {
            throw new WrongAttributeTypeException("rdiReporting", "E1PhysPathTerm");
        }
        boolean bl = (Boolean)attrList.getValue(n);
        attrList.removeElementAt(n);
        return bl;
    }

    private static boolean checkAndGetAisReporting(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("aisReporting");
        if (n == -1) {
            return false;
        }
        if (!(attrList.getValue(n) instanceof Boolean)) {
            throw new WrongAttributeTypeException("aisReporting", "E1PhysPathTerm");
        }
        boolean bl = (Boolean)attrList.getValue(n);
        attrList.removeElementAt(n);
        return bl;
    }

    private static int checkAndGetShutDownTimeout(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("shutDownTimeout");
        if (n == -1) {
            return 1800;
        }
        if (!(attrList.getValue(n) instanceof Integer)) {
            throw new WrongAttributeTypeException("shutDownTimeout", "E1PhysPathTerm");
        }
        int n2 = (Integer)attrList.getValue(n);
        MoAttributeValidator.checkIntegerAttribute((String)"shutDownTimeout", (int)n2, (int)0, (int)100000, (String)"E1PhysPathTerm");
        attrList.removeElementAt(n);
        return n2;
    }

    private static void checkOtherAttributes(AttrList attrList) throws NoSuchAttributeException {
        long l = attrList.size();
        if (l != 0L) {
            throw new NoSuchAttributeException(attrList.getName(0), "E1PhysPathTerm");
        }
    }

    private int getPhyE1Attribute(Coordinator coordinator, int n) throws MoAccessException {
        int n2 = 0;
        if (coordinator != null) {
            n2 = coordinator.getTransactionID();
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyE1MiGetAttributeRsp phyE1MiGetAttributeRsp = phyE1Proxy.sendPhyE1MiGetAttributeReq(n2, this.phyPortFroId.getValue(coordinator), n);
        this.checkSignal((Signal)phyE1MiGetAttributeRsp);
        if (phyE1MiGetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("E1PhysPathTerm", "E1PhysicalPortFro", "GetAttributeReq: " + phyE1Proxy.getResultMsg(phyE1MiGetAttributeRsp.getResult()), phyE1MiGetAttributeRsp.getResult());
        }
        return phyE1MiGetAttributeRsp.getValue();
    }

    private void setPhyE1Attributes(Coordinator coordinator, int n, int n2) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        PhyE1MiSetAttributeRsp phyE1MiSetAttributeRsp = phyE1Proxy.sendPhyE1MiSetAttributeReq(coordinator.getTransactionID(), this.phyPortFroId.getValue(coordinator), n2, n);
        this.checkSignal((Signal)phyE1MiSetAttributeRsp);
        if (phyE1MiSetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("E1PhysPathTerm", "E1PhysicalPortFro", "SetAttributeReq: " + phyE1Proxy.getResultMsg(phyE1MiSetAttributeRsp.getResult()), phyE1MiSetAttributeRsp.getResult());
        }
    }

    public void trafficReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        if (managedObject == null) {
            MessageLog.traceError(this.getClass(), (String)"trafficReserve: userId == null()", null);
            throw new InvalidReferenceException("E1PhysPathTerm", (Object)managedObject);
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.reservedByImaLink.getValue(coordinator) != null) {
            throw new MoNotPossibleToReserveException("has been reserved by ImaLink", this.getType());
        }
        if (this.getChildren().hasMoreElements()) {
            throw new MoNotPossibleToReserveException("has Ds0Bundle children", this.getType());
        }
        this.reservedByTraffic = ReservableImpl.trafficReserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"E1PhysPathTerm", (MoData)this.data, (ReferenceAttribute)this.reservedByTraffic);
    }

    public void trafficRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reservedByTraffic = ReservableImpl.trafficRelease((ManagedObject)managedObject, (Coordinator)coordinator, (String)"E1PhysPathTerm", (MoData)this.data, (ReferenceAttribute)this.reservedByTraffic);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.phyPortFroId.getValue(coordinator);
    }

    private boolean checkChildren(Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            if (!(managedObject instanceof Ds0BundleBuildIF)) continue;
            if (((Ds0BundleBuildIF)managedObject).getReservedBy(coordinator) != null) {
                ManagedObject managedObject2 = ((Ds0BundleBuildIF)managedObject).getReservedBy(coordinator);
                return !(managedObject2 instanceof AtmPortBuildIF);
            }
            return true;
        }
        return false;
    }

    public void syncReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reservedBySync = ReservableImpl.syncReserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"E1PhysPathTerm", (MoData)this.data, (ReferenceAttribute)this.reservedBySync);
    }

    public void syncRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reservedBySync = ReservableImpl.syncRelease((ManagedObject)managedObject, (Coordinator)coordinator, (String)"E1PhysPathTerm", (MoData)this.data, (ReferenceAttribute)this.reservedBySync);
    }

    public synchronized void parameterChanged(FroLockInd froLockInd, String string) {
        if (froLockInd instanceof PhyE1MiAutoLockInd) {
            String[] stringArray = new String[]{"administrativeState"};
            Object[] objectArray = new Object[]{new Integer(0)};
            notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray);
            AlarmManager.getReporter().reportEvent(36, (ManagedObject)this, "", "", null);
        }
    }

    public void eventRaised(UnlinkedSignal unlinkedSignal, String string) {
        if (unlinkedSignal instanceof PhyE1MiNoCRCMFEInd) {
            AlarmManager.getReporter().reportEvent(11, (ManagedObject)this, "", "", null);
        }
    }

    private void lockE1PhyPort(Coordinator coordinator) throws MoAccessException {
        PhyE1MiLockRsp phyE1MiLockRsp = phyE1Proxy.sendPhyE1MiLockReq(coordinator.getTransactionID(), this.phyPortFroId.getValue(coordinator));
        this.checkSignal((Signal)phyE1MiLockRsp);
        if (phyE1MiLockRsp.getResult() != 0) {
            throw new FroRequestFailedException("E1PhysPathTerm", "E1PhysicalPortFro", "ActionReq: " + phyE1Proxy.getResultMsg(phyE1MiLockRsp.getResult()), phyE1MiLockRsp.getResult());
        }
    }

    private void unlockE1PhyPort(Coordinator coordinator) throws MoAccessException {
        PhyE1MiUnlockRsp phyE1MiUnlockRsp = phyE1Proxy.sendPhyE1MiUnlockReq(coordinator.getTransactionID(), this.phyPortFroId.getValue(coordinator));
        this.checkSignal((Signal)phyE1MiUnlockRsp);
        if (phyE1MiUnlockRsp.getResult() != 0) {
            throw new FroRequestFailedException("E1PhysPathTerm", "E1PhysicalPortFro", "ActionReq: " + phyE1Proxy.getResultMsg(phyE1MiUnlockRsp.getResult()), phyE1MiUnlockRsp.getResult());
        }
    }

    private void shutDownE1PhyPort(Coordinator coordinator) throws MoAccessException {
        PhyE1MiShutDownRsp phyE1MiShutDownRsp = phyE1Proxy.sendPhyE1MiShutDownReq(coordinator.getTransactionID(), this.phyPortFroId.getValue(coordinator));
        this.checkSignal((Signal)phyE1MiShutDownRsp);
        if (phyE1MiShutDownRsp.getResult() != 0) {
            throw new FroRequestFailedException("E1PhysPathTerm", "E1PhysicalPortFro", "ActionReq: " + phyE1Proxy.getResultMsg(phyE1MiShutDownRsp.getResult()), phyE1MiShutDownRsp.getResult());
        }
    }

    private int createPhyE1PortFro(Coordinator coordinator, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyE1MiCreateRsp phyE1MiCreateRsp = phyE1Proxy.sendPhyE1MiCreateReq(coordinator.getTransactionID(), n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11);
        if (phyE1MiCreateRsp == null) {
            throw new FroNotAccessibleException("E1PhysPathTerm", "E1PhysicalFro");
        }
        if (phyE1MiCreateRsp.getResult() != 0) {
            throw new FroRequestFailedException("E1PhysPathTerm", "E1PhysicalFro", "CreateFroReq: " + phyE1Proxy.getResultMsg(phyE1MiCreateRsp.getResult()), phyE1MiCreateRsp.getResult());
        }
        return phyE1MiCreateRsp.getFroId();
    }

    private void sendDelete(Coordinator coordinator) throws MoAccessException {
        PhyE1MiDeleteRsp phyE1MiDeleteRsp = phyE1Proxy.sendPhyE1MiDeleteReq(coordinator.getTransactionID(), this.phyPortFroId.getValue(coordinator));
        this.checkSignal((Signal)phyE1MiDeleteRsp);
        if (phyE1MiDeleteRsp.getResult() != 0) {
            throw new FroRequestFailedException("E1PhysPathTerm", "E1PhysicalPortFro", "DeleteFroReq: " + phyE1Proxy.getResultMsg(phyE1MiDeleteRsp.getResult()), phyE1MiDeleteRsp.getResult());
        }
    }

    private void checkSignal(Signal signal) throws MoAccessException {
        if (signal == null) {
            throw new FroNotAccessibleException("E1PhysPathTerm", "E1PhysPathTermFro");
        }
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject == null) {
            MessageLog.traceError(this.getClass(), (String)"reserve: userId is null", null);
            throw new InvalidReferenceException("E1PhysPathTerm", (Object)managedObject);
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.reservedByTraffic.getValue(coordinator) != null) {
            throw new MoNotPossibleToReserveException("has been reserved by AtmPort", this.getType());
        }
        if (this.checkChildren(coordinator)) {
            throw new MoNotPossibleToReserveException("has Ds0Bundle children reserved by AtmPort", this.getType());
        }
        this.reservedByImaLink = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"E1PhysPathTerm", (MoData)this.data, (ReferenceAttribute)this.reservedByImaLink);
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.reservedByImaLink = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"E1PhysPathTerm", (MoData)this.data, (ReferenceAttribute)this.reservedByImaLink);
    }

    private static int getLineNumberMax(ManagedObject managedObject) throws MoAccessException {
        if (managedObject.getParent().getType().equals("Cbu")) {
            return 4;
        }
        return 8;
    }
}

