/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pdhsdhtrans;

import se.ericsson.cello.common.fropxy.FroLockInd;
import se.ericsson.cello.common.fropxy.MoNotifiable;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.FroNotLockedException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.pdhsdhtrans.AtmPortBuildIF;
import se.ericsson.cello.pdhsdhtrans.E3PhysPathTermMo;
import se.ericsson.cello.pdhsdhtrans.ExchangeTerminalMoImpl;
import se.ericsson.cello.pdhsdhtrans.PhysPathTermInfo;
import se.ericsson.cello.pdhsdhtrans.PhysPathTermRepositoryImpl;
import se.ericsson.cello.pdhsdhtrans.PhysValidator;
import se.ericsson.cello.pdhsdhtrans.TrafficReservable;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE3MiAutoLockInd;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE3MiCreateRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE3MiDeleteRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE3MiGetAttributeRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE3MiGetPmCountersRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE3MiSetAttributeRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyE3Proxy;
import se.ericsson.cello.sync.PDHSyncReference;
import se.ericsson.cello.sync.SyncReservable;
import se.ericsson.cello.sync.SynchronizationMo;
import se.ericsson.cello.transaction.Coordinator;

public class E3PhysPathTermMoImpl
extends CelloMao
implements E3PhysPathTermMo,
PhysPathTermInfo,
TrafficReservable,
SyncReservable,
MoNotifiable,
FroInfo,
PDHSyncReference {
    private static final int PHY_HPDH_EQUIPMENT_ID = 0;
    private static final int PHY_HPDH_LINE_NUMBER = 1;
    private static final int PHY_HPDH_LOOPBACK_MODE = 2;
    private static final int PHY_HPDH_ADMIN_STATE = 3;
    private static final int PHY_HPDH_DEG_DEGTHR = 4;
    private static final int PHY_HPDH_DEG_DEGM = 5;
    private static final int PHY_HPDH_AIS_REPORTING = 6;
    private static final int PHY_HPDH_RDI_REPORTING = 7;
    private static final int PHY_HPDH_OPER_STATE = 8;
    private static final int PHY_HPDH_AVAIL_STATE = 9;
    private static final int PHY_HPDH_SYNC_STATE = 10;
    private static final int PHY_HPDH_TIMEOUT = 11;
    private static final int SHUT_DOWN_TIMEOUT_MIN = 0;
    private static final int SHUT_DOWN_TIMEOUT_DEFAULT = 1800;
    private static final int SHUT_DOWN_TIMEOUT_MAX = 100000;
    private static final int LINE_NO_MIN = 1;
    private static final int LINE_NO_MAX = 2;
    private static final int DEG_DEG_THR_DEFAULT = 30;
    private static final int DEG_DEG_THR_MIN = 0;
    private static final int DEG_DEG_THR_MAX = 100;
    private static final int DEG_DEG_M_DEFAULT = 7;
    private static final int DEG_DEG_M_MIN = 2;
    private static final int DEG_DEG_M_MAX = 10;
    private static final int PHY_HPDHRESULT_OK = 0;
    private static final Class[] atmPortReserver = new Class[]{AtmPortBuildIF.class};
    private static final Class[] syncReserver = new Class[]{SynchronizationMo.class};
    private MoData data;
    private static final int MO_DATA_REVISION_43 = 4300;
    private static final int MO_DATA_REVISION_LATEST = 4300;
    private static PhyE3Proxy phyE3Proxy = PhyE3Proxy.instance();
    private static NotificationSender notificationSender = NotificationSender.instance();
    private static PhysPathTermRepositoryImpl repository = PhysPathTermRepositoryImpl.instance();
    static /* synthetic */ Class class$java$lang$Integer;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"ExchangeTerminal");
        MoAttributeValidator.checkIdentity((String)"E3PhysPathTerm", (String)string);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"administrativeState", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)2, (String)"E3PhysPathTerm");
        int n2 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"shutDownTimeout", (AttrList)attrList, (boolean)false, (int)1800, (int)0, (int)100000, (String)"E3PhysPathTerm");
        int n3 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"lineNo", (AttrList)attrList, (boolean)true, (int)0, (int)0, (int)Integer.MAX_VALUE, (String)"E3PhysPathTerm");
        PhysValidator.checkPhysPath(managedObject, "E3PhysPathTerm", n3, coordinator);
        int n4 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"degDegThr", (AttrList)attrList, (boolean)false, (int)30, (int)0, (int)100, (String)"E3PhysPathTerm");
        int n5 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"degDegM", (AttrList)attrList, (boolean)false, (int)7, (int)2, (int)10, (String)"E3PhysPathTerm");
        int n6 = MoAttributeValidator.checkAndGetIntegerAttribute((String)"loopback", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)2, (String)"E3PhysPathTerm");
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"aisReporting", (AttrList)attrList, (boolean)false, (boolean)false, (String)"E3PhysPathTerm");
        boolean bl2 = MoAttributeValidator.checkAndGetBooleanAttribute((String)"rdiReporting", (AttrList)attrList, (boolean)false, (boolean)false, (String)"E3PhysPathTerm");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"E3PhysPathTerm", (int)128, (int)0);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"E3PhysPathTerm");
        return new E3PhysPathTermMoImpl(managedObject, string, n, n2, n3, n4, n5, n6, bl, bl2, string2, coordinator);
    }

    private E3PhysPathTermMoImpl(ManagedObject managedObject, String string, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, String string2, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "E3PhysPathTerm", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        if (n != 0 && n6 != 0) {
            throw new FroNotLockedException("E3PhysPathTerm", "AdministrativeState need to be locked when creating with loopback enabled");
        }
        int n7 = this.createE3PhysPathTermFro(coordinator, n3, n4, n5, bl, bl2, n6, n, n2);
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n7));
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("reservedByTraffic", false, null));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("reservedBySync", false, null));
        phyE3Proxy.registerForNotifications(coordinator, this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator));
        this.data.setRevision(4300);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        repository.register(n7, this, coordinator);
    }

    public E3PhysPathTermMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(4300);
        moDataRecoveryHelper.assertAttribute("reservedByTraffic");
        moDataRecoveryHelper.assertAttribute("reservedBySync");
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute("userLabel");
        int n = ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null);
        phyE3Proxy.registerForNotifications(null, this, n);
        repository.register(n, this);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getReservedByTraffic(coordinator) != null || this.getReservedBySync(coordinator) != null) {
            throw new MoReservedNotDeletableException("E3PhysPathTerm");
        }
        int n = ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
        phyE3Proxy.deregisterForNotifications(coordinator, n);
        this.deleteE3PhysPathTermFro(coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
        repository.remove(n, coordinator);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("administrativeState", coordinator);
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("administrativeState", new Integer(n), coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public String getType() {
        return "E3PhysPathTerm";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    public ManagedObject getReservedByTraffic(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((ReferenceAttribute)this.data.getAttribute("reservedByTraffic")).getValue(coordinator);
    }

    public ManagedObject getReservedBySync(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((ReferenceAttribute)this.data.getAttribute("reservedBySync")).getValue(coordinator);
    }

    public String getE3PhysPathTermId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute(this.getType() + "Id", coordinator);
    }

    public int getShutDownTimeout(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("shutDownTimeout", coordinator);
    }

    public void setShutDownTimeout(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("shutDownTimeout", new Integer(n), coordinator);
    }

    public int getLoopback(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("loopback", coordinator);
    }

    public void setLoopback(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("loopback", new Integer(n), coordinator);
    }

    public int getDegDegThr(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("degDegThr", coordinator);
    }

    public void setDegDegThr(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("degDegThr", new Integer(n), coordinator);
    }

    public int getDegDegM(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("degDegM", coordinator);
    }

    public void setDegDegM(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("degDegM", new Integer(n), coordinator);
    }

    public boolean getAisReporting(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("aisReporting", coordinator);
    }

    public void setAisReporting(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("aisReporting", bl, coordinator);
    }

    public boolean getRdiReporting(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("rdiReporting", coordinator);
    }

    public void setRdiReporting(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("rdiReporting", bl, coordinator);
    }

    public int getPmEs(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmEs", coordinator);
    }

    public int getPmSes(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSes", coordinator);
    }

    public int getPmUas(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmUas", coordinator);
    }

    public String[] getCurrentPmRegister(Coordinator coordinator) throws MoAccessException {
        return (String[])this.getAttribute("currentPmRegister", coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedByTraffic")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("reservedByTraffic")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBySync")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("reservedBySync")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("froId")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                objectArray[i] = new Integer(this.getE3PhysAttributes(coordinator, 3));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                objectArray[i] = new Integer(this.getE3PhysAttributes(coordinator, 8));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                objectArray[i] = new Integer(AvailConverter.convert((int)this.getE3PhysAttributes(coordinator, 9)));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("shutDownTimeout")) {
                objectArray[i] = new Integer(this.getE3PhysAttributes(coordinator, 11));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("lineNo")) {
                objectArray[i] = new Integer(this.getE3PhysAttributes(coordinator, 1) + 1);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("degDegThr")) {
                objectArray[i] = new Integer(this.getE3PhysAttributes(coordinator, 4));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("degDegM")) {
                objectArray[i] = new Integer(this.getE3PhysAttributes(coordinator, 5));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("loopback")) {
                objectArray[i] = new Integer(this.getE3PhysAttributes(coordinator, 2));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("aisReporting")) {
                objectArray[i] = MaoFroTypeConverter.int2boolean((int)this.getE3PhysAttributes(coordinator, 6));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("rdiReporting")) {
                objectArray[i] = MaoFroTypeConverter.int2boolean((int)this.getE3PhysAttributes(coordinator, 7));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmEs")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmEs", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSes")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmSes", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmUas")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmUas", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("currentPmRegister")) {
                objectArray[i] = super.getCurrentPmRegister(coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "E3PhysPathTerm");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            Object[] objectArray2;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!(objectArray[i] instanceof String)) {
                    throw new WrongAttributeTypeException("userLabel", "E3PhysPathTerm");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"E3PhysPathTerm", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("administrativeState")) {
                if (!objectArray[i].getClass().equals(class$java$lang$Integer == null ? E3PhysPathTermMoImpl.class$("java.lang.Integer") : class$java$lang$Integer)) {
                    throw new WrongAttributeTypeException("administrativeState", "E3PhysPathTerm");
                }
                n = (Integer)objectArray[i];
                if (n != 0 && n != 1 && n != 2) {
                    throw new ValueOutOfRangeException("administrativeState", "E3PhysPathTerm");
                }
                this.setPhyE3MiAttributes(coordinator, 3, n);
                String[] stringArray2 = new String[]{"administrativeState"};
                objectArray2 = new Object[]{new Integer(n)};
                notificationSender.pushAVC((ManagedObject)this, stringArray2, objectArray2, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("aisReporting")) {
                if (!(objectArray[i] instanceof Boolean)) {
                    throw new WrongAttributeTypeException("aisReporting", "E3PhysPathTerm");
                }
                this.setPhyE3MiAttributes(coordinator, 6, MaoFroTypeConverter.boolean2int((boolean)((Boolean)objectArray[i])));
                String[] stringArray3 = new String[]{"aisReporting"};
                objectArray2 = new Object[]{(Boolean)objectArray[i]};
                notificationSender.pushAVC((ManagedObject)this, stringArray3, objectArray2, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("loopback")) {
                if (!(objectArray[i] instanceof Integer)) {
                    throw new WrongAttributeTypeException("loopback", "E3PhysPathTerm");
                }
                n = (Integer)objectArray[i];
                int n2 = this.getE3PhysAttributes(coordinator, 3);
                if (n2 != 0 && n != 0) {
                    throw new FroNotLockedException("E3PhysPathTerm", "AdministrativeState need to be locked when creating with loopback enabled");
                }
                if (n != 0 && n != 1 && n != 2) {
                    throw new ValueOutOfRangeException("loopback", "E3PhysPathTerm");
                }
                this.setPhyE3MiAttributes(coordinator, 2, n);
                objectArray2 = new String[]{"loopback"};
                Object[] objectArray3 = new Object[]{new Integer(n)};
                notificationSender.pushAVC((ManagedObject)this, (String[])objectArray2, objectArray3, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("rdiReporting")) {
                if (!(objectArray[i] instanceof Boolean)) {
                    throw new WrongAttributeTypeException("rdiReporting", "E3PhysPathTerm");
                }
                this.setPhyE3MiAttributes(coordinator, 7, MaoFroTypeConverter.boolean2int((boolean)((Boolean)objectArray[i])));
                String[] stringArray4 = new String[]{"rdiReporting"};
                objectArray2 = new Object[]{(Boolean)objectArray[i]};
                notificationSender.pushAVC((ManagedObject)this, stringArray4, objectArray2, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("shutDownTimeout")) {
                if (!(objectArray[i] instanceof Integer)) {
                    throw new WrongAttributeTypeException("shutDownTimeout", "E3PhysPathTerm");
                }
                n = (Integer)objectArray[i];
                MoAttributeValidator.checkIntegerAttribute((String)"shutDownTimeout", (int)n, (int)0, (int)100000, (String)"E3PhysPathTerm");
                this.setPhyE3MiAttributes(coordinator, 11, n);
                String[] stringArray5 = new String[]{"shutDownTimeout"};
                objectArray2 = new Object[]{new Integer(n)};
                notificationSender.pushAVC((ManagedObject)this, stringArray5, objectArray2, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("degDegThr")) {
                if (!(objectArray[i] instanceof Integer)) {
                    throw new WrongAttributeTypeException("degDegThr", "E3PhysPathTerm");
                }
                n = (Integer)objectArray[i];
                if (n < 0 || n > 100) {
                    throw new ValueOutOfRangeException("degDegThr", "E3PhysPathTerm");
                }
                this.setPhyE3MiAttributes(coordinator, 4, n);
                String[] stringArray6 = new String[]{"degDegThr"};
                objectArray2 = new Object[]{new Integer(n)};
                notificationSender.pushAVC((ManagedObject)this, stringArray6, objectArray2, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("degDegM")) {
                if (!(objectArray[i] instanceof Integer)) {
                    throw new WrongAttributeTypeException("degDegM", "E3PhysPathTerm");
                }
                n = (Integer)objectArray[i];
                if (n < 2 || n > 10) {
                    throw new ValueOutOfRangeException("degDegM", "E3PhysPathTerm");
                }
                this.setPhyE3MiAttributes(coordinator, 5, n);
                String[] stringArray7 = new String[]{"degDegM"};
                objectArray2 = new Object[]{new Integer(n)};
                notificationSender.pushAVC((ManagedObject)this, stringArray7, objectArray2, coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "E3PhysPathTerm");
        }
    }

    public void trafficReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedByTraffic", (Class[])atmPortReserver);
    }

    public void trafficRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedByTraffic", (Class[])atmPortReserver);
    }

    public void syncReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBySync", (Class[])syncReserver);
    }

    public void syncRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBySync", (Class[])syncReserver);
    }

    public int getLineNo(Coordinator coordinator) throws MoAccessException {
        return this.getE3PhysAttributes(coordinator, 1) + 1;
    }

    public synchronized void parameterChanged(FroLockInd froLockInd, String string) {
        if (froLockInd instanceof PhyE3MiAutoLockInd) {
            String[] stringArray = new String[]{"administrativeState"};
            Object[] objectArray = new Object[]{new Integer(0)};
            notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray);
            AlarmManager.getReporter().reportEvent(37, (ManagedObject)this, "", "", null);
        }
    }

    private int createE3PhysPathTermFro(Coordinator coordinator, int n, int n2, int n3, boolean bl, boolean bl2, int n4, int n5, int n6) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        int n7 = ((ExchangeTerminalMoImpl)this.getParent()).getFroId(coordinator);
        PhyE3MiCreateRsp phyE3MiCreateRsp = phyE3Proxy.sendPhyE3MiCreateReq(coordinator.getTransactionID(), n7, n - 1, n2, n3, MaoFroTypeConverter.boolean2int((boolean)bl), MaoFroTypeConverter.boolean2int((boolean)bl2), n4, n5, n6);
        if (phyE3MiCreateRsp == null) {
            throw new FroNotAccessibleException("E3PhysPathTerm", "PhyE3MiCreateReq");
        }
        if (phyE3MiCreateRsp.getResult() != 0) {
            throw new FroRequestFailedException("E3PhysPathTerm", "E3PhysicalPortFro", "CreateFroReq: " + phyE3Proxy.getResultMsg(phyE3MiCreateRsp.getResult()), phyE3MiCreateRsp.getResult());
        }
        return phyE3MiCreateRsp.getFroId();
    }

    private void deleteE3PhysPathTermFro(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        PhyE3MiDeleteRsp phyE3MiDeleteRsp = phyE3Proxy.sendPhyE3MiDeleteReq(coordinator.getTransactionID(), ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator));
        if (phyE3MiDeleteRsp == null) {
            throw new FroNotAccessibleException("E3PhysPathTerm", "PhyE3MiDeleteReq");
        }
        if (phyE3MiDeleteRsp.getResult() != 0) {
            throw new FroRequestFailedException("E3PhysPathTerm", "E3PhysicalPortFro", "DeleteFroReq: " + phyE3Proxy.getResultMsg(phyE3MiDeleteRsp.getResult()), phyE3MiDeleteRsp.getResult());
        }
    }

    private int getE3PhysAttributes(Coordinator coordinator, int n) throws MoAccessException {
        PhyE3MiGetAttributeRsp phyE3MiGetAttributeRsp;
        int n2 = 0;
        if (coordinator != null) {
            n2 = coordinator.getTransactionID();
        }
        if ((phyE3MiGetAttributeRsp = phyE3Proxy.sendPhyE3MiGetAttributeReq(n2, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator), n)) == null) {
            throw new FroNotAccessibleException("E3PhysPathTerm", "PhyE3MiGetAttributeReq");
        }
        if (phyE3MiGetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("E3PhysPathTerm", "E3PhysicalPortFro", "GetAttrReq: " + phyE3Proxy.getResultMsg(phyE3MiGetAttributeRsp.getResult()), phyE3MiGetAttributeRsp.getResult());
        }
        return phyE3MiGetAttributeRsp.getValue();
    }

    private PhyE3MiGetPmCountersRsp getPhyE3PmCounters(Coordinator coordinator) throws MoAccessException {
        PhyE3MiGetPmCountersRsp phyE3MiGetPmCountersRsp = phyE3Proxy.sendPhyE3MiGetPmCountersReq(((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator));
        if (phyE3MiGetPmCountersRsp == null) {
            throw new FroNotAccessibleException("E3PhysPathTerm", "E3PhysicalPortFro");
        }
        if (phyE3MiGetPmCountersRsp.getResult() == 100) {
            phyE3MiGetPmCountersRsp.setPmCountersUnavailable();
        } else if (phyE3MiGetPmCountersRsp.getResult() != 0) {
            throw new FroRequestFailedException("E3PhysPathTerm", "E3PhysicalPortFro", "GetPmCountersReq: " + phyE3Proxy.getResultMsg(phyE3MiGetPmCountersRsp.getResult()), phyE3MiGetPmCountersRsp.getResult());
        }
        return phyE3MiGetPmCountersRsp;
    }

    private void setPhyE3MiAttributes(Coordinator coordinator, int n, int n2) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        PhyE3MiSetAttributeRsp phyE3MiSetAttributeRsp = phyE3Proxy.sendPhyE3MiSetAttributeReq(coordinator.getTransactionID(), ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator), n, n2);
        if (phyE3MiSetAttributeRsp == null) {
            throw new FroNotAccessibleException("E3PhysPathTerm", "E3PhysicalPortFro");
        }
        if (phyE3MiSetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("E3PhysPathTerm", "E3PhysicalPortFro", "SetAttrReq: " + phyE3Proxy.getResultMsg(phyE3MiSetAttributeRsp.getResult()), phyE3MiSetAttributeRsp.getResult());
        }
    }
}

