/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pdhsdhtrans;

import se.ericsson.cello.common.fropxy.FroLockInd;
import se.ericsson.cello.common.fropxy.MoNotifiable;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoNotPossibleToReserveException;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.pdhsdhtrans.AtmPortBuildIF;
import se.ericsson.cello.pdhsdhtrans.Ds0BundleBuildIF;
import se.ericsson.cello.pdhsdhtrans.ImaLinkBuildIF;
import se.ericsson.cello.pdhsdhtrans.ImaReservable;
import se.ericsson.cello.pdhsdhtrans.PhysPathTermRepositoryImpl;
import se.ericsson.cello.pdhsdhtrans.T1TtpMo;
import se.ericsson.cello.pdhsdhtrans.TrafficReservable;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyT1MiAutoLockInd;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyT1MiGetAttributeRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyT1MiSetAttributeRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyT1Proxy;
import se.ericsson.cello.transaction.Coordinator;

public class T1TtpMoImpl
extends CelloMao
implements T1TtpMo,
TrafficReservable,
MoNotifiable,
ImaReservable {
    private static final String T1TTP_FRO_ID = "t1TtpFroId";
    private static final String DEFAULT_USERLABEL = "";
    private static final int RESULT_OK = 0;
    private static final int TYPE_AIS_REPORTING = 26;
    private static final int TYPE_RDI_REPORTING = 27;
    private static final int TYPE_IDLE_PATTERN = 29;
    private static final int TYPE_OPERATIONAL_STATE = 2;
    private static final int TYPE_AVAILABILITY_STATUS = 3;
    private static final int IDLE_PATTERN_UNDEFINED = 0;
    private static final int IDLE_PATTERN_A_LAW = 1;
    private static final int IDLE_PATTERN_MICRO_LAW = 2;
    private static final Class[] reservedClassesForTrafficReserve = new Class[]{AtmPortBuildIF.class};
    private MoData data;
    private IntegerAttribute t1TtpFroId;
    private StringAttribute userLabel;
    private ReferenceAttribute reservedBy;
    private ReferenceAttribute reservedByImaLink;
    private static PhyT1Proxy phyT1Proxy = PhyT1Proxy.instance();
    private static PhysPathTermRepositoryImpl repository = PhysPathTermRepositoryImpl.instance();
    private static final int MO_DATA_REVISION_43 = 4300;
    private static final int MO_DATA_REVISION_LATEST = 4300;

    static T1TtpMoImpl create(ManagedObject managedObject, int n, String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"Vt15Ttp");
        return new T1TtpMoImpl(managedObject, n, string, coordinator);
    }

    private T1TtpMoImpl(ManagedObject managedObject, int n, String string, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "T1Ttp", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.t1TtpFroId = new IntegerAttribute(T1TTP_FRO_ID, false, n);
        this.data.registerPersistentAttr((Attribute)this.t1TtpFroId);
        this.userLabel = new StringAttribute("userLabel", true, DEFAULT_USERLABEL);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.reservedBy = new ReferenceAttribute("reservedBy", false);
        this.reservedBy.setValue(null);
        this.data.registerPersistentAttr((Attribute)this.reservedBy);
        this.reservedByImaLink = new ReferenceAttribute("reservedByImaLink", false);
        this.reservedByImaLink.setValue(null);
        this.data.registerPersistentAttr((Attribute)this.reservedByImaLink);
        this.data.setRevision(4300);
        phyT1Proxy.registerForNotifications(coordinator, this, this.t1TtpFroId.getValue(coordinator));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        repository.register(n, this, coordinator);
    }

    public T1TtpMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(4300);
        moDataRecoveryHelper.assertAttribute(T1TTP_FRO_ID);
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute("reservedByImaLink");
        moDataRecoveryHelper.assertAttribute("userLabel");
        this.t1TtpFroId = (IntegerAttribute)moData.getAttribute(T1TTP_FRO_ID);
        this.reservedBy = (ReferenceAttribute)moData.getAttribute("reservedBy");
        this.reservedByImaLink = (ReferenceAttribute)moData.getAttribute("reservedByImaLink");
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        phyT1Proxy.registerForNotifications(null, this, this.t1TtpFroId.getValue(null));
        repository.register(this.t1TtpFroId.getValue(null), this);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deleteMo(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.reservedBy.getValue(coordinator) != null) {
            throw new MoReservedNotDeletableException("T1Ttp");
        }
        if (this.reservedByImaLink.getValue(coordinator) != null) {
            throw new MoReservedNotDeletableException("E1Ttp");
        }
        phyT1Proxy.deregisterForNotifications(coordinator, this.t1TtpFroId.getValue(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
        repository.remove(this.t1TtpFroId.getValue(coordinator), coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"T1Ttp", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getIdlePattern(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyT1MiGetAttributeRsp phyT1MiGetAttributeRsp = this.getT1TtpAttribute(coordinator, 29);
        return phyT1MiGetAttributeRsp.getValue();
    }

    public void setIdlePattern(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n != 0 && n != 1 && n != 2) {
            throw new ValueOutOfRangeException("idlePattern", "T1Ttp");
        }
        this.setT1TtpAttribute(coordinator, 29, n);
        this.sendNotification("idlePattern", new Integer(n), coordinator);
    }

    public ManagedObject[] getReservedBy(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ManagedObject[] managedObjectArray = new ManagedObject[]{this.reservedBy.getValue(coordinator)};
        return managedObjectArray;
    }

    public ManagedObject getReservedByTraffic(Coordinator coordinator) throws MoAccessException {
        if (this.reservedBy.getValue(coordinator) instanceof AtmPortBuildIF) {
            return this.reservedBy.getValue(coordinator);
        }
        return null;
    }

    public ManagedObject getReservedByImaLink(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.reservedByImaLink.getValue(coordinator);
    }

    public String getType() {
        return "T1Ttp";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.t1TtpFroId.getValue(coordinator);
    }

    private boolean checkChildren(Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            if (!(managedObject instanceof Ds0BundleBuildIF)) continue;
            if (((Ds0BundleBuildIF)managedObject).getReservedBy(coordinator) != null) {
                ManagedObject managedObject2 = ((Ds0BundleBuildIF)managedObject).getReservedBy(coordinator);
                return !(managedObject2 instanceof AtmPortBuildIF);
            }
            return true;
        }
        return false;
    }

    public void trafficReserve(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        if (managedObject == null) {
            throw new InvalidReferenceException("T1Ttp", null);
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.reservedByImaLink.getValue(coordinator) != null) {
            throw new MoNotPossibleToReserveException("has been reserved by ImaLink", this.getType());
        }
        if (this.getChildren().hasMoreElements()) {
            throw new MoNotPossibleToReserveException("has Ds0Bundle children", this.getType());
        }
        this.reservedBy = ReservableImpl.trafficReserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"T1Ttp", (MoData)this.data, (ReferenceAttribute)this.reservedBy, (Class[])reservedClassesForTrafficReserve);
    }

    public void trafficRelease(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        this.reservedBy = ReservableImpl.trafficRelease((ManagedObject)managedObject, (Coordinator)coordinator, (String)"T1Ttp", (MoData)this.data, (ReferenceAttribute)this.reservedBy, (Class[])reservedClassesForTrafficReserve);
    }

    public boolean getAisReporting(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyT1MiGetAttributeRsp phyT1MiGetAttributeRsp = this.getT1TtpAttribute(coordinator, 26);
        return MaoFroTypeConverter.int2boolean((int)phyT1MiGetAttributeRsp.getValue());
    }

    public void setAisReporting(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.setT1TtpAttribute(coordinator, 26, MaoFroTypeConverter.boolean2int((boolean)bl));
        this.sendNotification("aisReporting", bl, coordinator);
    }

    public int getDegDegThr(Coordinator coordinator) throws MoAccessException {
        PhyT1MiGetAttributeRsp phyT1MiGetAttributeRsp = this.getT1TtpAttribute(coordinator, 24);
        return phyT1MiGetAttributeRsp.getValue();
    }

    public void setDegDegThr(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkIntegerAttribute((String)"degDegThr", (int)n, (int)0, (int)100, (String)"T1Ttp");
        this.setT1TtpAttribute(coordinator, 24, n);
        this.sendNotification("degDegThr", new Integer(n), coordinator);
    }

    public int getDegDegM(Coordinator coordinator) throws MoAccessException {
        PhyT1MiGetAttributeRsp phyT1MiGetAttributeRsp = this.getT1TtpAttribute(coordinator, 25);
        return phyT1MiGetAttributeRsp.getValue();
    }

    public void setDegDegM(int n, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkIntegerAttribute((String)"degDegM", (int)n, (int)2, (int)10, (String)"T1Ttp");
        this.setT1TtpAttribute(coordinator, 25, n);
        this.sendNotification("degDegM", new Integer(n), coordinator);
    }

    public boolean getRdiReporting(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyT1MiGetAttributeRsp phyT1MiGetAttributeRsp = this.getT1TtpAttribute(coordinator, 27);
        return MaoFroTypeConverter.int2boolean((int)phyT1MiGetAttributeRsp.getValue());
    }

    public void setRdiReporting(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.setT1TtpAttribute(coordinator, 27, MaoFroTypeConverter.boolean2int((boolean)bl));
        this.sendNotification("rdiReporting", bl, coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        PhyT1MiGetAttributeRsp phyT1MiGetAttributeRsp = this.getT1TtpAttribute(coordinator, 2);
        return phyT1MiGetAttributeRsp.getValue();
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        PhyT1MiGetAttributeRsp phyT1MiGetAttributeRsp = this.getT1TtpAttribute(coordinator, 3);
        return AvailConverter.convert((int)phyT1MiGetAttributeRsp.getValue());
    }

    public int getPmEs(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmEs", coordinator);
    }

    public int getPmSes(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmSes", coordinator);
    }

    public int getPmUas(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmUas", coordinator);
    }

    private PhyT1MiGetAttributeRsp getT1TtpAttribute(Coordinator coordinator, int n) throws MoAccessException {
        int n2 = 0;
        if (coordinator != null) {
            n2 = coordinator.getTransactionID();
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyT1MiGetAttributeRsp phyT1MiGetAttributeRsp = phyT1Proxy.sendPhyT1MiGetAttributeReq(n2, this.t1TtpFroId.getValue(coordinator), n);
        if (phyT1MiGetAttributeRsp == null) {
            throw new FroNotAccessibleException("T1Ttp", "T1PhysPathTermFro");
        }
        if (phyT1MiGetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("T1Ttp", "T1PhysPathTermFro", "GetAttrReq: " + phyT1Proxy.getResultMsg(phyT1MiGetAttributeRsp.getResult()), phyT1MiGetAttributeRsp.getResult());
        }
        return phyT1MiGetAttributeRsp;
    }

    private void setT1TtpAttribute(Coordinator coordinator, int n, int n2) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        PhyT1MiSetAttributeRsp phyT1MiSetAttributeRsp = phyT1Proxy.sendPhyT1MiSetAttributeReq(coordinator.getTransactionID(), this.t1TtpFroId.getValue(coordinator), n, n2);
        if (phyT1MiSetAttributeRsp == null) {
            throw new FroNotAccessibleException("T1Ttp", "T1PhysPathTermFro");
        }
        if (phyT1MiSetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("T1Ttp", "T1PhysPathTermFro", "GetAttrReq: " + phyT1Proxy.getResultMsg(phyT1MiSetAttributeRsp.getResult()), phyT1MiSetAttributeRsp.getResult());
        }
    }

    public synchronized void parameterChanged(FroLockInd froLockInd, String string) {
        if (froLockInd instanceof PhyT1MiAutoLockInd) {
            String[] stringArray = new String[]{"administrativeState"};
            Object[] objectArray = new Object[]{new Integer(0)};
            NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray);
        }
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject == null) {
            throw new InvalidReferenceException("T1Ttp", null);
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        if (this.checkChildren(coordinator)) {
            throw new MoNotPossibleToReserveException("has Ds0Bundle children", this.getType());
        }
        if (managedObject instanceof ImaLinkBuildIF) {
            if (this.reservedBy.getValue(coordinator) != null) {
                throw new MoNotPossibleToReserveException("Already reserved by " + this.reservedBy.getValue(coordinator).getLocalDistinguishedName(), this.getType());
            }
            this.reservedByImaLink = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"T1Ttp", (MoData)this.data, (ReferenceAttribute)this.reservedByImaLink);
        } else {
            if (this.reservedByImaLink.getValue(coordinator) != null) {
                throw new MoNotPossibleToReserveException("Already reserved by " + this.reservedByImaLink.getValue(coordinator).getLocalDistinguishedName(), this.getType());
            }
            this.reservedBy = ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (String)"T1Ttp", (MoData)this.data, (ReferenceAttribute)this.reservedBy);
        }
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        if (managedObject == null) {
            throw new InvalidReferenceException("T1Ttp", null);
        }
        if (managedObject instanceof ImaLinkBuildIF) {
            this.reservedByImaLink = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"T1Ttp", (MoData)this.data, (ReferenceAttribute)this.reservedByImaLink);
        } else {
            this.reservedBy = ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (String)"T1Ttp", (MoData)this.data, (ReferenceAttribute)this.reservedBy);
        }
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }
}

