/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pdhsdhtrans;

import enea.ose.system.Signal;
import se.ericsson.cello.common.fropxy.FroLockInd;
import se.ericsson.cello.common.fropxy.MoNotifiable;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.pdhsdhtrans.E1TtpMo;
import se.ericsson.cello.pdhsdhtrans.E1TtpMoImpl;
import se.ericsson.cello.pdhsdhtrans.Vc12TtpMo;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyVc12TtpMiAutolockInd;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyVc12TtpMiGetAttributeRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyVc12TtpMiGetPmCountersRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyVc12TtpMiLockRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyVc12TtpMiProxy;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyVc12TtpMiSetAttributeRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyVc12TtpMiShutDownRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyVc12TtpMiUnlockRsp;
import se.ericsson.cello.transaction.Coordinator;

public class Vc12TtpMoImpl
extends CelloMao
implements Vc12TtpMo,
MoNotifiable,
FroInfo {
    private static final String VC12TTP_FRO_ID = "vc12TtpFroId";
    private static final int TIM_TYPE = 21;
    private static final int TRANSMITTED_PATH_TRACE_TYPE = 22;
    private static final int EXPECTED_PATH_TRACE_TYPE = 23;
    private static final int TIM_CONSEQUENT_ACTION_TYPE = 24;
    private static final int VC_DEG_THRESHOLD_TYPE = 25;
    private static final int VC_DEG_M_TYPE = 26;
    private static final int TU_AIS_REPORTING_TYPE = 27;
    private static final int VC_RDI_REPORTING_TYPE = 28;
    private static final int OPERATIONAL_STATE_TYPE = 2;
    private static final int AVAILABILITY_STATUS_TYPE = 3;
    private static final int ADMINISTRATIVE_STATE_TYPE = 1;
    private static final int SHUT_DOWN_TIMEOUT_TYPE = 32;
    private static final int PATH_TRACE_FORMAT_ETSI = 16;
    private static final int PATH_TRACE_FORMAT_ANSI_TTC = 64;
    private static final int NO_OF_USER_CHARS_ETSI = 15;
    private static final int NO_OF_USER_CHARS_ANSI_TTC = 62;
    private static final int VC_DEG_THRESHOLD_MIN = 0;
    private static final int VC_DEG_THRESHOLD_MAX = 100;
    private static final int VC_DEG_M_MIN = 2;
    private static final int VC_DEG_M_MAX = 10;
    private static final int SHUT_DOWN_TIMEOUT_MIN = 0;
    private static final int SHUT_DOWN_TIMEOUT_MAX = 100000;
    private static final int PHY_VC12TTP_RESULT_OK = 0;
    private static final int PADDING_INT_VALUE = 99;
    private static final String E1_IDENTITY = "1";
    private MoData data;
    private StringAttribute userLabel;
    private IntegerAttribute vc12TtpFroId;
    private PhyVc12TtpMiProxy froProxy = PhyVc12TtpMiProxy.instance();
    private static NotificationSender notificationSender = NotificationSender.instance();
    private static final int MO_DATA_REVISION_34 = 3400;

    public static synchronized void create(ManagedObject managedObject, int n, String string, Coordinator coordinator) throws MoAccessException {
        Vc12TtpMoImpl.checkTransaction(coordinator);
        Vc12TtpMoImpl.checkParent(managedObject);
        new Vc12TtpMoImpl(managedObject, n, string, coordinator);
    }

    private Vc12TtpMoImpl(ManagedObject managedObject, int n, String string, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "Vc12Ttp", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.data.setRevision(3400);
        this.userLabel = new StringAttribute("userLabel", true, "");
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.vc12TtpFroId = new IntegerAttribute(VC12TTP_FRO_ID, false, n);
        this.data.registerPersistentAttr((Attribute)this.vc12TtpFroId);
        E1TtpMoImpl.create(this, n, E1_IDENTITY, coordinator);
        this.froProxy.registerForNotifications(coordinator, this, this.vc12TtpFroId.getValue(coordinator));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public Vc12TtpMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3400);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(VC12TTP_FRO_ID);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.vc12TtpFroId = (IntegerAttribute)moData.getAttribute(VC12TTP_FRO_ID);
        this.froProxy.registerForNotifications(null, this, this.vc12TtpFroId.getValue(null));
    }

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        throw new MoCanNotBeCreatedException("Vc12Ttp");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deleteMo(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.deleteChildMo(coordinator);
        this.froProxy.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    private void deleteChildMo(Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            Object object = moIterator.nextElement();
            if (!(object instanceof E1TtpMo)) continue;
            ((E1TtpMoImpl)object).deleteMo(coordinator);
        }
    }

    public String getTransmittedPathTrace(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVc12TtpMiGetAttributeRsp phyVc12TtpMiGetAttributeRsp = this.getVc12TtpFroAttr(coordinator, 22);
        char[] cArray = phyVc12TtpMiGetAttributeRsp.getStringValue();
        String string = "invalid TPT";
        string = cArray[0] == '\u0000' ? "" : new String(cArray).trim();
        return string;
    }

    public void setTransmittedPathTrace(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (!string.equals("") && string.length() > 15) {
            throw new ValueOutOfRangeException("transmittedPathTrace", "Vc12Ttp");
        }
        this.setVc12TtpFroStringAttr(coordinator, 22, string);
        this.notifyAttrChanged(coordinator, "transmittedPathTrace", string);
    }

    public String getExpectedPathTrace(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVc12TtpMiGetAttributeRsp phyVc12TtpMiGetAttributeRsp = this.getVc12TtpFroAttr(coordinator, 23);
        char[] cArray = phyVc12TtpMiGetAttributeRsp.getStringValue();
        String string = "invalid EPT";
        string = cArray[0] == '\u0000' ? "" : new String(cArray).trim();
        return string;
    }

    public void setExpectedPathTrace(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (string.equals("")) {
            this.setTimConsequentAction(false, coordinator);
        } else if (string.length() > 15) {
            throw new ValueOutOfRangeException("expectedPathTrace", "Vc12Ttp");
        }
        this.setVc12TtpFroStringAttr(coordinator, 23, string);
        this.notifyAttrChanged(coordinator, "expectedPathTrace", string);
    }

    public boolean getTimConsequentAction(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVc12TtpMiGetAttributeRsp phyVc12TtpMiGetAttributeRsp = this.getVc12TtpFroAttr(coordinator, 24);
        return MaoFroTypeConverter.int2boolean((int)phyVc12TtpMiGetAttributeRsp.getU32Value());
    }

    public void setTimConsequentAction(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = MaoFroTypeConverter.boolean2int((boolean)bl);
        this.setVc12TtpFroIntAttr(coordinator, 24, n);
        this.notifyAttrChanged(coordinator, "timConsequentAction", bl);
    }

    public int getVcDegThreshold(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVc12TtpMiGetAttributeRsp phyVc12TtpMiGetAttributeRsp = this.getVc12TtpFroAttr(coordinator, 25);
        return phyVc12TtpMiGetAttributeRsp.getU32Value();
    }

    public void setVcDegThreshold(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (!this.inRange(n, 0, 100)) {
            throw new ValueOutOfRangeException("vcDegThreshold", "Vc12Ttp");
        }
        this.setVc12TtpFroIntAttr(coordinator, 25, n);
        this.notifyAttrChanged(coordinator, "vcDegThreshold", new Integer(n));
    }

    public int getVcDegM(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVc12TtpMiGetAttributeRsp phyVc12TtpMiGetAttributeRsp = this.getVc12TtpFroAttr(coordinator, 26);
        return phyVc12TtpMiGetAttributeRsp.getU32Value();
    }

    public void setVcDegM(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (!this.inRange(n, 2, 10)) {
            throw new ValueOutOfRangeException("vcDegM", "Vc12Ttp");
        }
        this.setVc12TtpFroIntAttr(coordinator, 26, n);
        this.notifyAttrChanged(coordinator, "vcDegM", new Integer(n));
    }

    public boolean getTuAisReporting(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVc12TtpMiGetAttributeRsp phyVc12TtpMiGetAttributeRsp = this.getVc12TtpFroAttr(coordinator, 27);
        return MaoFroTypeConverter.int2boolean((int)phyVc12TtpMiGetAttributeRsp.getU32Value());
    }

    public void setTuAisReporting(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = MaoFroTypeConverter.boolean2int((boolean)bl);
        this.setVc12TtpFroIntAttr(coordinator, 27, n);
        this.notifyAttrChanged(coordinator, "tuAisReporting", bl);
    }

    public boolean getVcRdiReporting(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVc12TtpMiGetAttributeRsp phyVc12TtpMiGetAttributeRsp = this.getVc12TtpFroAttr(coordinator, 28);
        return MaoFroTypeConverter.int2boolean((int)phyVc12TtpMiGetAttributeRsp.getU32Value());
    }

    public void setVcRdiReporting(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = MaoFroTypeConverter.boolean2int((boolean)bl);
        this.setVc12TtpFroIntAttr(coordinator, 28, n);
        this.notifyAttrChanged(coordinator, "vcRdiReporting", bl);
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVc12TtpMiGetAttributeRsp phyVc12TtpMiGetAttributeRsp = this.getVc12TtpFroAttr(coordinator, 1);
        return phyVc12TtpMiGetAttributeRsp.getU32Value();
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n == 0) {
            this.lockVc12TtpFro(coordinator);
        } else if (n == 1) {
            this.unLockVc12TtpFro(coordinator);
        } else if (n == 2) {
            this.shutdownVc12TtpFro(coordinator);
        } else {
            throw new ValueOutOfRangeException("administrativeState", "Vc12Ttp");
        }
        String[] stringArray = new String[]{"administrativeState"};
        Object[] objectArray = new Object[]{new Integer(n)};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        PhyVc12TtpMiGetAttributeRsp phyVc12TtpMiGetAttributeRsp = this.getVc12TtpFroAttr(coordinator, 2);
        return phyVc12TtpMiGetAttributeRsp.getU32Value();
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        PhyVc12TtpMiGetAttributeRsp phyVc12TtpMiGetAttributeRsp = this.getVc12TtpFroAttr(coordinator, 3);
        return AvailConverter.convert((int)phyVc12TtpMiGetAttributeRsp.getU32Value());
    }

    public int getPmVcEs(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmVcEs", coordinator);
    }

    public int getPmVcSes(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmVcSes", coordinator);
    }

    public int getPmVcUas(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmVcUas", coordinator);
    }

    public int getPmVcBbe(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmVcBbe", coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"Vc12Ttp", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getShutDownTimeout(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVc12TtpMiGetAttributeRsp phyVc12TtpMiGetAttributeRsp = this.getVc12TtpFroAttr(coordinator, 32);
        return phyVc12TtpMiGetAttributeRsp.getU32Value();
    }

    public void setShutDownTimeout(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n < 0 || n > 100000) {
            throw new ValueOutOfRangeException("shutDownTimeout", "Vc12Ttp");
        }
        this.setVc12TtpFroIntAttr(coordinator, 32, n);
        this.notifyAttrChanged(coordinator, "shutDownTimeout", new Integer(n));
    }

    public String getType() {
        return "Vc12Ttp";
    }

    private static void checkTransaction(Coordinator coordinator) throws TransactionRequiredException {
        if (coordinator == null) {
            throw new TransactionRequiredException();
        }
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.vc12TtpFroId.getValue(coordinator);
    }

    private PhyVc12TtpMiGetAttributeRsp getVc12TtpFroAttr(Coordinator coordinator, int n) throws MoAccessException {
        int n2 = 0;
        if (coordinator != null) {
            n2 = coordinator.getTransactionID();
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVc12TtpMiGetAttributeRsp phyVc12TtpMiGetAttributeRsp = this.froProxy.sendPhyVc12TtpMiGetAttributeReq(n2, this.vc12TtpFroId.getValue(coordinator), n);
        this.checkSignal((Signal)phyVc12TtpMiGetAttributeRsp);
        if (phyVc12TtpMiGetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("Vc12Ttp", "Vc12TtpFro", "GetAttrReq: " + this.froProxy.getResultMsg(phyVc12TtpMiGetAttributeRsp.getResult()), phyVc12TtpMiGetAttributeRsp.getResult());
        }
        return phyVc12TtpMiGetAttributeRsp;
    }

    private void setVc12TtpFroIntAttr(Coordinator coordinator, int n, int n2) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        char[] cArray = this.convertStringToCharArray("");
        PhyVc12TtpMiSetAttributeRsp phyVc12TtpMiSetAttributeRsp = this.froProxy.sendPhyVc12TtpMiSetAttributeReq(coordinator.getTransactionID(), this.vc12TtpFroId.getValue(coordinator), n, n2, cArray);
        this.checkSignal((Signal)phyVc12TtpMiSetAttributeRsp);
        if (phyVc12TtpMiSetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("Vc12Ttp", "Vc12TtpFro", "SetAttrReq: " + this.froProxy.getResultMsg(phyVc12TtpMiSetAttributeRsp.getResult()), phyVc12TtpMiSetAttributeRsp.getResult());
        }
    }

    private void setVc12TtpFroStringAttr(Coordinator coordinator, int n, String string) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n2 = 99;
        char[] cArray = this.convertStringToCharArray(string);
        PhyVc12TtpMiSetAttributeRsp phyVc12TtpMiSetAttributeRsp = this.froProxy.sendPhyVc12TtpMiSetAttributeReq(coordinator.getTransactionID(), this.vc12TtpFroId.getValue(coordinator), n, n2, cArray);
        this.checkSignal((Signal)phyVc12TtpMiSetAttributeRsp);
        if (phyVc12TtpMiSetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("Vc12Ttp", "Vc12TtpFro", "SetAttrReq: " + this.froProxy.getResultMsg(phyVc12TtpMiSetAttributeRsp.getResult()), phyVc12TtpMiSetAttributeRsp.getResult());
        }
    }

    private PhyVc12TtpMiGetPmCountersRsp getVc12TtpPmCounter(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVc12TtpMiGetPmCountersRsp phyVc12TtpMiGetPmCountersRsp = this.froProxy.sendPhyVc12TtpMiGetPmCountersReq(this.vc12TtpFroId.getValue(coordinator));
        if (phyVc12TtpMiGetPmCountersRsp == null) {
            throw new FroNotAccessibleException("Vc12Ttp", "GetPmCountersReq");
        }
        if (phyVc12TtpMiGetPmCountersRsp.getResult() == 100) {
            phyVc12TtpMiGetPmCountersRsp.setPmCountersUnavailable();
        } else if (phyVc12TtpMiGetPmCountersRsp.getResult() != 0) {
            throw new FroRequestFailedException("Vc12Ttp", "Vc12TtpFro", "GetPmCounterReq: " + this.froProxy.getResultMsg(phyVc12TtpMiGetPmCountersRsp.getResult()), phyVc12TtpMiGetPmCountersRsp.getResult());
        }
        return phyVc12TtpMiGetPmCountersRsp;
    }

    private void notifyAttrChanged(Coordinator coordinator, String string, Object object) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    private boolean inRange(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    private void checkSignal(Signal signal) throws MoAccessException {
        if (signal == null) {
            throw new FroNotAccessibleException("Vc12Ttp", "Vc12TtpFro");
        }
    }

    static void checkParent(ManagedObject managedObject) throws MoAccessException {
        if (!managedObject.getType().equals("Vc4Ttp")) {
            throw new IllegalParentException("Vc12Ttp");
        }
    }

    public char[] convertStringToCharArray(String string) {
        char[] cArray = new char[65];
        if (string.equals("")) {
            return cArray;
        }
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                cArray[i] = string.charAt(i);
            }
        }
        return cArray;
    }

    public synchronized void parameterChanged(FroLockInd froLockInd, String string) {
        if (froLockInd instanceof PhyVc12TtpMiAutolockInd) {
            String[] stringArray = new String[]{"administrativeState"};
            Object[] objectArray = new Object[]{new Integer(0)};
            notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray);
        }
    }

    private void lockVc12TtpFro(Coordinator coordinator) throws MoAccessException {
        PhyVc12TtpMiLockRsp phyVc12TtpMiLockRsp = this.froProxy.sendPhyVc12TtpMiLockReq(coordinator.getTransactionID(), this.vc12TtpFroId.getValue(coordinator));
        if (phyVc12TtpMiLockRsp == null) {
            throw new FroNotAccessibleException("Vc12Ttp", "lockVc12TtpMiFro");
        }
        if (phyVc12TtpMiLockRsp.getResult() != 0) {
            throw new FroRequestFailedException("Vc12Ttp", "Vc12TtpFro", "ActionReq: " + this.froProxy.getResultMsg(phyVc12TtpMiLockRsp.getResult()), phyVc12TtpMiLockRsp.getResult());
        }
    }

    private void unLockVc12TtpFro(Coordinator coordinator) throws MoAccessException {
        PhyVc12TtpMiUnlockRsp phyVc12TtpMiUnlockRsp = this.froProxy.sendPhyVc12TtpMiUnlockReq(coordinator.getTransactionID(), this.vc12TtpFroId.getValue(coordinator));
        if (phyVc12TtpMiUnlockRsp == null) {
            throw new FroNotAccessibleException("Vc12Ttp", "UnlockVc12TtpMiFro");
        }
        if (phyVc12TtpMiUnlockRsp.getResult() != 0) {
            throw new FroRequestFailedException("Vc12Ttp", "Vc12TtpFro", "ActionReq: " + this.froProxy.getResultMsg(phyVc12TtpMiUnlockRsp.getResult()), phyVc12TtpMiUnlockRsp.getResult());
        }
    }

    private void shutdownVc12TtpFro(Coordinator coordinator) throws MoAccessException {
        PhyVc12TtpMiShutDownRsp phyVc12TtpMiShutDownRsp = this.froProxy.sendPhyVc12TtpMiShutDownReq(coordinator.getTransactionID(), this.vc12TtpFroId.getValue(coordinator));
        if (phyVc12TtpMiShutDownRsp == null) {
            throw new FroNotAccessibleException("Vc12Ttp", "ShutdownVc12TtpMiFro");
        }
        if (phyVc12TtpMiShutDownRsp.getResult() != 0) {
            throw new FroRequestFailedException("Vc12Ttp", "Vc12TtpFro", "ActionReq: " + this.froProxy.getResultMsg(phyVc12TtpMiShutDownRsp.getResult()), phyVc12TtpMiShutDownRsp.getResult());
        }
    }
}

