/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pdhsdhtrans;

import enea.ose.system.Signal;
import se.ericsson.cello.common.fropxy.FroLockInd;
import se.ericsson.cello.common.fropxy.MoNotifiable;
import se.ericsson.cello.faultmanagement.AlarmManager;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AvailConverter;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.pdhsdhtrans.T1TtpMo;
import se.ericsson.cello.pdhsdhtrans.T1TtpMoImpl;
import se.ericsson.cello.pdhsdhtrans.Vt15TtpMo;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyVt1_5TtpMiAutolockInd;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyVt1_5TtpMiGetAttributeRsp;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyVt1_5TtpMiProxy;
import se.ericsson.cello.pdhsdhtrans.fropxy.PhyVt1_5TtpMiSetAttributeRsp;
import se.ericsson.cello.transaction.Coordinator;

public class Vt15TtpMoImpl
extends CelloMao
implements Vt15TtpMo,
FroInfo,
MoNotifiable {
    private static final String VT1_5TTP_FRO_ID = "vt15TtpFroId";
    private static final int AIS_REPORTING_TYPE = 27;
    private static final int RDI_REPORTING_TYPE = 28;
    private static final int OPERATIONAL_STATE_TYPE = 2;
    private static final int AVAILABILITY_STATUS_TYPE = 3;
    private static final int ADMINISTRATIVE_STATE_TYPE = 1;
    private static final int SHUT_DOWN_TIMEOUT_TYPE = 32;
    private static final int SHUT_DOWN_TIMER_MIN = 0;
    private static final int SHUT_DOWN_TIMER_MAX = 100000;
    private static final int PHY_VT1_5TTP_RESULT_OK = 0;
    private static final int PADDING_INT_VALUE = 99;
    private static final String T1_IDENTITY = "1";
    private MoData data;
    private StringAttribute userLabel;
    private IntegerAttribute vt15TtpFroId;
    private PhyVt1_5TtpMiProxy froProxy = PhyVt1_5TtpMiProxy.instance();
    private static NotificationSender notificationSender = NotificationSender.instance();
    private static final int MO_DATA_REVISION_42 = 4200;

    public static synchronized ManagedObject create(ManagedObject managedObject, int n, String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"Sts1SpeTtp");
        return new Vt15TtpMoImpl(managedObject, n, string, coordinator);
    }

    private Vt15TtpMoImpl(ManagedObject managedObject, int n, String string, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "Vt15Ttp", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.data.setRevision(4200);
        this.userLabel = new StringAttribute("userLabel", true, "");
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.vt15TtpFroId = new IntegerAttribute(VT1_5TTP_FRO_ID, false, n);
        this.data.registerPersistentAttr((Attribute)this.vt15TtpFroId);
        this.froProxy.registerForNotifications(coordinator, this, this.vt15TtpFroId.getValue(coordinator));
        T1TtpMoImpl.create(this, n, T1_IDENTITY, coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public Vt15TtpMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(4200);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(VT1_5TTP_FRO_ID);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.vt15TtpFroId = (IntegerAttribute)moData.getAttribute(VT1_5TTP_FRO_ID);
        this.froProxy.registerForNotifications(null, this, this.vt15TtpFroId.getValue(null));
    }

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        throw new MoCanNotBeCreatedException("Vt15Ttp");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deleteMo(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.deleteChildMo(coordinator);
        this.froProxy.deregisterForNotifications(coordinator, this.getFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    private void deleteChildMo(Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = this.getChildren();
        while (moIterator.hasMoreElements()) {
            Object object = moIterator.nextElement();
            if (!(object instanceof T1TtpMo)) continue;
            ((T1TtpMoImpl)object).deleteMo(coordinator);
        }
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.vt15TtpFroId.getValue(coordinator);
    }

    public boolean getAisVreporting(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVt1_5TtpMiGetAttributeRsp phyVt1_5TtpMiGetAttributeRsp = this.getVt15TtpFroAttr(coordinator, 27);
        return MaoFroTypeConverter.int2boolean((int)phyVt1_5TtpMiGetAttributeRsp.getU32Value());
    }

    public void setAisVreporting(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = MaoFroTypeConverter.boolean2int((boolean)bl);
        this.setVt15TtpFroIntAttr(coordinator, 27, n);
        this.notifyAttrChanged(coordinator, "aisVreporting", bl);
    }

    public boolean getRdiVreporting(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVt1_5TtpMiGetAttributeRsp phyVt1_5TtpMiGetAttributeRsp = this.getVt15TtpFroAttr(coordinator, 28);
        return MaoFroTypeConverter.int2boolean((int)phyVt1_5TtpMiGetAttributeRsp.getU32Value());
    }

    public void setRdiVreporting(boolean bl, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n = MaoFroTypeConverter.boolean2int((boolean)bl);
        this.setVt15TtpFroIntAttr(coordinator, 28, n);
        this.notifyAttrChanged(coordinator, "rdiVreporting", bl);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"Vt15Ttp", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public int getShutDownTimer(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVt1_5TtpMiGetAttributeRsp phyVt1_5TtpMiGetAttributeRsp = this.getVt15TtpFroAttr(coordinator, 32);
        return phyVt1_5TtpMiGetAttributeRsp.getU32Value();
    }

    public void setShutDownTimer(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n < 0 || n > 100000) {
            throw new ValueOutOfRangeException("shutDownTimer", "Vt15Ttp");
        }
        this.setVt15TtpFroIntAttr(coordinator, 32, n);
        this.notifyAttrChanged(coordinator, "shutDownTimer", new Integer(n));
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        PhyVt1_5TtpMiGetAttributeRsp phyVt1_5TtpMiGetAttributeRsp = this.getVt15TtpFroAttr(coordinator, 2);
        return phyVt1_5TtpMiGetAttributeRsp.getU32Value();
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        PhyVt1_5TtpMiGetAttributeRsp phyVt1_5TtpMiGetAttributeRsp = this.getVt15TtpFroAttr(coordinator, 3);
        return AvailConverter.convert((int)phyVt1_5TtpMiGetAttributeRsp.getU32Value());
    }

    public int getAdministrativeState(Coordinator coordinator) throws MoAccessException {
        PhyVt1_5TtpMiGetAttributeRsp phyVt1_5TtpMiGetAttributeRsp = this.getVt15TtpFroAttr(coordinator, 1);
        return phyVt1_5TtpMiGetAttributeRsp.getU32Value();
    }

    public void setAdministrativeState(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.setVt15TtpFroIntAttr(coordinator, 1, n);
        this.notifyAttrChanged(coordinator, "administrativeState", new Integer(n));
    }

    public int getPmEs(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmEs", coordinator);
    }

    public int getPmSes(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmSes", coordinator);
    }

    public int getPmUas(Coordinator coordinator) throws MoAccessException {
        return super.getPmAttribute("pmUas", coordinator);
    }

    public String getType() {
        return "Vt15Ttp";
    }

    private void notifyAttrChanged(Coordinator coordinator, String string, Object object) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    private PhyVt1_5TtpMiGetAttributeRsp getVt15TtpFroAttr(Coordinator coordinator, int n) throws MoAccessException {
        int n2 = 0;
        if (coordinator != null) {
            n2 = coordinator.getTransactionID();
        }
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        PhyVt1_5TtpMiGetAttributeRsp phyVt1_5TtpMiGetAttributeRsp = this.froProxy.sendPhyVt1_5TtpMiGetAttributeReq(n2, this.vt15TtpFroId.getValue(coordinator), n);
        this.checkSignal((Signal)phyVt1_5TtpMiGetAttributeRsp);
        if (phyVt1_5TtpMiGetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("Vt15Ttp", "Vt15TtpFro", "GetAttrReq: " + this.froProxy.getResultMsg(phyVt1_5TtpMiGetAttributeRsp.getResult()), phyVt1_5TtpMiGetAttributeRsp.getResult());
        }
        return phyVt1_5TtpMiGetAttributeRsp;
    }

    private void setVt15TtpFroIntAttr(Coordinator coordinator, int n, int n2) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        char[] cArray = this.convertStringToCharArray("");
        PhyVt1_5TtpMiSetAttributeRsp phyVt1_5TtpMiSetAttributeRsp = this.froProxy.sendPhyVt1_5TtpMiSetAttributeReq(coordinator.getTransactionID(), this.vt15TtpFroId.getValue(coordinator), n, n2, cArray);
        this.checkSignal((Signal)phyVt1_5TtpMiSetAttributeRsp);
        if (phyVt1_5TtpMiSetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("Vt15Ttp", "Vt15TtpFro", "SetAttrReq: " + this.froProxy.getResultMsg(phyVt1_5TtpMiSetAttributeRsp.getResult()), phyVt1_5TtpMiSetAttributeRsp.getResult());
        }
    }

    private void setVt15TtpFroStringAttr(Coordinator coordinator, int n, String string) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        int n2 = 99;
        char[] cArray = this.convertStringToCharArray(string);
        PhyVt1_5TtpMiSetAttributeRsp phyVt1_5TtpMiSetAttributeRsp = this.froProxy.sendPhyVt1_5TtpMiSetAttributeReq(coordinator.getTransactionID(), this.vt15TtpFroId.getValue(coordinator), n, n2, cArray);
        this.checkSignal((Signal)phyVt1_5TtpMiSetAttributeRsp);
        if (phyVt1_5TtpMiSetAttributeRsp.getResult() != 0) {
            throw new FroRequestFailedException("Vt15Ttp", "Vt15TtpFro", "SetAttrReq: " + this.froProxy.getResultMsg(phyVt1_5TtpMiSetAttributeRsp.getResult()), phyVt1_5TtpMiSetAttributeRsp.getResult());
        }
    }

    public synchronized void parameterChanged(FroLockInd froLockInd, String string) {
        if (froLockInd instanceof PhyVt1_5TtpMiAutolockInd) {
            String[] stringArray = new String[]{"administrativeState"};
            Object[] objectArray = new Object[]{new Integer(0)};
            notificationSender.pushAVC((ManagedObject)this, stringArray, objectArray);
            AlarmManager.getReporter().reportEvent(44, (ManagedObject)this, "", "", null);
        }
    }

    private void checkSignal(Signal signal) throws MoAccessException {
        if (signal == null) {
            throw new FroNotAccessibleException("Vt15Ttp", "Vt15TtpFro");
        }
    }

    public char[] convertStringToCharArray(String string) {
        int n;
        char[] cArray = new char[65];
        int n2 = 32;
        for (n = 0; n < 64; ++n) {
            cArray[n] = n2;
        }
        cArray[64] = '\u0000';
        if (string.equals("")) {
            for (n = 0; n < 64; ++n) {
                cArray[n] = '\u0000';
            }
            return cArray;
        }
        if (string != null) {
            for (n = 0; n < string.length(); ++n) {
                cArray[n] = string.charAt(n);
            }
        }
        if (string.length() == 15) {
            cArray[15] = '\u0000';
        } else if (string.length() == 62) {
            cArray[62] = 13;
            cArray[63] = 10;
        }
        return cArray;
    }
}

