/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step2.actions;

import java.util.Collection;
import java.util.Iterator;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataFilter;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;
import se.ericsson.crbs.omf.aue.common.util.AueUtil;

public class DeleteMoInstanceAction
implements MoDataAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step2$actions$DeleteMoInstanceAction == null ? (class$se$ericsson$crbs$omf$aue$step2$actions$DeleteMoInstanceAction = DeleteMoInstanceAction.class$("se.ericsson.crbs.omf.aue.step2.actions.DeleteMoInstanceAction")) : class$se$ericsson$crbs$omf$aue$step2$actions$DeleteMoInstanceAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    protected final String ldn;
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step2$actions$DeleteMoInstanceAction;

    public DeleteMoInstanceAction(String ldn) throws CrbsAueException {
        if (!AueUtil.isLdn(ldn)) {
            throw new CrbsAueException("Specified LDN " + AueUtil.doubleQuote(ldn) + " is not a valid LDN");
        }
        this.ldn = this.trimLdn(ldn);
    }

    public void perform(MoDataWrapper moDataWrapper, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        block6: {
            logger.traceEnter(THIS_CLASS, "perform(" + this.ldn + ")");
            try {
                String moLdn = this.trimLdn(moDataWrapper.getLocalDistinguishedName());
                if (!moLdn.equals(this.ldn)) break block6;
                this.deleteChildren(moLdn, converterContext, coordinator);
                MoDataAccessor moDataAccessor = converterContext.getMoDataAccessor();
                try {
                    moDataAccessor.delete(moDataWrapper, coordinator);
                }
                catch (AueException ae) {
                    CrbsAueException cae = new CrbsAueException(ae.getMessage());
                    cae.setStackTrace(ae.getStackTrace());
                    throw cae;
                }
                if (moDataWrapper.isDeleted()) {
                    logger.traceGeneral(THIS_CLASS, this.ldn + " successfully deleted!");
                } else {
                    logger.traceError(THIS_CLASS, this.ldn + " NOT deleted !");
                }
            }
            catch (CrbsAueException auee) {
                logger.traceError(THIS_CLASS, auee.getMessage(), (Throwable)((Object)auee));
                throw auee;
            }
        }
        logger.traceReturn(THIS_CLASS, "perform(" + this.ldn + ")");
    }

    private void deleteChildren(String parentLdn, ConverterContext converterContext, Coordinator coordinator) throws CrbsAueException {
        final String ldnToLookFor = parentLdn.endsWith(",") ? parentLdn : parentLdn + ",";
        MoDataAccessor accessor = converterContext.getMoDataAccessor();
        try {
            Collection children = accessor.find(new MoDataFilter(){

                public boolean accept(MoDataWrapper localMoDataWrapper) {
                    String trimmedLdn = DeleteMoInstanceAction.this.trimLdn(localMoDataWrapper.getLocalDistinguishedName());
                    return trimmedLdn.startsWith(ldnToLookFor);
                }
            });
            if (children != null) {
                Iterator childIter = children.iterator();
                while (childIter.hasNext()) {
                    MoDataWrapper moDataWrapper = (MoDataWrapper)childIter.next();
                    String childLdn = moDataWrapper.getLocalDistinguishedName();
                    accessor.delete(moDataWrapper, coordinator);
                    if (!moDataWrapper.isDeleted()) continue;
                    logger.traceGeneral(THIS_CLASS, "Deleted the child: " + AueUtil.doubleQuote(childLdn) + ", of MO, " + AueUtil.doubleQuote(parentLdn));
                }
            }
        }
        catch (CrbsAueException cae) {
            throw cae;
        }
        catch (AueException ae) {
            CrbsAueException cae = new CrbsAueException(ae.getMessage());
            cae.setStackTrace(ae.getStackTrace());
            throw cae;
        }
    }

    private String trimLdn(String ldnToBeTrimmed) {
        return AueUtil.replaceInString(ldnToBeTrimmed, " ", "");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

