/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.aue.step2.actions;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import se.ericsson.cello.aueframework.common.AueException;
import se.ericsson.cello.aueframework.converter.ConverterContext;
import se.ericsson.cello.aueframework.converter.FindMoDataByLDNFilter;
import se.ericsson.cello.aueframework.converter.MoDataAccessor;
import se.ericsson.cello.aueframework.converter.MoDataAction;
import se.ericsson.cello.aueframework.converter.MoDataFilter;
import se.ericsson.cello.aueframework.converter.MoDataWrapper;
import se.ericsson.cello.aueframework.converter.actions.ReplaceInAllLDNs;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.crbs.omf.aue.common.CrbsAueException;
import se.ericsson.crbs.omf.aue.common.FindMoDataByParentLDNFilter;
import se.ericsson.crbs.omf.aue.common.logging.AbstractLogger;
import se.ericsson.crbs.omf.aue.common.logging.LoggingService;

public class ReplaceInAllLdnsAction
implements MoDataAction {
    private static final Class THIS_CLASS = class$se$ericsson$crbs$omf$aue$step2$actions$ReplaceInAllLdnsAction == null ? (class$se$ericsson$crbs$omf$aue$step2$actions$ReplaceInAllLdnsAction = ReplaceInAllLdnsAction.class$("se.ericsson.crbs.omf.aue.step2.actions.ReplaceInAllLdnsAction")) : class$se$ericsson$crbs$omf$aue$step2$actions$ReplaceInAllLdnsAction;
    private static final AbstractLogger logger = LoggingService.getLogger(THIS_CLASS.getName());
    private final String oldLdnPart;
    private final String newLdnPart;
    static /* synthetic */ Class class$se$ericsson$crbs$omf$aue$step2$actions$ReplaceInAllLdnsAction;

    public ReplaceInAllLdnsAction(String oldLdnPart, String newLdnPart) {
        this.oldLdnPart = oldLdnPart;
        this.newLdnPart = newLdnPart;
    }

    public void perform(MoDataWrapper moDataWrapper, ConverterContext context, Coordinator coordinator) throws CrbsAueException {
        logger.traceEnter(THIS_CLASS, "perform()");
        this.findAndUpdateReferencedMos(moDataWrapper, context, coordinator);
        this.findAndUpdateChildMos(moDataWrapper, context, coordinator);
        this.updateMo(moDataWrapper, context, coordinator);
        logger.traceReturn(THIS_CLASS, "perform()");
    }

    private void findAndUpdateReferencedMos(MoDataWrapper moDataWrapper, ConverterContext context, Coordinator coordinator) throws CrbsAueException {
        logger.traceDebug(THIS_CLASS, "Enter findAndUpdateInReferencedMos() for MO: " + moDataWrapper.getLocalDistinguishedName());
        Enumeration allAttributes = moDataWrapper.getAllPersistentAttributes();
        while (allAttributes != null && allAttributes.hasMoreElements()) {
            Attribute attribute = (Attribute)allAttributes.nextElement();
            if (attribute == null) continue;
            this.findAndUpdateMosFromAttribute(attribute, context, coordinator);
        }
        logger.traceDebug(THIS_CLASS, "Return findAndUpdateInReferencedMos()");
    }

    private void findAndUpdateMosFromAttribute(Attribute attribute, ConverterContext context, Coordinator coordinator) throws CrbsAueException {
        logger.traceDebug(THIS_CLASS, "Enter findAndUpdateMosFromAttribute() for attribute: " + attribute.getName());
        if (attribute instanceof ReferenceAttribute && attribute != null) {
            this.updateMo(((ReferenceAttribute)attribute).getReferenceAsLDN(), context, coordinator);
        } else if (attribute instanceof StructAttribute) {
            Attribute[] attributes = ((StructAttribute)attribute).getElements(coordinator);
            for (int i = 0; i < attributes.length; ++i) {
                this.findAndUpdateMosFromAttribute(attributes[i], context, coordinator);
            }
        } else if (attribute instanceof SequenceAttribute) {
            Attribute[] attributes = ((SequenceAttribute)attribute).getValue(coordinator);
            Attribute firstAttr = null;
            if (attributes.length > 0) {
                firstAttr = attributes[0];
            }
            if (firstAttr instanceof ReferenceAttribute || firstAttr instanceof StructAttribute || firstAttr instanceof SequenceAttribute) {
                for (int i = 0; i < attributes.length; ++i) {
                    this.findAndUpdateMosFromAttribute(attributes[i], context, coordinator);
                }
            }
        }
        logger.traceDebug(THIS_CLASS, "Return findAndUpdateMosFromAttribute() for attribute: " + attribute.getName());
    }

    private void findAndUpdateChildMos(MoDataWrapper parentMo, ConverterContext context, Coordinator coordinator) throws CrbsAueException {
        logger.traceDebug(THIS_CLASS, "Enter findAndUpdateChildMos() for parent MO: " + parentMo.getLocalDistinguishedName());
        MoDataAccessor moDataAccessor = context.getMoDataAccessor();
        String parentLdn = parentMo.getLocalDistinguishedName();
        try {
            Collection children = moDataAccessor.find((MoDataFilter)new FindMoDataByParentLDNFilter(parentLdn));
            Iterator childIterator = children.iterator();
            while (childIterator.hasNext()) {
                this.perform((MoDataWrapper)childIterator.next(), context, coordinator);
            }
        }
        catch (AueException ae) {
            CrbsAueException cae = new CrbsAueException(ae.getMessage());
            cae.setStackTrace(ae.getStackTrace());
            throw cae;
        }
        logger.traceDebug(THIS_CLASS, "Return findAndUpdateChildMos() for parent MO: " + parentMo.getLocalDistinguishedName());
    }

    private void updateMo(MoDataWrapper moDataWrapper, ConverterContext context, Coordinator coordinator) throws CrbsAueException {
        logger.traceDebug(THIS_CLASS, "Enter updateMo() for MO: " + moDataWrapper.getLocalDistinguishedName());
        ReplaceInAllLDNs cppReplaceInAllLdns = new ReplaceInAllLDNs(this.oldLdnPart, this.newLdnPart);
        try {
            cppReplaceInAllLdns.perform(moDataWrapper, context, coordinator);
        }
        catch (AueException ae) {
            CrbsAueException cae = new CrbsAueException(ae.getMessage());
            cae.setStackTrace(ae.getStackTrace());
            throw cae;
        }
        logger.traceDebug(THIS_CLASS, "Return updateMo()");
    }

    private void updateMo(String ldn, ConverterContext context, Coordinator coordinator) throws CrbsAueException {
        if (ldn == null) {
            logger.traceAbnormal(THIS_CLASS, "Could not update the LDN and/or reference LDNs for: " + ldn + ". Reason: Ldn is null");
        } else {
            FindMoDataByLDNFilter filter = new FindMoDataByLDNFilter(ldn);
            try {
                MoDataWrapper mo = context.getMoDataAccessor().findFirst((MoDataFilter)filter);
                if (mo == null) {
                    logger.traceAbnormal(THIS_CLASS, "Could not update the LDN and/or reference LDNs for: " + ldn + ". Reason: No MO with that LDN was found.");
                } else {
                    this.updateMo(mo, context, coordinator);
                }
            }
            catch (AueException ae) {
                CrbsAueException cae = new CrbsAueException(ae.getMessage());
                cae.setStackTrace(ae.getStackTrace());
                throw cae;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

