/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal;

import java.io.IOException;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.POA;
import se.ericsson.cello.neal.CelloNode;
import se.ericsson.cello.neal.NealLogger;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.NodeConfig;
import se.ericsson.cello.neal.internal.NealLog;
import se.ericsson.cello.neal.internal.NealOrb;
import se.ericsson.cello.neal.internal.SystemOutLogger;
import se.ericsson.cello.neal.internal.omsi_version.OmsiAndAdapterTypeRepository;

public final class NodeAccess {
    private static final int LOG_LEVEL_FINE = 500;
    private static Node myMockNode;

    private NodeAccess() {
    }

    public static Node getNode(String string) throws IOException {
        if (myMockNode != null) {
            return myMockNode;
        }
        return NodeAccess.getNode(new NodeConfig(string));
    }

    public static Node getNode(NodeConfig nodeConfig) throws IOException {
        NealLogger nealLogger = NodeAccess.getLogger();
        if (nealLogger == null) {
            NodeAccess.createSystemOutLogger();
        }
        if (myMockNode != null) {
            return myMockNode;
        }
        String string = nodeConfig.getConnectionInfo();
        if (string == null) {
            throw new IllegalArgumentException("getNode : NodeConfig Parameter contains null ConnectionInfo");
        }
        CelloNode celloNode = new CelloNode(nodeConfig.getNodeConfiguration());
        return celloNode;
    }

    private static void createSystemOutLogger() {
        if (System.getProperty("neal.log", "off").equalsIgnoreCase("stdout")) {
            SystemOutLogger systemOutLogger = new SystemOutLogger();
            NodeAccess.setLogger(systemOutLogger);
            String string = System.getProperty("neal.level", Integer.toString(500));
            try {
                systemOutLogger.setLevel(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                systemOutLogger.info("Invalid log level provided. Setting default 500 (FINE)");
                systemOutLogger.setLevel(500);
            }
        }
    }

    public static void setExternalOrbAndPoa(ORB oRB, POA pOA, POA pOA2) {
        NealOrb.setDefaultOrbAndPoa(oRB, pOA, pOA2);
    }

    public static void setLogger(NealLogger nealLogger) {
        NealLog.setLogger(nealLogger);
    }

    public static NealLogger getLogger() {
        return NealLog.getLogger();
    }

    public static void setMockNode(Node node) {
        myMockNode = node;
    }

    static {
        OmsiAndAdapterTypeRepository.instance();
    }
}

