/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.cm;

import BasicConfig.MORefHelper;
import BasicConfig.MOidpair;
import BasicConfig.MOidpairHelper;
import BasicConfig.MOidpairSeqHelper;
import CosNaming.NameComponent;
import java.lang.reflect.Array;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UserException;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynSequenceHelper;
import org.omg.DynamicAny.DynStruct;
import org.omg.DynamicAny.DynStructHelper;
import org.omg.DynamicAny.NameValuePair;
import org.threegppsa5.NotificationIRPConstDefs.CorrelatedNotification;
import org.threegppsa5.NotificationIRPConstDefs.CorrelatedNotificationSetTypeHelper;
import se.ericsson.cello.configirpimpl.helpers.BooleanSeqHelper;
import se.ericsson.cello.configirpimpl.helpers.FloatSeqHelper;
import se.ericsson.cello.configirpimpl.helpers.LongLongSeqHelper;
import se.ericsson.cello.configirpimpl.helpers.LongSeqHelper;
import se.ericsson.cello.configirpimpl.helpers.StringSeqHelper;
import se.ericsson.cello.neal.cm.CelloManagedObject;
import se.ericsson.cello.neal.cm.CelloNameValue;
import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.cello.neal.cm.CorrelatedNotifications;
import se.ericsson.cello.neal.cm.CorrelatedNotificationsImpl;
import se.ericsson.cello.neal.cm.EasyNaming;
import se.ericsson.cello.neal.cm.IllegalTypeException;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.Struct;
import se.ericsson.cello.neal.cm.UtcTime;
import se.ericsson.cello.neal.cm.Value;
import se.ericsson.cello.neal.internal.NealLog;
import se.ericsson.cello.neal.internal.NealOrb;
import se.ericsson.cello.neal.internal.ServiceContext;
import se.ericsson.cello.neal.internal.jvm_version.NealArrays;
import se.ericsson.cello.neal.internal.omsi_version.UtcTAdapter;
import se.ericsson.cello.neal.internal.omsi_version.UtcTHelperAdapter;

class CelloValue
implements Value {
    static final String UNDEFINED = "undefined";
    private int _type = 0;
    private int _arrayType = 0;
    private java.lang.Object _value;
    private ServiceContext serviceContext;

    CelloValue() {
        this._type = 0;
    }

    CelloValue(int n) {
        this.setIntValue(n);
    }

    CelloValue(long l) {
        this.setLongValue(l);
    }

    CelloValue(float f) {
        this.setFloatValue(f);
    }

    CelloValue(boolean bl) {
        this.setBooleanValue(bl);
    }

    CelloValue(String string) {
        this.setStringValue(string);
    }

    CelloValue(Mo mo) {
        this.setMoValue(mo);
    }

    CelloValue(UtcTime utcTime) {
        this.setUtcTimeValue(utcTime);
    }

    CelloValue(UtcTime[] utcTimeArray) {
        this.setUtcTimeArrayValue(utcTimeArray);
    }

    CelloValue(CorrelatedNotifications correlatedNotifications) {
        this.setCorrelatedNotificationsValue(correlatedNotifications);
    }

    CelloValue(Struct struct) {
        this.setStructValue(struct);
    }

    CelloValue(Struct[] structArray) {
        this.setStructArrayValue(structArray);
    }

    CelloValue(int[] nArray) {
        this.setIntArrayValue(nArray);
    }

    CelloValue(long[] lArray) {
        this.setLongArrayValue(lArray);
    }

    CelloValue(boolean[] blArray) {
        this.setBooleanArrayValue(blArray);
    }

    CelloValue(float[] fArray) {
        this.setFloatArrayValue(fArray);
    }

    CelloValue(String[] stringArray) {
        this.setStringArrayValue(stringArray);
    }

    CelloValue(Mo[] moArray) {
        this.setMoArrayValue(moArray);
    }

    CelloValue(Any any) {
        this.setAnyValue(any);
    }

    CelloValue(Any any, ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        this._type = this.extractType(any);
        this._value = this.extractValue(any);
    }

    CelloValue(int n, Any any, ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        this._type = n;
        this._value = this.extractValue(any);
    }

    public boolean equals(java.lang.Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CelloValue)) {
            return false;
        }
        CelloValue celloValue = (CelloValue)object;
        if (!this._value.getClass().isArray()) {
            return this._value.equals(celloValue._value);
        }
        if (!celloValue._value.getClass().isArray()) {
            return false;
        }
        try {
            int n = Array.getLength(this._value);
            if (n != Array.getLength(celloValue._value)) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                java.lang.Object object2;
                java.lang.Object object3 = Array.get(this._value, i);
                if (object3.equals(object2 = Array.get(celloValue._value, i))) continue;
                return false;
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            NealLog.severe("NEAL INTERNAL ERROR! Falied comparing this " + this.describe() + " for equality!", runtimeException);
            throw runtimeException;
        }
    }

    public int hashCode() {
        return this.getValue() == null ? 0 : this.getValue().hashCode();
    }

    String getName() {
        return UNDEFINED;
    }

    public int getType() {
        return this._type;
    }

    public int getArrayType() {
        return this._arrayType;
    }

    public java.lang.Object getValue() {
        return this._value;
    }

    public void setBooleanValue(boolean bl) {
        this._type = 1;
        this._value = bl;
    }

    public void setIntValue(int n) {
        this._type = 5;
        this._value = new Integer(n);
    }

    public void setLongValue(long l) {
        this._type = 6;
        this._value = new Long(l);
    }

    public void setFloatValue(float f) {
        this._type = 7;
        this._value = new Float(f);
    }

    public void setStringValue(String string) {
        this._type = 9;
        this._value = string;
    }

    void setFDNValue(String string) {
        this._type = 14;
        this._value = string;
    }

    public void setIntArrayValue(int[] nArray) {
        this._type = 13;
        this._arrayType = 5;
        this._value = nArray;
    }

    public void setLongArrayValue(long[] lArray) {
        this._type = 13;
        this._arrayType = 6;
        this._value = lArray;
    }

    public void setBooleanArrayValue(boolean[] blArray) {
        this._type = 13;
        this._arrayType = 1;
        this._value = blArray;
    }

    public void setFloatArrayValue(float[] fArray) {
        this._type = 13;
        this._arrayType = 7;
        this._value = fArray;
    }

    public void setStringArrayValue(String[] stringArray) {
        this._type = 13;
        this._arrayType = 9;
        this._value = stringArray;
    }

    public void setMoArrayValue(Mo[] moArray) {
        this._type = 13;
        this._arrayType = 12;
        this._value = moArray;
    }

    public void setStructValue(Struct struct) {
        this._type = 11;
        this._value = struct;
    }

    public void setStructArrayValue(Struct[] structArray) {
        this._type = 13;
        this._arrayType = 11;
        this._value = structArray;
    }

    public void setMoValue(Mo mo) {
        this._type = 12;
        this._value = mo;
    }

    public void setUtcTimeValue(UtcTime utcTime) {
        this._type = 15;
        this._value = utcTime;
    }

    public void setUtcTimeArrayValue(UtcTime[] utcTimeArray) {
        this._type = 13;
        this._arrayType = 15;
        this._value = utcTimeArray;
    }

    public void setCorrelatedNotificationsValue(CorrelatedNotifications correlatedNotifications) {
        this._type = 16;
        this._value = correlatedNotifications;
    }

    void setAnyValue(Any any) {
        this.setAnyValue(any, null);
    }

    void setAnyValue(Any any, ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
        this._type = this.extractType(any);
        this._value = this.extractValue(any);
    }

    static String typeAsString(int n) {
        switch (n) {
            case 0: {
                return "VOID";
            }
            case 1: {
                return "BOOLEAN";
            }
            case 5: {
                return "INT";
            }
            case 6: {
                return "LONG";
            }
            case 7: {
                return "FLOAT";
            }
            case 9: {
                return "STRING";
            }
            case 11: {
                return "STRUCT";
            }
            case 12: {
                return "MO";
            }
            case 13: {
                return "ARRAY";
            }
            case 14: {
                return "FDN";
            }
            case 15: {
                return "UTC_TIME";
            }
            case 16: {
                return "CORRELATEDNOTIFICATIONS";
            }
        }
        throw new IllegalTypeException("Unexpected type=" + n + "!");
    }

    public String getTypeString() {
        String string = (this._type == 13 ? CelloValue.typeAsString(this._arrayType) + " " : "") + CelloValue.typeAsString(this._type);
        return string;
    }

    private String describe() {
        String string = "Value" + (this.getName() == UNDEFINED ? "" : " named " + this.getName()) + " of type " + this.getTypeString();
        return string;
    }

    private void assertGetType(int n) {
        String string = CelloValue.typeAsString(n);
        String string2 = CelloValue.typeAsString(this._type);
        if (this._type != n) {
            throw new IllegalTypeException("Tried to get " + string + " type from " + string2 + " Value" + (this.getName() == UNDEFINED ? "" : " named " + this.getName()) + "!");
        }
    }

    private void assertGetType(int n, int n2) {
        String string = CelloValue.typeAsString(n);
        String string2 = CelloValue.typeAsString(this._type);
        String string3 = CelloValue.typeAsString(n2);
        String string4 = CelloValue.typeAsString(this._arrayType);
        if (this._type != n || this._arrayType != n2) {
            throw new IllegalTypeException("Tried to get " + string3 + " " + string + " type from " + string4 + " " + string2 + " Value" + (this.getName() == UNDEFINED ? "" : " named " + this.getName()) + "!");
        }
    }

    public boolean getBooleanValue() throws IllegalTypeException {
        this.assertGetType(1);
        return (Boolean)this._value;
    }

    public int getIntValue() throws IllegalTypeException {
        this.assertGetType(5);
        return (Integer)this._value;
    }

    public Integer getIntegerValue() throws IllegalTypeException {
        this.assertGetType(5);
        return (Integer)this._value;
    }

    public long getLongValue() throws IllegalTypeException {
        this.assertGetType(6);
        return (Long)this._value;
    }

    public float getFloatValue() throws IllegalTypeException {
        this.assertGetType(7);
        return ((Float)this._value).floatValue();
    }

    public String getStringValue() throws IllegalTypeException {
        if (this._type != 9 && this._type != 14) {
            throw new IllegalTypeException("Tried to get a STRING from a " + CelloValue.typeAsString(this._type) + " Value" + (this.getName() == UNDEFINED ? "" : " named " + this.getName()) + "!");
        }
        return (String)this._value;
    }

    public Struct getStructValue() throws IllegalTypeException {
        this.assertGetType(11);
        return (Struct)this._value;
    }

    public Struct[] getStructArrayValue() throws IllegalTypeException {
        this.assertGetType(13, 11);
        return (Struct[])this._value;
    }

    public int[] getIntArrayValue() throws IllegalTypeException {
        this.assertGetType(13, 5);
        return (int[])this._value;
    }

    public long[] getLongArrayValue() throws IllegalTypeException {
        this.assertGetType(13, 6);
        return (long[])this._value;
    }

    public float[] getFloatArrayValue() throws IllegalTypeException {
        this.assertGetType(13, 7);
        return (float[])this._value;
    }

    public boolean[] getBooleanArrayValue() throws IllegalTypeException {
        this.assertGetType(13, 1);
        return (boolean[])this._value;
    }

    public String[] getStringArrayValue() throws IllegalTypeException {
        if (this._type != 13 || this._arrayType != 9 && this._arrayType != 14) {
            throw new IllegalTypeException("Tried to get STRING ARRAY fom " + CelloValue.typeAsString(this._arrayType) + " " + CelloValue.typeAsString(this._type) + " Value" + (this.getName() == UNDEFINED ? "" : " named " + this.getName()) + "!");
        }
        return (String[])this._value;
    }

    public Mo[] getMoArrayValue() throws IllegalTypeException {
        this.assertGetType(13, 12);
        return (Mo[])this._value;
    }

    public Mo getMoValue() throws IllegalTypeException {
        this.assertGetType(12);
        return (Mo)this._value;
    }

    public UtcTime[] getUtcTimeArrayValue() throws IllegalTypeException {
        this.assertGetType(13, 15);
        return (UtcTime[])this._value;
    }

    public UtcTime getUtcTimeValue() throws IllegalTypeException {
        this.assertGetType(15);
        return (UtcTime)this._value;
    }

    public CorrelatedNotifications getCorrelatedNotificationsValue() throws IllegalTypeException {
        this.assertGetType(16);
        return (CorrelatedNotifications)this._value;
    }

    public String valueToString() {
        if (this._type == 13) {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                stringBuffer.append("[");
                switch (this.getArrayType()) {
                    case 9: 
                    case 14: {
                        for (int i = 0; i < this.getStringArrayValue().length; ++i) {
                            stringBuffer.append(this.getStringArrayValue()[i]);
                            if (i == this.getStringArrayValue().length - 1) continue;
                            stringBuffer.append(";");
                        }
                        return stringBuffer.append("]").toString();
                    }
                    case 12: {
                        for (int i = 0; i < this.getMoArrayValue().length; ++i) {
                            stringBuffer.append(this.getMoArrayValue()[i]);
                            if (i == this.getMoArrayValue().length - 1) continue;
                            stringBuffer.append(";");
                        }
                        return stringBuffer.append("]").toString();
                    }
                }
                return NealArrays.toString(this._value);
            }
            catch (IllegalTypeException illegalTypeException) {
                NealLog.severe("Unexpected value type=" + this._type + ", arrayType=" + this._arrayType, illegalTypeException);
                return "??????";
            }
        }
        return String.valueOf(this._value);
    }

    public String toString() {
        String string = this.getName();
        String string2 = this.valueToString();
        return string + "=" + string2;
    }

    BasicConfig.NameValue toNameValue() {
        return new BasicConfig.NameValue(this.getName(), this.getAnyValue());
    }

    private int extractType(Any any) {
        TypeCode typeCode = any.type();
        int n = typeCode.kind().value();
        switch (n) {
            case 3: {
                return 5;
            }
            case 2: {
                return 5;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 6: {
                return 7;
            }
            case 18: {
                return 9;
            }
            case 8: {
                return 1;
            }
            case 23: {
                return 6;
            }
        }
        if (typeCode.equal(MOidpairHelper.type())) {
            if (this.serviceContext != null) {
                return 12;
            }
            return 14;
        }
        if (typeCode.equal(MORefHelper.type())) {
            return 12;
        }
        if (typeCode.equal(UtcTHelperAdapter.type())) {
            return 15;
        }
        if (typeCode.equal(CorrelatedNotificationSetTypeHelper.type())) {
            return 16;
        }
        switch (n) {
            case 21: {
                return 13;
            }
            case 19: {
                return 13;
            }
            case 15: {
                return 11;
            }
        }
        throw new IllegalTypeException(typeCode);
    }

    private java.lang.Object extractValue(Any any) {
        TypeCode typeCode = any.type();
        int n = typeCode.kind().value();
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return null;
            }
            case 2: {
                return new Integer(any.extract_short());
            }
            case 3: {
                return new Integer(any.extract_long());
            }
            case 6: {
                return new Float(any.extract_float());
            }
            case 18: {
                return any.extract_string();
            }
            case 8: {
                return any.extract_boolean();
            }
            case 23: {
                return new Long(any.extract_longlong());
            }
        }
        if (typeCode.equal(MOidpairHelper.type())) {
            MOidpair mOidpair = MOidpairHelper.extract(any);
            if (this.serviceContext != null) {
                if (mOidpair.name().length == 0) {
                    return null;
                }
                Mo mo = this.lookupMo(this.serviceContext, mOidpair.name());
                return mo;
            }
            String string = EasyNaming.nameComponentArray2String(mOidpair.name());
            return string;
        }
        if (typeCode.equal(UtcTHelperAdapter.type())) {
            UtcTAdapter utcTAdapter = UtcTHelperAdapter.extract(any);
            UtcTime utcTime = new UtcTime(utcTAdapter.time, utcTAdapter.inacclo, utcTAdapter.inacchi, utcTAdapter.tdf);
            return utcTime;
        }
        if (typeCode.equal(CorrelatedNotificationSetTypeHelper.type())) {
            CorrelatedNotification[] correlatedNotificationArray = CorrelatedNotificationSetTypeHelper.extract(any);
            CorrelatedNotificationsImpl correlatedNotificationsImpl = new CorrelatedNotificationsImpl(correlatedNotificationArray, this.serviceContext);
            return correlatedNotificationsImpl;
        }
        switch (n) {
            case 21: {
                return this.extractSequenceValue(any);
            }
            case 19: {
                return this.extractSequenceValue(any);
            }
            case 15: {
                return this.extractStructValue(any);
            }
        }
        throw new IllegalTypeException(typeCode);
    }

    private java.lang.Object extractSequenceValue(Any any) {
        TypeCode typeCode = null;
        TypeCode typeCode2 = any.type();
        try {
            typeCode = typeCode2.kind() == TCKind.tk_alias ? any.type().content_type().content_type() : any.type().content_type();
        }
        catch (BadKind badKind) {
            throw new IllegalTypeException("Failed to extract elementTypeCode from Any value", typeCode2, badKind);
        }
        if (typeCode.kind() == TCKind.tk_long) {
            int[] nArray = LongSeqHelper.extract(any);
            this._arrayType = 5;
            return nArray;
        }
        if (typeCode.kind() == TCKind.tk_longlong) {
            long[] lArray = LongLongSeqHelper.extract(any);
            this._arrayType = 6;
            return lArray;
        }
        if (typeCode.kind() == TCKind.tk_float) {
            float[] fArray = FloatSeqHelper.extract(any);
            this._arrayType = 7;
            return fArray;
        }
        if (typeCode.kind() == TCKind.tk_string) {
            String[] stringArray = StringSeqHelper.extract(any);
            this._arrayType = 9;
            return stringArray;
        }
        if (typeCode.kind() == TCKind.tk_boolean) {
            boolean[] blArray = BooleanSeqHelper.extract(any);
            this._arrayType = 1;
            return blArray;
        }
        if (typeCode.equal(MOidpairHelper.type())) {
            MOidpair[] mOidpairArray = MOidpairSeqHelper.extract(any);
            if (this.serviceContext != null) {
                Mo[] moArray = new Mo[mOidpairArray.length];
                for (int i = 0; i < mOidpairArray.length; ++i) {
                    moArray[i] = this.lookupMo(this.serviceContext, mOidpairArray[i].name());
                }
                this._arrayType = 12;
                return moArray;
            }
            String[] stringArray = new String[mOidpairArray.length];
            for (int i = 0; i < mOidpairArray.length; ++i) {
                stringArray[i] = EasyNaming.nameComponentArray2String(mOidpairArray[i].name());
            }
            this._arrayType = 14;
            return stringArray;
        }
        if (typeCode.kind() == TCKind.tk_struct) {
            try {
                DynAnyFactory dynAnyFactory = CelloValue.getDynAnyFactory();
                DynSequence dynSequence = (DynSequence)dynAnyFactory.create_dyn_any(any);
                Any[] anyArray = dynSequence.get_elements();
                Struct[] structArray = new Struct[anyArray.length];
                for (int i = 0; i < structArray.length; ++i) {
                    structArray[i] = this.extractStructValue(anyArray[i]);
                }
                this._arrayType = 11;
                return structArray;
            }
            catch (InconsistentTypeCode inconsistentTypeCode) {
                throw new CmException("NotHandledAttributeSequenceTypeException");
            }
            catch (UserException userException) {
                throw new CmException(userException);
            }
        }
        if (typeCode.kind() == TCKind.tk_short) {
            this._arrayType = 11;
            return new Struct[0];
        }
        throw new UnsupportedOperationException("elementTC.kind() = " + typeCode.kind());
    }

    private Struct extractStructValue(Any any) {
        try {
            DynAnyFactory dynAnyFactory = CelloValue.getDynAnyFactory();
            DynStruct dynStruct = DynStructHelper.narrow((Object)dynAnyFactory.create_dyn_any(any));
            NameValuePair[] nameValuePairArray = dynStruct.get_members();
            NameValue[] nameValueArray = this.createNameValueArray(nameValuePairArray.length);
            for (int i = 0; i < nameValueArray.length; ++i) {
                nameValueArray[i] = this.createNameValue(nameValuePairArray[i].id);
                ((CelloValue)((java.lang.Object)nameValueArray[i])).setAnyValue(nameValuePairArray[i].value, this.serviceContext);
            }
            dynStruct.destroy();
            return new Struct(nameValueArray);
        }
        catch (UserException userException) {
            userException.printStackTrace();
            throw new CmException(userException);
        }
    }

    private CelloNameValue[] createNameValueArray(int n) {
        return new CelloNameValue[n];
    }

    private CelloNameValue createNameValue(String string) {
        return new CelloNameValue(string);
    }

    Any getAnyValue() {
        if (this._type == 0) {
            throw new CmException("Type not set in Value");
        }
        if (this._type == 11) {
            return CelloValue.createAnyStruct(this.getStructValue());
        }
        if (this._type == 13) {
            return this.getAnySequenceValue();
        }
        return this.getAnyOtherTypeValue();
    }

    private Any getAnyOtherTypeValue() {
        Any any = CelloValue.create_any();
        switch (this._type) {
            case 1: {
                any.insert_boolean(((Boolean)this._value).booleanValue());
                break;
            }
            case 5: {
                any.insert_long(((Integer)this._value).intValue());
                break;
            }
            case 6: {
                any.insert_longlong(((Long)this._value).longValue());
                break;
            }
            case 7: {
                any.insert_float(((Float)this._value).floatValue());
                break;
            }
            case 9: 
            case 14: {
                any.insert_string((String)this._value);
                break;
            }
            case 15: {
                String string = ((UtcTime)this._value).toString();
                any.insert_string(string);
                break;
            }
            case 12: {
                Mo mo = (Mo)this._value;
                MOidpair mOidpair = this.getMoIdPair(mo);
                MOidpairHelper.insert(any, mOidpair);
                break;
            }
            default: {
                throw new CmException("Illegal type (internal error)");
            }
        }
        return any;
    }

    private MOidpair getMoIdPair(Mo mo) {
        MOidpair mOidpair;
        if (mo == null) {
            mOidpair = new MOidpair();
            mOidpair.name(EasyNaming.string2NameComponentArray(""));
        } else {
            mOidpair = ((CelloManagedObject)mo).getMoHandle();
        }
        return mOidpair;
    }

    private Any getAnySequenceValue() {
        Any any = null;
        switch (this._arrayType) {
            case 1: {
                any = CelloValue.create_any();
                BooleanSeqHelper.insert(any, this.getBooleanArrayValue());
                break;
            }
            case 5: {
                any = CelloValue.create_any();
                LongSeqHelper.insert(any, this.getIntArrayValue());
                break;
            }
            case 6: {
                any = CelloValue.create_any();
                LongLongSeqHelper.insert(any, this.getLongArrayValue());
                break;
            }
            case 7: {
                any = CelloValue.create_any();
                FloatSeqHelper.insert(any, this.getFloatArrayValue());
                break;
            }
            case 9: 
            case 14: {
                any = CelloValue.create_any();
                StringSeqHelper.insert(any, this.getStringArrayValue());
                break;
            }
            case 12: {
                any = CelloValue.create_any();
                Mo[] moArray = this.getMoArrayValue();
                MOidpair[] mOidpairArray = new MOidpair[moArray.length];
                for (int i = 0; i < mOidpairArray.length; ++i) {
                    mOidpairArray[i] = this.getMoIdPair(moArray[i]);
                }
                MOidpairSeqHelper.insert(any, mOidpairArray);
                break;
            }
            case 11: {
                any = CelloValue.createAnySeqStruct(this.getStructArrayValue());
                break;
            }
            default: {
                throw new CmException("Illegal type (internal error)");
            }
        }
        return any;
    }

    private static Any createAnySeqStruct(Struct[] structArray) {
        DynSequence dynSequence;
        java.lang.Object object;
        TypeCode typeCode;
        int n = structArray.length;
        Any[] anyArray = new Any[n];
        for (int i = 0; i < n; ++i) {
            anyArray[i] = CelloValue.createAnyStruct(structArray[i]);
        }
        ORB oRB = ORB.init();
        if (n > 0) {
            typeCode = oRB.create_sequence_tc(n, anyArray[0].type());
        } else {
            object = new Struct(new NameValue[]{new CelloNameValue("dummyMember", false)});
            dynSequence = CelloValue.createAnyStruct((Struct)object);
            typeCode = oRB.create_sequence_tc(n, dynSequence.type());
        }
        try {
            object = CelloValue.getDynAnyFactory();
            dynSequence = DynSequenceHelper.narrow((Object)object.create_dyn_any_from_type_code(typeCode));
            dynSequence.set_elements(anyArray);
            return dynSequence.to_any();
        }
        catch (UserException userException) {
            throw new CmException(userException);
        }
    }

    private static Any createAnyStruct(Struct struct) {
        String[] stringArray = struct.getMemberNames();
        StructMember[] structMemberArray = new StructMember[stringArray.length];
        Any[] anyArray = new Any[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            anyArray[i] = ((CelloValue)((java.lang.Object)struct.getMember(stringArray[i]))).getAnyValue();
            structMemberArray[i] = new StructMember(stringArray[i], anyArray[i].type(), null);
        }
        ORB oRB = ORB.init();
        TypeCode typeCode = oRB.create_struct_tc("IDL:Anonymous:1.0", "Anonymous", structMemberArray);
        NameValuePair[] nameValuePairArray = new NameValuePair[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nameValuePairArray[i] = new NameValuePair(stringArray[i], anyArray[i]);
        }
        try {
            DynAnyFactory dynAnyFactory = CelloValue.getDynAnyFactory();
            DynStruct dynStruct = DynStructHelper.narrow((Object)dynAnyFactory.create_dyn_any_from_type_code(typeCode));
            dynStruct.set_members(nameValuePairArray);
            return dynStruct.to_any();
        }
        catch (UserException userException) {
            throw new CmException(userException);
        }
    }

    private Mo lookupMo(ServiceContext serviceContext, NameComponent[] nameComponentArray) {
        CelloManagedObject celloManagedObject = null;
        if (nameComponentArray.length == 0) {
            return null;
        }
        celloManagedObject = new CelloManagedObject(serviceContext, EasyNaming.nameComponentArray2String(nameComponentArray));
        return celloManagedObject;
    }

    private static DynAnyFactory getDynAnyFactory() throws InvalidName {
        DynAnyFactory dynAnyFactory = NealOrb.getDefaultDynAnyFactory();
        return dynAnyFactory;
    }

    private static Any create_any() {
        Any any = NealOrb.create_any();
        return any;
    }
}

