/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.cm;

import java.util.HashMap;
import se.ericsson.cello.neal.cm.CelloCmSubscription;
import se.ericsson.cello.neal.cm.CmNotificationConsumer;
import se.ericsson.cello.neal.cm.CmNotificationConsumerImpl;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.CmSubscription;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NotificationType;
import se.ericsson.cello.neal.cm.Scope;
import se.ericsson.cello.neal.internal.NealLog;
import se.ericsson.cello.neal.internal.ServiceContext;

public class CmSubscriptionFactory {
    private static HashMap cmContainer = new HashMap();

    public static CmSubscription subscribe(NotificationType notificationType, CmNotificationConsumer cmNotificationConsumer, Mo mo) {
        CmSubscription cmSubscription = CmSubscriptionFactory.subscribe(Scope.BASE_ONLY, notificationType, cmNotificationConsumer, mo);
        return cmSubscription;
    }

    public static CmSubscription subscribe(Scope scope, NotificationType notificationType, CmNotificationConsumer cmNotificationConsumer, Mo mo) {
        CmSubscription cmSubscription = CmSubscriptionFactory.subscribe(scope, new String[0], notificationType, cmNotificationConsumer, mo);
        return cmSubscription;
    }

    public static CmSubscription subscribe(Scope scope, String[] stringArray, NotificationType notificationType, CmNotificationConsumer cmNotificationConsumer, Mo mo) {
        ServiceContext serviceContext = CmSubscriptionFactory.lookUp(mo.getNode().getCmService());
        if (serviceContext == null) {
            NealLog.fine("CM Service not exists/ not initialized.");
            return null;
        }
        CmNotificationConsumerImpl cmNotificationConsumerImpl = CmNotificationConsumerImpl.create(cmNotificationConsumer, serviceContext);
        CelloCmSubscription celloCmSubscription = cmNotificationConsumerImpl.subscribe(mo, notificationType, stringArray, scope, serviceContext);
        return celloCmSubscription;
    }

    static synchronized void init(CmService cmService, ServiceContext serviceContext) {
        cmContainer.put(cmService, serviceContext);
    }

    private static ServiceContext lookUp(CmService cmService) {
        return (ServiceContext)cmContainer.get(cmService);
    }

    static synchronized void free(CmService cmService) {
        cmContainer.remove(cmService);
    }
}

