/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.pi;

import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import se.ericsson.cello.ProductInventory.InventoryResponse;
import se.ericsson.cello.ProductInventory.InventoryResponseHelper;
import se.ericsson.cello.ProductInventory.ProductType;
import se.ericsson.cello.neal.internal.OamService;
import se.ericsson.cello.neal.internal.ServiceContext;
import se.ericsson.cello.neal.pi.InventoryResponseServant;
import se.ericsson.cello.neal.pi.PiException;
import se.ericsson.cello.neal.pi.PiRequest;
import se.ericsson.cello.neal.pi.PiService;

class CelloPiService
implements PiService,
OamService {
    private ServiceContext serviceContext;

    CelloPiService() {
    }

    public void init(ServiceContext serviceContext) throws NotFound, CannotProceed, InvalidName {
        this.serviceContext = serviceContext;
    }

    public void free() {
        this.serviceContext = null;
    }

    public synchronized PiRequest collectAllProductInventory() {
        int[] nArray = new int[]{1, 2, 4, 0, 3, 5};
        return this.collectProductInventory(nArray);
    }

    private ProductType[] translateProductTypeConstants(int[] nArray) {
        ProductType[] productTypeArray = new ProductType[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            productTypeArray[i] = ProductType.from_int(nArray[i]);
        }
        return productTypeArray;
    }

    public synchronized PiRequest collectProductInventory(int[] nArray) {
        InventoryResponseServant inventoryResponseServant = null;
        try {
            ProductType[] productTypeArray = this.translateProductTypeConstants(nArray);
            inventoryResponseServant = new InventoryResponseServant(this.serviceContext);
            this.serviceContext.connect(inventoryResponseServant);
            InventoryResponse inventoryResponse = InventoryResponseHelper.narrow(this.serviceContext.servant_to_reference(inventoryResponseServant));
            int n = this.serviceContext.getInventoryService().get_node_inventory_by_type(productTypeArray, inventoryResponse, 600);
            inventoryResponseServant.setRequestId(n);
        }
        catch (UserException userException) {
            if (inventoryResponseServant != null) {
                this.serviceContext.disconnect(inventoryResponseServant);
            }
            throw new PiException(userException);
        }
        catch (SystemException systemException) {
            if (inventoryResponseServant != null) {
                this.serviceContext.disconnect(inventoryResponseServant);
            }
            throw systemException;
        }
        return inventoryResponseServant;
    }
}

