/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.pm;

import PerformanceIRPConstDefs.DestinationHolder;
import PerformanceIRPConstDefs.Filter;
import PerformanceIRPConstDefs.FilterHolder;
import PerformanceIRPConstDefs.ObservationClassListHolder;
import PerformanceIRPConstDefs.ObservationObject;
import PerformanceIRPConstDefs.ObservationObjectHolder;
import PerformanceIRPConstDefs.ObservationObjectListHolder;
import PerformanceIRPConstDefs.PerformanceMonitoringIdListHolder;
import PerformanceIRPConstDefs.PerformanceMonitoringState;
import PerformanceIRPConstDefs.PerformanceMonitoringStateHolder;
import PerformanceIRPConstDefs.RecordingType;
import PerformanceIRPConstDefs.RecordingTypeHolder;
import PerformanceIRPConstDefs.ScheduleHolder;
import PerformanceIRPConstDefs.TimeWindowHolder;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.UserException;
import org.threegppsa5.PerformanceIRPSystem._PerformanceMonitoringOperations;
import se.ericsson.cello.neal.internal.NealLog;
import se.ericsson.cello.neal.pm.Pm;
import se.ericsson.cello.neal.pm.PmAttributeContainer;
import se.ericsson.cello.neal.pm.PmAttributeContainerImpl;
import se.ericsson.cello.neal.pm.PmException;
import se.ericsson.cello.neal.pm.PmFilter;
import se.ericsson.cello.neal.pm.PmFilterInfo;
import se.ericsson.cello.neal.pm.PmFilterInfoImpl;
import se.ericsson.cello.neal.pm.PmInfo;
import se.ericsson.cello.neal.pm.PmObservationObject;

class CelloPm
implements Pm {
    protected final int scannerId;
    protected _PerformanceMonitoringOperations perfMonitorOps;

    CelloPm(int n, _PerformanceMonitoringOperations _PerformanceMonitoringOperations2) {
        this.scannerId = n;
        this.perfMonitorOps = _PerformanceMonitoringOperations2;
    }

    public void suspend() {
        NealLog.fine("Suspending PM with ID = " + this.scannerId);
        try {
            int[] nArray = new int[]{this.scannerId};
            PerformanceMonitoringIdListHolder performanceMonitoringIdListHolder = new PerformanceMonitoringIdListHolder();
            this.perfMonitorOps.suspend_performance_monitoring(nArray, performanceMonitoringIdListHolder);
            if (performanceMonitoringIdListHolder.value.length > 0) {
                throw new PmException("Scanner id = " + this.scannerId + " is invalid.");
            }
        }
        catch (UserException userException) {
            throw new PmException(userException);
        }
    }

    public void resume() {
        NealLog.fine("Resume PM with ID = " + this.scannerId);
        try {
            int[] nArray = new int[]{this.scannerId};
            PerformanceMonitoringIdListHolder performanceMonitoringIdListHolder = new PerformanceMonitoringIdListHolder();
            PerformanceMonitoringIdListHolder performanceMonitoringIdListHolder2 = new PerformanceMonitoringIdListHolder();
            this.perfMonitorOps.resume_performance_monitoring(nArray, performanceMonitoringIdListHolder, performanceMonitoringIdListHolder2);
            if (performanceMonitoringIdListHolder.value.length > 0) {
                throw new PmException("Scanner id = " + this.scannerId + " is bad.");
            }
            if (performanceMonitoringIdListHolder2.value.length > 0) {
                throw new PmException("Scanner id = " + this.scannerId + " is rejected.");
            }
        }
        catch (UserException userException) {
            throw new PmException(userException);
        }
    }

    public void delete() {
        NealLog.fine("Delete PM with ID = " + this.scannerId);
        try {
            this.perfMonitorOps.delete_performance_monitoring(this.scannerId);
        }
        catch (UserException userException) {
            throw new PmException(userException);
        }
    }

    public PmInfo getPmInfo() {
        NealLog.fine("Lookup PM with ID = " + this.scannerId);
        try {
            ObservationClassListHolder observationClassListHolder = new ObservationClassListHolder();
            ObservationObjectListHolder observationObjectListHolder = new ObservationObjectListHolder();
            IntHolder intHolder = new IntHolder();
            ScheduleHolder scheduleHolder = new ScheduleHolder();
            IntHolder intHolder2 = new IntHolder();
            DestinationHolder destinationHolder = new DestinationHolder();
            PerformanceMonitoringStateHolder performanceMonitoringStateHolder = new PerformanceMonitoringStateHolder();
            StringHolder stringHolder = new StringHolder();
            this.perfMonitorOps.lookup_performance_monitoring(this.scannerId, observationClassListHolder, observationObjectListHolder, intHolder, scheduleHolder, intHolder2, destinationHolder, performanceMonitoringStateHolder, stringHolder);
            return new ScannerInfo(stringHolder.value, performanceMonitoringStateHolder.value.equals(PerformanceMonitoringState.ACTIVE), intHolder.value, new PmAttributeContainerImpl(observationClassListHolder.value, observationObjectListHolder.value));
        }
        catch (UserException userException) {
            throw new PmException(userException);
        }
    }

    public PmFilterInfo lookupFilter() {
        return this.fetchFilterFromNode();
    }

    protected PmFilterInfo fetchFilterFromNode() {
        NealLog.fine("Fetching filter for PM with ID = " + this.scannerId);
        RecordingTypeHolder recordingTypeHolder = new RecordingTypeHolder();
        ObservationObjectHolder observationObjectHolder = new ObservationObjectHolder();
        ObservationObjectListHolder observationObjectListHolder = new ObservationObjectListHolder();
        FilterHolder filterHolder = new FilterHolder();
        TimeWindowHolder timeWindowHolder = new TimeWindowHolder();
        IntHolder intHolder = new IntHolder();
        try {
            this.perfMonitorOps.lookup_filter_performance_monitoring_report(this.scannerId, recordingTypeHolder, observationObjectHolder, observationObjectListHolder, filterHolder, timeWindowHolder, intHolder);
        }
        catch (UserException userException) {
            throw new PmException(userException);
        }
        PmFilterInfoImpl pmFilterInfoImpl = new PmFilterInfoImpl(recordingTypeHolder.value, observationObjectHolder.value, observationObjectListHolder.value, filterHolder.value, timeWindowHolder.value, intHolder.value);
        return pmFilterInfoImpl;
    }

    public void setFilter(PmFilterInfo pmFilterInfo) {
        this.setFilterInPm(pmFilterInfo);
    }

    protected void setFilterInPm(PmFilterInfo pmFilterInfo) {
        NealLog.fine("Set filter for PM with ID = " + this.scannerId);
        int[] nArray = new int[]{this.scannerId};
        ObservationObject[] observationObjectArray = this.toObservationObject(pmFilterInfo.getObservationObjectList());
        PerformanceMonitoringIdListHolder performanceMonitoringIdListHolder = new PerformanceMonitoringIdListHolder();
        ObservationObject observationObject = new ObservationObject(pmFilterInfo.getTriggeringObject().getInstanceList(), pmFilterInfo.getTriggeringObject().getInstanceAttributeList());
        RecordingType recordingType = RecordingType.from_int(pmFilterInfo.getRecordingType().value);
        try {
            this.perfMonitorOps.filter_performance_monitoring_report(nArray, recordingType, observationObject, observationObjectArray, this.toFilter(pmFilterInfo.getFilter()), pmFilterInfo.getTimeWindow(), pmFilterInfo.getSamplingRate(), performanceMonitoringIdListHolder);
        }
        catch (UserException userException) {
            throw new PmException(userException);
        }
    }

    protected Filter toFilter(PmFilter pmFilter) {
        return new Filter(pmFilter.getAttributeName(), pmFilter.getAttributeValue());
    }

    protected ObservationObject[] toObservationObject(PmObservationObject[] pmObservationObjectArray) {
        ObservationObject[] observationObjectArray = new ObservationObject[pmObservationObjectArray.length];
        for (int i = 0; i < observationObjectArray.length; ++i) {
            observationObjectArray[i] = new ObservationObject(pmObservationObjectArray[i].getInstanceList(), pmObservationObjectArray[i].getInstanceAttributeList());
        }
        return observationObjectArray;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            CelloPm celloPm = (CelloPm)object;
            return celloPm.getId() == this.getId();
        }
        return false;
    }

    public int hashCode() {
        return this.getId();
    }

    public String toString() {
        return this.getClass().getName() + ": id=" + this.getId() + ", pmInfo=" + this.getPmInfo();
    }

    public int getId() {
        return this.scannerId;
    }

    static class ScannerInfo
    implements PmInfo {
        private String name;
        private boolean isActive;
        private int granularityPeriod;
        private PmAttributeContainerImpl pmAttrMOContainer;

        ScannerInfo(String string, boolean bl, int n, PmAttributeContainerImpl pmAttributeContainerImpl) {
            this.name = string;
            this.isActive = bl;
            this.granularityPeriod = n;
            this.pmAttrMOContainer = pmAttributeContainerImpl;
        }

        public int getGranularityPeriod() {
            return this.granularityPeriod;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public String getName() {
            return this.name;
        }

        public PmAttributeContainer getPmAttributeContainer() {
            return this.pmAttrMOContainer;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append(":");
            stringBuffer.append("name=" + this.getName() + ",");
            stringBuffer.append("granularity period=" + this.getGranularityPeriod() + ",");
            stringBuffer.append("is active=" + this.isActive() + ",");
            stringBuffer.append("pm attributes=" + this.getPmAttributeContainer());
            return stringBuffer.toString();
        }
    }
}

