/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.neal.pm;

import PerformanceIRPConstDefs.FilterHolder;
import PerformanceIRPConstDefs.ObservationObject;
import PerformanceIRPConstDefs.ObservationObjectHolder;
import PerformanceIRPConstDefs.ObservationObjectListHolder;
import PerformanceIRPConstDefs.PerformanceMonitoringIdListHolder;
import PerformanceIRPConstDefs.RecordingType;
import PerformanceIRPConstDefs.RecordingTypeHolder;
import PerformanceIRPConstDefs.TimeWindowHolder;
import PmServiceExtended.DestinationAddress;
import PmServiceExtended.DestinationAddressHolder;
import PmServiceExtended.OutputMode;
import PmServiceExtended.OutputModeHolder;
import PmServiceExtended.PerformanceMonitoringExtendedOperations;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.UserException;
import org.threegppsa5.PerformanceIRPSystem._PerformanceMonitoringOperations;
import se.ericsson.cello.neal.internal.NealLog;
import se.ericsson.cello.neal.pm.CelloPm;
import se.ericsson.cello.neal.pm.Pm;
import se.ericsson.cello.neal.pm.PmException;
import se.ericsson.cello.neal.pm.PmFilterInfo;
import se.ericsson.cello.neal.pm.PmFilterInfoImpl;

public class CelloPmExtended
extends CelloPm
implements Pm {
    private PerformanceMonitoringExtendedOperations perfMonitorExtOps;

    CelloPmExtended(int n, PerformanceMonitoringExtendedOperations performanceMonitoringExtendedOperations) {
        super(n, (_PerformanceMonitoringOperations)((Object)performanceMonitoringExtendedOperations));
        this.perfMonitorExtOps = performanceMonitoringExtendedOperations;
    }

    protected PmFilterInfo fetchFilterFromNode() {
        NealLog.fine("Lookup extended filter for PM with ID = " + this.scannerId);
        RecordingTypeHolder recordingTypeHolder = new RecordingTypeHolder();
        ObservationObjectHolder observationObjectHolder = new ObservationObjectHolder();
        ObservationObjectListHolder observationObjectListHolder = new ObservationObjectListHolder();
        FilterHolder filterHolder = new FilterHolder();
        TimeWindowHolder timeWindowHolder = new TimeWindowHolder();
        IntHolder intHolder = new IntHolder();
        OutputModeHolder outputModeHolder = new OutputModeHolder();
        DestinationAddressHolder destinationAddressHolder = new DestinationAddressHolder();
        StringHolder stringHolder = new StringHolder();
        try {
            this.perfMonitorExtOps.lookup_filter_performance_monitoring_report_ext(this.scannerId, recordingTypeHolder, observationObjectHolder, observationObjectListHolder, filterHolder, timeWindowHolder, intHolder, outputModeHolder, destinationAddressHolder, stringHolder);
        }
        catch (UserException userException) {
            throw new PmException(userException);
        }
        NealLog.fine("Creating new PmFilterInfo");
        PmFilterInfoImpl pmFilterInfoImpl = new PmFilterInfoImpl(recordingTypeHolder.value, observationObjectHolder.value, observationObjectListHolder.value, filterHolder.value, timeWindowHolder.value, intHolder.value, outputModeHolder.value, destinationAddressHolder.value, stringHolder.value);
        return pmFilterInfoImpl;
    }

    protected void setFilterInPm(PmFilterInfo pmFilterInfo) {
        NealLog.fine("Set extended filter for PM with ID = " + this.scannerId);
        int[] nArray = new int[]{this.scannerId};
        ObservationObject[] observationObjectArray = this.toObservationObject(pmFilterInfo.getObservationObjectList());
        PerformanceMonitoringIdListHolder performanceMonitoringIdListHolder = new PerformanceMonitoringIdListHolder();
        ObservationObject observationObject = new ObservationObject(pmFilterInfo.getTriggeringObject().getInstanceList(), pmFilterInfo.getTriggeringObject().getInstanceAttributeList());
        RecordingType recordingType = RecordingType.from_int(pmFilterInfo.getRecordingType().value);
        OutputMode outputMode = OutputMode.from_int(pmFilterInfo.getOutputMode().value);
        DestinationAddress destinationAddress = new DestinationAddress(pmFilterInfo.getDestinationAddress(), pmFilterInfo.getDestinationPort());
        try {
            this.perfMonitorExtOps.filter_performance_monitoring_report_ext(nArray, recordingType, observationObject, observationObjectArray, this.toFilter(pmFilterInfo.getFilter()), pmFilterInfo.getTimeWindow(), pmFilterInfo.getSamplingRate(), outputMode, destinationAddress, pmFilterInfo.getTraceReference(), performanceMonitoringIdListHolder);
        }
        catch (UserException userException) {
            throw new PmException(userException);
        }
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

