/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import ConfigExtended.ConfigurationExtended;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.omg.CORBA.ORB;
import se.ericsson.cello.emas.eq.applications.SettingsApplication;
import se.ericsson.cello.support.gui.AbstractViewElement;
import se.ericsson.cello.support.gui.AbstractViewManager;
import se.ericsson.cello.support.gui.CachingPolicy;
import se.ericsson.cello.support.gui.ConnectionStatus;
import se.ericsson.cello.support.gui.ConnectionSupervisionController;
import se.ericsson.cello.support.gui.ConnectionSupervisorInterface;
import se.ericsson.cello.support.gui.DefaultEmasStartupService;
import se.ericsson.cello.support.gui.DetailModel;
import se.ericsson.cello.support.gui.DetailTable;
import se.ericsson.cello.support.gui.EmasFramework;
import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.EmasLaunchableInterface;
import se.ericsson.cello.support.gui.EmasLauncherInterface;
import se.ericsson.cello.support.gui.EmasPopupMenu;
import se.ericsson.cello.support.gui.EmasProgressMonitor;
import se.ericsson.cello.support.gui.EmasProperties;
import se.ericsson.cello.support.gui.EmasSecondErrorReporterImpl;
import se.ericsson.cello.support.gui.ErrorDialog;
import se.ericsson.cello.support.gui.IndexServiceQueryApplication;
import se.ericsson.cello.support.gui.IndexingServiceRegistrator;
import se.ericsson.cello.support.gui.LDNIndexService;
import se.ericsson.cello.support.gui.LaunchExternalApplication;
import se.ericsson.cello.support.gui.MainWindowView;
import se.ericsson.cello.support.gui.MappedController;
import se.ericsson.cello.support.gui.MenuController;
import se.ericsson.cello.support.gui.MenuModel;
import se.ericsson.cello.support.gui.MenuTree;
import se.ericsson.cello.support.gui.ParameterInterface;
import se.ericsson.cello.support.gui.PropertiesHelper;
import se.ericsson.cello.support.gui.RefreshAction;
import se.ericsson.cello.support.gui.ReservedByAction;
import se.ericsson.cello.support.gui.ShowLDNAction;
import se.ericsson.cello.support.gui.TaskMenuEntry;
import se.ericsson.cello.support.gui.TitleUpdateService;
import se.ericsson.cello.support.gui.TopologyModel;
import se.ericsson.cello.support.gui.TopologyTree;
import se.ericsson.cello.support.gui.ViewElementCreator;
import se.ericsson.cello.support.gui.ViewSelectorComboBox;
import se.ericsson.cello.support.gui.WaitCursorEventQueue;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.cello.support.gui.guilib.infra.Application;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationManager;
import se.ericsson.cello.support.gui.guilib.infra.EmasSystemProperties;
import se.ericsson.cello.support.gui.guilib.infra.ErrorReporter;
import se.ericsson.cello.support.gui.guilib.infra.GuilibConfigParams;
import se.ericsson.cello.support.gui.guilib.infra.GuilibResourceBundle;
import se.ericsson.cello.support.gui.guilib.infra.LocaleChangeListener;
import se.ericsson.cello.support.gui.guilib.infra.Printout;
import se.ericsson.cello.support.gui.guilib.table.SortedTableModel;
import se.ericsson.cello.support.logging.LogManager;
import se.ericsson.cello.support.mgr.OEGoToAction;
import se.ericsson.cello.support.mgr.RestoreConfirm;
import se.ericsson.cello.support.mgr.TimeConverter;
import se.ericsson.cello.support.proxy.CSFacade;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.Transaction;
import se.ericsson.security.corba.ORBInit;

public class MainWindowController
extends AbstractApplicationController
implements ActionListener,
ConnectionSupervisorInterface,
CSFacade.OverflowSubscriber,
EmasLauncherInterface {
    private MainWindowView view;
    private MenuController menuController;
    private MenuTree menuTree;
    private MenuModel menuModel;
    private ConnectionSupervisionController connectionSupervisionController;
    private static final int CONNECTION_POLLING_PERIOD = 5;
    private SettingsAction settingsAction = new SettingsAction();
    private SearchAction searchAction = new SearchAction();
    private PrintAction printAction = new PrintAction();
    private PageLayoutAction pageLayoutAction = new PageLayoutAction();
    private Printout printout = null;
    private MainWindowController mc;
    public static boolean PROPS_DEBUG = true;
    private Vector abstractViewManagers = new Vector();
    private boolean selectElementFromTable = false;
    private SelectorStateChangeListener selectorStateChangeListener;
    private ViewLocaleChangeListener viewLocaleChangeListener;
    private Thread corbaInitThread = null;
    private Vector viewManagerList = new Vector();
    private Vector lazyViewManagerDataList = null;
    private Vector NotIntializedManagerList = new Vector();
    private Boolean defaultViewManagerDisplayed = new Boolean(false);
    private boolean restartManagersInitiated = false;
    private static boolean isNewVersion = false;
    private Map modelToController = Collections.synchronizedMap(new HashMap());
    private Map myAbstractManager = new HashMap();
    private myNodeTimeThread myNodeTime = null;
    private Hashtable externalApps = null;
    private ProgressThread prgBar = null;
    private boolean globalpmMonitor = false;
    private boolean noCorbaForRBS = false;
    private ActionListener refreshListener;
    private boolean weAreInTheReconnectionCase = false;
    private Hashtable viewHash = new Hashtable();
    private static final int TREE_PLACE = 0;
    private static final int TREE_SELECTIONLISTENER_PLACE = 1;
    private static final int TREE_MOUSELISTENER_PLACE = 2;
    private static final int TABLE_PLACE = 3;
    private static final int TABLE_MOUSELISTENER_PLACE = 4;
    private EmasLaunchableInterface oeApplication = null;
    private String emtApplToRun = null;

    public void setOeApplication(EmasLaunchableInterface oeApplication) {
        this.oeApplication = oeApplication;
    }

    public EmasLaunchableInterface getOeApplication() {
        return this.oeApplication;
    }

    protected void init() {
        try {
            if (System.getProperty("ARTH").equals("true")) {
                this.noCorbaForRBS = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.mc = this;
        WaitCursorEventQueue waitQueue = new WaitCursorEventQueue(750);
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(waitQueue);
        EmasGuilibMediator.getReference().addMainWindowReference(this);
        if (!this.noCorbaForRBS) {
            this.corbaInitThread = new Thread(){

                public void run() {
                    try {
                        MainWindowController.this.initStartupService();
                        Log.trace("Initialized Corba services in emserv7");
                    }
                    catch (IOException e) {
                        Log.trace("Error initializing Corba services");
                    }
                }
            };
            this.corbaInitThread.start();
        }
        PROPS_DEBUG = System.getProperty("PROPSDEBUG", "false").equals("true");
        this.view = (MainWindowView)this.getView();
        Log.trace("Reading the dynamic menu");
        try {
            this.menuModel = new MenuModel();
            this.menuController = new MenuController(this.menuModel);
            this.menuTree = new MenuTree(this.menuModel, this);
        }
        catch (Exception e) {
            Log.logError("error creating menu bar", e);
        }
        this.menuController.start();
        this.view.menu = this.menuTree.getMenu();
        this.view.settingsMenuItem.addActionListener(this.settingsAction);
        this.view.searchMenuItem.addActionListener(this.searchAction);
        this.view.printMenuItem.addActionListener(this.printAction);
        this.view.pageLayoutMenuItem.addActionListener(this.pageLayoutAction);
        this.refreshListener = new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MainWindowController.this.refreshTable();
            }
        };
        this.view.refreshButton.addActionListener(this.refreshListener);
        this.view.refreshButton.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MainWindowController.this.refreshTable();
            }
        }, "", KeyStroke.getKeyStroke(116, 0, false), 2);
        this.init2();
    }

    private void init2() {
        this.addLazyManagerItems();
        ErrorReporter.setReporter(new EmasSecondErrorReporterImpl());
        if (EmasGuilibMediator.getReference().getMainWindowReference() == null) {
            EmasGuilibMediator.getReference().addMainWindowReference(this);
        }
        this.selectorStateChangeListener = new SelectorStateChangeListener();
        this.view.selector.addItemListener(this.selectorStateChangeListener);
        Log.trace("Loading view managersfrom the properties file");
        this.startManagers();
        this.waitForCorbaServices();
        this.viewLocaleChangeListener = new ViewLocaleChangeListener();
        this.addLocaleChangeListener(this.viewLocaleChangeListener);
        TitleUpdateService tus = TitleUpdateService.getInstance();
        if (!this.noCorbaForRBS) {
            tus.setDefaultPrefix();
        }
        this.getApplication().setTitle("MAINWINDOW_TITLE", null);
        if (!this.noCorbaForRBS) {
            MOProxy managedElement = new MOProxy("ManagedElement=1,ManagedElementData=1");
            this.myNodeTime = new myNodeTimeThread(managedElement);
            this.myNodeTime.start();
        }
        if (!this.weAreInTheReconnectionCase) {
            RestoreConfirm.restoreConfirmSlideWizard();
        }
        this.initEMT();
    }

    private void initEMT() {
        String where_emtApplToRun = this.emtApplToRun;
        this.emtApplToRun = System.getProperty("EMT_APPL_TO_RUN");
        if (where_emtApplToRun != null) {
            this.emtApplToRun = where_emtApplToRun;
        }
        if (this.emtApplToRun == null) {
            return;
        }
        Runnable startEmtTool = new Runnable(){

            public void run() {
                Object[][] parameters = MainWindowController.this.getProps();
                try {
                    String isWizard = EmasSystemProperties.getProperty("wizard launched");
                    if (isWizard != null && isWizard.equalsIgnoreCase("true")) {
                        MainWindowController.this.startApplication(MainWindowController.this.emtApplToRun, parameters, false);
                    } else {
                        MainWindowController.this.startApplication(MainWindowController.this.emtApplToRun, parameters, true);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        SwingUtilities.invokeLater(startEmtTool);
    }

    private Object[][] getProps() {
        String ldnlist = EmasSystemProperties.getProperty("LDNLIST", null);
        String tag = ldnlist == null ? "LDNs" : "LDNLIST";
        Object[][] params = new Object[][]{{"LDNLIST", EmasSystemProperties.getProperty(tag, null)}, {"ACTION", EmasSystemProperties.getProperty("ACTION", null)}, {"CV_NAME", EmasSystemProperties.getProperty("CVNAME", null)}};
        return params;
    }

    protected void initStartupService() throws IOException {
        DefaultEmasStartupService startupService;
        String debuggingOn = "true";
        if (debuggingOn.equals("false")) {
            startupService = new DefaultEmasStartupService(this.getApplet(), this.getApplication().getORB());
        } else {
            String singletonProp = EmasSystemProperties.getProperty("org.omg.CORBA.ORBSingletonClass");
            if (singletonProp != null && singletonProp.equals("org.jacorb.orb.ORBSingleton")) {
                Log.logNotify("AnyHandler.SingletonClass: " + singletonProp);
            } else {
                EmasSystemProperties.setProperty("org.omg.CORBA.ORBSingletonClass", "org.jacorb.orb.ORBSingleton");
                Log.logNotify("Set SingletonClass to: org.jacorb.orb.ORBSingleton");
            }
            Properties properties = ORBInit.getOrbProperties();
            ORB testORB = ORB.init((String[])new String[0], (Properties)properties);
            startupService = new DefaultEmasStartupService(testORB);
        }
        startupService.start();
        this.initCommunication();
    }

    private void initCommunication() {
        Log.trace("Starting connection-supervisor");
        ConfigurationExtended configService = EmasFramework.getCelloConfigService();
        try {
            if (EmasSystemProperties.getProperty("CONNECTIONSUPERVISION", "TRUE").equalsIgnoreCase("TRUE")) {
                Log.trace("connectionSupervisionController restart starts");
                if (this.connectionSupervisionController != null && this.connectionSupervisionController.isAlive()) {
                    this.connectionSupervisionController.quit();
                }
                this.connectionSupervisionController = new ConnectionSupervisionController(configService, this, 5);
                this.connectionSupervisionController.start();
                Log.trace("Starting overflow supervisor");
            }
            CSFacade.getInstance().subscribeOverflow(this);
        }
        catch (Exception e) {
            System.out.println("connectionSupervisionController failed to start");
            Log.trace("connectionSupervisionController failed to start");
        }
    }

    public boolean checkEmasVersion() {
        ApplicationManager applicationManager = this.getApplicationManager();
        try {
            if (!applicationManager.hasNESameVersion()) {
                throw new IOException("Wrong Element Manager version");
            }
        }
        catch (IOException e) {
            if (SwingUtilities.isEventDispatchThread()) {
                isNewVersion = true;
                if (EmasSystemProperties.getProperty("application launched", "false").equalsIgnoreCase("false")) {
                    this.reportException(e, "CONNECTION_WRONG_VERSION_MESSAGE", null);
                }
            } else if (!isNewVersion) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        MainWindowController.this.checkEmasVersion();
                    }
                });
            }
            return false;
        }
        return true;
    }

    private boolean restoreWizIsRunning() {
        if (this.emtApplToRun != null && "se.ericsson.cello.emas.sm.applications.RestoreWizardApplication".equals(this.emtApplToRun)) {
            System.out.println("MainWindowController::restoreWizIsRunning returning true");
            return true;
        }
        System.out.println("MainWindowController::restoreWizIsRunning returning false");
        return false;
    }

    public boolean connectionRestored(boolean reconnect) {
        try {
            this.weAreInTheReconnectionCase = true;
            Log.trace("MainWindowController - connectionRestored() ");
            if (reconnect) {
                System.out.println("MainWindowController::connectionRestored reconnect == true");
                if (!this.checkEmasVersion() && !this.restoreWizIsRunning()) {
                    if (this.connectionSupervisionController != null) {
                        this.getApplication().setStatus("ERROR_MESSAGE_CONNECTION", null);
                        this.connectionSupervisionController.quit();
                    }
                    System.out.println("MainWindowController::connectionRestored. Different version of EM and no RestoreWizardApplication running. Returning.");
                    return true;
                }
                if (this.emtApplToRun != null) {
                    AbstractApplication tmpApp;
                    String ClsName;
                    Enumeration allApps;
                    AbstractApplication app;
                    System.out.println("MainWindowController::connectionRestored emtApplToRun = " + this.emtApplToRun);
                    Log.logNotify("Connection restored. Restarting session object");
                    CSFacade.getInstance().initSession();
                    System.out.println("MainWindowController::connectionRestored. After initSession. EMT_APPLICATION_LAUNCHED is: " + EmasSystemProperties.getProperty("application launched"));
                    if (EmasSystemProperties.getProperty("application launched", "false").equalsIgnoreCase("false")) {
                        System.out.println("MainWindowController::connectionRestored. Not EMT_APPLICATION_LAUNCHED");
                        if ("se.ericsson.cello.emas.sm.applications.RestoreWizardApplication".equals(this.emtApplToRun)) {
                            System.out.println("Call RestoreConfirm to check if the CV needs to be restored");
                            app = this.getApplication();
                            allApps = this.getApplications().elements();
                            ClsName = app.getApplicationControllerClassName();
                            while (allApps.hasMoreElements()) {
                                tmpApp = (AbstractApplication)allApps.nextElement();
                                if (ClsName.equals(tmpApp.getApplicationControllerClassName())) continue;
                                tmpApp.stopApplicationNoCheck();
                            }
                            app.setStatus(null);
                            RestoreConfirm.restoreConfirmSlideWizard();
                        } else {
                            System.out.println("MainWindowController::connectionRestored. It was not RestoreWizardApplication");
                        }
                    } else {
                        System.out.println("MainWindowController::connectionRestored. EMT_APPLICATION_LAUNCHED was true");
                    }
                    if ("se.ericsson.cello.emas.fm.am.AlarmApplication".equals(this.emtApplToRun)) {
                        try {
                            System.out.println("MainWindowController::connectionRestored se.ericsson.cello.emas.fm.am.AlarmApplication");
                            this.cleanupAndRestart();
                        }
                        catch (Exception e) {
                            System.out.println("cleanupAndRestart failed = " + e);
                            return false;
                        }
                        app = this.getApplication();
                        allApps = this.getApplications().elements();
                        ClsName = app.getApplicationControllerClassName();
                        while (allApps.hasMoreElements()) {
                            tmpApp = (AbstractApplication)allApps.nextElement();
                            if (ClsName.equals(tmpApp.getApplicationControllerClassName())) continue;
                            tmpApp.stopApplicationNoCheck();
                        }
                        app.setStatus(null);
                        this.startAlarmList();
                    }
                } else {
                    try {
                        this.cleanupAndRestart();
                    }
                    catch (Exception e) {
                        Log.trace("cleanupAndRestart failed = " + e);
                        return false;
                    }
                    Log.trace("cleanupAndRestart succed");
                    System.gc();
                }
            } else {
                System.out.println("MainWindowController::connectionRestored reconnect == false");
                this.getApplication().setStatus(null);
                this.myNodeTime.start();
            }
            return true;
        }
        catch (Exception e) {
            System.out.println("Error during reconnecting the node.");
            e.printStackTrace();
            return false;
        }
    }

    private void startAlarmList() {
        if (SwingUtilities.isEventDispatchThread()) {
            MainWindowController mainWindowController = EmasGuilibMediator.getReference().getMainWindowReference();
            mainWindowController.startApplication("se.ericsson.cello.emas.fm.am.AlarmApplication", null, true);
        } else {
            Runnable alarmListRerun = new Runnable(){

                public void run() {
                    MainWindowController.this.startAlarmList();
                }
            };
            SwingUtilities.invokeLater(alarmListRerun);
        }
    }

    public void restartManager(final String aManager) {
        if (SwingUtilities.isEventDispatchThread()) {
            Object tmpApp;
            AbstractApplication app = this.getApplication();
            String ClsName = app.getApplicationControllerClassName();
            Enumeration allApps = this.getApplications().elements();
            while (allApps.hasMoreElements()) {
                tmpApp = (AbstractApplication)allApps.nextElement();
                if (ClsName.equals(((AbstractApplication)tmpApp).getApplicationControllerClassName())) continue;
                ((AbstractApplication)tmpApp).stopApplicationNoCheck();
            }
            app.setStatus(null);
            tmpApp = (AbstractViewManager)this.myAbstractManager.remove(aManager);
            if (tmpApp != null) {
                TopologyModel tm = ((AbstractViewManager)tmpApp).getTopologyModel();
                this.cleanupView(tm);
                DummyManagerController managerController = (DummyManagerController)this.modelToController.get(tm);
                LDNIndexService.getInstance().unregister(managerController);
                this.modelToController.remove(tm);
                int indexOfManager = this.abstractViewManagers.indexOf(tmpApp);
                this.abstractViewManagers.remove(tmpApp);
                this.view.selector.removeItemListener(this.selectorStateChangeListener);
                this.view.selector.removeItem(tm);
                this.view.selector.addItemListener(this.selectorStateChangeListener);
                tm.dispose();
                tm = null;
                tmpApp = null;
                this.startManagers(aManager, indexOfManager);
            }
        } else {
            Runnable runCleanup = new Runnable(){

                public void run() {
                    MainWindowController.this.restartManager(aManager);
                }
            };
            SwingUtilities.invokeLater(runCleanup);
        }
    }

    public synchronized void cleanupAndRestart() throws IOException {
        JDialog okDialog;
        Log.logNotify("cleanupAndRestart is running!!!!!! ");
        AbstractApplication app = this.getApplication();
        Enumeration allApps = this.getApplications().elements();
        String ClsName = app.getApplicationControllerClassName();
        Log.logNotify("--------------------This application class name = " + ClsName);
        while (allApps.hasMoreElements()) {
            AbstractApplication tmpApp = (AbstractApplication)allApps.nextElement();
            Log.logNotify("--------------------Other application class name = " + tmpApp.getApplicationControllerClassName());
            if (ClsName.equals(tmpApp.getApplicationControllerClassName())) continue;
            tmpApp.stopApplicationNoCheck();
        }
        app.setStatus(null);
        this.cleanupViews();
        Enumeration allManagers = this.abstractViewManagers.elements();
        while (allManagers.hasMoreElements()) {
            AbstractViewManager tmpApp = (AbstractViewManager)allManagers.nextElement();
            TopologyModel tm = tmpApp.getTopologyModel();
            DummyManagerController managerController = (DummyManagerController)this.modelToController.get(tm);
            LDNIndexService.getInstance().unregister(managerController);
            Log.logNotify("unregistered hyperlinks");
            this.modelToController.remove(tm);
            Log.logNotify("disposing model");
            try {
                tm.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Log.trace("After dispose");
            tm = null;
            tmpApp = null;
        }
        this.abstractViewManagers.clear();
        this.myAbstractManager.clear();
        this.view.selector.removeAllItems();
        ShowLDNAction.closeAllLDNWindows();
        this.shutdownAllExternalApplications();
        if (this.globalpmMonitor) {
            this.prgBar.setFinished(true);
        }
        Log.logNotify("Managers disposed");
        this.modelToController.clear();
        CSFacade.dropAllSubscriptions();
        MOProxy.cleanup();
        CSFacade.cleanup();
        EmasFramework.cleanup();
        System.gc();
        Log.logNotify("initStartup!");
        this.initStartupService();
        if (this.restartManagersInitiated && (okDialog = this.getMessageDialog()) != null) {
            okDialog.hide();
        }
        this.swingUtilsInCleanupAndRestart();
    }

    private void swingUtilsInCleanupAndRestart() {
        if (SwingUtilities.isEventDispatchThread()) {
            TitleUpdateService tus = TitleUpdateService.getInstance();
            tus.setDefaultPrefix();
            this.restartManagers();
            this.restartManagersInitiated = true;
            Object[] exceptionMessage = new Object[1];
            if (EmasSystemProperties.getProperty("application launched", "false").equalsIgnoreCase("false")) {
                this.showMessageDialog("CONNECTION_RESTORED_MESSAGE", null, "INFORMATION_MESSAGE_BOX_TITLE", exceptionMessage, 1, null);
            }
            this.restartManagersInitiated = false;
            if (EmasSystemProperties.getProperty("application launched", "false").equalsIgnoreCase("false") && !"se.ericsson.cello.emas.fm.am.AlarmApplication".equals(this.emtApplToRun)) {
                RestoreConfirm.restoreConfirmSlideWizard();
            }
            this.weAreInTheReconnectionCase = false;
            if (!this.myNodeTime.isAlive()) {
                this.myNodeTime.start();
            }
            this.setStatusNull();
            EmasProgressMonitor.closeAllOpenProgressMonitors();
        } else {
            Runnable runCleanup = new Runnable(){

                public void run() {
                    MainWindowController.this.swingUtilsInCleanupAndRestart();
                }
            };
            SwingUtilities.invokeLater(runCleanup);
        }
    }

    private void cleanupView(TopologyModel tm) {
        Log.logNotify("will clean up one view");
        Object arr = this.viewHash.get(tm);
        if (null != arr) {
            try {
                SortedTableModel temp2Model;
                DetailTable dt = (DetailTable)Array.get(arr, 3);
                DetailModel tempModel = (DetailModel)dt.getOriginalTableModel();
                if (tempModel != null) {
                    tempModel.cleanup();
                }
                if ((temp2Model = (SortedTableModel)this.view.table.getModel()) != null) {
                    temp2Model.resetClickedColumn();
                }
                TopologyTree tree = (TopologyTree)Array.get(arr, 0);
                tree.removeTreeSelectionListener((TopologyTreeSelectionListener)Array.get(arr, 1));
                tree.removeMouseListener((TopologyTreeMouseListener)Array.get(arr, 2));
                dt.removeMouseListener((TableMouseListener)Array.get(arr, 4));
                this.viewHash.remove(tm);
                this.view.leftScrollPane.getViewport().removeAll();
                this.view.rightScrollPane.getViewport().removeAll();
                this.view.invalidate();
                this.view.table = null;
                this.view.revalidate();
            }
            catch (Exception exep) {
                Log.logError("Error while doing cleanupView" + exep);
            }
        }
    }

    private void cleanupViews() {
        Log.logNotify("will clean up all views");
        Enumeration elems = this.viewHash.elements();
        while (elems.hasMoreElements()) {
            try {
                SortedTableModel temp2Model;
                Object arr = elems.nextElement();
                DetailTable dt = (DetailTable)Array.get(arr, 3);
                DetailModel tempModel = (DetailModel)dt.getOriginalTableModel();
                if (tempModel != null) {
                    tempModel.cleanup();
                }
                if ((temp2Model = (SortedTableModel)this.view.table.getModel()) != null) {
                    temp2Model.resetClickedColumn();
                }
                TopologyTree tree = (TopologyTree)Array.get(arr, 0);
                tree.removeTreeSelectionListener((TopologyTreeSelectionListener)Array.get(arr, 1));
                tree.removeMouseListener((TopologyTreeMouseListener)Array.get(arr, 2));
                dt.removeMouseListener((TableMouseListener)Array.get(arr, 4));
            }
            catch (Exception exep) {
                Log.logError("Error while doing cleanupViews" + exep);
            }
        }
        this.view.leftScrollPane.getViewport().removeAll();
        this.view.rightScrollPane.getViewport().removeAll();
        this.view.invalidate();
        this.view.revalidate();
        this.view.table = null;
        this.viewHash.clear();
        TitleUpdateService tus = TitleUpdateService.getInstance();
        if (tus != null) {
            tus.cleanup();
        }
    }

    private void restartManagers() {
        Log.traceFlow();
        this.view.selector.removeItemListener(this.selectorStateChangeListener);
        this.selectorStateChangeListener = null;
        this.viewManagerList = new Vector();
        this.lazyViewManagerDataList = null;
        this.NotIntializedManagerList = new Vector();
        this.defaultViewManagerDisplayed = new Boolean(false);
        this.init2();
    }

    private void setStatusNull() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.getApplication().setStatus(null);
        } else {
            Runnable run = new Runnable(){

                public void run() {
                    MainWindowController.this.setStatusNull();
                }
            };
            SwingUtilities.invokeLater(run);
        }
    }

    public void connectionWarning(final int timeout, final ConnectionStatus status) {
        if (SwingUtilities.isEventDispatchThread()) {
            Log.trace("MainWindowController - connectionWarning()");
            Object[] args = new Object[]{new Integer(timeout), status.toString()};
            this.getApplication().setStatus("CONNECTION_WARNING_MESSAGE", args);
            this.myNodeTime.closeTimeThread();
        } else {
            Runnable runStatusUpdate = new Runnable(){

                public void run() {
                    MainWindowController.this.connectionWarning(timeout, status);
                }
            };
            SwingUtilities.invokeLater(runStatusUpdate);
        }
    }

    public void connectionError() {
        Log.trace("MainWindowController - connectionError() ");
        ErrorDialog errDia = ErrorDialog.create(this.getView(), this.getString("ERROR_MESSAGE_CONNECTION", null), null);
        errDia.show();
        Log.logNotify("connectionError() : stopping execution");
        this.myNodeTime.closeTimeThread();
    }

    public void overflow() {
        Log.trace("MainWindowController - overflowError() ");
        ErrorDialog errDia = ErrorDialog.create(this.getView(), this.getString("ERROR_MESSAGE_OVERFLOW", null), null);
        errDia.show();
        this.getApplication().stopApplicationNoCheck();
    }

    protected boolean canStop() {
        Log.traceFlow();
        int result = this.showConfirmDialog("EXIT_MAINWINDOW_MSG", null, "EXIT_APPLICATION_TITLE", null, 0, 3, null);
        return result == 0;
    }

    protected void stop() {
        this.cleanupForClosing();
        this.shutdownAllExternalApplications();
    }

    public void actionPerformed(ActionEvent e) {
        Log.traceFlow();
        JComponent button = (JComponent)e.getSource();
        String tag = button.getName();
        TaskMenuEntry task = this.menuController.getTaskEntry(tag);
        if (task.nonguilib) {
            String app_name = task.link;
            Log.trace("The following external application has been started : " + app_name);
            System.out.println("app_name = " + app_name);
            this.startExternalApplication(app_name, task);
        } else {
            if (this.requireToStartAllLazyManagers(e)) {
                this.startAllLazyManagers();
            }
            this.startApplication(e.getActionCommand(), null);
        }
    }

    private void startExternalApplication(String applicationName, TaskMenuEntry task) {
        final String method_id = task.method_id;
        final String application_name = applicationName;
        if (!applicationName.equals("oe.client.OeLaunch")) {
            System.out.println("applicationName!=oe.client.OeLaunch");
            try {
                EmasLaunchableInterface appl;
                Object[] temp_parameter = null;
                if (task.parameterClass != null) {
                    try {
                        Class<?> managerClass = Class.forName(task.parameterClass);
                        managerClass.newInstance();
                        Class[] classes = new Class[]{MainWindowController.class};
                        Constructor<?> constructor = managerClass.getConstructor(classes);
                        ParameterInterface parameters = (ParameterInterface)constructor.newInstance(this);
                        temp_parameter = parameters.getParameters();
                    }
                    catch (ClassNotFoundException e) {
                        temp_parameter = new Object[]{task.parameterClass};
                    }
                }
                final Object[] parameter = temp_parameter;
                final Properties props = EmasSystemProperties.getProperties();
                final String host = EmasSystemProperties.getProperty("host");
                final ORB tmp_orb = this.getApplication().getORB();
                final MainWindowController launcher = this;
                Class<?> application_class = Class.forName(application_name);
                if (this.externalApps == null) {
                    this.externalApps = new Hashtable();
                }
                if ((appl = (EmasLaunchableInterface)this.externalApps.get(application_name)) == null) {
                    appl = (EmasLaunchableInterface)application_class.newInstance();
                    this.externalApps.put(application_name, appl);
                }
                final EmasLaunchableInterface app = appl;
                Thread start_app = new Thread(){

                    public void run() {
                        try {
                            if (app.init(host, props, launcher, tmp_orb)) {
                                Log.logNotify("Application  started *******");
                            } else {
                                Log.logNotify("Application  already running *******");
                            }
                            MainWindowController.this.getApplication().setCursor(Application.WAIT_CURSOR);
                            MainWindowController.this.updateExternalApplicationsLogging(app);
                            app.genMethod(method_id, parameter);
                            Log.logNotify("Returned from method ");
                            MainWindowController.this.getApplication().setCursor(Application.DEFAULT_CURSOR);
                        }
                        catch (Exception x) {
                            Log.logError("Error launching external application: " + application_name, x);
                        }
                    }
                };
                start_app.start();
            }
            catch (Exception e) {
                this.reportException(e, "EXTERNAL_EXCEPTION_MESSAGE", null);
            }
        } else {
            Object[] parameters = new Object[1];
            String[] ldnArr = new String[]{task.parameterClass};
            parameters = new Object[ldnArr.length];
            System.arraycopy(ldnArr, 0, parameters, 0, ldnArr.length);
            this.startOE(method_id, null, null, null, parameters);
        }
    }

    public void startOE(String method_id_in, String codebase, String pClass, String application, Object[] parameter_in) {
        String method_id = method_id_in;
        Object[] parameter = parameter_in;
        try {
            String host = EmasSystemProperties.getProperty("host");
            if (this.externalApps == null) {
                this.externalApps = new Hashtable();
            }
            EmasSystemProperties.setProperty("OE_VISIBLE", "FALSE");
            EmasSystemProperties.setProperty("EMAS_STARTS_OE", "TRUE");
            String configfile = EmasSystemProperties.getProperty("OE_CONFIG_FILE");
            LaunchExternalApplication start_app = new LaunchExternalApplication(host, this.getApplicationManager(), this, method_id, parameter, configfile, this);
            start_app.start();
        }
        catch (Exception e) {
            this.reportException(e, "EXTERNAL_EXCEPTION_MESSAGE", null);
        }
    }

    public Hashtable getExternalApplications() {
        return this.externalApps;
    }

    public void removeExternalApplication(String application_name) {
        this.externalApps.remove(application_name);
    }

    private void shutdownAllExternalApplications() {
        ApplicationManager applicationManager = this.getApplicationManager();
        applicationManager.shoutDownAllExternaApplications();
    }

    private synchronized void startManagers() {
        Log.traceFlow();
        String viewManagersFileName = EmasSystemProperties.getProperty("emas.mainwindow.viewmanagers.filename", "/se/ericsson/cello/support/gui/resources/Viewmanagers.properties");
        Log.logNotify("viewManagersFileName=" + viewManagersFileName);
        PropertiesHelper properties = new PropertiesHelper(viewManagersFileName);
        ((EmasProperties)properties).extendProperties(viewManagersFileName);
        String extensions = ((Properties)properties).getProperty("extensions");
        ((EmasProperties)properties).setExtensions(extensions);
        String views = ((Properties)properties).getProperty("views");
        if (views == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(views, ",");
        while (st.hasMoreTokens()) {
            final String viewName = st.nextToken();
            Log.measure("manager", true, "Loading " + viewName + "-Manager");
            String key = "view." + viewName;
            final String className = ((Properties)properties).getProperty(key + ".class");
            final String propertiesName = ((Properties)properties).getProperty(key + ".properties");
            final boolean isExtFile = this.isExtendedFile(extensions, propertiesName);
            Thread viewManagerWorker = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (!MainWindowController.this.defaultViewManagerDisplayed.booleanValue()) {
                        Boolean bl = MainWindowController.this.defaultViewManagerDisplayed;
                        synchronized (bl) {
                            MainWindowController.this.defaultViewManagerDisplayed = new Boolean(true);
                            this.setPriority(10);
                            AbstractViewManager theFirstMgr = MainWindowController.this.startManager(viewName, className, propertiesName, isExtFile);
                            MainWindowController.this.selectAndDisplayManager(theFirstMgr);
                        }
                    } else {
                        MainWindowController.this.startManager(viewName, className, propertiesName, isExtFile);
                    }
                }
            };
            this.viewManagerList.add(viewManagerWorker);
            viewManagerWorker.start();
            Log.measure("manager", false);
        }
    }

    private String concatExtPath(String file) {
        file = file.trim();
        String extFile = "/resources/" + file;
        int inx = file.indexOf("/");
        if (inx == 0 || inx == 1) {
            extFile = "/resources/" + file.substring(inx + 1);
        }
        return extFile;
    }

    private void startManagers(String managerToStart, int managerIndex) {
        Log.traceFlow();
        String viewManagersFileName = EmasSystemProperties.getProperty("emas.mainwindow.viewmanagers.filename", "/se/ericsson/cello/support/gui/resources/Viewmanagers.properties");
        Log.logNotify("viewManagersFileName=" + viewManagersFileName);
        PropertiesHelper properties = new PropertiesHelper(viewManagersFileName);
        ((EmasProperties)properties).extendProperties(viewManagersFileName);
        String extensions = ((Properties)properties).getProperty("extensions");
        ((EmasProperties)properties).setExtensions(extensions);
        String views = ((Properties)properties).getProperty("views");
        String lazyViews = ((Properties)properties).getProperty("lazyviews");
        StringBuffer mergedViews = new StringBuffer();
        if (views != null) {
            mergedViews.append(views);
        }
        if (lazyViews != null) {
            if (views != null) {
                mergedViews.append(",");
            }
            mergedViews.append(lazyViews);
        }
        String viewList = mergedViews.toString();
        StringTokenizer st = new StringTokenizer(viewList, ",");
        while (st.hasMoreTokens()) {
            String viewName = st.nextToken();
            if (!managerToStart.equals("all") && !viewName.equals(managerToStart)) continue;
            Log.measure("manager", true, "Loading " + viewName + "-Manager");
            String key = "view." + viewName;
            String className = ((Properties)properties).getProperty(key + ".class");
            String propertiesName = ((Properties)properties).getProperty(key + ".properties");
            boolean isExtFile = this.isExtendedFile(extensions, propertiesName);
            Log.logNotify("propertyfile for " + viewName + " = " + propertiesName);
            try {
                Properties viewProperties;
                Class<?> managerClass = Class.forName(className);
                String packagePath = "";
                if (!isExtFile) {
                    packagePath = this.getPackagePathToManagerPropertiesHolder(propertiesName);
                    viewProperties = PropertiesHelper.getProperties(propertiesName, packagePath);
                } else {
                    viewProperties = PropertiesHelper.getProperties(this.concatExtPath(propertiesName));
                }
                Log.trace("propertyfile for view " + viewName + " loaded");
                viewProperties.setProperty("viewprefix", key + ".");
                AbstractViewManager abstractViewManager = null;
                try {
                    Constructor<?> constructor = managerClass.getConstructor(Properties.class, String.class);
                    abstractViewManager = (AbstractViewManager)constructor.newInstance(viewProperties, packagePath);
                }
                catch (Exception e) {
                    Constructor<?> constructor = managerClass.getConstructor(Properties.class);
                    abstractViewManager = (AbstractViewManager)constructor.newInstance(viewProperties);
                }
                this.view.selector.removeItemListener(this.selectorStateChangeListener);
                this.addView(abstractViewManager.getTopologyModel());
                this.abstractViewManagers.add(abstractViewManager);
                this.selectAndDisplayManager(abstractViewManager);
                this.view.selector.addItemListener(this.selectorStateChangeListener);
                this.myAbstractManager.put(viewName, abstractViewManager);
            }
            catch (ClassNotFoundException e) {
                Log.logError("Error in properties file!\nUnable to load class for " + viewName + "=" + className, e);
                continue;
            }
            catch (NoSuchMethodException e) {
                Log.logError("Error in properties file!\nUnable to get constructor for " + viewName + "=" + className, e);
                continue;
            }
            catch (SecurityException e) {
                Log.logError("Error in properties file!\nUnable to get constructor for " + viewName + "=" + className, e);
                continue;
            }
            catch (InstantiationException e) {
                Log.logError("Error in properties file!\nUnable to instantiate " + viewName + "=" + className, e);
            }
            catch (IllegalAccessException e) {
                Log.logError("Error in properties file!\nUnable to instantiate " + viewName + "=" + className, e);
            }
            catch (IllegalArgumentException e) {
                Log.logError("Error in properties file!\nUnable to instantiate " + viewName + "=" + className, e);
            }
            catch (InvocationTargetException e) {
                Log.logError("Error in properties file!\nUnable to instantiate " + viewName + "=" + className, e);
            }
            Log.measure("manager", false);
        }
    }

    private synchronized String getPackagePathToManagerPropertiesHolder(String path) {
        int index = path.lastIndexOf("/elements/resources");
        if (index < 0 && (index = path.lastIndexOf("/")) == 0) {
            return "";
        }
        return path.substring(1, index).replace('/', '.');
    }

    public void addView(String name, ViewElementCreator aRootCreator) {
        Log.traceFlow();
        this.addView(new TopologyModel(name, aRootCreator));
    }

    public void addView(String name, ViewElementCreator aRootCreator, CachingPolicy policy) {
        Log.traceFlow();
        this.addView(new TopologyModel(name, aRootCreator, policy));
    }

    public void addView(String name, AbstractViewElement root) {
        Log.traceFlow();
        this.addView(new TopologyModel(name, root));
    }

    public void addView(TopologyModel model) {
        this.waitForCorbaServices();
        Log.traceFlow();
        model.updateLocale(this.getApplication().getLocale());
        this.view.selector.addItem(model);
        DummyManagerController managerController = new DummyManagerController(this, model);
        this.modelToController.put(model, managerController);
        IndexingServiceRegistrator isr = new IndexingServiceRegistrator(managerController, model, null);
    }

    public void addView(TopologyModel model, int index) {
        this.waitForCorbaServices();
        Log.traceFlow();
        model.updateLocale(this.getApplication().getLocale());
        this.view.selector.insertItemAt(model, index);
        DummyManagerController managerController = new DummyManagerController(this, model);
        this.modelToController.put(model, managerController);
        IndexingServiceRegistrator isr = new IndexingServiceRegistrator(managerController, model, null);
    }

    public void selectElement(AbstractViewElement elt) {
        this.view.tree.setSelectionPath(elt.getPathToRoot());
    }

    public void makeVisible(AbstractViewElement elt) {
        this.view.tree.scrollPathToVisible(elt.getPathToRoot());
    }

    public void openElement(AbstractViewElement elt) {
        Action actionToPerform = elt.getDefaultAction();
        if (actionToPerform != null) {
            ActionEvent defaultActionEvent = new ActionEvent(this.view.table, 1001, "default");
            actionToPerform.actionPerformed(defaultActionEvent);
        }
    }

    public void changeView(String viewName) {
        Log.traceFlow();
        Log.trace("Change to view : " + viewName);
        TopologyModel foundView = this.findView(viewName);
        if (foundView != null && foundView != this.getCurrentView()) {
            this.view.selector.setSelectedItem(foundView);
        }
    }

    public TopologyModel getCurrentView() {
        return (TopologyModel)this.view.selector.getSelectedItem();
    }

    public AbstractViewElement getSelectedElement() {
        TreePath path = this.view.tree.getSelectionPath();
        return path == null ? null : (AbstractViewElement)path.getLastPathComponent();
    }

    public AbstractViewElement[] getSelectedElements() {
        TreePath[] paths = this.view.tree.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        AbstractViewElement[] selectedElements = new AbstractViewElement[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            selectedElements[i] = (AbstractViewElement)paths[i].getLastPathComponent();
        }
        return selectedElements;
    }

    public TopologyModel[] getViews() {
        Log.traceFlow();
        if (this.view.selector.getItemCount() == 0) {
            return null;
        }
        Vector<TopologyModel> views = new Vector<TopologyModel>();
        for (int i = 0; i < this.view.selector.getItemCount(); ++i) {
            Object item = this.view.selector.getItemAt(i);
            if (!(item instanceof TopologyModel)) continue;
            views.add((TopologyModel)item);
        }
        return views.toArray(new TopologyModel[0]);
    }

    private synchronized void selectView(TopologyModel selectedView) {
        Log.traceFlow();
        this.waitForCorbaServices();
        Object aViewArr = this.viewHash.get(selectedView);
        if (null != aViewArr) {
            this.view.leftScrollPane.getViewport().removeAll();
            this.view.rightScrollPane.getViewport().removeAll();
            this.view.invalidate();
            TopologyTree treInHash = (TopologyTree)Array.get(aViewArr, 0);
            this.view.leftScrollPane.getViewport().add((Component)treInHash, null);
            treInHash.setBackground(Color.white);
            this.view.leftScrollPane.getViewport().setBackground(treInHash.getBackground());
            this.view.tree = treInHash;
            DetailTable dt = (DetailTable)Array.get(aViewArr, 3);
            this.view.rightScrollPane.getViewport().add((Component)dt, null);
            this.view.table = dt;
            AbstractViewElement newElt = this.getSelectedElement();
            String detailText = newElt.getDetailText();
            if (detailText == null) {
                this.view.currentElementLabel.setText(" No information available");
            } else {
                this.view.currentElementLabel.setText(detailText);
            }
            ((MainWindowView)this.getView()).setRefreshButtonVisible(newElt.refreshButtonNeeded());
            this.view.table.requestFocus();
            this.view.revalidate();
        } else {
            this.view.leftScrollPane.getViewport().removeAll();
            this.view.rightScrollPane.getViewport().removeAll();
            this.view.invalidate();
            this.view.tree = new TopologyTree();
            String currentBundleName = this.getApplication().getLanguageBundleName();
            DetailModel tablemodel = new DetailModel(selectedView, GuilibResourceBundle.getBundle(currentBundleName, this.getClass().getClassLoader()));
            this.view.tree.setModel(selectedView);
            this.view.initializeTree();
            TopologyTreeSelectionListener treeSelListener = new TopologyTreeSelectionListener();
            TopologyTreeMouseListener treeMouseListener = new TopologyTreeMouseListener();
            TableMouseListener taMouseListener = new TableMouseListener();
            this.view.tree.addTreeSelectionListener(treeSelListener);
            this.view.tree.addMouseListener(treeMouseListener);
            this.view.initializeTable(tablemodel);
            this.view.table.addMouseListener(taMouseListener);
            this.view.tree.setSelectionRow(0);
            this.selectElementFromTable = false;
            this.view.tree.requestFocus();
            Object viewItems = Array.newInstance(new Object().getClass(), 5);
            Array.set(viewItems, 0, this.view.tree);
            Array.set(viewItems, 1, treeSelListener);
            Array.set(viewItems, 2, treeMouseListener);
            Array.set(viewItems, 3, this.view.table);
            Array.set(viewItems, 4, taMouseListener);
            this.viewHash.put(selectedView, viewItems);
        }
    }

    private void elementSelected(AbstractViewElement newElt) {
        Log.trace("elementSelected(" + newElt + ")");
        ((SortedTableModel)this.view.table.getModel()).resetClickedColumn();
        ((DetailModel)this.view.table.getOriginalTableModel()).setParentElement(newElt);
        String detailText = newElt.getDetailText();
        if (detailText == null) {
            this.view.currentElementLabel.setText(" No information available");
        } else {
            this.view.currentElementLabel.setText(detailText);
        }
        ((MainWindowView)this.getView()).setRefreshButtonVisible(newElt.refreshButtonNeeded());
    }

    private void showPopupMenu(AbstractViewElement elt, JComponent component, int x, int y) {
        Action[] allActions;
        Action[] actions = elt.getActions();
        Locale currentLocale = this.getApplication().getLocale();
        String currentBundleName = this.getCurrentView().getResourceBundleBasename();
        ResourceBundle currentBundle = null;
        if (currentBundleName != null) {
            currentBundle = currentLocale == null ? GuilibResourceBundle.getBundle(currentBundleName, this.getClass().getClassLoader()) : GuilibResourceBundle.getBundle(currentBundleName, currentLocale, this.getClass().getClassLoader());
        }
        String mainWindowLanguage = this.getApplication().getLanguageBundleName();
        ResourceBundle mainWindowLanguageBundle = GuilibResourceBundle.getBundle(mainWindowLanguage, this.getClass().getClassLoader());
        RefreshAction refreshAction = new RefreshAction("REFRESH_ACTION", elt);
        ShowLDNAction ldnAction = new ShowLDNAction("SHOWLDN_ACTION", elt, mainWindowLanguageBundle);
        OEGoToAction oeGotoAction = new OEGoToAction(elt.getDN(), mainWindowLanguageBundle.getString("SHOW_IN_OE"));
        ReservedByAction reservedByAction = new ReservedByAction("RESERVEDBY_ACTION", elt, this.mc);
        boolean emasEl = false;
        String dn = elt.getDN();
        if (!dn.equals("")) {
            emasEl = true;
            allActions = !elt.showReservedBy() ? new Action[actions.length + 3] : new Action[actions.length + 4];
        } else {
            allActions = !elt.showReservedBy() ? new Action[actions.length + 1] : new Action[actions.length + 2];
        }
        int index = 0;
        allActions[0] = refreshAction;
        if (emasEl) {
            System.out.println("emasEl =============");
            allActions[1] = ldnAction;
            allActions[2] = oeGotoAction;
            if (!elt.showReservedBy()) {
                index = 3;
            } else {
                allActions[3] = reservedByAction;
                index = 4;
            }
        } else if (!elt.showReservedBy()) {
            index = 1;
        } else {
            allActions[1] = reservedByAction;
            index = 2;
        }
        int i = index;
        while (i - index < actions.length) {
            allActions[i] = actions[i - index];
            ++i;
        }
        DummyManagerController managerController = (DummyManagerController)this.modelToController.get(elt.getModel());
        Log.assertion(managerController != null, "No managing controller found for view element");
        JMenuItem hyperlinks = null;
        if (allActions != null || hyperlinks != null) {
            EmasPopupMenu popupMenu = new EmasPopupMenu();
            for (int i2 = 0; i2 < allActions.length; ++i2) {
                JMenuItem newItem = new JMenuItem();
                newItem.setAction(allActions[i2]);
                if (currentBundle == null) continue;
                if (allActions[i2] != ldnAction && allActions[i2] != refreshAction && allActions[i2] != reservedByAction) {
                    try {
                        newItem.setText(currentBundle.getString(newItem.getText()));
                        popupMenu.add(newItem);
                    }
                    catch (Exception e) {
                        if (null == newItem || null == newItem.getText()) continue;
                        popupMenu.add(newItem);
                    }
                    continue;
                }
                if (mainWindowLanguageBundle == null) continue;
                try {
                    newItem.setText(mainWindowLanguageBundle.getString(newItem.getText()));
                    popupMenu.add(newItem);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (hyperlinks != null) {
                popupMenu.add(hyperlinks);
            }
            popupMenu.show(component, x, y);
            Point location = popupMenu.getLocationOnScreen();
            Dimension size = new Dimension();
            size = popupMenu.getSize(size);
            double popup_X = size.getWidth();
            double popup_Y = size.getHeight();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            double screenSize_X = screenSize.getWidth();
            double screenSize_Y = screenSize.getHeight();
            if (popup_Y + (double)location.y > screenSize_Y) {
                y -= (int)popup_Y;
            }
            if ((double)location.x + popup_X > screenSize_X) {
                x -= (int)popup_X;
            }
            popupMenu.show(component, x, y);
        }
    }

    private TopologyModel findView(String viewName) {
        Log.traceFlow();
        Object foundElt = null;
        for (int i = 0; foundElt == null && i < this.view.selector.getItemCount(); ++i) {
            if (!this.view.selector.getItemAt(i).toString().equals(viewName)) continue;
            foundElt = this.view.selector.getItemAt(i);
        }
        return foundElt;
    }

    private void refreshTable() {
        AbstractViewElement el = this.getSelectedElement();
        if (null != el) {
            el.refresh();
            el.refreshChildren();
            Object[] arr = new String[]{el.getName()};
            this.getApplication().setStatus("REFRESHED_MESSAGE", arr);
        }
    }

    protected void cleanupForClosing() {
        ShowLDNAction.closeAllLDNWindows();
        if (this.connectionSupervisionController != null) {
            this.connectionSupervisionController.quit();
            this.connectionSupervisionController = null;
        }
        this.cleanupViews();
        Enumeration allManagers = this.abstractViewManagers.elements();
        while (allManagers.hasMoreElements()) {
            AbstractViewManager tmpApp = (AbstractViewManager)allManagers.nextElement();
            TopologyModel tm = tmpApp.getTopologyModel();
            DummyManagerController managerController = (DummyManagerController)this.modelToController.get(tm);
            LDNIndexService.getInstance().unregister(managerController);
            Log.logNotify("unregistered hyperlinks");
            this.modelToController.remove(tm);
            Log.logNotify("disposing model");
            System.out.println("------------Deleting TopologyModel and ElementManager  " + tm.getName() + "-------- ");
            if (tm != null) {
                tm.dispose();
                tm = null;
            }
            tmpApp = null;
        }
        this.abstractViewManagers.clear();
        this.myAbstractManager.clear();
        this.view.selector.removeItemListener(this.selectorStateChangeListener);
        this.view.selector.removeAllItems();
        this.view.selector = null;
        Log.logNotify("Managers disposed");
        this.modelToController.clear();
        this.modelToController = null;
        this.view.printMenuItem.removeActionListener(this.printAction);
        this.view.printMenuItem = null;
        this.view.pageLayoutMenuItem.removeActionListener(this.pageLayoutAction);
        this.view.pageLayoutMenuItem = null;
        this.view.settingsMenuItem.removeActionListener(this.settingsAction);
        this.view.settingsMenuItem = null;
        this.view.refreshButton.removeActionListener(this.refreshListener);
        this.settingsAction = null;
        this.printAction = null;
        this.pageLayoutAction = null;
        this.printout = null;
        for (int i = 0; i < this.view.menu.length; ++i) {
            this.closeDisplayedMenu(this.view.menu[i]);
            this.view.menu[i].removeAll();
        }
        this.view.menu = null;
        this.menuTree.destroy();
        this.menuTree = null;
        this.menuController.destroy();
        this.menuController = null;
        this.menuModel.destroy();
        this.menuModel = null;
        if (!this.noCorbaForRBS) {
            this.myNodeTime.closeTimeThread();
            CSFacade.dropAllSubscriptions();
            MOProxy.cleanup();
            CSFacade.getInstance().dispose();
        }
        EmasFramework.cleanup();
        this.selectorStateChangeListener = null;
        this.view.tree = null;
        this.view = null;
        this.mc = null;
        this.getApplication().getORB().shutdown(true);
        GuilibConfigParams.getInstance().dispose();
        Transaction.cleanup();
        LogManager.dispose();
        if (this.myNodeTime != null) {
            this.myNodeTime.closeTimeThread();
        }
        System.gc();
    }

    public MainWindowView getMainWindowView() {
        return this.view;
    }

    private synchronized AbstractViewManager startManager(String viewName, String className, String propertiesName, boolean isExtFile) {
        Log.traceFlow();
        String key = "view." + viewName;
        AbstractViewManager abstractViewManager = null;
        try {
            Class<?> managerClass = Class.forName(className);
            Properties viewProperties = null;
            String packagePath = "";
            if (!isExtFile) {
                packagePath = this.getPackagePathToManagerPropertiesHolder(propertiesName);
                viewProperties = PropertiesHelper.getProperties(propertiesName, packagePath);
            } else {
                viewProperties = PropertiesHelper.getProperties(this.concatExtPath(propertiesName));
            }
            Log.trace("propertyfile for view " + viewName + " loaded");
            viewProperties.setProperty("viewprefix", key + ".");
            String reservedByTypeString = viewProperties.getProperty("reservedByTypes");
            try {
                Constructor<?> constructor = managerClass.getConstructor(Properties.class, String.class);
                abstractViewManager = (AbstractViewManager)constructor.newInstance(viewProperties, packagePath);
            }
            catch (Exception e) {
                Constructor<?> constructor = managerClass.getConstructor(Properties.class);
                abstractViewManager = (AbstractViewManager)constructor.newInstance(viewProperties);
            }
            int index = this.getSelectorItemIndex(viewName);
            Log.trace("viewName: " + viewName + " at " + index);
            if (-1 == index) {
                this.addView(abstractViewManager.getTopologyModel());
            } else {
                this.addView(abstractViewManager.getTopologyModel(), index);
            }
            this.abstractViewManagers.add(abstractViewManager);
            this.myAbstractManager.put(viewName, abstractViewManager);
        }
        catch (ClassNotFoundException e) {
            Log.logError("Error in properties file!\nUnable to load class for " + viewName + "=" + className, e);
        }
        catch (NoSuchMethodException e) {
            Log.logError("Error in properties file!\nUnable to get constructor for " + viewName + "=" + className, e);
        }
        catch (SecurityException e) {
            Log.logError("Error in properties file!\nUnable to get constructor for " + viewName + "=" + className, e);
        }
        catch (InstantiationException e) {
            Log.logError("Error in properties file!\nUnable to instantiate " + viewName + "=" + className, e);
        }
        catch (IllegalAccessException e) {
            Log.logError("Error in properties file!\nUnable to instantiate " + viewName + "=" + className, e);
        }
        catch (IllegalArgumentException e) {
            Log.logError("Error in properties file!\nUnable to instantiate " + viewName + "=" + className, e);
        }
        catch (InvocationTargetException e) {
            Log.logError("Error in properties file!\nUnable to instantiate " + viewName + "=" + className, e);
        }
        Log.measure("manager", false);
        return abstractViewManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLazyManager(final String lazyViewName, final boolean pmMonitor) {
        this.globalpmMonitor = pmMonitor;
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            Log.trace("startLazyManager interrupted.");
        }
        LazyManagerView manager = null;
        String viewName = "No Mamager";
        for (int i = 0; i < this.lazyViewManagerDataList.size(); ++i) {
            manager = (LazyManagerView)this.lazyViewManagerDataList.get(i);
            viewName = manager.getViewName();
            String NonTranslatedName = manager.getNameToName(lazyViewName);
            if (NonTranslatedName != null && NonTranslatedName.equals(viewName)) break;
        }
        if (null == manager) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            if (!this.NotIntializedManagerList.contains(viewName)) {
                return;
            }
            this.NotIntializedManagerList.remove(viewName);
            if (pmMonitor) {
                this.prgBar = new ProgressThread(viewName + " manager", 1000);
                this.prgBar.start();
            }
            ViewSelectorComboBox i = this.view.selector;
            synchronized (i) {
                this.view.selector.removeItemListener(this.selectorStateChangeListener);
                this.view.selector.removeItem(lazyViewName);
                String className = manager.getClassName();
                boolean isExtFile = manager.isExtFile();
                String propertiesName = manager.getPropertiesName();
                AbstractViewManager mgr = this.startManager(viewName, className, propertiesName, isExtFile);
                this.view.selector.setSelectedItem(mgr.getTopologyModel());
                this.selectAndDisplayManager(mgr);
                this.view.selector.addItemListener(this.selectorStateChangeListener);
            }
            if (pmMonitor) {
                this.prgBar.setFinished(true);
            }
        } else {
            Runnable runStartLazyManager = new Runnable(){

                public void run() {
                    MainWindowController.this.startLazyManager(lazyViewName, pmMonitor);
                }
            };
            SwingUtilities.invokeLater(runStartLazyManager);
        }
    }

    private Vector readLazyManagerData() {
        Vector<LazyManagerView> managerList = new Vector<LazyManagerView>();
        Log.traceFlow();
        String viewManagersFileName = EmasSystemProperties.getProperty("emas.mainwindow.viewmanagers.filename", "/se/ericsson/cello/support/gui/resources/Viewmanagers.properties");
        Log.logNotify("viewManagersFileName=" + viewManagersFileName);
        PropertiesHelper properties = new PropertiesHelper(viewManagersFileName);
        ((EmasProperties)properties).extendProperties(viewManagersFileName);
        String extensions = ((Properties)properties).getProperty("extensions");
        ((EmasProperties)properties).setExtensions(extensions);
        String lazyviews = ((Properties)properties).getProperty("lazyviews");
        if (lazyviews == null) {
            return managerList;
        }
        StringTokenizer st = new StringTokenizer(lazyviews, ",");
        while (st.hasMoreTokens()) {
            String viewName = st.nextToken();
            Log.measure("manager", true, "Loading " + viewName + "-Manager");
            String key = "view." + viewName;
            String className = ((Properties)properties).getProperty(key + ".class");
            String propertiesName = ((Properties)properties).getProperty(key + ".properties");
            boolean extFile = this.isExtendedFile(extensions, propertiesName);
            managerList.add(new LazyManagerView(viewName, className, propertiesName, extFile));
        }
        return managerList;
    }

    protected void afterVisible() {
    }

    private int getSelectorItemIndex(String viewName) {
        int selectorItemIndex = -1;
        boolean found = false;
        LazyManagerView mgr = null;
        for (int i = 0; this.lazyViewManagerDataList != null && i < this.lazyViewManagerDataList.size(); ++i) {
            mgr = (LazyManagerView)this.lazyViewManagerDataList.get(i);
            String name = mgr.getViewName();
            String translatedViewName = mgr.getNameToName(viewName);
            if (!name.equals(viewName) && !name.equals(translatedViewName)) continue;
            found = true;
            break;
        }
        if (!found) {
            return -1;
        }
        selectorItemIndex = mgr.getSelectorItemIndexFromName(viewName);
        return selectorItemIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLazyManagerItems() {
        this.lazyViewManagerDataList = this.readLazyManagerData();
        ViewSelectorComboBox viewSelectorComboBox = this.view.selector;
        synchronized (viewSelectorComboBox) {
            this.view.selector.removeItemListener(this.selectorStateChangeListener);
            int selectorItemIndex = 0;
            for (int i = 0; this.lazyViewManagerDataList != null && i < this.lazyViewManagerDataList.size(); ++i) {
                LazyManagerView mgr = (LazyManagerView)this.lazyViewManagerDataList.get(i);
                String viewName = mgr.getViewName();
                String translatedViewName = mgr.getNameToName(viewName);
                selectorItemIndex = this.view.selector.getItemCount();
                Log.trace("selectorItemIndex: " + selectorItemIndex + "Name: " + translatedViewName);
                this.view.selector.insertItemAt(translatedViewName, selectorItemIndex);
                mgr.setSelectorItemIndex(selectorItemIndex);
                this.NotIntializedManagerList.add(viewName);
            }
            this.view.selector.addItemListener(this.selectorStateChangeListener);
        }
    }

    private void closeDisplayedMenu(JMenu menu) {
        JPopupMenu myPopupMenu = menu.getPopupMenu();
        if (myPopupMenu.isVisible()) {
            MenuElement[] myMenuElements = myPopupMenu.getSubElements();
            for (int i = myMenuElements.length; i > 0; --i) {
                if (myMenuElements[i - 1].getComponent() instanceof JMenu) {
                    this.closeDisplayedMenu((JMenu)myMenuElements[i - 1]);
                }
                myMenuElements[i - 1].getComponent().setVisible(false);
            }
            menu.setPopupMenuVisible(false);
        }
    }

    private synchronized void waitForCorbaServices() {
        if (this.corbaInitThread == null) {
            return;
        }
        try {
            this.corbaInitThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.corbaInitThread = null;
    }

    private void waitForManagerInitialization() {
        if (this.viewManagerList == null) {
            return;
        }
        for (int i = 0; null != this.viewManagerList && i < this.viewManagerList.size(); ++i) {
            try {
                ((Thread)this.viewManagerList.get(i)).join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.viewManagerList = null;
    }

    private void selectAndDisplayManager(AbstractViewManager mgr) {
        this.view.selector.setSelectedItem(mgr.getTopologyModel());
        this.selectView(mgr.getTopologyModel());
        this.defaultViewManagerDisplayed = new Boolean(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAllLazyManagers() {
        if (this.NotIntializedManagerList == null || this.NotIntializedManagerList.size() == 0) {
            return;
        }
        TopologyModel myCurrentView = this.getCurrentView();
        ViewSelectorComboBox viewSelectorComboBox = this.view.selector;
        synchronized (viewSelectorComboBox) {
            this.view.selector.removeItemListener(this.selectorStateChangeListener);
            for (int i = 0; this.lazyViewManagerDataList != null && i < this.lazyViewManagerDataList.size(); ++i) {
                String viewName;
                LazyManagerView mgr = (LazyManagerView)this.lazyViewManagerDataList.get(i);
                String translatedViewName = mgr.getNameToName(viewName = mgr.getViewName());
                if (this.NotIntializedManagerList.contains(translatedViewName)) continue;
                this.startLazyManager(translatedViewName, false);
            }
            this.view.selector.addItemListener(this.selectorStateChangeListener);
        }
        this.view.selector.setSelectedItem(myCurrentView);
    }

    private boolean requireToStartAllLazyManagers(ActionEvent e) {
        boolean result = false;
        String cmd = e.getActionCommand();
        if (cmd.equals("se.ericsson.cello.support.gui.FetchAllTopologyManagersApplication")) {
            result = true;
        }
        return result;
    }

    private boolean isExtendedFile(String extensions, String propertiesFileName) {
        ArrayList<String> extensionFilesArray = null;
        boolean extFile = false;
        if (extensions != null && !extensions.equals("")) {
            StringTokenizer stok = new StringTokenizer(extensions, ",");
            extensionFilesArray = new ArrayList<String>();
            while (stok.hasMoreTokens()) {
                String str = stok.nextToken();
                extensionFilesArray.add(str);
            }
        }
        if (extensionFilesArray != null && extensionFilesArray.size() > 0) {
            for (int i = 0; i < extensionFilesArray.size(); ++i) {
                if (!propertiesFileName.equals((String)extensionFilesArray.get(i))) continue;
                extFile = true;
            }
        }
        return extFile;
    }

    public void updateExternalApplicationsLogging(EmasLaunchableInterface anLanchable) {
        String logToFile = "false";
        String logToStdOut = "false";
        int logLevel = Log.getLogLevel();
        logToFile = Log.getLogToFile() ? "true" : "false";
        logToStdOut = Log.getLogToStdOut() ? "true" : "false";
        Object[] args = new Object[]{logToFile, logToStdOut, new Integer(logLevel)};
        String methodName = "updateLoggingSettings";
        anLanchable.genMethod(methodName, args);
        Log.logNotify("Successfully changed logging settings in MainWindowController.");
    }

    public ConnectionSupervisionController getConnectionSupervisionController() {
        return this.connectionSupervisionController;
    }

    public boolean getSelectElementFromTable() {
        return this.selectElementFromTable;
    }

    private class LazyManagerView {
        private String viewName;
        private String className;
        private String propertiesName;
        private boolean isExtFile;
        private Hashtable nameToName = new Hashtable();
        private int selectorItemIdex = -1;
        private HashMap nameToIndex = new HashMap();

        public LazyManagerView(String viewName, String className, String propertiesName, boolean extFile) {
            String translatedViewName;
            this.viewName = viewName;
            this.className = className;
            this.propertiesName = propertiesName;
            this.isExtFile = extFile;
            String key = "view." + viewName;
            PropertiesHelper properties = extFile ? new PropertiesHelper(MainWindowController.this.concatExtPath(propertiesName)) : new PropertiesHelper(propertiesName);
            try {
                String myBundleKey;
                String myTag = ((Properties)properties).getProperty(key + ".tag");
                if (myTag == null) {
                    myTag = ((Properties)properties).getProperty("tag");
                }
                if ((myBundleKey = ((Properties)properties).getProperty(key + ".languageBundle")) == null) {
                    myBundleKey = ((Properties)properties).getProperty("languageBundle");
                }
                ResourceBundle myBundle = GuilibResourceBundle.getBundle(myBundleKey, MainWindowController.class.getClassLoader());
                translatedViewName = myBundle.getString(myTag);
            }
            catch (NullPointerException e) {
                translatedViewName = MainWindowController.this.getString(viewName, null);
            }
            this.nameToName.put(viewName, translatedViewName);
            this.nameToName.put(translatedViewName, viewName);
        }

        public String getViewName() {
            return this.viewName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getPropertiesName() {
            return this.propertiesName;
        }

        public String getNameToName(String name) {
            return (String)this.nameToName.get(name);
        }

        public boolean isExtFile() {
            return this.isExtFile;
        }

        public void setSelectorItemIndex(int itemIndex) {
            this.selectorItemIdex = itemIndex;
            Integer theValue = new Integer(this.selectorItemIdex);
            this.nameToIndex.put(this.getViewName(), theValue);
            this.nameToIndex.put(this.getNameToName(this.getViewName()), theValue);
        }

        public int getSelectorItemIndex() {
            return this.selectorItemIdex;
        }

        public int getSelectorItemIndexFromName(String name) {
            Integer result = null;
            result = (Integer)this.nameToIndex.get(name);
            if (result == null) {
                return -1;
            }
            return result;
        }
    }

    private class ProgressThread
    extends Thread {
        private boolean finished = false;
        private String message = "Ss7 Manager";
        private int totalSteps = 1000;

        public void setFinished(boolean finished) {
            this.finished = finished;
        }

        public ProgressThread(String message, int steps) {
            this.message = message;
            this.totalSteps = steps;
            this.finished = false;
        }

        public void run() {
            EmasProgressMonitor pm = new EmasProgressMonitor(null, "Initializing..", this.message, "Please wait...", 0, this.totalSteps);
            int progressCount = 0;
            while (!this.finished) {
                try {
                    if (progressCount == this.totalSteps) {
                        pm.close();
                        pm = null;
                        pm = new EmasProgressMonitor(null, "Initializing..", this.message, "Please wait", 0, this.totalSteps);
                        progressCount = 0;
                    }
                    pm.setProgress(progressCount++);
                    ProgressThread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            pm.close();
        }
    }

    private class SearchAction
    implements ActionListener {
        private SearchAction() {
        }

        public void actionPerformed(ActionEvent event) {
            IndexServiceQueryApplication application = (IndexServiceQueryApplication)MainWindowController.this.mc.startApplication("se.ericsson.cello.support.gui.IndexServiceQueryApplication", null, true);
        }
    }

    private class PageLayoutAction
    implements ActionListener {
        private PageLayoutAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if (MainWindowController.this.printout == null) {
                MainWindowController.this.printout = new Printout(((MainWindowController)MainWindowController.this).view.table, ((MainWindowController)MainWindowController.this).view.currentElementLabel.getText());
            }
            MainWindowController.this.printout.pageLayout();
            MainWindowController.this.getApplication().bringToFront();
        }
    }

    private class PrintAction
    implements ActionListener {
        private boolean printFromDetailsPane;

        private PrintAction() {
        }

        public void actionPerformed(ActionEvent event) {
            if (MainWindowController.this.printout == null) {
                MainWindowController.this.printout = new Printout(((MainWindowController)MainWindowController.this).view.table, ((MainWindowController)MainWindowController.this).view.currentElementLabel.getText());
            }
            MainWindowController.this.printout.setPrintDetailsPane(true);
            MainWindowController.this.printout.setPrintDetailsPane(true);
            MainWindowController.this.printout.setTitle(((MainWindowController)MainWindowController.this).view.currentElementLabel.getText());
            MainWindowController.this.printout.print();
            Log.trace("###########in MAIN WINDOW CONTROLLER  it prints from here #################");
            MainWindowController.this.getApplication().bringToFront();
        }
    }

    private class SettingsAction
    implements ActionListener {
        private SettingsAction() {
        }

        public void actionPerformed(ActionEvent event) {
            SettingsApplication application = (SettingsApplication)MainWindowController.this.mc.startApplication("se.ericsson.cello.emas.eq.applications.SettingsApplication", null, true);
        }
    }

    private class DummyManagerController
    implements MappedController {
        MainWindowController mwc;
        TopologyModel model;
        private static final String POPUP_TITLE = "HYPERLINK_POPUP_TITLE";

        public DummyManagerController(MainWindowController mwc, TopologyModel model) {
            this.mwc = mwc;
            this.model = model;
        }

        public void exposeView() {
            this.mwc.getApplication().bringToFront();
            this.mwc.changeView(this.model.getName());
        }

        public void selectElement(AbstractViewElement viewElement) {
            this.exposeView();
            AbstractViewElement parent = viewElement.getParent();
            if (parent != null) {
                ((MainWindowController)this.mwc).view.tree.setSelectionPath(parent.getPathToRoot());
                this.mwc.makeVisible(parent);
                ((MainWindowController)this.mwc).view.table.requestFocus();
                ((MainWindowController)this.mwc).view.table.selectTableElement(viewElement);
            } else {
                this.mwc.selectElement(viewElement);
                this.mwc.makeVisible(viewElement);
            }
        }

        public Action getHyperlinkAction(String key, Object viewElement) {
            final AbstractViewElement ve = (AbstractViewElement)viewElement;
            AbstractAction action = new AbstractAction(ve.getHyperlinkActionName(), ve.getIcon()){

                public void actionPerformed(ActionEvent e) {
                    DummyManagerController.this.selectElement(ve);
                }

                public String toString() {
                    return "MainWindow HyperlinkAction[NAME=" + this.getValue("Name") + "]";
                }
            };
            return action;
        }

        public JMenu getHyperlinkMenu(AbstractViewElement ve) {
            LDNIndexService is = LDNIndexService.getInstance();
            String[] keys = ve.getIndexKeys();
            if (keys.length == 0) {
                return null;
            }
            TreeSet<Action> allHyperlinks = new TreeSet<Action>(LDNIndexService.actionsByName);
            for (int i = 0; i < keys.length; ++i) {
                List<Action> keyHyperlinks = Arrays.asList(is.getHyperlinks(keys[i], 4, this, ve));
                allHyperlinks.addAll(keyHyperlinks);
            }
            if (allHyperlinks.size() > 0) {
                Action[] actions = allHyperlinks.toArray(new Action[allHyperlinks.size()]);
                return LDNIndexService.toJMenu(MainWindowController.this.getString(POPUP_TITLE, null), actions);
            }
            return null;
        }
    }

    private class SelectorStateChangeListener
    implements ItemListener {
        private SelectorStateChangeListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Log.measure("managersel", true, "Starting " + e.getItem() + "-Manager");
                final Object item = e.getItem();
                if (item instanceof String) {
                    new Thread(){

                        public void run() {
                            MainWindowController.this.startLazyManager((String)item, false);
                        }
                    }.start();
                } else {
                    MainWindowController.this.selectView((TopologyModel)item);
                }
                Log.measure("managersel", false);
            }
        }
    }

    private class ViewLocaleChangeListener
    implements LocaleChangeListener {
        private ViewLocaleChangeListener() {
        }

        public void updateLocale(Locale locale) {
            MainWindowController.this.waitForManagerInitialization();
            Log.traceFlow();
            for (int i = 0; i < ((MainWindowController)MainWindowController.this).view.selector.getItemCount(); ++i) {
                if (((MainWindowController)MainWindowController.this).view.selector.getItemAt(i) instanceof String) continue;
                TopologyModel model = (TopologyModel)((MainWindowController)MainWindowController.this).view.selector.getItemAt(i);
                model.updateLocale(locale);
            }
            ((MainWindowController)MainWindowController.this).view.selector.setLocale(locale);
            ((MainWindowController)MainWindowController.this).view.selector.updateUI();
            if (((MainWindowController)MainWindowController.this).view.table == null) {
                return;
            }
            DetailModel myModel = (DetailModel)((MainWindowController)MainWindowController.this).view.table.getOriginalTableModel();
            if (myModel == null) {
                Log.logError("Model is null!");
            } else {
                myModel.setLocale(locale);
            }
        }

        public void dispose() {
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        public void mousePressed(MouseEvent evt) {
            MainWindowController.this.selectElementFromTable = true;
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void showPopup(MouseEvent evt) {
            Log.trace("Right mouse-button was clicked");
            AbstractViewElement clickedElt = ((MainWindowController)MainWindowController.this).view.table.getViewElementAtPoint(evt.getPoint());
            if (clickedElt != null) {
                ((MainWindowController)MainWindowController.this).view.table.requestFocus();
                ((MainWindowController)MainWindowController.this).view.table.selectTableElement(clickedElt);
                MainWindowController.this.showPopupMenu(clickedElt, ((MainWindowController)MainWindowController.this).view.table, evt.getX(), evt.getY());
            }
        }

        public void mouseClicked(MouseEvent evt) {
            AbstractViewElement clickedElt;
            if (evt.getClickCount() == 2 && (clickedElt = ((MainWindowController)MainWindowController.this).view.table.getViewElementAtPoint(evt.getPoint())) != null) {
                if (clickedElt.childrenAreAllowed()) {
                    ((MainWindowController)MainWindowController.this).view.tree.requestFocus();
                    MainWindowController.this.selectElement(clickedElt);
                    MainWindowController.this.setStatusNull();
                } else {
                    MainWindowController.this.openElement(clickedElt);
                }
            }
        }
    }

    private class TopologyTreeSelectionListener
    implements TreeSelectionListener {
        private TopologyTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            if (Log.getLogLevel() >= 6) {
                Log.trace("valueChanged(" + (e.isAddedPath() ? "select:" : "deselect:") + e.getPath() + ", source=" + e.getSource() + ")");
            }
            AbstractViewElement changedItem = (AbstractViewElement)e.getPath().getLastPathComponent();
            if (e.isAddedPath()) {
                MainWindowController.this.elementSelected(changedItem);
            } else {
                TreePath previousPath = e.getPath();
                TreePath previousRoot = previousPath;
                for (int pathLength = previousPath.getPathCount(); pathLength != 1; --pathLength) {
                    previousRoot = previousRoot.getParentPath();
                }
                TreePath rootPath = new TreePath(((MainWindowController)MainWindowController.this).view.tree.getModel().getRoot());
                if (rootPath.equals(previousRoot)) {
                    AbstractViewElement existingParent = (AbstractViewElement)previousPath.getLastPathComponent();
                    while (existingParent != (AbstractViewElement)((MainWindowController)MainWindowController.this).view.tree.getModel().getRoot() && existingParent.getParent() == null) {
                        previousPath = previousPath.getParentPath();
                        existingParent = (AbstractViewElement)previousPath.getLastPathComponent();
                    }
                    ((MainWindowController)MainWindowController.this).view.tree.setSelectionPath(previousPath);
                    MainWindowController.this.elementSelected(existingParent);
                    ((MainWindowController)MainWindowController.this).view.tree.scrollPathToVisible(previousPath);
                } else {
                    AbstractViewElement existingParent = (AbstractViewElement)rootPath.getLastPathComponent();
                    ((MainWindowController)MainWindowController.this).view.tree.setSelectionPath(rootPath);
                    MainWindowController.this.elementSelected(existingParent);
                    ((MainWindowController)MainWindowController.this).view.tree.scrollPathToVisible(rootPath);
                }
            }
            MainWindowController.this.selectElementFromTable = false;
        }
    }

    private class TopologyTreeMouseListener
    extends MouseAdapter {
        private TopologyTreeMouseListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            MainWindowController.this.selectElementFromTable = false;
        }

        public void mousePressed(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showPopup(evt);
            }
            MainWindowController.this.setStatusNull();
        }

        public void showPopup(MouseEvent evt) {
            TreePath treePath = ((MainWindowController)MainWindowController.this).view.tree.getPathForLocation(evt.getX(), evt.getY());
            if (treePath != null) {
                Log.trace("Popup trigger detected on view element in tree");
                AbstractViewElement clickedElt = (AbstractViewElement)treePath.getLastPathComponent();
                if (clickedElt != null) {
                    MainWindowController.this.selectElement(clickedElt);
                    MainWindowController.this.showPopupMenu(clickedElt, ((MainWindowController)MainWindowController.this).view.tree, evt.getX(), evt.getY());
                }
            }
        }
    }

    private class myNodeTimeThread
    extends Thread {
        boolean doContinue = true;
        SimpleDateFormat utc_formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        TimeConverter timeConverter = new TimeConverter();
        TimeZone utc_TimeZone = TimeZone.getTimeZone("GMT+00:00");

        public myNodeTimeThread(MOProxy aMo) {
            this.setName("myNodeTimeThread");
            this.utc_formatter.setTimeZone(this.utc_TimeZone);
        }

        public void closeTimeThread() {
            this.doContinue = false;
        }

        public void run() {
            this.setName("myNodeTimeThread");
            while (this.doContinue) {
                try {
                    final String dateString = this.timeConverter.get_current_node_UTC_time().substring(0, 16);
                    Runnable run = new Runnable(){

                        public void run() {
                            MainWindowController.this.getApplication().setStatus("CLOCK" + dateString);
                        }
                    };
                    SwingUtilities.invokeLater(run);
                }
                catch (Exception e) {
                    Log.trace("Could not retrive time from the node!");
                    this.doContinue = false;
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (Exception e) {
                    this.doContinue = false;
                }
            }
        }
    }
}

