/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import se.ericsson.cello.support.gui.HashBag;
import se.ericsson.cello.support.gui.MappedController;
import se.ericsson.cello.support.gui.guilib.comp.Log;

class ModelViewMap {
    private HashBag mapping = new HashBag();
    public static final int MATCH_STARTS_WITH = 1;
    public static final int MATCH_ENDS_WITH = 2;
    public static final int MATCH_CONTAINS = 3;
    public static final int MATCH_EQUALS = 4;
    public static Comparator actionsByName = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 instanceof Action && o2 instanceof Action) {
                Object attr1 = ((Action)o1).getValue("Name");
                Object attr2 = ((Action)o2).getValue("Name");
                String name1 = attr1 != null ? attr1.toString() : "";
                String name2 = attr2 != null ? attr2.toString() : "";
                int result = name1.compareTo(name2);
                return result;
            }
            throw new ClassCastException("Comparison error o1=" + o1 + "; o2=" + o2);
        }
    };

    public synchronized void register(String ldn, MappedController controller, Object viewElement, Action exposeAction) {
        Log.trace("register(" + ldn + "," + controller + "," + viewElement + "," + exposeAction + ")");
        if (ldn == null || ldn.equals("")) {
            Log.logError("Registration with empth key " + ldn + "not possible");
            return;
        }
        String origLdn = ldn;
        ldn = ldn.toLowerCase();
        if (exposeAction != null && exposeAction.getValue("Name") == null) {
            Log.logError("Name of registered action missing.");
            exposeAction.putValue("Name", ldn);
        }
        this.mapping.put(ldn, new MVRegistration(ldn, controller, viewElement, exposeAction, origLdn));
    }

    public synchronized void unregister(String ldn, MappedController controller, Object viewElement) {
        String origLdn = ldn;
        ldn = ldn.toLowerCase();
        Log.trace("unregister(" + ldn + "," + controller + "," + viewElement + ")");
        this.mapping.remove(ldn, new MVRegistration(ldn, controller, viewElement, null, origLdn));
    }

    public synchronized void unregister(MappedController controller, Object viewElement) {
        Log.trace("unregister(" + controller + ",VE=" + viewElement + ")");
        MVRegistration toRemove = new MVRegistration(null, controller, viewElement, null);
        Iterator entry = this.mapping.entrySet().iterator();
        while (entry.hasNext()) {
            Map.Entry map = (Map.Entry)entry.next();
            Vector values = (Vector)map.getValue();
            Iterator target = values.iterator();
            while (target.hasNext()) {
                MVRegistration reg = (MVRegistration)target.next();
                if (!reg.equalControllerAndElement(toRemove)) continue;
                target.remove();
            }
            if (!values.isEmpty()) continue;
            entry.remove();
        }
    }

    public synchronized void unregister(MappedController controller) {
        Log.trace("unregister(" + controller + ")");
        MVRegistration toRemove = new MVRegistration(null, controller, null, null);
        Iterator entry = this.mapping.entrySet().iterator();
        while (entry.hasNext()) {
            Map.Entry map = (Map.Entry)entry.next();
            Vector values = (Vector)map.getValue();
            Iterator target = values.iterator();
            while (target.hasNext()) {
                MVRegistration reg = (MVRegistration)target.next();
                if ((reg.controller != null || controller != null) && (reg.controller == null || !reg.controller.equals(controller))) continue;
                target.remove();
            }
            if (!values.isEmpty()) continue;
            entry.remove();
        }
    }

    public Action[] getHyperlinks(String ldn) {
        return this.getHyperlinks(ldn, 4, null, null);
    }

    public Action[] getHyperlinks(String ldn, MappedController excludedController, Object excludedViewElement) {
        Log.trace("getHyperlinks(" + ldn + ",,)");
        TreeSet<Action> result = new TreeSet<Action>(actionsByName);
        MVRegistration exclude = excludedController == null ? null : new MVRegistration(ldn, excludedController, excludedViewElement, null);
        List values = this.mapping.get(ldn);
        Log.log(7, values.size() + " elements for key " + ldn);
        for (MVRegistration reg : values) {
            if (reg.equalControllerAndElement(exclude)) continue;
            if (reg.exposeAction != null) {
                reg.exposeAction.putValue("LDN", reg.originalLDN);
                result.add(reg.exposeAction);
                continue;
            }
            Action exposeAction = reg.controller.getHyperlinkAction(reg.ldn, reg.viewElement);
            if (exposeAction == null) {
                Log.logError("Registered view/view element failed to provide a hyperlink action.");
                continue;
            }
            String name = exposeAction.getValue("Name").toString();
            if (name == null || name.equals("")) {
                Log.logError("Nameless action provided to indexing service");
                exposeAction.putValue("Name", reg.ldn);
            }
            exposeAction.putValue("LDN", reg.originalLDN);
            result.add(exposeAction);
        }
        return result.toArray(new Action[result.size()]);
    }

    public Action[] getHyperlinks(String ldnPart, int matchRule, MappedController excludedController, Object excludedViewElement) {
        if (matchRule < 1 || matchRule > 4) {
            throw new IllegalArgumentException("Illegal match-rule");
        }
        ldnPart = ldnPart.toLowerCase();
        Log.trace("getHyperlinks(" + ldnPart + "," + matchRule + ",,)");
        if (matchRule == 4) {
            return this.getHyperlinks(ldnPart, excludedController, excludedViewElement);
        }
        TreeSet<Action> result = new TreeSet<Action>(actionsByName);
        MVRegistration exclude = excludedController == null ? null : new MVRegistration(ldnPart, excludedController, excludedViewElement, null);
        for (Map.Entry map : this.mapping.entrySet()) {
            String key = (String)map.getKey();
            boolean matchFound = matchRule == 2 && key.endsWith(ldnPart) || matchRule == 1 && key.startsWith(ldnPart) || matchRule == 3 && key.indexOf(ldnPart) != -1;
            Log.log(7, matchFound + " " + ldnPart + "=[" + matchRule + "]=" + key);
            if (!matchFound) continue;
            Vector values = (Vector)map.getValue();
            for (int i = 0; i < values.size(); ++i) {
                MVRegistration reg = (MVRegistration)values.get(i);
                if (reg.exposeAction != null) {
                    reg.exposeAction.putValue("LDN", reg.originalLDN);
                    result.add(reg.exposeAction);
                    continue;
                }
                Action a = reg.controller.getHyperlinkAction(reg.ldn, reg.viewElement);
                if (null == a) continue;
                a.putValue("LDN", reg.originalLDN);
                result.add(a);
            }
        }
        return result.toArray(new Action[result.size()]);
    }

    protected Action[] getHyperlinksRE(String regExp, MappedController excludedController, Object excludedViewElement) {
        int matchRule = 0;
        String searchString = null;
        int posStar1 = regExp.indexOf("*");
        if (posStar1 == -1) {
            matchRule = 4;
        } else {
            int posStar2 = regExp.indexOf("*", posStar1 + 1);
            if (posStar1 == 0) {
                matchRule = 2;
                if (posStar2 == regExp.length() - 1) {
                    matchRule = 3;
                }
            } else if (posStar1 == regExp.length() - 1) {
                matchRule = 1;
            }
            if (matchRule == 0) {
                throw new IllegalArgumentException("LDN may have '*' only at its beginning and/or its end");
            }
        }
        switch (matchRule) {
            case 4: {
                searchString = regExp;
                break;
            }
            case 2: {
                searchString = regExp.substring(1);
                break;
            }
            case 1: {
                searchString = regExp.substring(0, regExp.length() - 2);
                break;
            }
            case 3: {
                searchString = regExp.substring(1, regExp.length() - 2);
            }
        }
        return this.getHyperlinks(searchString, matchRule, excludedController, excludedViewElement);
    }

    public JPopupMenu getPopupMenu(String popupLabel, String ldnPart, int matchRule, MappedController excludedController, Object excludedViewElement) {
        Action[] hyperlinks = this.getHyperlinks(ldnPart, matchRule, excludedController, excludedViewElement);
        return ModelViewMap.toPopupMenu(popupLabel, hyperlinks);
    }

    public JPopupMenu getPopupMenuRE(String popupLabel, String regExp, MappedController excludedController, Object excludedViewElement) {
        Action[] hyperlinks = this.getHyperlinksRE(regExp, excludedController, excludedViewElement);
        return ModelViewMap.toPopupMenu(popupLabel, hyperlinks);
    }

    public void debugToString(PrintStream debugStream) {
        debugStream.println("ModelViewMap - Registered Keys");
        Set set = this.mapping.keySet();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            debugStream.println("   " + i.next().toString());
        }
    }

    public static JPopupMenu toPopupMenu(String label, Action[] actions) {
        Log.trace("toPopup(" + label + ", actions[" + actions.length + "])");
        JPopupMenu popup = new JPopupMenu(label);
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i] != null) {
                JMenuItem newItem = new JMenuItem();
                newItem.setAction(actions[i]);
                popup.add(newItem);
                continue;
            }
            popup.addSeparator();
        }
        return popup;
    }

    public static JMenu toJMenu(String label, Action[] actions) {
        Log.trace("toJMenu(" + label + ", actions[" + actions.length + "])");
        JMenu menu = new JMenu(label);
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i] != null) {
                menu.add(new JMenuItem(actions[i]));
                continue;
            }
            menu.addSeparator();
        }
        return menu;
    }

    protected static class MVRegistration {
        public String originalLDN;
        public String ldn;
        public MappedController controller;
        public Object viewElement;
        public Action exposeAction;

        public MVRegistration(String ldn, MappedController controller, Object viewElement, Action exposeAction) {
            this.ldn = ldn;
            this.controller = controller;
            this.viewElement = viewElement;
            this.exposeAction = exposeAction;
            this.originalLDN = ldn;
        }

        public MVRegistration(String ldn, MappedController controller, Object viewElement, Action exposeAction, String originalLdn) {
            this.ldn = ldn;
            this.controller = controller;
            this.viewElement = viewElement;
            this.exposeAction = exposeAction;
            this.originalLDN = originalLdn;
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof MVRegistration) {
                MVRegistration ie = (MVRegistration)obj;
                if (this.ldn == null && ie.ldn != null || this.ldn != null && !this.ldn.equals(ie.ldn)) {
                    return false;
                }
                if (this.controller == null && ie.controller != null || this.controller != null && !this.controller.equals(ie.controller)) {
                    return false;
                }
                return (this.viewElement != null || ie.viewElement == null) && (this.viewElement == null || this.viewElement.equals(ie.viewElement));
            }
            return false;
        }

        public boolean equalControllerAndElement(MVRegistration ie) {
            if (ie == null) {
                return false;
            }
            if (this.controller == null && ie.controller != null || this.controller != null && !this.controller.equals(ie.controller)) {
                return false;
            }
            return (this.viewElement != null || ie.viewElement == null) && (this.viewElement == null || this.viewElement.equals(ie.viewElement));
        }

        public String toString() {
            return "ModelViewMap[ldn='" + this.ldn + "',controller=" + this.controller + ",viewElement=" + this.viewElement + ",exposeAction=" + this.exposeAction + "]";
        }
    }
}

