/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import se.ericsson.cello.support.gui.gengui.GenList;
import se.ericsson.cello.support.gui.gengui.GuiConstants;

public class GenDoubleList
extends JPanel
implements ComponentListener,
ActionListener {
    private GenList listFrom = null;
    private GenList listTo = null;
    private JButton add = null;
    private JButton remove = null;
    private String[] value = new String[0];
    private ActionListener actionListener = null;
    private String actionCommand = null;

    public GenDoubleList(String tagFrom, String tagTo, boolean sorting) {
        String[] list = new String[]{""};
        this.listFrom = new GenList(tagFrom, list, sorting);
        this.listFrom.setUnderneath(true);
        this.listFrom.setScrollable(6, 150);
        this.listFrom.setActionListener(this, "FROM");
        this.listTo = new GenList(tagTo, list, sorting);
        this.listTo.setScrollable(6, 150);
        this.listTo.setUnderneath(true);
        this.listTo.setActionListener(this, "TO");
        this.add = new JButton(">");
        this.add.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        this.add.addActionListener(this);
        this.add.setActionCommand("ADD");
        Font f1 = this.add.getFont();
        Font f2 = new Font(f1.getName(), 1, f1.getSize() + 1);
        this.add.setFont(f2);
        this.add.setAlignmentX(0.5f);
        this.add.setEnabled(false);
        this.remove = new JButton("<");
        this.remove.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        this.remove.addActionListener(this);
        this.remove.setActionCommand("REMOVE");
        this.remove.setFont(f2);
        this.remove.setAlignmentX(0.5f);
        this.remove.setEnabled(false);
        this.layoutComponent();
        this.listTo.removeAllItems();
    }

    public GenDoubleList(String tagFrom, String tagTo) {
        this(tagFrom, tagTo, true);
    }

    public GenDoubleList(String translations, String tagFrom, String tagTo, boolean sorting) {
        String[] list = new String[]{""};
        this.listFrom = new GenList(translations, tagFrom, list, sorting);
        this.listFrom.setUnderneath(true);
        this.listFrom.setScrollable(6, 150);
        this.listFrom.setActionListener(this, "FROM");
        this.listTo = new GenList(translations, tagTo, list, sorting);
        this.listTo.setScrollable(6, 150);
        this.listTo.setUnderneath(true);
        this.listTo.setActionListener(this, "TO");
        this.add = new JButton(">");
        this.add.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        this.add.addActionListener(this);
        this.add.setActionCommand("ADD");
        Font f1 = this.add.getFont();
        Font f2 = new Font(f1.getName(), 1, f1.getSize() + 1);
        this.add.setFont(f2);
        this.add.setAlignmentX(0.5f);
        this.add.setEnabled(false);
        this.remove = new JButton("<");
        this.remove.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        this.remove.addActionListener(this);
        this.remove.setActionCommand("REMOVE");
        this.remove.setFont(f2);
        this.remove.setAlignmentX(0.5f);
        this.remove.setEnabled(false);
        this.layoutComponent();
        this.listTo.removeAllItems();
    }

    public GenDoubleList(String translations, String tagFrom, String tagTo) {
        this(translations, tagFrom, tagTo, true);
    }

    public void setSizeLists(int widthList, int columsList) {
        this.listTo.setScrollable(columsList, widthList);
        this.listFrom.setScrollable(columsList, widthList);
    }

    public void addItemsRight(String[] items) {
        this.listTo.removeAllItems();
        this.listTo.addItems(items);
        ListModel d = ((JList)this.listTo.getFieldComponent()).getModel();
        this.value = new String[d.getSize()];
        for (int i = 0; i < d.getSize(); ++i) {
            this.value[i] = (String)d.getElementAt(i);
        }
    }

    public void addItemsLeft(String[] items) {
        this.listFrom.removeAllItems();
        this.listFrom.addItems(items);
    }

    void layoutComponent() {
        this.setLayout(new BoxLayout(this, 0));
        this.setAlignmentX(0.0f);
        JPanel buttons = new JPanel();
        Dimension dim = new Dimension(60, 2 * GuiConstants.HEIGHT_BUTTON + 5);
        buttons.setMaximumSize(dim);
        buttons.setPreferredSize(dim);
        buttons.setLayout(new BoxLayout(buttons, 1));
        Dimension preferredSize = new Dimension(50, GuiConstants.HEIGHT_BUTTON);
        this.add.setMaximumSize(preferredSize);
        this.remove.setMaximumSize(preferredSize);
        this.add.setMinimumSize(preferredSize);
        this.remove.setMinimumSize(preferredSize);
        this.add.setPreferredSize(preferredSize);
        this.remove.setPreferredSize(preferredSize);
        buttons.add((Component)this.add, "Center");
        buttons.add(Box.createRigidArea(new Dimension(0, 5)));
        buttons.add((Component)this.remove, "Center");
        this.add(this.listFrom);
        this.add(buttons);
        this.add(this.listTo);
    }

    public void setMandatory(boolean set) {
        this.listTo.setMandatory(set);
    }

    public void setActionListener(ActionListener aListener, String aCommand) {
        this.actionListener = aListener;
        this.actionCommand = aCommand;
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.add)) {
            String[] selected = this.listFrom.getValue();
            for (int i = 0; i < selected.length; ++i) {
                this.listFrom.removeItem(selected[i]);
            }
            this.listTo.addItems(selected);
            ListModel d = ((JList)this.listTo.getFieldComponent()).getModel();
            this.value = new String[d.getSize()];
            for (int i = 0; i < d.getSize(); ++i) {
                this.value[i] = (String)d.getElementAt(i);
            }
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 0, "ENTRYFIELD_FILLEDIN"));
            }
        } else if (event.getSource().equals(this.remove)) {
            String[] selected = this.listTo.getValue();
            for (int i = 0; i < selected.length; ++i) {
                this.listTo.removeItem(selected[i]);
            }
            this.listFrom.addItems(selected);
            ListModel d = ((JList)this.listTo.getFieldComponent()).getModel();
            this.value = new String[d.getSize()];
            for (int i = 0; i < d.getSize(); ++i) {
                this.value[i] = (String)d.getElementAt(i);
            }
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 0, "ENTRYFIELD_FILLEDIN"));
            }
        }
        this.add.setEnabled(this.listFrom.isFilledIn());
        this.remove.setEnabled(this.listTo.isFilledIn());
    }

    public String[] getValue() {
        return this.value;
    }

    public boolean isFilledIn() {
        return this.value.length > 0;
    }

    public Object getLeftList() {
        return this.listFrom;
    }

    public Object getRightList() {
        return this.listTo;
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }
}

