/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui;

import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import se.ericsson.cello.support.gui.gengui.ComponentLayout;
import se.ericsson.cello.support.gui.gengui.LabelledField;
import se.ericsson.cello.support.gui.gengui.SyntaxException;
import se.ericsson.cello.support.gui.guilib.comp.Log;

public class GenList
extends LabelledField
implements FocusListener,
ListSelectionListener,
ComponentListener {
    private String[] unsorted = null;
    private String[] sorted = null;
    private boolean sortingOn = true;
    protected String[] value = new String[]{""};
    private JList list = null;
    private ActionListener actionListener = null;
    private String actionCommand = null;
    private int width = 0;
    private JScrollPane scrollPane = null;
    private boolean maxsize = false;
    private Dimension d = new Dimension();
    private boolean begin = true;

    public GenList(String translations, String tag, String[] items, boolean sorting) {
        super(translations, tag);
        this.sortingOn = sorting;
        this.createList(items);
    }

    public GenList(String translations, String tag, String[] items) {
        this(translations, tag, items, true);
    }

    public GenList(String tag, String[] items, boolean sorting) {
        super(tag);
        this.sortingOn = sorting;
        this.createList(items);
    }

    public GenList(String tag, String[] items) {
        this(tag, items, true);
    }

    private void createList(String[] items) {
        this.unsorted = items;
        this.copyAndSort(items);
        this.list = new JList<String>(this.sorted);
        this.add(this.list);
        this.list.addFocusListener(this);
        this.list.addListSelectionListener(this);
        this.addComponentListener(this);
    }

    public void setActionListener(ActionListener aListener, String aCommand) {
        this.actionListener = aListener;
        this.actionCommand = aCommand;
    }

    public void setValue(String[] setValue) throws SyntaxException {
        int[] selectedItems = new int[setValue.length];
        boolean undefinedListItem = true;
        for (int i = 0; i < setValue.length; ++i) {
            undefinedListItem = true;
            for (int j = 0; j < this.sorted.length; ++j) {
                if (!this.sorted[j].equals(setValue[i])) continue;
                undefinedListItem = false;
                selectedItems[i] = j;
            }
            if (!undefinedListItem) continue;
            throw new SyntaxException();
        }
        this.list.setSelectedIndices(selectedItems);
        this.value = setValue;
    }

    public String[] getValue() {
        return this.value;
    }

    public int getSelectedIndex() {
        String myValue = (String)this.list.getSelectedValue();
        for (int i = 0; i < this.unsorted.length; ++i) {
            if (!this.unsorted[i].equals(myValue)) continue;
            return i;
        }
        return -1;
    }

    public void focusLost(FocusEvent e) {
        if (this.changeSelection()) {
            Object[] arrayOfObjects = this.list.getSelectedValues();
            this.value = new String[arrayOfObjects.length];
            for (int i = 0; i < arrayOfObjects.length; ++i) {
                this.value[i] = (String)arrayOfObjects[i];
            }
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 0, this.actionCommand));
            }
        }
    }

    public void removeAllItems() {
        this.remove(this.list);
        this.list.setListData(new String[0]);
        this.add(this.list);
        this.unsorted = null;
        this.sorted = null;
        this.layoutMyComponent();
    }

    public void addItems(String[] items) {
        if (this.unsorted == null) {
            this.unsorted = items;
        } else {
            int i;
            int newLength = items.length + this.unsorted.length;
            String[] dummy = this.unsorted;
            this.unsorted = new String[newLength];
            for (i = 0; i < dummy.length; ++i) {
                this.unsorted[i] = dummy[i];
            }
            for (i = dummy.length; i < newLength; ++i) {
                this.unsorted[i] = items[i - dummy.length];
            }
        }
        this.copyAndSort(this.unsorted);
        this.updateList(this.sorted);
    }

    public void removeItem(String item) {
        int length = this.unsorted.length;
        String[] dummy = this.unsorted;
        this.unsorted = new String[length - 1];
        try {
            int j = 0;
            boolean itemRemoved = false;
            for (int i = 0; i < length; ++i) {
                if (dummy[i].equals(item) && !itemRemoved) {
                    itemRemoved = true;
                    continue;
                }
                this.unsorted[j] = dummy[i];
                ++j;
            }
            this.copyAndSort(this.unsorted);
            this.updateList(this.sorted);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.logError("Item not in List: " + item);
            this.unsorted = dummy;
            this.updateList(this.sorted);
        }
        catch (NegativeArraySizeException n) {
            Log.logError("No items in the list");
        }
    }

    private void updateList(String[] items) {
        if (this.scrollPane == null) {
            this.remove(this.list);
            this.list.setListData(items);
            this.add(this.list);
            if (this.width != 0) {
                this.setWidth(this.width);
            }
        } else {
            this.list.setListData(items);
        }
        this.layoutMyComponent();
    }

    public void setWidth(int width) {
        Dimension myDim = this.list.getPreferredSize();
        myDim.width = width;
        this.width = width;
        this.list.setMinimumSize(myDim);
        this.list.setPreferredSize(myDim);
    }

    public void focusGained(FocusEvent e) {
        if (this.list.getSelectedIndex() < 0) {
            this.list.setSelectedIndex(0);
        }
    }

    void layoutMyComponent() {
        if (this.scrollPane != null) {
            if (this.maxsize && !this.begin) {
                this.remove(this.scrollPane);
                this.scrollPane = new JScrollPane(this.list, 20, 30);
                this.scrollPane.setPreferredSize(new Dimension(this.getSize().width - 8, this.getSize().height - this.getLabel().getSize().height - 8));
                this.add(this.scrollPane);
            } else if (!this.maxsize || this.begin) {
                this.remove(this.scrollPane);
                this.scrollPane = new JScrollPane(this.list, 20, 30);
                this.scrollPane.setPreferredSize(this.d);
                this.add(this.scrollPane);
            }
        }
        this.layoutComponent();
    }

    private boolean changeSelection() {
        Object[] arrayOfObjects = null;
        try {
            arrayOfObjects = this.list.getSelectedValues();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.trace("Not possible to get the values of the list.");
            return false;
        }
        if (this.value.length == arrayOfObjects.length) {
            for (int i = 0; i < arrayOfObjects.length; ++i) {
                if (this.value[i] == (String)arrayOfObjects[i]) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public Object getFieldComponent() {
        return this.list;
    }

    public void setScrollable(int rows, int width) {
        this.scrollPane = new JScrollPane(20, 30);
        this.d = new Dimension(width, rows * 19);
        this.remove(this.list);
        this.add(this.scrollPane);
        this.scrollPane.getViewport().setView(this.list);
        this.maxsize = true;
        this.updateList(this.sorted);
    }

    public int getNumberOfItems() {
        return this.list.getModel().getSize();
    }

    public Dimension getMaximumSize() {
        if (this.maxsize) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        return super.getMaximumSize();
    }

    public void componentResized(ComponentEvent e) {
        this.begin = false;
        if (this.maxsize && this.getParent() != null) {
            LayoutManager layoutManager = this.getParent().getLayout();
            if (layoutManager instanceof BoxLayout) {
                if (this.getParent().getParent() != null) {
                    LayoutManager l = this.getParent().getParent().getLayout();
                    if (l instanceof BoxLayout) {
                        this.maxsize = true;
                        ((ComponentLayout)this.getLayout()).setSizeAble(true);
                    } else {
                        this.maxsize = false;
                    }
                } else {
                    this.maxsize = true;
                    ((ComponentLayout)this.getLayout()).setSizeAble(true);
                }
            } else {
                this.maxsize = false;
            }
        }
        if (this.maxsize) {
            this.layoutMyComponent();
        }
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void updateLocale(Locale locale) {
        super.updateLocale(locale);
        this.translateTooltip(locale);
    }

    public boolean isFilledIn() {
        boolean filledIn = true;
        if (this.list.getSelectedIndex() == -1) {
            filledIn = false;
        }
        return filledIn;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.actionListener != null && !e.getValueIsAdjusting()) {
            this.actionListener.actionPerformed(new ActionEvent(this, 0, "ENTRYFIELD_FILLEDIN"));
        }
    }

    private void copyAndSort(String[] items) {
        this.sorted = new String[items.length];
        for (int i = 0; i < items.length; ++i) {
            this.sorted[i] = items[i];
        }
        if (this.sortingOn) {
            Arrays.sort(this.sorted, String.CASE_INSENSITIVE_ORDER);
        }
    }
}

