/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.gengui.ui.date;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.swing.DefaultFocusManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.metal.MetalComboBoxUI;
import javax.swing.plaf.metal.MetalTextFieldUI;
import se.ericsson.cello.support.gui.gengui.ui.date.CalendarPanel;
import se.ericsson.cello.support.gui.gengui.ui.date.DateParser;

public class DateField
extends JTextField {
    private JWindow dateWindow;
    private BasicArrowButton arrowButton;
    private CalendarPanel calendarPanel;
    private String parseString = "";
    private DateParser parser;
    private Locale locale;
    private int style;
    private Calendar calendarType;
    private boolean keySelect = false;
    private int[] pos = new int[2];
    private ItemListener calendarItemListener;
    private int myArrowButtonActionCounter = 1;
    private static final boolean debug = false;

    public DateField() {
        this(Locale.getDefault(), 3);
    }

    public DateField(Locale loc) {
        this(loc, 3);
    }

    public DateField(Locale loc, int dateStyle) {
        this.locale = loc;
        this.style = dateStyle;
        this.parser = new DateParser(loc, dateStyle);
        this.setMargin(new Insets(2, 2, 2, 2));
        this.setRequestFocusEnabled(true);
        this.arrowButton = new BasicArrowButton(5);
        this.arrowButton.setSize(150, 50);
        this.calendarPanel = new CalendarPanel(loc, dateStyle, this, new GregorianCalendar());
        this.dateWindow = new JWindow();
        this.layoutComponents();
        DefaultFocusManager.setCurrentManager(new DateFieldFocusManager());
        this.pos[0] = -1;
        this.pos[1] = -1;
        this.registerListeners();
        this.calendarType = this.calendarPanel.getCalendar();
    }

    public Date getDate() {
        return this.calendarPanel.getDate();
    }

    public String getDateToString() {
        return this.calendarPanel.getDateToString();
    }

    public void setDate(Date d) {
        this.calendarPanel.setDate(d);
    }

    public void setDate(int year, int month, int day) {
        this.calendarPanel.year = year;
        this.calendarPanel.month = month - 1;
        this.calendarPanel.day = day;
    }

    public void setLocale(Locale l) {
        this.locale = l;
        this.parser = new DateParser(l, this.style);
        this.calendarPanel.setLocale(l);
        this.resizeDateWindow();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setDateStyle(int dateStyle) {
        this.style = dateStyle;
        this.parser = new DateParser(this.locale, dateStyle);
        this.calendarPanel.setDateStyle(dateStyle);
    }

    public int getDateStyle() {
        return this.style;
    }

    public void setCalendar(Calendar c) {
        this.calendarType = c;
        this.calendarPanel.setCalendar(c);
        this.resizeDateWindow();
    }

    public Calendar getCalendar() {
        return this.calendarType;
    }

    public void copyDate() {
        this.calendarPanel.setDate();
        this.setText(this.calendarPanel.getDateToString());
    }

    public void hidePopup() {
        if (this.dateWindow != null && this.dateWindow.isVisible()) {
            this.calendarPanel.monthAndYearPanel.monthBox.hidePopup();
            this.dateWindow.setVisible(false);
        }
    }

    public void showPopup() {
        if (this.dateWindow != null && !this.dateWindow.isVisible()) {
            Toolkit tool = Toolkit.getDefaultToolkit();
            Point thisPoint = this.getLocationOnScreen();
            int x = thisPoint.x + this.getBounds().width - this.dateWindow.getBounds().width;
            if (x < 0) {
                x = 0;
            }
            if (x + this.dateWindow.getBounds().width > tool.getScreenSize().width) {
                x = tool.getScreenSize().width - this.dateWindow.getBounds().width;
            }
            int y = thisPoint.y + this.getBounds().height + this.dateWindow.getBounds().height > tool.getScreenSize().height ? thisPoint.y - this.dateWindow.getBounds().height : thisPoint.y + this.getBounds().height;
            this.debug("x = " + x);
            this.debug("y = " + y);
            Rectangle dwRect = new Rectangle(x, y, this.dateWindow.getBounds().width, this.dateWindow.getBounds().height);
            this.dateWindow.setBounds(dwRect);
            this.dateWindow.show();
            this.dateWindow.requestFocus();
            this.dateWindow.dispatchEvent(new WindowEvent(this.dateWindow, 205));
        }
    }

    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.dateWindow.setVisible(false);
        }
        this.arrowButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public void updateUI() {
        super.updateUI();
        if (this.dateWindow != null) {
            SwingUtilities.updateComponentTreeUI(this.dateWindow);
        }
        if (this.calendarPanel != null) {
            this.calendarPanel.setDate();
        }
        if (this.arrowButton != null) {
            this.layoutComponents();
        }
    }

    public void addItemListener(ItemListener aListener) {
        this.calendarItemListener = aListener;
        this.calendarPanel.addItemListener(aListener);
    }

    public void removeItemListener(ItemListener aListener) {
        this.calendarPanel.removeItemListener(aListener);
    }

    public Object[] getSelectedObjects() {
        return this.calendarPanel.getSelectedObjects();
    }

    public DateParser getParser() {
        return this.parser;
    }

    private void layoutComponents() {
        this.removeAll();
        this.dateWindow.getContentPane().add(this.calendarPanel);
        LineBorder border = new LineBorder(Color.black);
        MatteBorder margin = new MatteBorder(0, 0, 0, 0, Color.black);
        this.dateWindow.getRootPane().setBorder(new CompoundBorder(border, margin));
        this.resizeDateWindow();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gridbag);
        gbc.gridwidth = -1;
        if (this.arrowButton != null) {
            Insets insets;
            int top = -this.getMargin().top;
            int bottom = -this.getMargin().bottom;
            int left = -(this.getMargin().left + 1);
            int right = -(this.getMargin().right + 1);
            gbc.anchor = 18;
            if (this.getUI() instanceof MetalTextFieldUI) {
                --top;
                --bottom;
            }
            gbc.insets = insets = new Insets(top, left, bottom, right);
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridheight = 1;
            gbc.gridwidth = 1;
            gbc.fill = 1;
            JLabel dummy = new JLabel("dummy"){

                public void paint(Graphics g) {
                }
            };
            this.gridBagAdd(this, dummy, gridbag, gbc);
            gbc.gridwidth = 0;
            gbc.weighty = 1.0;
            gbc.gridheight = 1;
            gbc.weightx = 0.0;
            gbc.insets = insets = new Insets(top, 0, bottom, right);
            gbc.fill = 3;
            gbc.ipadx = 2;
            this.gridBagAdd(this, this.arrowButton, gridbag, gbc);
            this.setPreferredSize(new Dimension(this.getPreferredSize().width + this.arrowButton.getSize().width, this.getPreferredSize().height));
            this.setVisible(true);
        }
    }

    private void gridBagAdd(JComponent dest, JComponent comp, GridBagLayout gb, GridBagConstraints gbc) {
        gb.setConstraints(comp, gbc);
        dest.add(comp);
    }

    private void registerListeners() {
        MyActionListener actionListener = new MyActionListener();
        MyKeyListener keyListener = new MyKeyListener();
        MyItemListener itemListener = new MyItemListener();
        this.arrowButton.setActionCommand("arrow_button");
        this.arrowButton.addActionListener(actionListener);
        this.addKeyListener(keyListener);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DateField.this.hidePopup();
            }
        });
        this.calendarPanel.monthAndYearPanel.monthBox.addItemListener(itemListener);
        this.calendarPanel.monthAndYearPanel.yearBox.addItemListener(itemListener);
        for (int i = 0; i < 42; ++i) {
            this.calendarPanel.daysPanel.dayButtons[i].addActionListener(actionListener);
            this.calendarPanel.daysPanel.dayButtons[i].addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1 && e.getComponent().isEnabled()) {
                        DateField.this.hidePopup();
                    }
                }
            });
        }
    }

    private void resizeDateWindow() {
        Insets windowInsets = this.dateWindow.getRootPane().getBorder().getBorderInsets(this.dateWindow);
        Dimension calendarDim = this.calendarPanel.getPreferredSize();
        int windowWidth = calendarDim.width + windowInsets.left + windowInsets.right;
        int windowHeight = calendarDim.height + windowInsets.top + windowInsets.bottom;
        this.dateWindow.setSize(new Dimension(windowWidth, windowHeight));
        this.debug("Size of dateWindow = " + this.dateWindow.getSize());
    }

    private void selectText(int datePart) {
        if (this.style == 3) {
            if (datePart > -1 && this.parser != null) {
                this.pos = this.parser.getFieldPositions(datePart, this.getText());
            }
            if (this.pos[0] > -1 && this.pos[1] > -1 && this.pos[0] <= this.getText().length() && this.pos[1] <= this.getText().length()) {
                this.select(this.pos[0], this.pos[1]);
            }
        }
    }

    private void debug(String string) {
    }

    private class DateFieldFocusManager
    extends DefaultFocusManager {
        private DateFieldFocusManager() {
        }

        public void focusNextComponent(Component comp) {
            if (comp == DateField.this && DateField.this.dateWindow.isVisible()) {
                DateField.this.dateWindow.requestFocus();
            } else if (comp == ((DateField)DateField.this).calendarPanel.monthAndYearPanel.yearBox) {
                super.focusNextComponent(comp);
                DateField.this.hidePopup();
            } else if (comp instanceof JToggleButton && comp.getParent() == ((DateField)DateField.this).calendarPanel.daysPanel) {
                if (((DateField)DateField.this).calendarPanel.monthAndYearPanel.monthBox.getUI() instanceof MetalComboBoxUI) {
                    ((DateField)DateField.this).calendarPanel.monthAndYearPanel.monthBox.getComponent(0).requestFocus();
                } else {
                    ((DateField)DateField.this).calendarPanel.monthAndYearPanel.monthBox.requestFocus();
                }
                DateField.this.selectText(1);
            } else if (comp == ((DateField)DateField.this).calendarPanel.monthAndYearPanel.monthBox.getComponent(0) && ((DateField)DateField.this).calendarPanel.monthAndYearPanel.monthBox.getUI() instanceof MetalComboBoxUI) {
                DateField.this.selectText(0);
                super.focusNextComponent(comp);
            } else if (comp == ((DateField)DateField.this).calendarPanel.monthAndYearPanel.monthBox && !(((DateField)DateField.this).calendarPanel.monthAndYearPanel.monthBox.getUI() instanceof MetalComboBoxUI)) {
                DateField.this.selectText(0);
                super.focusNextComponent(comp);
            } else {
                super.focusNextComponent(comp);
            }
        }

        public void focusPreviousComponent(Component comp) {
            if (comp instanceof JToggleButton && comp.getParent() == ((DateField)DateField.this).calendarPanel.daysPanel) {
                if (comp.isEnabled()) {
                    DateField.this.requestFocus();
                    DateField.this.selectText(2);
                    super.focusPreviousComponent(comp);
                    DateField.this.hidePopup();
                }
            } else if (comp == ((DateField)DateField.this).calendarPanel.monthAndYearPanel.yearBox && ((DateField)DateField.this).calendarPanel.monthAndYearPanel.monthBox.getUI() instanceof MetalComboBoxUI) {
                DateField.this.selectText(1);
                ((DateField)DateField.this).calendarPanel.monthAndYearPanel.monthBox.getComponent(0).requestFocus();
            } else if (comp == ((DateField)DateField.this).calendarPanel.monthAndYearPanel.yearBox && !(((DateField)DateField.this).calendarPanel.monthAndYearPanel.monthBox.getUI() instanceof MetalComboBoxUI)) {
                DateField.this.selectText(1);
                ((DateField)DateField.this).calendarPanel.monthAndYearPanel.monthBox.requestFocus();
            } else if (comp == ((DateField)DateField.this).calendarPanel.monthAndYearPanel.monthBox.getComponent(0) && ((DateField)DateField.this).calendarPanel.monthAndYearPanel.monthBox.getUI() instanceof MetalComboBoxUI) {
                DateField.this.selectText(2);
                DateField.this.calendarPanel.requestFocus();
            } else if (comp == ((DateField)DateField.this).calendarPanel.monthAndYearPanel.monthBox && !(((DateField)DateField.this).calendarPanel.monthAndYearPanel.monthBox.getUI() instanceof MetalComboBoxUI)) {
                DateField.this.selectText(2);
                DateField.this.calendarPanel.requestFocus();
            } else {
                super.focusPreviousComponent(comp);
            }
        }
    }

    private class MyItemListener
    implements ItemListener {
        private MyItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 && !DateField.this.keySelect) {
                int datePart = 0;
                if (e.getItemSelectable() == ((DateField)DateField.this).calendarPanel.monthAndYearPanel.monthBox) {
                    ((DateField)DateField.this).calendarPanel.month = ((DateField)DateField.this).calendarPanel.monthAndYearPanel.monthBox.getSelectedIndex();
                    datePart = 1;
                } else {
                    ((DateField)DateField.this).calendarPanel.year = Integer.valueOf(((DateField)DateField.this).calendarPanel.monthAndYearPanel.yearBox.getText());
                    datePart = 0;
                }
                DateField.this.copyDate();
                DateField.this.selectText(datePart);
            }
        }
    }

    private class MyKeyListener
    implements KeyListener {
        private String selectedText;
        private int selectionStart;
        private int selectionEnd;

        private MyKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            this.selectedText = DateField.this.getSelectedText();
            this.selectionStart = DateField.this.getSelectionStart();
            this.selectionEnd = DateField.this.getSelectionEnd();
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            int datePart = 0;
            String parseString = DateField.this.getText();
            if (e.getModifiers() == 8) {
                if (e.getKeyCode() == 27 || e.getKeyCode() == 38) {
                    DateField.this.hidePopup();
                    e.setKeyChar('\uffff');
                } else if (e.getKeyCode() == 40 && !DateField.this.dateWindow.isVisible()) {
                    DateField.this.arrowButton.doClick();
                    e.setKeyChar('\uffff');
                }
            } else if (e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 39 || e.getKeyCode() == 37) {
                int modification = 0;
                int caretPosition = DateField.this.getCaretPosition();
                if (this.selectedText == null) {
                    this.selectionStart = caretPosition;
                    this.selectionEnd = caretPosition;
                }
                if (e.getKeyCode() == 38) {
                    modification = 1;
                }
                if (e.getKeyCode() == 40) {
                    modification = -1;
                }
                if (e.getKeyCode() == 39) {
                    caretPosition = this.selectionEnd + 1;
                }
                if (e.getKeyCode() == 37) {
                    caretPosition = this.selectionStart - 1;
                }
                if (DateField.this.parser.isYearField(parseString, caretPosition)) {
                    ((DateField)DateField.this).calendarPanel.year += modification;
                    datePart = 0;
                } else if (DateField.this.parser.isMonthField(parseString, caretPosition)) {
                    ((DateField)DateField.this).calendarPanel.month += modification;
                    datePart = 1;
                } else if (DateField.this.parser.isDayField(parseString, caretPosition)) {
                    ((DateField)DateField.this).calendarPanel.day += modification;
                    datePart = 2;
                }
                if ((e.getKeyCode() == 38 || e.getKeyCode() == 40) && caretPosition >= 0 && caretPosition <= parseString.length()) {
                    ((DateField)DateField.this).parser.dateFormat.applyPattern(((DateField)DateField.this).parser.defaultPattern);
                    DateField.this.copyDate();
                    if (DateField.this.getText().length() < caretPosition) {
                        caretPosition = DateField.this.getText().length();
                    }
                    DateField.this.setCaretPosition(caretPosition);
                }
                if (this.selectedText != null) {
                    DateField.this.selectText(datePart);
                }
            } else if (e.getModifiers() == 0 && DateField.this.parser != null && !Character.isIdentifierIgnorable(e.getKeyChar())) {
                ((DateField)DateField.this).pos[0] = -1;
                ((DateField)DateField.this).pos[1] = -1;
                Date tempDate = DateField.this.parser.parseDate(parseString);
                DateField.this.keySelect = true;
                DateField.this.calendarPanel.setDate(tempDate);
                DateField.this.keySelect = false;
            }
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (DateField.this.dateWindow != null) {
                if (e.getActionCommand().equals("arrow_button")) {
                    DateField.this.arrowButton.getParent().requestFocus();
                    DateField.this.myArrowButtonActionCounter++;
                    if (DateField.this.dateWindow.isVisible()) {
                        DateField.this.myArrowButtonActionCounter = 0;
                        DateField.this.hidePopup();
                    } else if (DateField.this.myArrowButtonActionCounter > 1) {
                        DateField.this.myArrowButtonActionCounter = 0;
                        DateField.this.showPopup();
                    }
                } else {
                    ((DateField)DateField.this).calendarPanel.day = Integer.valueOf(e.getActionCommand());
                    ((DateField)DateField.this).calendarPanel.month = ((DateField)DateField.this).calendarPanel.monthAndYearPanel.monthBox.getSelectedIndex();
                    ((DateField)DateField.this).calendarPanel.year = Integer.parseInt(((DateField)DateField.this).calendarPanel.monthAndYearPanel.yearBox.getText());
                    DateField.this.copyDate();
                    DateField.this.selectText(2);
                    DateField.this.calendarPanel.paintImmediately(((DateField)DateField.this).calendarPanel.daysPanel.getBounds());
                    int i = 0;
                    while (!((DateField)DateField.this).calendarPanel.daysPanel.dayButtons[i].isSelected()) {
                        ++i;
                    }
                    ((DateField)DateField.this).calendarPanel.daysPanel.dayButtons[i].requestFocus();
                }
            }
        }
    }
}

