/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.comp;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.comp.ProgressDialogView;
import se.ericsson.cello.support.gui.guilib.infra.AbstractDialogController;

public class ProgressDialogController
extends AbstractDialogController {
    private ProgressDialogView view;
    private CancelButtonAction cancelButtonAction = new CancelButtonAction();
    private String message;
    private int minimum = 0;
    private int maximum = 100;
    private int progress = 0;
    private boolean cancelled = false;

    protected void init() {
        this.view = (ProgressDialogView)this.getView();
        this.view.progressBar.setMinimum(this.minimum);
        this.view.progressBar.setMaximum(this.maximum);
        this.view.progressBar.setValue(this.progress);
        this.view.cancelButton.addActionListener(this.cancelButtonAction);
        this.view.repaint();
    }

    public void setMessage(String aKey, Object[] theArguments) {
        this.message = this.getString(aKey, theArguments);
        this.view.messageLabel.setText(this.message);
        this.view.repaint();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMinimum(int aMinimum) {
        this.minimum = aMinimum;
        this.view.progressBar.setMinimum(this.minimum);
        this.view.minimumLabel.setText("" + this.minimum);
        this.view.repaint();
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMaximum(int aMaximum) {
        this.maximum = aMaximum;
        this.view.progressBar.setMaximum(this.maximum);
        this.view.maximumLabel.setText("" + this.maximum);
        this.view.repaint();
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setProgress(int aProgress) {
        this.progress = aProgress;
        Log.trace("progress is " + this.progress);
        this.view.progressBar.setValue(this.progress);
        this.view.currentLabel.setText("" + this.progress);
        this.view.repaint();
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    protected void stop() {
        Log.trace("stop()");
        this.view.cancelButton.removeActionListener(this.cancelButtonAction);
    }

    protected boolean canStop() {
        Log.trace("canStop() was called");
        return true;
    }

    protected void viewClosing() {
        this.cancelled = true;
        this.view.cancelButton.setEnabled(false);
    }

    private class CancelButtonAction
    implements ActionListener {
        private CancelButtonAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Log.trace("Cancel-button pressed");
            ProgressDialogController.this.cancelled = true;
            ((ProgressDialogController)ProgressDialogController.this).view.cancelButton.setEnabled(false);
        }
    }
}

