/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import se.ericsson.cello.support.gui.guilib.comp.ComponentToolkit;
import se.ericsson.cello.support.gui.guilib.infra.AbstractPresenter;
import se.ericsson.cello.support.gui.guilib.infra.AbstractView;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationMenuBar;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationPresenter;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationToolBar;
import se.ericsson.cello.support.gui.guilib.infra.ViewContainer;

class AppletViewContainer
implements ViewContainer {
    private JApplet applet;
    private ApplicationPresenter applicationPresenter;
    private ApplicationToolBar applicationToolBar;
    private JScrollPane viewPane;
    private JPanel statusBar;
    private JLabel statusLabel;

    AppletViewContainer(JApplet applet) {
        this.applet = applet;
        applet.getContentPane().removeAll();
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        this.viewPane = new JScrollPane();
        contentPanel.add((Component)this.viewPane, "Center");
        this.viewPane.setBorder(null);
        this.viewPane.setViewportBorder(new EtchedBorder());
        this.createStatusBar();
        contentPanel.add((Component)this.statusBar, "South");
        applet.getContentPane().add((Component)contentPanel, "Center");
    }

    private void createStatusBar() {
        this.statusLabel = new JLabel();
        this.statusBar = new JPanel();
        this.statusBar.setLayout(new GridBagLayout());
        this.statusBar.setBorder(new BevelBorder(1));
        this.statusBar.add((Component)this.statusLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void init(AbstractPresenter presenter) {
        this.applicationPresenter = (ApplicationPresenter)presenter;
    }

    public Component getComponent() {
        return this.applet;
    }

    public Component getFocusOwner() {
        return ComponentToolkit.getFocusOwner(this.applet);
    }

    public void setView(AbstractView view) {
        this.viewPane.getViewport().setView(view);
    }

    public void setToolBar(ApplicationToolBar applicationToolBar) {
        if (this.applicationToolBar != null) {
            this.applet.getContentPane().remove(applicationToolBar);
        }
        this.applicationToolBar = applicationToolBar;
        if (this.applicationToolBar != null) {
            this.applet.getContentPane().add((Component)applicationToolBar, "North");
        }
    }

    public void setMenuBar(ApplicationMenuBar applicationMenuBar) {
        this.applet.setJMenuBar(applicationMenuBar);
    }

    public Window getWindow() {
        return null;
    }

    public void setTitle(String title) {
    }

    public void setStatus(String status) {
        if (status == null || status.equals("")) {
            status = " ";
        }
        this.statusLabel.setText(status);
    }

    public void setVisible(boolean visible) {
    }

    public void setEnabled(boolean enabled) {
        ComponentToolkit.setEnabled(enabled, this.applet);
    }

    public void bringToFront() {
    }

    public void setLocation(int x, int y) {
    }

    public void setMaximized() {
    }

    public void setMinimized() {
    }

    public void setRestored() {
    }

    public void setViewResizable(boolean resizable) {
    }

    public void setHorizontalScrollBarPolicy(int policy) {
        this.viewPane.setHorizontalScrollBarPolicy(policy);
    }

    public void setVerticalScrollBarPolicy(int policy) {
        this.viewPane.setVerticalScrollBarPolicy(policy);
    }

    public void doValidate() {
        this.applet.validate();
        this.applet.repaint();
    }

    public void dispose() {
    }
}

