/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import se.ericsson.cello.support.gui.guilib.comp.ComponentToolkit;
import se.ericsson.cello.support.gui.guilib.comp.IconHelper;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractApplicationView;
import se.ericsson.cello.support.gui.guilib.infra.AbstractPresenter;
import se.ericsson.cello.support.gui.guilib.infra.AbstractView;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationMenuBar;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationPresenter;
import se.ericsson.cello.support.gui.guilib.infra.ApplicationToolBar;
import se.ericsson.cello.support.gui.guilib.infra.SDIViewContainer;
import se.ericsson.cello.support.gui.guilib.infra.ViewContainer;

class ApplicationViewContainerDelegator
implements ViewContainer {
    private ApplicationPresenter applicationPresenter;
    private static Hashtable desktops = new Hashtable();
    private int presentation;
    private ViewContainer viewContainerDelegate;
    private boolean desktopOwner;
    private boolean settingDelegatorVisible;

    ApplicationViewContainerDelegator() {
    }

    public void init(AbstractPresenter presenter) {
        this.applicationPresenter = (ApplicationPresenter)presenter;
        this.presentation = presenter.getApplication().getApplicationManager().getPresentation();
        if (this.presentation == 0) {
            this.viewContainerDelegate = new SDIViewContainer();
        } else if (this.presentation == 1) {
            this.viewContainerDelegate = new MDIViewContainer();
        } else if (this.presentation == 2) {
            this.viewContainerDelegate = new DesktopViewContainer();
        } else if (this.presentation == 3) {
            this.viewContainerDelegate = new TabbedViewContainer();
        } else {
            Log.assertion(false, "Presentation not supported: " + this.presentation);
        }
        this.viewContainerDelegate.init(presenter);
    }

    private MDIDesktop getDesktop() {
        MDIDesktop desktop = this.lookupDesktop();
        if (desktop == null) {
            Log.logNotify("Creating new desktop for delegate: " + this.viewContainerDelegate.getClass());
            boolean inApplet = false;
            if (this.applicationPresenter.getApplication().getApplet() != null) {
                String presentation = (String)this.applicationPresenter.getApplication().getParameter("gsl.showapplicationinapplet");
                inApplet = "DESKTOP".equalsIgnoreCase(presentation);
            }
            desktop = inApplet ? new MDIDesktopApplet(this.applicationPresenter) : new MDIDesktopFrame(this.applicationPresenter);
            this.addDesktop(desktop);
            this.desktopOwner = true;
        }
        return desktop;
    }

    private MDIDesktop lookupDesktop() {
        return (MDIDesktop)desktops.get(this.applicationPresenter.getController().getApplicationManager());
    }

    private void addDesktop(MDIDesktop desktop) {
        desktops.put(this.applicationPresenter.getController().getApplicationManager(), desktop);
    }

    private void removeDesktop() {
        desktops.remove(this.applicationPresenter.getController().getApplicationManager());
    }

    public void setView(AbstractView view) {
        this.viewContainerDelegate.setView(view);
    }

    public void setToolBar(ApplicationToolBar applicationToolBar) {
        this.viewContainerDelegate.setToolBar(applicationToolBar);
    }

    public void setMenuBar(ApplicationMenuBar applicationMenuBar) {
        this.viewContainerDelegate.setMenuBar(applicationMenuBar);
    }

    public Window getWindow() {
        return this.viewContainerDelegate.getWindow();
    }

    public Component getComponent() {
        return this.viewContainerDelegate.getComponent();
    }

    public Component getFocusOwner() {
        return this.viewContainerDelegate.getFocusOwner();
    }

    public void setTitle(String title) {
        this.viewContainerDelegate.setTitle(title);
    }

    public void setStatus(String status) {
        this.viewContainerDelegate.setStatus(status);
    }

    public void setVisible(boolean visible) {
        this.settingDelegatorVisible = true;
        this.viewContainerDelegate.setVisible(visible);
        if (this.desktopOwner) {
            if (visible) {
                this.getDesktop().setVisible(true);
            } else {
                this.getDesktop().setVisible(false);
                this.getDesktop().dispose();
                this.removeDesktop();
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.viewContainerDelegate.setEnabled(enabled);
    }

    public void bringToFront() {
        this.viewContainerDelegate.bringToFront();
    }

    public void setLocation(int x, int y) {
        this.viewContainerDelegate.setLocation(x, y);
    }

    public void setMaximized() {
        this.viewContainerDelegate.setMaximized();
    }

    public void setMinimized() {
        this.viewContainerDelegate.setMinimized();
    }

    public void setRestored() {
        this.viewContainerDelegate.setRestored();
    }

    public void setViewResizable(boolean resizable) {
        this.viewContainerDelegate.setViewResizable(resizable);
    }

    public void doValidate() {
        this.viewContainerDelegate.doValidate();
    }

    public void dispose() {
        this.viewContainerDelegate.dispose();
    }

    public void setHorizontalScrollBarPolicy(int policy) {
        this.viewContainerDelegate.setHorizontalScrollBarPolicy(policy);
    }

    public void setVerticalScrollBarPolicy(int policy) {
        this.viewContainerDelegate.setVerticalScrollBarPolicy(policy);
    }

    ViewContainer getViewContainerDelegate() {
        return this.viewContainerDelegate;
    }

    private static class MDIDesktopImpl
    extends JPanel
    implements MDIDesktop {
        private ApplicationPresenter applicationPresenter;
        private JPanel contentPanel;
        private JDesktopPane desktopPane;
        private JTabbedPane tabbedPane;
        private JPanel statusBar;
        private JLabel statusLabel;
        private TabSelectionChangeListener tabSelectionChangeListener;

        MDIDesktopImpl(ApplicationPresenter applicationPresenter) {
            this.applicationPresenter = applicationPresenter;
            this.setLayout(new BorderLayout());
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new BorderLayout());
            this.add((Component)this.contentPanel, "Center");
        }

        public void dispose() {
        }

        public Component getDesktopComponent() {
            return this;
        }

        public void setJMenuBar(JMenuBar menuBar) {
        }

        public void setJToolBar(JToolBar toolBar) {
        }

        public void addViewContainer(ViewContainer container) {
            if (container instanceof MDIViewContainer) {
                this.addMDIViewContainer(container);
            } else if (container instanceof TabbedViewContainer) {
                this.addTabbedViewContainer(this.applicationPresenter.getTitle(), container);
            }
        }

        public void removeViewContainer(ViewContainer container) {
            if (container instanceof MDIViewContainer) {
                this.removeMDIViewContainer(container);
            } else if (container instanceof TabbedViewContainer) {
                this.removeTabbedViewContainer(container);
            }
        }

        public JTabbedPane getTabbedPane() {
            if (this.tabbedPane == null) {
                this.tabbedPane = new JTabbedPane();
                this.contentPanel.add((Component)this.tabbedPane, "Center");
                this.tabbedPane.getModel().addChangeListener(new TabSelectionChangeListener());
            }
            return this.tabbedPane;
        }

        private void addMDIViewContainer(ViewContainer container) {
            this.getDesktopPane().add((Component)((Object)container));
        }

        private JDesktopPane getDesktopPane() {
            if (this.desktopPane == null) {
                this.desktopPane = new JDesktopPane();
                this.contentPanel.add((Component)this.desktopPane, "Center");
            }
            return this.desktopPane;
        }

        private void addTabbedViewContainer(String title, ViewContainer container) {
            this.getTabbedPane().add(title, (Component)((Object)container));
        }

        private void removeMDIViewContainer(ViewContainer container) {
            this.getDesktopPane().remove((Component)((Object)container));
            JInternalFrame[] frames = this.desktopPane.getAllFrames();
            if (frames.length > 0) {
                JInternalFrame nextFrame = frames[0];
                nextFrame.requestFocus();
                nextFrame.toFront();
                try {
                    nextFrame.setSelected(true);
                }
                catch (Throwable t) {
                    Log.logError("Could not deiconify frame", t);
                }
            }
            this.getDesktopPane().repaint();
        }

        private void removeTabbedViewContainer(ViewContainer container) {
            try {
                this.getTabbedPane().remove((Component)((Object)container));
                if (this.tabbedPane.getTabCount() > 0) {
                    this.tabbedPane.setSelectedIndex(0);
                }
            }
            catch (Throwable t) {
                Log.logError("Exception occurred when removing pane.", t);
            }
        }

        private class TabSelectionChangeListener
        implements ChangeListener {
            private TabSelectionChangeListener() {
            }

            public void stateChanged(ChangeEvent e) {
                int index = MDIDesktopImpl.this.tabbedPane.getModel().getSelectedIndex();
                if (index >= 0) {
                    TabbedViewContainer container = (TabbedViewContainer)MDIDesktopImpl.this.tabbedPane.getComponentAt(index);
                    container.setSelected();
                }
            }
        }
    }

    private static class MDIDesktopFrame
    extends JFrame
    implements MDIDesktop {
        private ApplicationPresenter applicationPresenter;
        private MDIDesktopImpl mdiDesktopImpl;
        private JToolBar toolBar;

        MDIDesktopFrame(ApplicationPresenter applicationPresenter) {
            this.applicationPresenter = applicationPresenter;
            this.getContentPane().setLayout(new BorderLayout());
            this.mdiDesktopImpl = new MDIDesktopImpl(applicationPresenter);
            this.getContentPane().add((Component)this.mdiDesktopImpl, "Center");
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WinAdapter());
        }

        private void centerOnScreen() {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
        }

        public Dimension getPreferredSize() {
            return new Dimension(800, 600);
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.pack();
                this.centerOnScreen();
            }
            super.setVisible(visible);
        }

        public Component getDesktopComponent() {
            return this;
        }

        public void setJMenuBar(JMenuBar menuBar) {
            super.setJMenuBar(menuBar);
        }

        public void setJToolBar(JToolBar toolBar) {
            if (this.toolBar != null) {
                this.getContentPane().remove(this.toolBar);
            }
            this.toolBar = toolBar;
            if (this.toolBar != null) {
                this.toolBar.setOrientation(0);
                this.getContentPane().add((Component)this.toolBar, "North");
                this.pack();
            }
        }

        public void addViewContainer(ViewContainer container) {
            this.mdiDesktopImpl.addViewContainer(container);
            if (container instanceof MDIViewContainer) {
                this.pack();
            }
        }

        public void removeViewContainer(ViewContainer container) {
            this.mdiDesktopImpl.removeViewContainer(container);
            if (container instanceof MDIViewContainer) {
                this.pack();
            }
        }

        public JTabbedPane getTabbedPane() {
            return this.mdiDesktopImpl.getTabbedPane();
        }

        private class WinAdapter
        extends WindowAdapter {
            private WinAdapter() {
            }

            public void windowClosing(WindowEvent e) {
                MDIDesktopFrame.this.applicationPresenter.getApplication().getApplicationManager().stopApplicationManager();
            }

            public void windowDeiconified(WindowEvent e) {
                int width = MDIDesktopFrame.this.getWidth();
                int height = MDIDesktopFrame.this.getHeight();
                MDIDesktopFrame.this.setSize(width + 1, height);
            }

            public void windowIconified(WindowEvent e) {
                int width = MDIDesktopFrame.this.getWidth();
                int height = MDIDesktopFrame.this.getHeight();
                MDIDesktopFrame.this.setSize(width - 1, height);
            }
        }
    }

    private static class MDIDesktopApplet
    implements MDIDesktop {
        private ApplicationPresenter applicationPresenter;
        private JApplet applet;
        private MDIDesktopImpl mdiDesktopImpl;
        private JToolBar toolBar;

        MDIDesktopApplet(ApplicationPresenter applicationPresenter) {
            this.applicationPresenter = applicationPresenter;
            this.applet = applicationPresenter.getApplication().getApplet();
            this.applet.getContentPane().setLayout(new BorderLayout());
            this.mdiDesktopImpl = new MDIDesktopImpl(applicationPresenter);
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.applet.getContentPane().add((Component)this.mdiDesktopImpl, "Center");
                this.pack();
            } else {
                this.applet.getContentPane().remove(this.mdiDesktopImpl);
            }
            this.applet.setVisible(visible);
        }

        public void dispose() {
        }

        public void setJMenuBar(JMenuBar menuBar) {
            this.applet.setJMenuBar(menuBar);
        }

        public void setJToolBar(JToolBar toolBar) {
            if (this.toolBar != null) {
                this.applet.getContentPane().remove(this.toolBar);
            }
            this.toolBar = toolBar;
            if (this.toolBar != null) {
                this.toolBar.setOrientation(0);
                this.applet.getContentPane().add((Component)this.toolBar, "North");
            }
        }

        public Component getDesktopComponent() {
            return this.mdiDesktopImpl.getDesktopComponent();
        }

        public void addViewContainer(ViewContainer container) {
            this.mdiDesktopImpl.addViewContainer(container);
            if (container instanceof MDIViewContainer) {
                this.pack();
            }
        }

        public void removeViewContainer(ViewContainer container) {
            this.mdiDesktopImpl.removeViewContainer(container);
            if (container instanceof MDIViewContainer) {
                this.pack();
            }
        }

        public JTabbedPane getTabbedPane() {
            return this.mdiDesktopImpl.getTabbedPane();
        }

        private void pack() {
            this.applet.validate();
            this.applet.repaint();
        }
    }

    private static interface MDIDesktop {
        public void setVisible(boolean var1);

        public void dispose();

        public Component getDesktopComponent();

        public void setJMenuBar(JMenuBar var1);

        public void setJToolBar(JToolBar var1);

        public void addViewContainer(ViewContainer var1);

        public void removeViewContainer(ViewContainer var1);

        public JTabbedPane getTabbedPane();
    }

    private class TabbedViewContainer
    extends JPanel
    implements ViewContainer {
        private ApplicationPresenter applicationPresenter;
        private JPanel contentPanel;
        private JPanel statusBar;
        private JLabel statusLabel;
        private Icon ericsson_icon = new ImageIcon();

        public TabbedViewContainer() {
            this.setLayout(new BorderLayout());
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new BorderLayout());
            this.add((Component)this.contentPanel, "Center");
        }

        public void init(AbstractPresenter presenter) {
            AbstractApplicationView view;
            this.applicationPresenter = (ApplicationPresenter)presenter;
            JComponent viewComp = view = (AbstractApplicationView)this.applicationPresenter.getView();
            if (view.isResizable()) {
                viewComp = new JScrollPane(view);
            }
            this.contentPanel.add((Component)viewComp, "Center");
            this.createStatusBar();
            this.contentPanel.add((Component)this.statusBar, "South");
            ApplicationViewContainerDelegator.this.getDesktop().addViewContainer(this);
        }

        public void setViewResizable(boolean resizable) {
        }

        private void createStatusBar() {
            String name = this.applicationPresenter.getApplication().getEnvironment().getProperty("se/ericsson/cello/support/gui/guilib/infra/resources/images/toolbaricons/approved_black_logo_grey_background.gif");
            this.statusLabel = new JLabel("", IconHelper.createIcon(name), 2);
            this.statusBar = new JPanel();
            this.statusBar.setLayout(new GridBagLayout());
            this.statusBar.setBorder(new BevelBorder(1));
            this.statusBar.add((Component)this.statusLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        public Window getWindow() {
            MDIDesktop desktop = ApplicationViewContainerDelegator.this.getDesktop();
            Window window = null;
            if (desktop instanceof Window) {
                window = (Window)((Object)desktop);
            }
            return window;
        }

        public void setView(AbstractView view) {
        }

        public void setToolBar(ApplicationToolBar applicationToolBar) {
        }

        public void setMenuBar(ApplicationMenuBar applicationMenuBar) {
        }

        public void setHorizontalScrollBarPolicy(int policy) {
        }

        public void setVerticalScrollBarPolicy(int policy) {
        }

        public Component getComponent() {
            return this;
        }

        public Component getFocusOwner() {
            return ComponentToolkit.getFocusOwner(this);
        }

        public void setTitle(String title) {
            JTabbedPane tabbedPane = ApplicationViewContainerDelegator.this.getDesktop().getTabbedPane();
            int index = tabbedPane.indexOfComponent(this);
            tabbedPane.setTitleAt(index, title);
        }

        public void setStatus(String status) {
            if (status == null || status.equals("")) {
                status = " ";
            }
            this.statusLabel.setText(status);
        }

        public void setVisible(boolean visible) {
            if (ApplicationViewContainerDelegator.this.settingDelegatorVisible) {
                ApplicationViewContainerDelegator.this.settingDelegatorVisible = false;
                if (!visible && ApplicationViewContainerDelegator.this.lookupDesktop() != null) {
                    ApplicationViewContainerDelegator.this.getDesktop().setJMenuBar(null);
                    ApplicationViewContainerDelegator.this.getDesktop().setJToolBar(null);
                    ApplicationViewContainerDelegator.this.getDesktop().removeViewContainer(this);
                }
            }
            super.setVisible(visible);
        }

        public void setEnabled(boolean enabled) {
            if (this.applicationPresenter.isDefaultEnabling()) {
                super.setEnabled(enabled);
            }
        }

        public void bringToFront() {
            ApplicationViewContainerDelegator.this.getDesktop().getTabbedPane().setSelectedComponent(this);
        }

        public void setLocation(int x, int y) {
        }

        public void setMaximized() {
        }

        public void setMinimized() {
        }

        public void setRestored() {
        }

        public void doValidate() {
            this.validate();
        }

        public void dispose() {
        }

        void setSelected() {
            if (ApplicationViewContainerDelegator.this.lookupDesktop() != null) {
                ApplicationViewContainerDelegator.this.getDesktop().setJMenuBar(this.applicationPresenter.getApplicationMenuBar());
                ApplicationViewContainerDelegator.this.getDesktop().setJToolBar(this.applicationPresenter.getApplicationToolBar());
            } else {
                Log.logWarning("Desktop null");
            }
        }
    }

    private class DesktopViewContainer
    extends MDIViewContainer {
        ApplicationMenuBar applicationMenuBar;
        ApplicationToolBar applicationToolbar;

        private DesktopViewContainer() {
        }

        public void init(AbstractPresenter presenter) {
            super.init(presenter);
            this.applicationMenuBar = this.applicationPresenter.getApplicationMenuBar();
            if (this.applicationMenuBar != null) {
                this.setJMenuBar(this.applicationMenuBar);
            }
            this.applicationToolbar = this.applicationPresenter.getApplicationToolBar();
            if (this.applicationToolbar != null) {
                this.getContentPane().add((Component)this.applicationToolbar, "North");
            }
        }
    }

    private class MDIViewContainer
    extends JInternalFrame
    implements ViewContainer {
        private boolean isConstructed = false;
        protected ApplicationPresenter applicationPresenter;
        protected JPanel contentPanel;
        private JPanel statusBar;
        private JLabel statusLabel;
        private InternalFrameAdapterImpl internalFrameListener;
        private ImageIcon ericsson_icon = new ImageIcon();

        public MDIViewContainer() {
            this.getContentPane().setLayout(new BorderLayout());
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.contentPanel, "Center");
            this.setClosable(true);
            this.setIconifiable(true);
            this.setMaximizable(true);
            this.setDefaultCloseOperation(0);
            this.internalFrameListener = new InternalFrameAdapterImpl();
            this.addInternalFrameListener(this.internalFrameListener);
            this.isConstructed = true;
        }

        public void init(AbstractPresenter presenter) {
            AbstractApplicationView view;
            String name = presenter.getApplication().getEnvironment().getProperty("se/ericsson/cello/support/gui/guilib/infra/resources/images/toolbaricons/approved_black_logo_grey_background.gif");
            this.ericsson_icon = (ImageIcon)IconHelper.createIcon(name);
            super.setFrameIcon(this.ericsson_icon);
            this.applicationPresenter = (ApplicationPresenter)presenter;
            JComponent viewComp = view = (AbstractApplicationView)this.applicationPresenter.getView();
            if (view.isResizable()) {
                viewComp = new JScrollPane(view);
            }
            this.contentPanel.add((Component)viewComp, "Center");
            this.createStatusBar();
            this.contentPanel.add((Component)this.statusBar, "South");
            this.setResizable(view.isResizable());
            ApplicationViewContainerDelegator.this.getDesktop().addViewContainer(this);
        }

        public void setViewResizable(boolean resizable) {
            this.setResizable(resizable);
        }

        private void createStatusBar() {
            this.statusLabel = new JLabel("", this.ericsson_icon, 2);
            this.statusBar = new JPanel();
            this.statusBar.setLayout(new GridBagLayout());
            this.statusBar.setBorder(new BevelBorder(1));
            this.statusBar.add((Component)this.statusLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        public void setClosed(boolean b) throws PropertyVetoException {
            this.applicationPresenter.getController().viewClosing();
        }

        public void setView(AbstractView view) {
        }

        public void setToolBar(ApplicationToolBar applicationToolBar) {
        }

        public void setMenuBar(ApplicationMenuBar applicationMenuBar) {
        }

        public void setHorizontalScrollBarPolicy(int policy) {
        }

        public void setVerticalScrollBarPolicy(int policy) {
        }

        public Window getWindow() {
            MDIDesktop desktop = ApplicationViewContainerDelegator.this.getDesktop();
            Window window = null;
            if (desktop instanceof Window) {
                window = (Window)((Object)desktop);
            }
            return window;
        }

        public Component getComponent() {
            return this;
        }

        public Component getFocusOwner() {
            return ComponentToolkit.getFocusOwner(this);
        }

        public void setTitle(String title) {
            super.setTitle(title);
        }

        public void setStatus(String status) {
            if (status == null || status.equals("")) {
                status = " ";
            }
            this.statusLabel.setText(status);
        }

        public void setVisible(boolean visible) {
            if (this.isConstructed) {
                try {
                    this.setSelected(visible);
                }
                catch (Throwable t) {
                    Log.logError("Could not set frame selected", t);
                }
                if (visible) {
                    this.requestFocus();
                    this.toFront();
                    this.setSize(this.getPreferredSize());
                } else {
                    this.removeInternalFrameListener(this.internalFrameListener);
                    if (ApplicationViewContainerDelegator.this.lookupDesktop() != null) {
                        ApplicationViewContainerDelegator.this.getDesktop().removeViewContainer(this);
                    } else {
                        Log.logWarning("Desktop null");
                    }
                }
            }
            super.setVisible(visible);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
        }

        public void bringToFront() {
            try {
                if (this.isIcon()) {
                    this.setIcon(false);
                }
                this.setSelected(true);
                this.requestFocus();
                this.toFront();
            }
            catch (Throwable t) {
                Log.logError("Could not deiconify frame", t);
            }
        }

        public void setLocation(int x, int y) {
            super.setLocation(x, y);
        }

        public void setMaximized() {
            try {
                this.setMaximum(true);
            }
            catch (Throwable t) {
                Log.logError("Could not maximize frame", t);
            }
        }

        public void setMinimized() {
            try {
                this.setIcon(true);
            }
            catch (Throwable t) {
                Log.logError("Could not minimize frame", t);
            }
        }

        public void setRestored() {
            try {
                if (this.isIcon()) {
                    this.setIcon(false);
                }
                if (this.isMaximum()) {
                    this.setMaximum(false);
                }
            }
            catch (Throwable t) {
                Log.logError("Could not restore frame", t);
            }
        }

        public void doValidate() {
            this.validate();
        }

        private void centerOnScreen() {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
        }

        private class InternalFrameAdapterImpl
        extends InternalFrameAdapter {
            private InternalFrameAdapterImpl() {
            }

            public void internalFrameActivated(InternalFrameEvent e) {
                if (!(MDIViewContainer.this instanceof DesktopViewContainer)) {
                    if (ApplicationViewContainerDelegator.this.lookupDesktop() != null) {
                        ApplicationViewContainerDelegator.this.getDesktop().setJMenuBar(MDIViewContainer.this.applicationPresenter.getApplicationMenuBar());
                        ApplicationViewContainerDelegator.this.getDesktop().setJToolBar(MDIViewContainer.this.applicationPresenter.getApplicationToolBar());
                    } else {
                        Log.logWarning("Desktop null");
                    }
                }
            }

            public void internalFrameDeactivated(InternalFrameEvent e) {
                if (!(MDIViewContainer.this instanceof DesktopViewContainer) && ApplicationViewContainerDelegator.this.lookupDesktop() != null) {
                    ApplicationViewContainerDelegator.this.getDesktop().setJMenuBar(null);
                    ApplicationViewContainerDelegator.this.getDesktop().setJToolBar(null);
                }
            }

            public void internalFrameClosing(InternalFrameEvent e) {
                try {
                    MDIViewContainer.this.setClosed(true);
                }
                catch (Throwable t) {
                    String msg = "Could not set internal frame closed";
                    Log.logError(msg, t);
                    Log.assertion(false, msg);
                }
            }
        }
    }
}

