/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.gui.guilib.infra;

import java.util.Locale;
import javax.swing.JComponent;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.gui.guilib.infra.AbstractHandler;
import se.ericsson.cello.support.gui.guilib.infra.AbstractHelp;
import se.ericsson.cello.support.gui.guilib.infra.Resources;

class HelpManager
extends AbstractHandler {
    static final String DEFAULT_HELP_BUNDLE_NAME_KEY = "gsl.help.default.bundle.name";
    public static final String HELP_TRACKING = "HELP_TRACKING";
    static final String HELP_HANDLER_CLASS_KEY = "gsl.help.helphandler.class";
    private AbstractHelp helpHandler;

    HelpManager() {
    }

    AbstractHelp getHelpHandler() {
        return this.helpHandler;
    }

    public void dispose() {
        if (this.helpHandler != null) {
            this.helpHandler.dispose();
        }
    }

    public boolean handleComponent(JComponent comp) {
        Log.trace("HelpManager.handleComponent(" + comp.getClass().getName() + ")");
        if (this.helpHandler != null) {
            Object helpHandle = comp.getClientProperty("HELP_KEY");
            if (helpHandle != null) {
                if (helpHandle.equals("NA")) {
                    return false;
                }
                if (!helpHandle.equals("NT")) {
                    this.helpHandler.handleComponent(comp);
                }
            }
            return true;
        }
        Log.logNotify("No further sub-component help-handling for component: " + comp.getClass().getName());
        return false;
    }

    public void init() {
        Resources resourceComp = this.getResources();
        String className = null;
        try {
            className = resourceComp.getEnvironment().getProperty(HELP_HANDLER_CLASS_KEY);
            if (className == null) {
                className = this.getApplication().getApplicationManager().getFirstInitialApplication().getEnvironment().getProperty(HELP_HANDLER_CLASS_KEY);
            }
            Log.log(4, "helphandler className = " + className);
            if (className != null && !"null".equalsIgnoreCase(className)) {
                this.helpHandler = (AbstractHelp)Class.forName(className).newInstance();
                this.helpHandler.init(this.presenter);
            }
        }
        catch (Exception e) {
            String msg = "Could not create help handler class: " + className;
            Log.logError(msg, e);
            Log.assertion(false, msg);
        }
    }

    public void updateLocale(Locale locale) {
        if (this.helpHandler != null) {
            this.helpHandler.updateHelp(locale);
        }
    }
}

