/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import se.ericsson.cello.support.logging.Handler;
import se.ericsson.cello.support.logging.Level;
import se.ericsson.cello.support.logging.LogManager;
import se.ericsson.cello.support.logging.LogRecord;
import se.ericsson.cello.support.logging.SimpleFormatter;

public class MemoryHandler
extends Handler {
    private Level pushLevel;
    private int size;
    private Handler target;
    private LogRecord[] buffer;
    int start;
    int count;

    private void configure() {
        LogManager manager = LogManager.getLogManager();
        String cname = MemoryHandler.class.getName();
        this.pushLevel = manager.getLevelProperty(cname + ".push", Level.SEVERE);
        this.size = manager.getIntProperty(cname + ".size", 1000);
        this.setLevel(manager.getLevelProperty(cname + ".level", Level.ALL));
        this.setFilter(manager.getFilterProperty(cname + ".filter", null));
        this.setFormatter(manager.getFormatterProperty(cname + ".formatter", new SimpleFormatter()));
    }

    public MemoryHandler() {
        this.sealed = false;
        this.configure();
        this.sealed = true;
        String name = "???";
        try {
            LogManager manager = LogManager.getLogManager();
            name = manager.getProperty("se.ericsson.cello.support.logging.MemoryHandler.target");
            Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(name);
            this.target = (Handler)clz.newInstance();
        }
        catch (Exception ex) {
            System.err.println("MemoryHandler can't load handler \"" + name + "\"");
            System.err.println("" + ex);
            throw new RuntimeException("Can't load " + name);
        }
        this.init();
    }

    private void init() {
        this.buffer = new LogRecord[this.size];
        this.start = 0;
        this.count = 0;
    }

    public MemoryHandler(Handler target, int size, Level pushLevel) {
        if (target == null || pushLevel == null) {
            throw new NullPointerException();
        }
        this.sealed = false;
        this.configure();
        this.sealed = true;
        this.target = target;
        this.pushLevel = pushLevel;
        this.size = size;
        this.init();
    }

    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        int ix = (this.start + this.count) % this.buffer.length;
        this.buffer[ix] = record;
        if (this.count < this.buffer.length) {
            ++this.count;
        } else {
            ++this.start;
        }
        if (record.getLevel().intValue() >= this.pushLevel.intValue()) {
            this.push();
        }
    }

    public synchronized void push() {
        for (int i = 0; i < this.count; ++i) {
            int ix = (this.start + i) % this.buffer.length;
            LogRecord record = this.buffer[ix];
            this.target.publish(record);
        }
        this.start = 0;
        this.count = 0;
    }

    public void flush() {
        this.target.flush();
    }

    public void close() throws SecurityException {
        this.target.close();
        this.setLevel(Level.OFF);
    }

    public void setPushLevel(Level newLevel) throws SecurityException {
        if (newLevel == null) {
            throw new NullPointerException();
        }
        LogManager manager = LogManager.getLogManager();
        this.checkAccess();
        this.pushLevel = newLevel;
    }

    public synchronized Level getPushLevel() {
        return this.pushLevel;
    }

    public boolean isLoggable(LogRecord record) {
        return super.isLoggable(record);
    }
}

