/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.logging;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import se.ericsson.cello.support.logging.Formatter;
import se.ericsson.cello.support.logging.Handler;
import se.ericsson.cello.support.logging.Level;
import se.ericsson.cello.support.logging.LogManager;
import se.ericsson.cello.support.logging.LogRecord;
import se.ericsson.cello.support.logging.SimpleFormatter;

public class StreamHandler
extends Handler {
    private OutputStream output;
    private boolean doneHeader;
    private Writer writer;

    private void configure() {
        LogManager manager = LogManager.getLogManager();
        String cname = StreamHandler.class.getName();
        this.setLevel(manager.getLevelProperty(cname + ".level", Level.INFO));
        this.setFilter(manager.getFilterProperty(cname + ".filter", null));
        this.setFormatter(manager.getFormatterProperty(cname + ".formatter", new SimpleFormatter()));
        try {
            this.setEncoding(manager.getStringProperty(cname + ".encoding", null));
        }
        catch (Exception ex) {
            try {
                this.setEncoding(null);
            }
            catch (Exception ex2) {
                // empty catch block
            }
        }
    }

    public StreamHandler() {
        this.sealed = false;
        this.configure();
        this.sealed = true;
    }

    public StreamHandler(OutputStream out, Formatter formatter) {
        this.sealed = false;
        this.configure();
        this.setFormatter(formatter);
        this.setOutputStream(out);
        this.sealed = true;
    }

    protected synchronized void setOutputStream(OutputStream out) throws SecurityException {
        if (out == null) {
            throw new NullPointerException();
        }
        this.flushAndClose();
        this.output = out;
        this.doneHeader = false;
        String encoding = this.getEncoding();
        if (encoding == null) {
            this.writer = new OutputStreamWriter(this.output);
        } else {
            try {
                this.writer = new OutputStreamWriter(this.output, encoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new Error("Unexpected exception " + ex);
            }
        }
    }

    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(encoding);
        if (this.output == null) {
            return;
        }
        this.flush();
        this.writer = encoding == null ? new OutputStreamWriter(this.output) : new OutputStreamWriter(this.output, encoding);
    }

    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        String msg = this.getFormatter().format(record);
        try {
            if (!this.doneHeader) {
                this.writer.write(this.getFormatter().getHead(this));
                this.doneHeader = true;
            }
            this.writer.write(msg);
        }
        catch (Exception ex) {
            this.setException(ex);
        }
    }

    public boolean isLoggable(LogRecord record) {
        if (this.writer == null) {
            return false;
        }
        return super.isLoggable(record);
    }

    public synchronized void flush() {
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (Exception ex) {
                this.setException(ex);
            }
        }
    }

    private synchronized void flushAndClose() throws SecurityException {
        this.checkAccess();
        if (this.writer != null) {
            try {
                if (!this.doneHeader) {
                    this.writer.write(this.getFormatter().getHead(this));
                    this.doneHeader = true;
                }
                this.writer.write(this.getFormatter().getTail(this));
                this.writer.flush();
                this.writer.close();
            }
            catch (Exception ex) {
                this.setException(ex);
            }
            this.writer = null;
            this.output = null;
        }
    }

    public synchronized void close() throws SecurityException {
        this.flushAndClose();
    }
}

