/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.mgr;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import se.ericsson.cello.support.gui.AbstractViewElement;
import se.ericsson.cello.support.gui.EmasGuilibMediator;
import se.ericsson.cello.support.gui.EmasProperties;
import se.ericsson.cello.support.gui.MainWindowController;
import se.ericsson.cello.support.gui.guilib.comp.IconHelper;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.mgr.EmasViewElementCreator;
import se.ericsson.cello.support.mgr.EmasViewElementInterface;
import se.ericsson.cello.support.mgr.MOComposite;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;
import se.ericsson.cello.support.proxy.NameValue;

public class EmasViewElement
extends AbstractViewElement
implements MOProxy.MOListener,
EmasViewElementInterface {
    protected String tag;
    protected Vector myActions = new Vector();
    protected Properties properties;
    protected MOComposite moc;
    protected EmasViewElementCreator creator;
    protected ImageIcon icon;
    protected boolean invalidIcon = false;
    protected String elementprefix;

    public EmasViewElement(MOComposite moc, Properties p, EmasViewElementCreator creator) {
        super(EmasProperties.getEMProperty(p, "tag"), creator);
        this.properties = p;
        this.elementprefix = EmasProperties.getEMProperty(this.properties, "elementprefix");
        this.tag = EmasProperties.getEMProperty(this.properties, "tag");
        String leafvalue = EmasProperties.getEMProperty(this.properties, "leaf");
        if (leafvalue != null && leafvalue.equals("yes")) {
            this.childrenAreNotAllowed();
        }
        this.properties = this.properties;
        this.creator = creator;
        this.tag = this.getAssertedProperty("tag");
        this.moc = moc;
        if (MainWindowController.PROPS_DEBUG) {
            System.out.println("______________________________" + (EmasProperties.isExtended(this.properties, "tag") ? "EXT.tag = " : "tag = ") + this.tag);
        }
        this.setActions();
        MOProxy[] molist = moc.getAllMOs();
        String[] result = new String[molist.length];
        Vector ldnlist = new Vector(molist.length);
        for (int i = 0; i < molist.length; ++i) {
            result[i] = molist[i].getDN();
        }
        this.setIndexKeys(result);
    }

    public Action[] getActions() {
        return this.myActions.toArray(new Action[0]);
    }

    public Action getAction(String name) {
        Iterator i = this.myActions.iterator();
        Action action = null;
        while (i.hasNext()) {
            Action currentAction = (Action)i.next();
            String actionName = (String)currentAction.getValue("Name");
            if (!actionName.equals(name)) continue;
            action = currentAction;
            break;
        }
        return action;
    }

    private void setActions() {
        this.myActions = new Vector();
        String actions = EmasProperties.getEMProperty(this.properties, "actions");
        if (MainWindowController.PROPS_DEBUG) {
            System.out.println("______________________________" + (EmasProperties.isExtended(this.properties, "actions") ? "EXT.actions = " : "actions = ") + actions);
        }
        if (actions == null || actions.equalsIgnoreCase("null")) {
            return;
        }
        StringTokenizer st = new StringTokenizer(actions, ",");
        while (st.hasMoreTokens()) {
            this.addAction(st.nextToken());
        }
    }

    private void addAction(String name) {
        String className = EmasProperties.getEMProperty(this.properties, "action." + name + ".class");
        if (className == null || className.equals("") || className.equalsIgnoreCase("null")) {
            Log.logNotify("Empty Class for Action " + name + ")");
            return;
        }
        if (MainWindowController.PROPS_DEBUG) {
            System.out.println("______________________________" + (EmasProperties.isExtended(this.properties, "action." + name + ".class") ? "EXT.action." + name + ".class = " : "action." + name + ".class = ") + className);
        }
        try {
            Object[] param = new Object[]{"action." + name, this};
            Class<?> c = Class.forName(className);
            Constructor<?> constructor = c.getConstructor(String.class, EmasViewElementInterface.class);
            AbstractAction action = (AbstractAction)constructor.newInstance(param);
            this.myActions.add(action);
        }
        catch (ClassNotFoundException e) {
            Log.logError("Class " + className + "not found for Action " + name + ")", e);
        }
        catch (NoSuchMethodException e) {
            Log.logError("Missing constructor in class" + className + " for Action " + name + ")", e);
        }
        catch (InvocationTargetException e) {
            Log.logError("Exception thrown in constructor of action " + name + " (" + className + ")", e);
        }
        catch (InstantiationException e) {
            Log.logError("Action " + name + "(" + className + ") cannot be instantiated (abstract class)", e);
        }
        catch (IllegalAccessException e) {
            Log.logError("Constructor inaccessible in class" + className + " for Action " + name + ")", e);
        }
    }

    public ImageIcon getIcon() {
        if (this.icon == null && !this.invalidIcon) {
            String fileName = EmasProperties.getEMProperty(this.properties, "icon");
            if (MainWindowController.PROPS_DEBUG) {
                String iconKey = EmasProperties.isExtended(this.properties, "icon") ? "EXT.icon = " : "icon = ";
                System.out.println("______________________________" + iconKey + fileName);
            }
            try {
                this.icon = (ImageIcon)IconHelper.createIcon(fileName);
            }
            catch (RuntimeException e) {
                Log.logError("Cannot create ImageIcon from file=" + fileName, e);
                this.invalidIcon = true;
            }
        }
        return this.icon;
    }

    public String getName() {
        return this.translate(this.tag);
    }

    public String getType() {
        return this.tag;
    }

    public String getDetailText() {
        String detailText;
        Log.logNotify("Inside EmasViewElement getDetailText()");
        String txt = EmasProperties.getEMProperty(this.properties, "detailText");
        if (txt == null) {
            Object[] param = new Object[]{this.getName()};
            MainWindowController mainWindowController = EmasGuilibMediator.getReference().getMainWindowReference();
            detailText = mainWindowController.getString("DETAIL_TXT", param);
        } else {
            detailText = this.translate(txt);
        }
        return detailText;
    }

    public Object[] getAllRelevantMOs() {
        return this.moc.getAllMOs();
    }

    public String getReservedByTypes() {
        String wantedString = EmasProperties.getEMProperty(this.properties, "reservedByTypes");
        if (wantedString != null) {
            return wantedString;
        }
        return "";
    }

    public void refresh() {
        Log.trace("REFRESH ELEMENT" + this.tag);
    }

    public boolean refreshButtonNeeded() {
        String wantedString = EmasProperties.getEMProperty(this.properties, "refreshTableButton");
        return wantedString == null || !wantedString.equals("no");
    }

    public MOProxy getMO(String type) {
        return this.moc.getMO(type);
    }

    public MOComposite getMOC() {
        return this.moc;
    }

    public String getDN() {
        if (this.moc.isEmpty()) {
            return "";
        }
        return this.moc.getLastMO().getDN();
    }

    public String getRDN() {
        String dn = this.getDN();
        if (0 == dn.length()) {
            return "";
        }
        int comma = dn.lastIndexOf(44);
        if (dn.length() > ++comma) {
            return dn.substring(comma);
        }
        return "";
    }

    public MOProxy getLastMO() {
        return this.moc.getLastMO();
    }

    public Object getAttributeValue(String aName) {
        String value = null;
        if (aName.equals("VIEWELEMENT_TYPE") && ((value = EmasProperties.getEMProperty(this.properties, "tag")) == null || value.equalsIgnoreCase("null"))) {
            value = null;
        }
        return value;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public boolean showReservedBy() {
        String wantedString = EmasProperties.getEMProperty(this.properties, "showReservedBy");
        return wantedString == null || !wantedString.equals("no");
    }

    public void childDeleted(MOProxy child) {
        if (this.moc.contains(child)) {
            MOProxy newChild = this.moc.getFirstMO();
            AbstractViewElement parent = this.getParent();
            if (parent == null) {
                this.creator.deleteElement(this);
            } else if (newChild == null) {
                this.creator.deleteElement(this);
                parent.removeChild(this);
            } else {
                boolean newChildExists = false;
                try {
                    newChildExists = newChild.isExisting();
                }
                catch (CSException ce) {
                    // empty catch block
                }
                if (newChildExists) {
                    EmasViewElementInterface newElement = this.creator.createElement(newChild);
                    if (this.creator.replaceElement(this, newElement)) {
                        parent.replaceChild(this, (AbstractViewElement)((Object)newElement));
                    } else {
                        parent.removeChild(this);
                    }
                }
            }
        }
    }

    public void childCreated(MOProxy child) {
        EmasViewElementInterface newElement = this.creator.createElement(this.moc.getFirstMO());
        if (newElement == null) {
            this.creator.deleteElement(this);
        } else if (!newElement.getType().equals(this.getType())) {
            AbstractViewElement parentElement = this.getParent();
            if (this.creator.replaceElement(this, newElement)) {
                parentElement.replaceChild(this, (AbstractViewElement)((Object)newElement));
            } else {
                parentElement.removeChild(this);
            }
        }
    }

    public void attributesChanged(MOProxy mo, NameValue[] nameValue) {
        String type = mo.getType();
        NameValue[] nameValueWithPrefix = new NameValue[nameValue.length];
        for (int i = 0; i < nameValue.length; ++i) {
            nameValueWithPrefix[i] = new NameValue(type + "." + nameValue[i].name, nameValue[i].value);
        }
        this.attributesChanged(nameValueWithPrefix);
    }

    public void attributesChanged(NameValue[] nameValue) {
    }

    private String getAssertedProperty(String key) {
        String value = this.properties.getProperty(key);
        if (value == null) {
            Log.logError("Property " + key + " not found!");
        }
        return value;
    }

    protected void removeNotify() {
        if (this.creator != null) {
            this.creator.deleteElement(this);
        }
        this.icon = null;
        super.removeNotify();
        Log.logNotify("                            Super's removeNotify called");
    }
}

