/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.support.mgr;

import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.support.gui.guilib.comp.Log;
import se.ericsson.cello.support.proxy.CSException;
import se.ericsson.cello.support.proxy.MOProxy;

public class MOComposite {
    private Vector moVector;

    public MOComposite() {
        this.moVector = new Vector();
    }

    public MOComposite(MOProxy[] moArray) {
        for (int i = 0; i < moArray.length; ++i) {
            this.add(moArray[i]);
        }
    }

    public void add(MOProxy mo) {
        this.moVector.add(mo);
    }

    public MOProxy getFirstMO() {
        return (MOProxy)this.moVector.firstElement();
    }

    public MOProxy getLastMO() {
        if (this.moVector.isEmpty()) {
            return null;
        }
        return (MOProxy)this.moVector.lastElement();
    }

    public MOProxy getMO(String type) {
        for (MOProxy mo : this.moVector) {
            if (!mo.getType().equals(type)) continue;
            return mo;
        }
        return null;
    }

    public String toString() {
        return this.moVector.toString();
    }

    public MOProxy[] getAllMOs() {
        return this.moVector.toArray(new MOProxy[0]);
    }

    public Object getAttribute(String mocAttribute) {
        Object value = null;
        if (mocAttribute.indexOf(".") > 0) {
            String type = mocAttribute.substring(0, mocAttribute.indexOf("."));
            String attribute = mocAttribute.substring(mocAttribute.indexOf(".") + 1);
            try {
                value = this.getMO(type).getAttribute(attribute);
            }
            catch (CSException e) {
                Log.trace("Error getting attribute " + mocAttribute);
            }
        } else {
            value = this.getMO(mocAttribute);
        }
        return value;
    }

    public boolean isEmpty() {
        return this.moVector.isEmpty();
    }

    public Iterator iterator() {
        return this.moVector.iterator();
    }

    public boolean contains(MOProxy mo) {
        Iterator i = this.moVector.iterator();
        while (i.hasNext()) {
            if (!mo.equals(i.next())) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.moVector.clear();
    }
}

