/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.login.creds;

import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Properties;
import se.ericsson.security.login.codec.CodecException;
import se.ericsson.security.login.codec.CodecFactory;
import se.ericsson.security.login.creds.CredentialsEncodingException;
import se.ericsson.security.login.creds.CredentialsException;

public class Credentials {
    private Properties properties;
    private Certificate[] trustedCertificates;
    private PrivateKey privateKey;
    private Certificate[] certificateChain;

    void setProperties(Properties properties) {
        this.properties = properties;
    }

    void setTrustedCertificates(Certificate[] certificateArray) {
        this.trustedCertificates = certificateArray;
    }

    void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    void setCertificateChain(Certificate[] certificateArray) {
        this.certificateChain = certificateArray;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public Certificate[] getCertificateChain() {
        return this.certificateChain;
    }

    public Certificate[] getTrustedCertificates() {
        return this.trustedCertificates;
    }

    public byte[] getEncoded() throws CredentialsEncodingException {
        return this.getEncoded(null);
    }

    public byte[] getEncoded(char[] cArray) throws CredentialsEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml ");
        stringBuffer.append("version=\"1.0\" ");
        stringBuffer.append("encoding=\"UTF-8\" ");
        stringBuffer.append("standalone=\"yes\"?>\n");
        stringBuffer.append("<slscredentials>\n");
        try {
            Object[] objectArray;
            CodecFactory codecFactory = CodecFactory.getInstance("PKCS#8");
            stringBuffer.append("\n<privatekey>\n");
            if (cArray != null) {
                objectArray = codecFactory.encodeAndEncrypt(this.getPrivateKey(), cArray);
                stringBuffer.append(new String((byte[])objectArray, "UTF-8"));
            } else {
                objectArray = codecFactory.encode(this.getPrivateKey());
                stringBuffer.append(new String((byte[])objectArray, "UTF-8"));
            }
            stringBuffer.append("\n</privatekey>\n");
            stringBuffer.append("\n<certificatechain>\n");
            objectArray = this.getCertificateChain();
            CodecFactory codecFactory2 = CodecFactory.getInstance("X509");
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append("<certificate>\n");
                stringBuffer.append(codecFactory2.encodeAsString(objectArray[i]));
                stringBuffer.append("\n</certificate>\n");
            }
            stringBuffer.append("</certificatechain>\n");
            stringBuffer.append("\n<trustedcertificates>\n");
            Certificate[] certificateArray = this.getTrustedCertificates();
            if (certificateArray != null) {
                for (int i = 0; i < certificateArray.length; ++i) {
                    stringBuffer.append("<certificate>\n");
                    stringBuffer.append(codecFactory2.encodeAsString(certificateArray[i]));
                    stringBuffer.append("\n</certificate>\n");
                }
            }
            stringBuffer.append("</trustedcertificates>\n");
            stringBuffer.append("\n<properties>\n");
            Properties properties = this.getProperties();
            if (properties != null) {
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append("<property name=\"");
                    String string = (String)enumeration.nextElement();
                    stringBuffer.append(string);
                    stringBuffer.append("\" value=\"");
                    stringBuffer.append(properties.getProperty(string, ""));
                    stringBuffer.append("\" />\n");
                }
            }
            stringBuffer.append("</properties>\n");
            stringBuffer.append("</slscredentials>\n");
            return stringBuffer.toString().getBytes("UTF-8");
        }
        catch (CodecException codecException) {
            throw new CredentialsEncodingException(codecException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CredentialsEncodingException(unsupportedEncodingException);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Credentials)) {
            return false;
        }
        try {
            byte[] byArray = this.getEncoded();
            byte[] byArray2 = ((Credentials)object).getEncoded();
            if (byArray.length != byArray2.length) {
                return false;
            }
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return false;
            }
            return true;
        }
        catch (CredentialsException credentialsException) {
            return false;
        }
    }

    public int hashCode() {
        int n = 0;
        try {
            byte[] byArray = this.getEncoded();
            for (int i = 1; i < byArray.length; ++i) {
                n += byArray[i] * i;
            }
            return n;
        }
        catch (CredentialsException credentialsException) {
            return n;
        }
    }
}

