/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.login.login;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.security.auth.login.LoginException;
import se.ericsson.security.login.Log;
import se.ericsson.security.login.creds.Credentials;
import se.ericsson.security.login.creds.CredentialsException;
import se.ericsson.security.login.creds.CredentialsFactory;
import se.ericsson.security.login.login.LoginCauseException;
import se.ericsson.security.login.login.LoginProxy;

final class FileProxy
implements LoginProxy {
    private final File file;
    private final String credentialsType;
    private Credentials credentials = null;

    FileProxy(File file, String string) {
        this.file = file;
        this.credentialsType = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean authenticateUser(String string, char[] cArray) throws LoginException {
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(this.file);
                CredentialsFactory credentialsFactory = CredentialsFactory.getInstance(this.credentialsType);
                this.credentials = credentialsFactory.generateCredentials(fileInputStream, cArray);
            }
            catch (IOException iOException) {
                Log.getInstance().error("Failed to read authentication data", iOException);
                throw new LoginCauseException("Failed to read authentication data", iOException);
            }
            catch (CredentialsException credentialsException) {
                Log.getInstance().error("Failed to parse credentials");
                Log.getInstance().debug("Failed to parse credentials", credentialsException);
                throw new LoginCauseException("Failed to parse credentials", credentialsException);
            }
            Object var6_7 = null;
            if (fileInputStream == null) return true;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (fileInputStream == null) throw throwable;
            try {
                try {
                    fileInputStream.close();
                    fileInputStream = null;
                    throw throwable;
                }
                catch (IOException iOException) {
                    Log.getInstance().error("Failed to close FileInputStream " + this.file, iOException);
                    throw throwable;
                }
            }
            finally {
                fileInputStream = null;
            }
        }
        try {}
        catch (Throwable throwable) {
            fileInputStream = null;
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            Log.getInstance().error("Failed to close FileInputStream " + this.file, iOException);
            return true;
        }
        fileInputStream.close();
        return true;
    }

    public Credentials getCredentials() throws LoginException {
        return this.credentials;
    }

    public void shutDown() {
        this.credentials = null;
    }
}

