/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.sls;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;

public class UserCredentials
implements Serializable {
    byte[] privateKey;
    byte[] userCertificate;
    byte[] slsCertificate;
    byte[] rootCertificate;
    String keyAlgorithm;

    public UserCredentials(PrivateKey privateKey, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.keyAlgorithm = privateKey.getAlgorithm();
        this.privateKey = privateKey.getEncoded();
        this.userCertificate = byArray;
        this.slsCertificate = byArray2;
        this.rootCertificate = byArray3;
    }

    public X509Certificate getCertificate() throws CertificateException {
        CertificateFactory certificateFactory = null;
        certificateFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.userCertificate);
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        return x509Certificate;
    }

    public X509Certificate getSLSCertificate() throws CertificateException {
        CertificateFactory certificateFactory = null;
        certificateFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.slsCertificate);
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        return x509Certificate;
    }

    public X509Certificate getRootCertificate() throws CertificateException {
        CertificateFactory certificateFactory = null;
        certificateFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.rootCertificate);
        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        return x509Certificate;
    }

    public PrivateKey getPrivateKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(this.keyAlgorithm);
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(this.privateKey);
        return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
    }

    public X509Certificate[] getCertificateChain() throws CertificateException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate[] x509CertificateArray = new X509Certificate[3];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.userCertificate);
        x509CertificateArray[0] = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(this.slsCertificate);
        x509CertificateArray[1] = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream2);
        ByteArrayInputStream byteArrayInputStream3 = new ByteArrayInputStream(this.rootCertificate);
        x509CertificateArray[2] = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream3);
        return x509CertificateArray;
    }
}

