/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.atm.aal2;

import java.util.ArrayList;
import java.util.Map;
import se.ericsson.cello.atm.aal2.Aal2ApMoImpl;
import se.ericsson.cello.atm.aal2.Aal2PathDistributionUnitMo;
import se.ericsson.cello.atm.aal2.Aal2PathIdNotUniqueException;
import se.ericsson.cello.atm.aal2.Aal2PathVccTpMoImpl;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConcurrentTransactionHandler;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.InvalidReferenceException;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.mao.TransactionHandler;
import se.ericsson.cello.mao.TransactionalFroIdMap;
import se.ericsson.cello.maofro.framework.ArrayParameter;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.Parameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.maofro.framework.UnsignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoCanNotBeCreatedException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.swmanagement.Aal2PduReservingRpu;
import se.ericsson.cello.swmanagement.ReliableProgramUniterMo;
import se.ericsson.cello.swmanagement.ReliableProgramUniterMoInternal;
import se.ericsson.cello.swmanagement.ReliableProgramUniterRepository;
import se.ericsson.cello.transaction.Coordinator;

public class Aal2PathDistributionUnitMoImpl
extends CelloMao
implements Aal2PathDistributionUnitMo,
Aal2PduReservingRpu,
FroInfo {
    private MoData data;
    private FroProxy aal2PduProxy = null;
    private static TransactionalFroIdMap froIdTable = new TransactionalFroIdMap((TransactionHandler)new ConcurrentTransactionHandler());
    private static final int MO_DATA_REVISION_6_0 = 6000;
    private static final int MO_DATA_REVISION_LATEST = 6000;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$se$ericsson$cello$swmanagement$ReliableProgramUniterRepository;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"Aal2Ap");
        MoAttributeValidator.checkIdentity((String)"Aal2PathDistributionUnit", (String)string);
        if (!((Aal2ApMoImpl)managedObject).checkAal2PathDistributionUnit()) {
            throw new MaxNumberExceededException("Max number of Aal2PathDistributionUnits is exceeded", "Aal2PathDistributionUnit");
        }
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"Aal2PathDistributionUnit", (int)128, (int)0);
        Class[] classArray = new Class[]{ReliableProgramUniterMo.class};
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"rpuId", (AttrList)attrList, (boolean)false, (Class[])classArray, (String)"Aal2PathDistributionUnit");
        if (managedObject3 != null) {
            Aal2PathDistributionUnitMoImpl.checkRpu(managedObject3, coordinator);
        }
        ManagedObject[] managedObjectArray = Aal2PathDistributionUnitMoImpl.checkAndGetAal2PathVccTpList(attrList, coordinator);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"Aal2PathDistributionUnit");
        return new Aal2PathDistributionUnitMoImpl(managedObject, string, string2, managedObject3, managedObjectArray, coordinator, initialMaoContext, froProxy);
    }

    private Aal2PathDistributionUnitMoImpl(ManagedObject managedObject, String string, String string2, ManagedObject managedObject2, ManagedObject[] managedObjectArray, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoAccessException {
        super(managedObject, "Aal2PathDistributionUnit", string, coordinator, initialMaoContext);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.aal2PduProxy = froProxy;
        this.data.setRevision(6000);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (managedObjectArray != null) {
            for (int i = 0; i < managedObjectArray.length; ++i) {
                ((Aal2PathVccTpMoImpl)managedObjectArray[i]).reserve(this, coordinator);
            }
            ArrayParameter arrayParameter = this.makeStructArrayParameter(managedObjectArray, coordinator);
            arrayList.add(arrayParameter);
        }
        int n = 0;
        if (managedObject2 != null) {
            n = (int)((ReliableProgramUniterMoInternal)managedObject2).getRpuId(coordinator);
            arrayList.add(new UnsignedIntParameter("rpuId", (long)n));
        }
        int n2 = ((Aal2ApMoImpl)managedObject).getFroId(coordinator);
        arrayList.add(new UnsignedIntParameter("aal2ApFroId", (long)n2));
        FroData froData = this.aal2PduProxy.create(coordinator, arrayList);
        int n3 = froData.getFroId();
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n3));
        froIdTable.put(n3, (ManagedObject)this, coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ((Aal2ApMoImpl)this.getParent()).dependentAttributeValueChange(coordinator);
    }

    public Aal2PathDistributionUnitMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.aal2PduProxy = froProxy;
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(6000);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("froId");
        froIdTable.put(((IntegerAttribute)this.data.getAttribute("froId")).getValue(null), (ManagedObject)this);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ManagedObject[] managedObjectArray = (ManagedObject[])this.getAttribute("aal2PathVccTpList", coordinator);
        if (managedObjectArray != null && managedObjectArray.length > 0) {
            this.actionRemovePath(managedObjectArray, coordinator);
        }
        this.aal2PduProxy.delete(coordinator, this.getFroId(coordinator), null);
        froIdTable.remove(this.getFroId(coordinator), coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
        ((Aal2ApMoImpl)this.getParent()).dependentAttributeValueChange(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public void actionAddPath(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException, InvalidReferenceException, Aal2PathIdNotUniqueException {
        this.addPath(managedObjectArray, coordinator);
        ((Aal2ApMoImpl)this.getParent()).dependentAttributeValueChange(coordinator);
        this.sendNotification("aal2PathVccTpList", this.getAttribute("aal2PathVccTpList", coordinator), coordinator);
    }

    private void addPath(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException, InvalidReferenceException, Aal2PathIdNotUniqueException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (managedObjectArray == null) {
            throw new InvalidReferenceException("Aal2PathDistributionUnit", null);
        }
        Aal2PathDistributionUnitMoImpl.checkAal2PathList(managedObjectArray, coordinator);
        for (int i = 0; i < managedObjectArray.length; ++i) {
            ((Aal2PathVccTpMoImpl)managedObjectArray[i]).reserve(this, coordinator);
        }
        this.addPathFroReq(coordinator, this.getFroId(coordinator), managedObjectArray);
    }

    private void addPathFroReq(Coordinator coordinator, int n, ManagedObject[] managedObjectArray) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<ArrayParameter> arrayList = new ArrayList<ArrayParameter>();
        ArrayParameter arrayParameter = this.makeStructArrayParameter(managedObjectArray, coordinator);
        arrayList.add(arrayParameter);
        this.aal2PduProxy.actionWithCfm(coordinator, n, 1, arrayList);
    }

    public void actionRemovePath(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException, InvalidReferenceException, OperationNotAllowedException {
        this.removePath(managedObjectArray, coordinator);
        ((Aal2ApMoImpl)this.getParent()).dependentAttributeValueChange(coordinator);
        this.sendNotification("aal2PathVccTpList", this.getAttribute("aal2PathVccTpList", coordinator), coordinator);
    }

    private void removePath(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException, InvalidReferenceException, OperationNotAllowedException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ManagedObject[] managedObjectArray2 = (ManagedObject[])this.getAttribute("aal2PathVccTpList", coordinator);
        if (managedObjectArray == null || managedObjectArray.length == 0) {
            throw new InvalidReferenceException("Aal2PathDistributionUnit", (Object)this);
        }
        Aal2PathDistributionUnitMoImpl.checkAal2PathList(managedObjectArray, coordinator);
        int[] nArray = new int[managedObjectArray.length];
        boolean bl = false;
        for (int i = 0; i < managedObjectArray.length; ++i) {
            for (int j = 0; j < managedObjectArray2.length; ++j) {
                if (!managedObjectArray[i].equals(managedObjectArray2[j])) continue;
                if ((Integer)((Aal2PathVccTpMoImpl)managedObjectArray[i]).getAttribute("administrativeState", coordinator) == 0) {
                    ((Aal2PathVccTpMoImpl)managedObjectArray[i]).release(this, coordinator);
                    nArray[i] = (Integer)((Aal2PathVccTpMoImpl)managedObjectArray[i]).getAttribute("aal2pepFroId", coordinator);
                    bl = true;
                    break;
                }
                throw new OperationNotAllowedException("AdmState of" + (Aal2PathVccTpMoImpl)managedObjectArray[i] + "is not Locked ", "Aal2PathDistributionUnit");
            }
            if (bl) continue;
            throw new InvalidReferenceException("Aal2PathDistributionUnit", (Object)this);
        }
        if (nArray.length > 0) {
            this.removePathFroReq(coordinator, this.getFroId(coordinator), nArray);
        }
    }

    private void removePathFroReq(Coordinator coordinator, int n, int[] nArray) throws MoAccessException {
        ArrayList<ArrayParameter> arrayList = new ArrayList<ArrayParameter>();
        ArrayParameter arrayParameter = new ArrayParameter("aal2PathEpFroIdArray");
        for (int i = 0; i < nArray.length; ++i) {
            UnsignedIntParameter unsignedIntParameter = new UnsignedIntParameter("aal2PathEpFroId", (long)nArray[i]);
            arrayParameter.add((Parameter)unsignedIntParameter);
        }
        arrayList.add(arrayParameter);
        this.aal2PduProxy.actionWithCfm(coordinator, n, 2, arrayList);
    }

    public ManagedObject[] actionAal2PduReservingRpu(int n, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ArrayList<UnsignedIntParameter> arrayList = new ArrayList<UnsignedIntParameter>();
        arrayList.add(new UnsignedIntParameter("rpuId", (long)n));
        Map map = this.aal2PduProxy.actionWithCfm(coordinator, this.getFroId(coordinator), 3, arrayList);
        ArrayParameter arrayParameter = (ArrayParameter)map.get("listOfPdusReservingRpu");
        ManagedObject[] managedObjectArray = this.getAal2PduArray(arrayParameter, coordinator);
        return managedObjectArray;
    }

    public String getAal2PathDistributionUnitId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("Aal2PathDistributionUnitId", coordinator);
    }

    public ManagedObject getRpuId(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("rpuId", coordinator);
    }

    public void setRpuId(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("rpuId", managedObject, coordinator);
    }

    public ManagedObject[] getAal2PathVccTpList(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject[])this.getAttribute("aal2PathVccTpList", coordinator);
    }

    public void setAal2PathVccTpList(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("aal2PathVccTpList", managedObjectArray, coordinator);
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? Aal2PathDistributionUnitMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "Aal2PathDistributionUnit");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"Aal2PathDistributionUnit", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("rpuId")) {
                if (objectArray[i] == null) {
                    throw new WrongAttributeTypeException("ReliableProgramUniterId", "Aal2PathDistributionUnit");
                }
                if (!((ManagedObject)objectArray[i]).getType().equals("ReliableProgramUniter")) {
                    throw new WrongAttributeTypeException("ReliableProgramUniterId", "Aal2PathDistributionUnit");
                }
                object = (String)((ReliableProgramUniterMo)objectArray[i]).getAttribute("reliableProgramLabel", coordinator);
                String string = null;
                if (this.getAttribute("rpuId", coordinator) != null) {
                    string = (String)((ReliableProgramUniterMo)this.getAttribute("rpuId", coordinator)).getAttribute("reliableProgramLabel", coordinator);
                }
                if (string != null && !((String)object).equals(string)) {
                    throw new ConfigurationMismatchException("New ReliableProgramUniter must have the same reliableProgramLabel as the old one has." + string, "Aal2PathDistributionUnit");
                }
                ArrayList<UnsignedIntParameter> arrayList = new ArrayList<UnsignedIntParameter>();
                int n = (int)((ReliableProgramUniterMo)objectArray[i]).getRpuId(coordinator);
                arrayList.add(new UnsignedIntParameter("rpuId", (long)n));
                this.aal2PduProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
                this.sendNotification("rpuId", objectArray[i], coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("aal2PathVccTpList")) {
                object = this.getPathsToAddOrRemove((ManagedObject[])this.getAttribute("aal2PathVccTpList", coordinator), (ManagedObject[])objectArray[i]);
                if (((ManagedObject[])object).length > 0) {
                    this.removePath((ManagedObject[])object, coordinator);
                }
                if (((Object)(object = this.getPathsToAddOrRemove((ManagedObject[])objectArray[i], (ManagedObject[])this.getAttribute("aal2PathVccTpList", coordinator)))).length > 0) {
                    this.addPath((ManagedObject[])object, coordinator);
                }
                ((Aal2ApMoImpl)this.getParent()).dependentAttributeValueChange(coordinator);
                this.sendNotification("aal2PathVccTpList", objectArray[i], coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Aal2PathDistributionUnit");
        }
    }

    private ManagedObject[] getPathsToAddOrRemove(ManagedObject[] managedObjectArray, ManagedObject[] managedObjectArray2) throws MoAccessException {
        int n;
        ArrayList<ManagedObject> arrayList = new ArrayList<ManagedObject>();
        for (int i = 0; i < managedObjectArray.length; ++i) {
            boolean bl = true;
            for (n = 0; n < managedObjectArray2.length; ++n) {
                if (!managedObjectArray[i].equals(managedObjectArray2[n])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(managedObjectArray[i]);
        }
        Object[] objectArray = arrayList.toArray();
        ManagedObject[] managedObjectArray3 = new ManagedObject[objectArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            managedObjectArray3[n] = (ManagedObject)objectArray[n];
        }
        return managedObjectArray3;
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = this.aal2PduProxy.getAttributes(coordinator, this.getFroId(coordinator));
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("froId")) {
                int n = this.getFroId(coordinator);
                objectArray[i] = new Integer(n);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("rpuId")) {
                UnsignedIntParameter unsignedIntParameter = (UnsignedIntParameter)map.get("rpuId");
                if (unsignedIntParameter.getValue() == 0L) {
                    objectArray[i] = null;
                    continue;
                }
                object = (ReliableProgramUniterRepository)this.getMaoContext().getServiceRepository().getService(class$se$ericsson$cello$swmanagement$ReliableProgramUniterRepository == null ? Aal2PathDistributionUnitMoImpl.class$("se.ericsson.cello.swmanagement.ReliableProgramUniterRepository") : class$se$ericsson$cello$swmanagement$ReliableProgramUniterRepository);
                if (object != null) {
                    objectArray[i] = object.lookupInstance((int)unsignedIntParameter.getValue(), coordinator);
                    continue;
                }
                MessageLog.traceError(this.getClass(), (String)"ReliableProgramUniterRepository not registered in ServiceRepository.");
                objectArray[i] = null;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("aal2PathVccTpList")) {
                objectArray[i] = new ManagedObject[0];
                ArrayParameter arrayParameter = (ArrayParameter)map.get("aal2PathListDataArray");
                if (arrayParameter == null || arrayParameter.size() <= 0) continue;
                object = this.getPathFroIdArray(arrayParameter);
                objectArray[i] = this.getPathObjectArray((int[])object, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "Aal2PathDistributionUnit");
        }
        return objectArray;
    }

    public void checkPathId(int[] nArray, Coordinator coordinator) throws MoAccessException, Aal2PathIdNotUniqueException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        ManagedObject[] managedObjectArray = (ManagedObject[])this.getAttribute("aal2PathVccTpList", coordinator);
        if (nArray != null && managedObjectArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                for (int j = 0; j < managedObjectArray.length; ++j) {
                    if (nArray[i] != ((Aal2PathVccTpMoImpl)managedObjectArray[j]).getAal2PathId(coordinator)) continue;
                    throw new Aal2PathIdNotUniqueException("Aal2PathDistributionUnit", nArray[i]);
                }
            }
        }
    }

    public String getType() {
        return "Aal2PathDistributionUnit";
    }

    private ManagedObject[] getPathObjectArray(int[] nArray, Coordinator coordinator) throws MoAccessException, ConfigurationMismatchException {
        ManagedObject[] managedObjectArray = null;
        if (nArray != null) {
            managedObjectArray = new ManagedObject[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                managedObjectArray[i] = Aal2PathVccTpMoImpl.lookupInstance(nArray[i], coordinator);
                if (managedObjectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch attribute aal2PathVccTpList", "Aal2PathDistributionUnit");
            }
        } else {
            return null;
        }
        return managedObjectArray;
    }

    private int[] getPathFroIdArray(ArrayParameter arrayParameter) throws MoAccessException {
        if (arrayParameter != null) {
            int[] nArray = new int[arrayParameter.size()];
            for (int i = 0; i < arrayParameter.size(); ++i) {
                StructParameter structParameter = (StructParameter)arrayParameter.get(i);
                nArray[i] = (int)((UnsignedIntParameter)structParameter.get("aal2PathEpFroId")).getValue();
            }
            return nArray;
        }
        return null;
    }

    private static void checkAal2PathList(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        Aal2PathDistributionUnitMoImpl.checkTypesInList(managedObjectArray);
        Aal2PathDistributionUnitMoImpl.checkUniquePathInList(managedObjectArray, coordinator);
    }

    private static void checkUniquePathInList(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException, ValueOutOfRangeException {
        for (int i = 0; i < managedObjectArray.length - 1; ++i) {
            for (int j = i + 1; j < managedObjectArray.length; ++j) {
                int n = ((Aal2PathVccTpMoImpl)managedObjectArray[i]).getAal2PathId(coordinator);
                if (n == ((Aal2PathVccTpMoImpl)managedObjectArray[j]).getAal2PathId(coordinator)) {
                    throw new Aal2PathIdNotUniqueException("Aal2PathDistributionUnit", n);
                }
                if (!managedObjectArray[i].equals(managedObjectArray[j])) continue;
                throw new ValueOutOfRangeException("aal2PathVccTpList", "Aal2PathDistributionUnit");
            }
        }
    }

    private static void checkTypesInList(ManagedObject[] managedObjectArray) throws MoAccessException, WrongAttributeTypeException {
        for (int i = 0; i < managedObjectArray.length; ++i) {
            if (managedObjectArray[i] != null && managedObjectArray[i].getType().equals("Aal2PathVccTp")) continue;
            throw new WrongAttributeTypeException("Aal2PathDistributionUnit", "aal2PathVccTpList");
        }
    }

    private static void checkRpu(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException, MoCanNotBeCreatedException {
        if (!((ReliableProgramUniterMoInternal)managedObject).checkRpuUsage(coordinator)) {
            MessageLog.info((Class)Aal2PathDistributionUnitMoImpl.class, (String)"Aal2PathDistributionMo not possible to create - The RPU is not used");
            throw new MoCanNotBeCreatedException("Aal2PathDistributionUnit");
        }
    }

    private static ManagedObject[] checkAndGetAal2PathVccTpList(AttrList attrList, Coordinator coordinator) throws MoAccessException {
        int n = attrList.indexOf("aal2PathVccTpList");
        if (n == -1) {
            return null;
        }
        if (!(attrList.getValue(n) instanceof ManagedObject[])) {
            throw new WrongAttributeTypeException("aal2PathVccTpList", "Aal2PathDistributionUnit");
        }
        ManagedObject[] managedObjectArray = (ManagedObject[])attrList.getValue(n);
        Aal2PathDistributionUnitMoImpl.checkAal2PathList(managedObjectArray, coordinator);
        attrList.removeElementAt(n);
        return managedObjectArray;
    }

    private ArrayParameter makeStructArrayParameter(ManagedObject[] managedObjectArray, Coordinator coordinator) throws MoAccessException {
        ArrayParameter arrayParameter = new ArrayParameter("aal2PathListDataArray");
        if (managedObjectArray != null) {
            Aal2PathVccTpMoImpl aal2PathVccTpMoImpl = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (int i = 0; i < managedObjectArray.length; ++i) {
                StructParameter structParameter = new StructParameter("aal2PathListData");
                aal2PathVccTpMoImpl = (Aal2PathVccTpMoImpl)managedObjectArray[i];
                n = (Integer)aal2PathVccTpMoImpl.getAttribute("aal2pepFroId", coordinator);
                n2 = (Integer)aal2PathVccTpMoImpl.getAttribute("aal2PathId", coordinator);
                n3 = MaoFroTypeConverter.boolean2int((boolean)((Boolean)aal2PathVccTpMoImpl.getAttribute("aal2PathOwner", coordinator)));
                structParameter.add((Parameter)new UnsignedIntParameter("aal2PathEpFroId", (long)n));
                structParameter.add((Parameter)new UnsignedIntParameter("aal2PathId", (long)n2));
                structParameter.add((Parameter)new UnsignedIntParameter("aal2PathOwner", (long)n3));
                arrayParameter.add((Parameter)structParameter);
            }
        }
        return arrayParameter;
    }

    private ManagedObject[] getAal2PduArray(ArrayParameter arrayParameter, Coordinator coordinator) throws MoAccessException, ConfigurationMismatchException {
        ManagedObject[] managedObjectArray = null;
        if (arrayParameter != null) {
            managedObjectArray = new ManagedObject[arrayParameter.size()];
            for (int i = 0; i < arrayParameter.size(); ++i) {
                managedObjectArray[i] = Aal2PathDistributionUnitMoImpl.lookupInstance((int)((UnsignedIntParameter)arrayParameter.get(i)).getValue(), coordinator);
                if (managedObjectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Invalid froId " + ((UnsignedIntParameter)arrayParameter.get(i)).getValue() + ", received from ANS_A2PDUMI.", "Aal2PathDistributionUnit");
            }
            return managedObjectArray;
        }
        return null;
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public static Aal2PathDistributionUnitMoImpl lookupInstance(int n, Coordinator coordinator) throws MoAccessException {
        return (Aal2PathDistributionUnitMoImpl)froIdTable.get(n, coordinator);
    }
}

