/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.atm.aal2;

import enea.ose.system.Signal;
import java.util.ArrayList;
import se.ericsson.cello.atm.aal2.Aal2ApMo;
import se.ericsson.cello.atm.aal2.Aal2ApMoImpl;
import se.ericsson.cello.atm.aal2.Aal2RoutingCaseMo;
import se.ericsson.cello.atm.aal2.InvalidPriorityException;
import se.ericsson.cello.atm.aal2.fropxy.AnsA2RcMiChangeDataRcFroRsp;
import se.ericsson.cello.atm.aal2.fropxy.AnsAal2RoutingCaseCreateFroRsp;
import se.ericsson.cello.atm.aal2.fropxy.AnsAal2RoutingCaseDeleteFroRsp;
import se.ericsson.cello.atm.aal2.fropxy.AnsAal2RoutingCaseGetAttrRsp;
import se.ericsson.cello.atm.aal2.fropxy.AnsAal2RoutingCaseProxy;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.IllegalAttributeValueException;
import se.ericsson.cello.mao.MaxNumberExceededException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.IllegalArgumentTypeException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class Aal2RoutingCaseMoImpl
extends ManagedObjectBase
implements Aal2RoutingCaseMo {
    private Aal2ApMo rcAal2Ap;
    private MoData data;
    private StringAttribute userLabel;
    private IntegerAttribute routingCaseFroId;
    private static AnsAal2RoutingCaseProxy aal2RoutingCaseProxy = AnsAal2RoutingCaseProxy.instance();
    private static final String ROUTING_CASE_FRO_ID = "routingCaseFroId";
    private static final String AAL2_ROUTING_CASE_PARENT_TYPE_NAME = "TransportNetwork";
    private static final int MO_DATA_REVISION_2_6_1 = 1;
    private static final int MO_DATA_REVISION_3_2 = 3020;
    private static final int MO_DATA_REVISION_LATEST = 3020;
    private static final int ZERO = 0;
    private static final int ROUTE_LIST_MIN_LENGTH = 0;
    private static final int ROUTE_LIST_MAX_LENGTH = 5;
    private static final int MIN_PRIORITY = 1;
    private static final int MAX_PRIORITY = 5;
    private static final int MAX_NO_OF_AAL2_ROUTINGCASE = 2000;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)AAL2_ROUTING_CASE_PARENT_TYPE_NAME);
        MoAttributeValidator.checkIdentity((String)"Aal2RoutingCase", (String)string);
        MoIterator moIterator = MoRepository.instance().lookupType("Aal2RoutingCase");
        if (moIterator != null && moIterator.size() >= 2000) {
            throw new MaxNumberExceededException("Max number of Aal2RoutingCases is exceeded", "Aal2RoutingCase");
        }
        String string2 = Aal2RoutingCaseMoImpl.checkAndGetNumberDirection(attrList);
        String string3 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"Aal2RoutingCase", (int)128, (int)0);
        ManagedObject[] managedObjectArray = Aal2RoutingCaseMoImpl.checkAndGetRouteList(attrList);
        int[] nArray = Aal2RoutingCaseMoImpl.checkAndGetRoutePriorityList(attrList);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"Aal2RoutingCase");
        Aal2RoutingCaseMoImpl aal2RoutingCaseMoImpl = new Aal2RoutingCaseMoImpl(managedObject, string3, string2, managedObjectArray, nArray, string, managedObject2, coordinator);
        return aal2RoutingCaseMoImpl;
    }

    private Aal2RoutingCaseMoImpl(ManagedObject managedObject, String string, String string2, ManagedObject[] managedObjectArray, int[] nArray, String string3, ManagedObject managedObject2, Coordinator coordinator) throws MoAccessException {
        super(managedObject, "Aal2RoutingCase", string3, coordinator);
        int n;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.userLabel = new StringAttribute("userLabel", true, string);
        this.data.registerPersistentAttr((Attribute)this.userLabel);
        this.routingCaseFroId = new IntegerAttribute(ROUTING_CASE_FRO_ID, false);
        this.data.registerPersistentAttr((Attribute)this.routingCaseFroId);
        if (managedObjectArray.length != nArray.length) {
            throw new IllegalAttributeValueException("The length of routeList and routePriorityList differs", "Aal2RoutingCase");
        }
        for (int i = 0; i < managedObjectArray.length; ++i) {
            ((Reservable)managedObjectArray[i]).reserve((ManagedObject)this, coordinator);
        }
        int[] nArray2 = new int[managedObjectArray.length];
        for (int i = 0; i < managedObjectArray.length; ++i) {
            nArray2[i] = ((Aal2ApMoImpl)managedObjectArray[i]).getAal2ApFroId(coordinator);
        }
        int[] nArray3 = new int[5];
        int[] nArray4 = new int[5];
        if (managedObjectArray.length != 5) {
            int n2;
            n = 0;
            for (n2 = 0; n2 < managedObjectArray.length; ++n2) {
                nArray3[n2] = nArray2[n2];
                nArray4[n2] = nArray[n2];
                ++n;
            }
            for (n2 = n + 1; n2 < 5; ++n2) {
                nArray3[n2] = 0;
                nArray4[n2] = 0;
            }
            nArray2 = nArray3;
            nArray = nArray4;
        }
        n = this.createRoutingCaseFro(coordinator, nArray2, nArray, string2);
        this.routingCaseFroId.setValue(n);
        this.data.setRevision(3020);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public Aal2RoutingCaseMoImpl(MoData moData) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(3020);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute(ROUTING_CASE_FRO_ID);
        this.userLabel = (StringAttribute)moData.getAttribute("userLabel");
        this.routingCaseFroId = (IntegerAttribute)moData.getAttribute(ROUTING_CASE_FRO_ID);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        int n;
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ManagedObject[] managedObjectArray = this.getRouteList(coordinator);
        int n2 = managedObjectArray.length;
        if (n2 != 0) {
            for (n = 0; n < managedObjectArray.length; ++n) {
                this.rcAal2Ap = (Aal2ApMo)managedObjectArray[n];
                this.rcAal2Ap.release(this, coordinator);
            }
        }
        n = this.getRoutingCaseFroId(coordinator);
        this.deleteRoutingCaseFro(n, coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.userLabel.getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        MoAttributeValidator.checkStringWithLength((String)string, (String)"userLabel", (String)"Aal2RoutingCase", (int)128, (int)0);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.userLabel.setValue(string);
    }

    public String getNumberDirection(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AnsAal2RoutingCaseGetAttrRsp ansAal2RoutingCaseGetAttrRsp = this.retrieveFroAttributes(coordinator);
        int[] nArray = ansAal2RoutingCaseGetAttrRsp.getNumberDirection();
        int n = 0;
        while (nArray[n] != 0) {
            ++n;
        }
        if (n < 1) {
            n = 1;
        } else if (n > 38) {
            n = 38;
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)nArray[i];
        }
        return new String(cArray);
    }

    public int getRoutingCaseFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return this.routingCaseFroId.getValue(coordinator);
    }

    public ManagedObject[] getRouteList(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AnsAal2RoutingCaseGetAttrRsp ansAal2RoutingCaseGetAttrRsp = this.retrieveFroAttributes(coordinator);
        int[] nArray = ansAal2RoutingCaseGetAttrRsp.getListOfApFro();
        ArrayList<Aal2ApMoImpl> arrayList = new ArrayList<Aal2ApMoImpl>();
        Aal2ApMoImpl aal2ApMoImpl = null;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            aal2ApMoImpl = Aal2ApMoImpl.lookupInstance(nArray[i], coordinator);
            if (aal2ApMoImpl == null) {
                throw new ConfigurationMismatchException("Attribute routeList failed to locate Aal2Ap reference with froId " + nArray[i], "Aal2RoutingCase");
            }
            arrayList.add(aal2ApMoImpl);
        }
        return arrayList.toArray(new ManagedObject[0]);
    }

    public int[] getRoutePriorityList(Coordinator coordinator) throws MoAccessException, IllegalAttributeValueException {
        int n;
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AnsAal2RoutingCaseGetAttrRsp ansAal2RoutingCaseGetAttrRsp = this.retrieveFroAttributes(coordinator);
        int[] nArray = ansAal2RoutingCaseGetAttrRsp.getPrioToApFro();
        boolean bl = false;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == 0) continue;
            bl = true;
        }
        if (!bl) {
            int[] nArray2 = new int[]{};
            return nArray2;
        }
        n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            ++n;
        }
        int[] nArray3 = new int[n];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            nArray3[n2] = nArray[i];
            ++n2;
        }
        return nArray3;
    }

    public String getType() {
        return "Aal2RoutingCase";
    }

    private static String checkAndGetNumberDirection(AttrList attrList) throws MoAccessException {
        String string = "0123456789abcdefABCDEF";
        int n = attrList.indexOf("numberDirection");
        if (n == -1) {
            throw new AttrMissingAtCreateException("numberDirection", "Aal2RoutingCase");
        }
        if (attrList.getValue(n) == null) {
            throw new ValueOutOfRangeException("numberDirection", "Aal2RoutingCase");
        }
        if (!(attrList.getValue(n) instanceof String)) {
            throw new WrongAttributeTypeException("numberDirection", "Aal2RoutingCase");
        }
        String string2 = (String)attrList.getValue(n);
        int n2 = string2.length();
        if (n2 < 1 || n2 > 38) {
            throw new ValueOutOfRangeException("numberDirection", "Aal2RoutingCase");
        }
        if (string2.charAt(0) == '0') {
            throw new ValueOutOfRangeException("Not allowed to use leading zeros in numberDirection", "Aal2RoutingCase");
        }
        for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            if (string.indexOf(c) >= 0) continue;
            throw new ValueOutOfRangeException("Only Hex Digits are allowed", "Aal2RoutingCase");
        }
        attrList.removeElementAt(n);
        return string2;
    }

    private static ManagedObject[] checkAndGetRouteList(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("routeList");
        if (n == -1) {
            ManagedObject[] managedObjectArray = new ManagedObject[]{};
            return managedObjectArray;
        }
        if (!(attrList.getValue(n) instanceof ManagedObject[])) {
            throw new WrongAttributeTypeException("routeList", "Aal2RoutingCase");
        }
        ManagedObject[] managedObjectArray = (ManagedObject[])attrList.getValue(n);
        int n2 = managedObjectArray.length;
        if (n2 < 0 || n2 > 5) {
            throw new ValueOutOfRangeException("Aal2RoutingCase", "routeList");
        }
        for (int i = 0; i < n2 - 1; ++i) {
            for (int j = i + 1; j < n2; ++j) {
                if (managedObjectArray[i] != managedObjectArray[j]) continue;
                throw new ValueOutOfRangeException("Aal2RoutingCase", "routeList");
            }
        }
        attrList.removeElementAt(n);
        return managedObjectArray;
    }

    private static int[] checkAndGetRoutePriorityList(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("routePriorityList");
        if (n == -1) {
            int[] nArray = new int[]{};
            return nArray;
        }
        if (!(attrList.getValue(n) instanceof int[])) {
            throw new WrongAttributeTypeException("routePriorityList", "Aal2RoutingCase");
        }
        int[] nArray = (int[])attrList.getValue(n);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 1 && nArray[i] <= 5) continue;
            throw new ValueOutOfRangeException("routePriorityList", "Aal2RoutingCase");
        }
        attrList.removeElementAt(n);
        return nArray;
    }

    public void actionAddAal2ApToRc(int n, ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n2;
        int n3;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (n < 1 || n > 5) {
            throw new InvalidPriorityException("Aal2RoutingCase", n);
        }
        if (!(managedObject instanceof Aal2ApMoImpl)) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "Trying to add a MAO which is not Aal2Ap.");
        }
        AnsAal2RoutingCaseGetAttrRsp ansAal2RoutingCaseGetAttrRsp = this.retrieveFroAttributes(coordinator);
        int[] nArray = ansAal2RoutingCaseGetAttrRsp.getListOfApFro();
        int[] nArray2 = ansAal2RoutingCaseGetAttrRsp.getPrioToApFro();
        int n4 = ((Aal2ApMoImpl)managedObject).getAal2ApFroId(coordinator);
        for (n3 = 0; n3 < nArray.length; ++n3) {
            if (nArray[n3] != n4) continue;
            throw new IllegalAttributeValueException("The Aal2Ap you are trying to add is already in the list.", "Aal2RoutingCase");
        }
        n3 = 0;
        for (n2 = 0; n2 < 5; ++n2) {
            if (nArray[n2] != 0) continue;
            n3 = 1;
            nArray[n2] = n4;
            nArray2[n2] = n;
            break;
        }
        if (n3 == 0) {
            throw new IllegalAttributeValueException("The number of Aal2Ap's in the list is 5. It is not possible to add another one.", "Aal2RoutingCase");
        }
        n2 = this.getRoutingCaseFroId(coordinator);
        this.sendDataChangeRequest(coordinator.getTransactionID(), n2, nArray, nArray2);
        ((Reservable)managedObject).reserve((ManagedObject)this, coordinator);
        this.sendNotificationsForRouteList(this.getRouteList(coordinator), coordinator);
        this.sendNotificationsForRoutePriorityList(this.getRoutePriorityList(coordinator), coordinator);
    }

    public void actionRemoveAal2ApFromRc(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        int n;
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (!(managedObject instanceof Aal2ApMoImpl)) {
            throw new IllegalArgumentTypeException((ManagedObject)this, "Trying to remove a MAO which is not Aal2Ap.");
        }
        AnsAal2RoutingCaseGetAttrRsp ansAal2RoutingCaseGetAttrRsp = this.retrieveFroAttributes(coordinator);
        int[] nArray = ansAal2RoutingCaseGetAttrRsp.getListOfApFro();
        int[] nArray2 = ansAal2RoutingCaseGetAttrRsp.getPrioToApFro();
        boolean bl = false;
        int n2 = ((Aal2ApMoImpl)managedObject).getAal2ApFroId(coordinator);
        for (n = 0; n < 5; ++n) {
            if (nArray[n] != n2) continue;
            bl = true;
            nArray[n] = 0;
            nArray2[n] = 0;
            break;
        }
        if (!bl) {
            throw new IllegalAttributeValueException("The Aal2Ap entered is not in the Routing list.", "Aal2RoutingCase");
        }
        n = this.getRoutingCaseFroId(coordinator);
        this.sendDataChangeRequest(coordinator.getTransactionID(), n, nArray, nArray2);
        ((Reservable)managedObject).release((ManagedObject)this, coordinator);
        this.sendNotificationsForRouteList(this.getRouteList(coordinator), coordinator);
        this.sendNotificationsForRoutePriorityList(this.getRoutePriorityList(coordinator), coordinator);
    }

    private int createRoutingCaseFro(Coordinator coordinator, int[] nArray, int[] nArray2, String string) throws MoAccessException {
        AnsAal2RoutingCaseCreateFroRsp ansAal2RoutingCaseCreateFroRsp = aal2RoutingCaseProxy.sendCreateFroReq(coordinator.getTransactionID(), nArray, nArray2, string);
        if (ansAal2RoutingCaseCreateFroRsp == null) {
            throw new FroNotAccessibleException("Aal2RoutingCase", "ANS_A2RCMI_SERVICE_NAME_2");
        }
        int n = ansAal2RoutingCaseCreateFroRsp.getResult();
        switch (n) {
            case 2: {
                throw new FroRequestFailedException("Aal2RoutingCase", "Aal2RoutingCase", "CreateFroReq: " + aal2RoutingCaseProxy.getResultMsg(ansAal2RoutingCaseCreateFroRsp.getResult()), ansAal2RoutingCaseCreateFroRsp.getResult());
            }
            case 1: {
                break;
            }
            default: {
                throw new FroRequestFailedException("Aal2RoutingCase", "Aal2RoutingCase", "CreateFroReq: " + aal2RoutingCaseProxy.getResultMsg(ansAal2RoutingCaseCreateFroRsp.getResult()), ansAal2RoutingCaseCreateFroRsp.getResult());
            }
        }
        return ansAal2RoutingCaseCreateFroRsp.getFroId();
    }

    private void sendDataChangeRequest(int n, int n2, int[] nArray, int[] nArray2) throws MoAccessException {
        AnsA2RcMiChangeDataRcFroRsp ansA2RcMiChangeDataRcFroRsp = aal2RoutingCaseProxy.sendChangeDataReq(n, n2, nArray, nArray2);
        if (ansA2RcMiChangeDataRcFroRsp == null) {
            throw new FroNotAccessibleException("Aal2RoutingCase", "ANS_A2RCMI_SERVICE_NAME_2");
        }
        int n3 = ansA2RcMiChangeDataRcFroRsp.getResult();
        switch (n3) {
            case 2: {
                throw new FroRequestFailedException("Aal2RoutingCase", "Aal2RoutingCase", "AddRouteReq: " + aal2RoutingCaseProxy.getResultMsg(ansA2RcMiChangeDataRcFroRsp.getResult()), ansA2RcMiChangeDataRcFroRsp.getResult());
            }
            case 1: {
                break;
            }
            default: {
                throw new FroRequestFailedException("Aal2RoutingCase", "Aal2RoutingCase", "AddRouteReq: " + aal2RoutingCaseProxy.getResultMsg(ansA2RcMiChangeDataRcFroRsp.getResult()), ansA2RcMiChangeDataRcFroRsp.getResult());
            }
        }
    }

    private void deleteRoutingCaseFro(int n, Coordinator coordinator) throws MoAccessException {
        AnsAal2RoutingCaseDeleteFroRsp ansAal2RoutingCaseDeleteFroRsp = aal2RoutingCaseProxy.sendDeleteFroReq(n, coordinator.getTransactionID());
        if (ansAal2RoutingCaseDeleteFroRsp == null) {
            throw new FroNotAccessibleException("Aal2RoutingCase", "ANS_A2RCMI_SERVICE_NAME_2");
        }
        int n2 = ansAal2RoutingCaseDeleteFroRsp.getResult();
        if (n2 != 1) {
            throw new FroRequestFailedException("Aal2RoutingCase", "Aal2RoutingCase", "DeleteFroReq: " + aal2RoutingCaseProxy.getResultMsg(ansAal2RoutingCaseDeleteFroRsp.getResult()), ansAal2RoutingCaseDeleteFroRsp.getResult());
        }
    }

    private AnsAal2RoutingCaseGetAttrRsp retrieveFroAttributes(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        AnsAal2RoutingCaseGetAttrRsp ansAal2RoutingCaseGetAttrRsp = aal2RoutingCaseProxy.sendGetAttrReq(MoAttributeValidator.getTransactionId((Coordinator)coordinator), this.routingCaseFroId.getValue(coordinator));
        Aal2RoutingCaseMoImpl.checkSignal((Signal)ansAal2RoutingCaseGetAttrRsp);
        int n = ansAal2RoutingCaseGetAttrRsp.getResult();
        if (n != 1) {
            throw new FroRequestFailedException("Aal2RoutingCase", "Aal2RoutingCase", "GetAttrReq: " + aal2RoutingCaseProxy.getResultMsg(ansAal2RoutingCaseGetAttrRsp.getResult()), ansAal2RoutingCaseGetAttrRsp.getResult());
        }
        return ansAal2RoutingCaseGetAttrRsp;
    }

    static void checkSignal(Signal signal) throws FroNotAccessibleException {
        if (signal == null) {
            FroNotAccessibleException froNotAccessibleException = new FroNotAccessibleException("Aal2RoutingCase", "ANS_A2RCMI_SERVICE_NAME_2");
            throw froNotAccessibleException;
        }
    }

    private void sendNotificationsForRouteList(ManagedObject[] managedObjectArray, Coordinator coordinator) {
        String[] stringArray = new String[]{"routeList"};
        Object[] objectArray = new Object[]{managedObjectArray};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    private void sendNotificationsForRoutePriorityList(int[] nArray, Coordinator coordinator) {
        String[] stringArray = new String[]{"routePriorityList"};
        Object[] objectArray = new Object[]{nArray};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }
}

