/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.atm.atm;

import java.util.ArrayList;
import java.util.Map;
import se.ericsson.cello.atm.atm.AtmCrossConnectionMo;
import se.ericsson.cello.atm.atm.AtmInfoExtend;
import se.ericsson.cello.atm.atm.VclTpMo;
import se.ericsson.cello.atm.atm.VclTpMoImpl;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class AtmCrossConnectionMoImpl
extends CelloMao
implements AtmCrossConnectionMo {
    private MoData data;
    private FroProxy genAtmccProxy = null;
    private AtmInfoExtend atmInfoExtend = new AtmInfoExtend();
    private static final int MO_DATA_REVISION_51 = 5100;
    private static final int MO_DATA_REVISION_LATEST = 5100;
    protected static final String VCCP_FRO_ID_A = "vcCpFroIdA";
    protected static final String VCCP_FRO_ID_B = "vcCpFroIdB";
    protected static final String ATM_CC_FRO_ID = "AtmCcFroId";
    private static final String ATM_INFO = "atmInfo";
    static /* synthetic */ Class class$java$lang$String;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"TransportNetwork");
        MoAttributeValidator.checkIdentity((String)"AtmCrossConnection", (String)string);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"AtmCrossConnection", (int)128, (int)0);
        ManagedObject managedObject3 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"vclTpAId", (AttrList)attrList, (boolean)true, (Class)VclTpMo.class, (String)"AtmCrossConnection");
        ManagedObject managedObject4 = MoAttributeValidator.checkAndGetReferenceAttribute((String)"vclTpBId", (AttrList)attrList, (boolean)true, (Class)VclTpMo.class, (String)"AtmCrossConnection");
        if (managedObject3 == managedObject4) {
            throw new ValueOutOfRangeException("AtmCrossConnection", "vclTpAId and vclTpBId can not refer to the same object");
        }
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"AtmCrossConnection");
        return new AtmCrossConnectionMoImpl(managedObject, string, string2, (VclTpMoImpl)managedObject3, (VclTpMoImpl)managedObject4, coordinator, initialMaoContext, froProxy);
    }

    private AtmCrossConnectionMoImpl(ManagedObject managedObject, String string, String string2, VclTpMoImpl vclTpMoImpl, VclTpMoImpl vclTpMoImpl2, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoAccessException {
        super(managedObject, "AtmCrossConnection", string, coordinator, initialMaoContext);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        vclTpMoImpl.reserve(this, coordinator);
        vclTpMoImpl2.reserve(this, coordinator);
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        this.genAtmccProxy = froProxy;
        arrayList.add(new SignedIntParameter(VCCP_FRO_ID_A, vclTpMoImpl.getFroId(coordinator)));
        arrayList.add(new SignedIntParameter(VCCP_FRO_ID_B, vclTpMoImpl2.getFroId(coordinator)));
        FroData froData = this.genAtmccProxy.create(coordinator, arrayList);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(ATM_CC_FRO_ID, false, froData.getFroId()));
        this.data.setRevision(5100);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public AtmCrossConnectionMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.data = moData;
        this.genAtmccProxy = froProxy;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(5100);
        moDataRecoveryHelper.assertAttribute(ATM_CC_FRO_ID);
        moDataRecoveryHelper.assertAttribute("userLabel");
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        VclTpMoImpl vclTpMoImpl = (VclTpMoImpl)this.getAttribute("vclTpAId", coordinator);
        vclTpMoImpl.release(this, coordinator);
        VclTpMoImpl vclTpMoImpl2 = (VclTpMoImpl)this.getAttribute("vclTpBId", coordinator);
        vclTpMoImpl2.release(this, coordinator);
        this.genAtmccProxy.delete(coordinator, this.getFroId(coordinator), null);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public String getAtmCrossConnectionId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("AtmCrossConnectionId", coordinator);
    }

    public ManagedObject getVclTpAId(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("vclTpAId", coordinator);
    }

    public ManagedObject getVclTpBId(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("vclTpBId", coordinator);
    }

    public void setVclTpAId(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("vclTpAId", managedObject, coordinator);
    }

    public void setVclTpBId(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("vclTpBId", managedObject, coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = this.genAtmccProxy.getAttributes(coordinator, this.getFroId(coordinator));
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                signedIntParameter = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("vclTpAId")) {
                signedIntParameter = (SignedIntParameter)map.get(VCCP_FRO_ID_A);
                objectArray[i] = VclTpMoImpl.lookupInstance(signedIntParameter.getValue(), coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch vclTpAId reference ", "AtmCrossConnection", "vclTpAId");
            }
            if (stringArray[i].equalsIgnoreCase("vclTpBId")) {
                signedIntParameter = (SignedIntParameter)map.get(VCCP_FRO_ID_B);
                objectArray[i] = VclTpMoImpl.lookupInstance(signedIntParameter.getValue(), coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch vclTpBId reference ", "AtmCrossConnection", "vclTpBId");
            }
            if (stringArray[i].equalsIgnoreCase(ATM_INFO)) {
                objectArray[i] = this.atmInfoExtend.getAtmCrossConnectionData(coordinator, this);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "AtmCrossConnection");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? AtmCrossConnectionMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "AtmCrossConnection");
                }
            } else {
                throw new NoSuchAttributeException(stringArray[i], "AtmCrossConnection");
            }
            MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"AtmCrossConnection", (int)128, (int)0);
            ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
        }
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    public String getType() {
        return "AtmCrossConnection";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(ATM_CC_FRO_ID)).getValue(coordinator);
    }
}

