/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.atm.atm;

import se.ericsson.cello.atm.atm.AtmCrossConnectionMo;
import se.ericsson.cello.atm.atm.AtmPortMoImpl;
import se.ericsson.cello.atm.atm.ImaGroupMo;
import se.ericsson.cello.atm.atm.VclTpMoImpl;
import se.ericsson.cello.atm.atm.VpcTpMoImpl;
import se.ericsson.cello.atm.atm.VplTpMoImpl;
import se.ericsson.cello.atm.terminations.Aal1TpVccTpMo;
import se.ericsson.cello.atm.terminations.Aal1TpVccTpMoInterface;
import se.ericsson.cello.atm.terminations.Ds0BundleMo;
import se.ericsson.cello.equipment.SlotMo;
import se.ericsson.cello.equipment.SubrackMo;
import se.ericsson.cello.mao.ImpossibleCollectAtmInfoException;
import se.ericsson.cello.mao.OperationalState;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.pdhsdhtrans.E1PhysPathTermMo;
import se.ericsson.cello.pdhsdhtrans.E3PhysPathTermMo;
import se.ericsson.cello.pdhsdhtrans.J1PhysPathTermMo;
import se.ericsson.cello.pdhsdhtrans.Os155SpiTtpMo;
import se.ericsson.cello.pdhsdhtrans.PDHPhysPathTermInfo;
import se.ericsson.cello.pdhsdhtrans.T1PhysPathTermMo;
import se.ericsson.cello.pdhsdhtrans.T3PhysPathTermMo;
import se.ericsson.cello.transaction.Coordinator;

public class AtmInfoExtend {
    private static final String LINE_NO = "lineNo";
    private static final String BOARD_TYPE = "boardType";
    private static final String SLOT_NUMBER = "slotNumber";
    private static final String PPT_TYPE = "pptType";
    private static String[] aal0Names = new String[]{"userLabel", "operationalState", "reservedBy", "externalVci", "externalVpi", "pptType", "lineNo", "boardType", "slotNumber", "cabinetPosition", "subrackPosition", "sts1SpeTtpId", "ds0BundleId", "vc12TpId"};
    private static String[] aal5Names = new String[]{"userLabel", "operationalState", "reservedBy", "externalVci", "externalVpi", "pptType", "lineNo", "boardType", "slotNumber", "cabinetPosition", "subrackPosition", "sts1SpeTtpId", "ds0BundleId", "vc12TpId"};
    private static String[] ds0Names = new String[]{"userLabel", "operationalState", "reservedBy", "pptType", "lineNo", "boardType", "slotNumber", "cabinetPosition", "subrackPosition", "sts1SpeTtpId"};
    private static String[] aal1Names = new String[]{"userLabel", "operationalState", "externalVci", "externalVpi", "pptType_Aal1", "lineNo_Aal1", "boardType_Aal1", "slotNumber_Aal1", "cabinetPosition_Aal1", "subrackPosition_Aal1", "pptType_Ds0", "lineNo_Ds0", "boardType_Ds0", "slotNumber_Ds0", "cabinetPosition_Ds0", "subrackPosition_Ds0", "sts1SpeTtpId_Aal1", "sts1SpeTtpId_Ds0", "ds0BundleId_Aal1", "ds0BundleId_Ds0", "vc12TpId_Aal1", "vc12TpId_Ds0"};
    private static String[] aal2PathNames = new String[]{"userLabel", "operationalState", "administrativeState", "reservedBy", "externalVci", "externalVpi", "pptType", "lineNo", "boardType", "slotNumber", "cabinetPosition", "subrackPosition", "sts1SpeTtpId", "ds0BundleId", "vc12TpId"};
    private static String[] AtmCCNames = new String[]{"userLabel", "operationalState", "externalVci_A", "externalVpi_A", "pptType_A", "lineNo_A", "boardType_A", "slotNumber_A", "cabinetPosition_A", "subrackPosition_A", "externalVci_B", "externalVpi_B", "pptType_B", "lineNo_B", "boardType_B", "slotNumber_B", "cabinetPosition_B", "subrackPosition_B", "sts1SpeTtpId_A", "sts1SpeTtpId_B", "ds0BundleId_A", "ds0BundleId_B", "vc12TpId_A", "vc12TpId_B"};

    public Struct getAal0TpVccTpData(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        SlotMo slotMo;
        if (!managedObject.getType().equals("Aal0TpVccTp")) {
            throw new ValueOutOfRangeException(this.getClass().getName(), "Aal0TpVccTp");
        }
        Object[] objectArray = new Object[14];
        objectArray[0] = managedObject.getAttribute("userLabel", coordinator);
        objectArray[1] = managedObject.getAttribute("operationalState", coordinator);
        objectArray[2] = managedObject.getAttribute("reservedBy", coordinator);
        VclTpMoImpl vclTpMoImpl = (VclTpMoImpl)managedObject.getAttribute("vclTpId", coordinator);
        objectArray[3] = vclTpMoImpl.getAttribute("externalVci", coordinator);
        VplTpMoImpl vplTpMoImpl = (VplTpMoImpl)((VpcTpMoImpl)vclTpMoImpl.getParent()).getParent();
        objectArray[4] = new Integer(vplTpMoImpl.getExternalVpi(coordinator));
        AtmPortMoImpl atmPortMoImpl = (AtmPortMoImpl)vplTpMoImpl.getParent();
        ManagedObject managedObject2 = (ManagedObject)atmPortMoImpl.getAttribute("uses", coordinator);
        objectArray[5] = this.getPptType(coordinator, managedObject2);
        objectArray[6] = this.getLineNo(coordinator, managedObject2);
        objectArray[7] = this.getBoardType(coordinator, managedObject2);
        ManagedObject managedObject3 = this.getMoBoard(coordinator, managedObject2);
        if (null == managedObject3) {
            objectArray[8] = new Integer(0);
            objectArray[9] = "";
            objectArray[10] = "";
        } else {
            slotMo = (SlotMo)this.getSlot(managedObject3);
            SubrackMo subrackMo = (SubrackMo)slotMo.getParent();
            objectArray[8] = new Integer(slotMo.getSlotNumber(coordinator));
            objectArray[9] = subrackMo.getCabinetPosition(coordinator);
            objectArray[10] = subrackMo.getSubrackPosition(coordinator);
        }
        objectArray[11] = this.getSts1SpeTtpId(managedObject2);
        objectArray[12] = this.getDs0BundleId(managedObject2);
        objectArray[13] = this.getVc12TtpId(managedObject2);
        slotMo = new StructImpl(aal0Names, objectArray);
        return slotMo;
    }

    private ManagedObject getSlot(ManagedObject managedObject) throws MoAccessException {
        ManagedObject managedObject2 = null;
        if (managedObject.getType().equals("ExchangeTerminal") && managedObject.getParent().getType().equals("Cbu")) {
            ManagedObject managedObject3 = managedObject.getParent();
            managedObject2 = managedObject3.getParent().getParent();
        } else {
            managedObject2 = managedObject.getParent().getParent();
        }
        return managedObject2;
    }

    public Struct getAal5TpVccTpData(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        SlotMo slotMo;
        if (!managedObject.getType().equals("Aal5TpVccTp")) {
            throw new ValueOutOfRangeException(this.getClass().getName(), "Aal5TpVccTp");
        }
        Object[] objectArray = new Object[14];
        objectArray[0] = managedObject.getAttribute("userLabel", coordinator);
        objectArray[1] = managedObject.getAttribute("operationalState", coordinator);
        objectArray[2] = managedObject.getAttribute("reservedBy", coordinator);
        VclTpMoImpl vclTpMoImpl = (VclTpMoImpl)managedObject.getAttribute("vclTpId", coordinator);
        objectArray[3] = vclTpMoImpl.getAttribute("externalVci", coordinator);
        VplTpMoImpl vplTpMoImpl = (VplTpMoImpl)((VpcTpMoImpl)vclTpMoImpl.getParent()).getParent();
        objectArray[4] = new Integer(vplTpMoImpl.getExternalVpi(coordinator));
        AtmPortMoImpl atmPortMoImpl = (AtmPortMoImpl)vplTpMoImpl.getParent();
        ManagedObject managedObject2 = (ManagedObject)atmPortMoImpl.getAttribute("uses", coordinator);
        objectArray[5] = this.getPptType(coordinator, managedObject2);
        objectArray[6] = this.getLineNo(coordinator, managedObject2);
        objectArray[7] = this.getBoardType(coordinator, managedObject2);
        ManagedObject managedObject3 = this.getMoBoard(coordinator, managedObject2);
        if (null == managedObject3) {
            objectArray[8] = new Integer(0);
            objectArray[9] = "";
            objectArray[10] = "";
        } else {
            slotMo = (SlotMo)this.getSlot(managedObject3);
            SubrackMo subrackMo = (SubrackMo)slotMo.getParent();
            objectArray[8] = new Integer(slotMo.getSlotNumber(coordinator));
            objectArray[9] = subrackMo.getCabinetPosition(coordinator);
            objectArray[10] = subrackMo.getSubrackPosition(coordinator);
        }
        objectArray[11] = this.getSts1SpeTtpId(managedObject2);
        objectArray[12] = this.getDs0BundleId(managedObject2);
        objectArray[13] = this.getVc12TtpId(managedObject2);
        slotMo = new StructImpl(aal5Names, objectArray);
        return slotMo;
    }

    public Struct getDs0BundleData(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        SlotMo slotMo;
        if (!managedObject.getType().equals("Ds0Bundle")) {
            throw new ValueOutOfRangeException(this.getClass().getName(), "Ds0Bundle");
        }
        Object[] objectArray = new Object[10];
        Ds0BundleMo ds0BundleMo = (Ds0BundleMo)managedObject;
        objectArray[0] = ds0BundleMo.getUserLabel(coordinator);
        objectArray[1] = new Integer(ds0BundleMo.getOperationalState(coordinator));
        objectArray[2] = ds0BundleMo.getReservedBy(coordinator);
        ManagedObject managedObject2 = managedObject.getParent();
        objectArray[3] = this.getPptType(coordinator, managedObject2);
        objectArray[4] = this.getLineNo(coordinator, managedObject2);
        objectArray[5] = this.getBoardType(coordinator, managedObject2);
        ManagedObject managedObject3 = this.getMoBoard(coordinator, managedObject2);
        if (null == managedObject3) {
            objectArray[6] = new Integer(0);
            objectArray[7] = "";
            objectArray[8] = "";
        } else {
            slotMo = (SlotMo)this.getSlot(managedObject3);
            SubrackMo subrackMo = (SubrackMo)slotMo.getParent();
            objectArray[6] = new Integer(slotMo.getSlotNumber(coordinator));
            objectArray[7] = subrackMo.getCabinetPosition(coordinator);
            objectArray[8] = subrackMo.getSubrackPosition(coordinator);
        }
        objectArray[9] = this.getSts1SpeTtpId(managedObject2);
        slotMo = new StructImpl(ds0Names, objectArray);
        return slotMo;
    }

    public Struct getAal1TpVccTpData(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        SubrackMo subrackMo;
        SlotMo slotMo;
        if (!managedObject.getType().equals("Aal1TpVccTp")) {
            throw new ValueOutOfRangeException(this.getClass().getName(), "Aal1TpVccTp");
        }
        Object[] objectArray = new Object[22];
        objectArray[0] = ((Aal1TpVccTpMo)managedObject).getUserLabel(coordinator);
        objectArray[1] = new Integer(((OperationalState)managedObject).getOperationalState(coordinator));
        VclTpMoImpl vclTpMoImpl = (VclTpMoImpl)((Aal1TpVccTpMoInterface)managedObject).getVclTpId(coordinator);
        objectArray[2] = vclTpMoImpl.getAttribute("externalVci", coordinator);
        VplTpMoImpl vplTpMoImpl = (VplTpMoImpl)((VpcTpMoImpl)vclTpMoImpl.getParent()).getParent();
        objectArray[3] = new Integer(vplTpMoImpl.getExternalVpi(coordinator));
        AtmPortMoImpl atmPortMoImpl = (AtmPortMoImpl)vplTpMoImpl.getParent();
        ManagedObject managedObject2 = (ManagedObject)atmPortMoImpl.getAttribute("uses", coordinator);
        objectArray[4] = this.getPptType(coordinator, managedObject2);
        objectArray[5] = this.getLineNo(coordinator, managedObject2);
        objectArray[6] = this.getBoardType(coordinator, managedObject2);
        ManagedObject managedObject3 = this.getMoBoard(coordinator, managedObject2);
        if (null == managedObject3) {
            objectArray[7] = new Integer(0);
            objectArray[8] = "";
            objectArray[9] = "";
        } else {
            slotMo = (SlotMo)this.getSlot(managedObject3);
            subrackMo = (SubrackMo)slotMo.getParent();
            objectArray[7] = new Integer(slotMo.getSlotNumber(coordinator));
            objectArray[8] = subrackMo.getCabinetPosition(coordinator);
            objectArray[9] = subrackMo.getSubrackPosition(coordinator);
        }
        objectArray[16] = this.getSts1SpeTtpId(managedObject2);
        objectArray[18] = this.getDs0BundleId(managedObject2);
        objectArray[20] = this.getVc12TtpId(managedObject2);
        ManagedObject managedObject4 = ((Aal1TpVccTpMoInterface)managedObject).getDs0BundleId(coordinator);
        managedObject2 = managedObject4.getParent();
        objectArray[10] = this.getPptType(coordinator, managedObject2);
        objectArray[11] = this.getLineNo(coordinator, managedObject2);
        objectArray[12] = this.getBoardType(coordinator, managedObject2);
        managedObject3 = this.getMoBoard(coordinator, managedObject2);
        if (null == managedObject3) {
            objectArray[13] = new Integer(0);
            objectArray[14] = "";
            objectArray[15] = "";
        } else {
            slotMo = (SlotMo)this.getSlot(managedObject3);
            subrackMo = (SubrackMo)slotMo.getParent();
            objectArray[13] = new Integer(slotMo.getSlotNumber(coordinator));
            objectArray[14] = subrackMo.getCabinetPosition(coordinator);
            objectArray[15] = subrackMo.getSubrackPosition(coordinator);
        }
        objectArray[17] = this.getSts1SpeTtpId(managedObject2);
        objectArray[19] = managedObject4.getNamingAttributeValue();
        objectArray[21] = this.getVc12TtpId(managedObject2);
        StructImpl structImpl = new StructImpl(aal1Names, objectArray);
        return structImpl;
    }

    public Struct getAtmCrossConnectionData(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        SubrackMo subrackMo;
        SlotMo slotMo;
        if (!(managedObject instanceof AtmCrossConnectionMo)) {
            throw new ValueOutOfRangeException(this.getClass().getName(), "AtmCrossConnection");
        }
        Object[] objectArray = new Object[24];
        objectArray[0] = managedObject.getAttribute("userLabel", coordinator);
        objectArray[1] = managedObject.getAttribute("operationalState", coordinator);
        VclTpMoImpl vclTpMoImpl = (VclTpMoImpl)managedObject.getAttribute("vclTpAId", coordinator);
        objectArray[2] = vclTpMoImpl.getAttribute("externalVci", coordinator);
        VplTpMoImpl vplTpMoImpl = (VplTpMoImpl)((VpcTpMoImpl)vclTpMoImpl.getParent()).getParent();
        objectArray[3] = new Integer(vplTpMoImpl.getExternalVpi(coordinator));
        AtmPortMoImpl atmPortMoImpl = (AtmPortMoImpl)vplTpMoImpl.getParent();
        ManagedObject managedObject2 = (ManagedObject)atmPortMoImpl.getAttribute("uses", coordinator);
        objectArray[4] = this.getPptType(coordinator, managedObject2);
        objectArray[5] = this.getLineNo(coordinator, managedObject2);
        objectArray[6] = this.getBoardType(coordinator, managedObject2);
        ManagedObject managedObject3 = this.getMoBoard(coordinator, managedObject2);
        if (null == managedObject3) {
            objectArray[7] = new Integer(0);
            objectArray[8] = "";
            objectArray[9] = "";
        } else {
            slotMo = (SlotMo)this.getSlot(managedObject3);
            subrackMo = (SubrackMo)slotMo.getParent();
            objectArray[7] = new Integer(slotMo.getSlotNumber(coordinator));
            objectArray[8] = subrackMo.getCabinetPosition(coordinator);
            objectArray[9] = subrackMo.getSubrackPosition(coordinator);
        }
        objectArray[18] = this.getSts1SpeTtpId(managedObject2);
        objectArray[20] = this.getDs0BundleId(managedObject2);
        objectArray[22] = this.getVc12TtpId(managedObject2);
        VclTpMoImpl vclTpMoImpl2 = (VclTpMoImpl)managedObject.getAttribute("vclTpBId", coordinator);
        objectArray[10] = vclTpMoImpl2.getAttribute("externalVci", coordinator);
        VplTpMoImpl vplTpMoImpl2 = (VplTpMoImpl)((VpcTpMoImpl)vclTpMoImpl2.getParent()).getParent();
        objectArray[11] = new Integer(vplTpMoImpl2.getExternalVpi(coordinator));
        atmPortMoImpl = (AtmPortMoImpl)vplTpMoImpl2.getParent();
        managedObject2 = (ManagedObject)atmPortMoImpl.getAttribute("uses", coordinator);
        objectArray[12] = this.getPptType(coordinator, managedObject2);
        objectArray[13] = this.getLineNo(coordinator, managedObject2);
        objectArray[14] = this.getBoardType(coordinator, managedObject2);
        managedObject3 = this.getMoBoard(coordinator, managedObject2);
        if (null == managedObject3) {
            objectArray[15] = new Integer(0);
            objectArray[16] = "";
            objectArray[17] = "";
        } else {
            slotMo = (SlotMo)this.getSlot(managedObject3);
            subrackMo = (SubrackMo)slotMo.getParent();
            objectArray[15] = new Integer(slotMo.getSlotNumber(coordinator));
            objectArray[16] = subrackMo.getCabinetPosition(coordinator);
            objectArray[17] = subrackMo.getSubrackPosition(coordinator);
        }
        objectArray[19] = this.getSts1SpeTtpId(managedObject2);
        objectArray[21] = this.getDs0BundleId(managedObject2);
        objectArray[23] = this.getVc12TtpId(managedObject2);
        StructImpl structImpl = new StructImpl(AtmCCNames, objectArray);
        return structImpl;
    }

    public Struct getAal2PathVccTpData(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        SlotMo slotMo;
        if (!managedObject.getType().equals("Aal2PathVccTp")) {
            throw new ValueOutOfRangeException(this.getClass().getName(), "Aal2PathVccTp");
        }
        Object[] objectArray = new Object[15];
        objectArray[0] = managedObject.getAttribute("userLabel", coordinator);
        objectArray[1] = managedObject.getAttribute("operationalState", coordinator);
        objectArray[2] = managedObject.getAttribute("administrativeState", coordinator);
        objectArray[3] = managedObject.getAttribute("reservedBy", coordinator);
        VclTpMoImpl vclTpMoImpl = (VclTpMoImpl)managedObject.getAttribute("vclTpId", coordinator);
        objectArray[4] = vclTpMoImpl.getAttribute("externalVci", coordinator);
        VplTpMoImpl vplTpMoImpl = (VplTpMoImpl)((VpcTpMoImpl)vclTpMoImpl.getParent()).getParent();
        objectArray[5] = new Integer(vplTpMoImpl.getExternalVpi(coordinator));
        AtmPortMoImpl atmPortMoImpl = (AtmPortMoImpl)vplTpMoImpl.getParent();
        ManagedObject managedObject2 = (ManagedObject)atmPortMoImpl.getAttribute("uses", coordinator);
        objectArray[6] = this.getPptType(coordinator, managedObject2);
        objectArray[7] = this.getLineNo(coordinator, managedObject2);
        objectArray[8] = this.getBoardType(coordinator, managedObject2);
        ManagedObject managedObject3 = this.getMoBoard(coordinator, managedObject2);
        if (null == managedObject3) {
            objectArray[9] = new Integer(0);
            objectArray[10] = "";
            objectArray[11] = "";
        } else {
            slotMo = (SlotMo)this.getSlot(managedObject3);
            SubrackMo subrackMo = (SubrackMo)slotMo.getParent();
            objectArray[9] = new Integer(slotMo.getSlotNumber(coordinator));
            objectArray[10] = subrackMo.getCabinetPosition(coordinator);
            objectArray[11] = subrackMo.getSubrackPosition(coordinator);
        }
        objectArray[12] = this.getSts1SpeTtpId(managedObject2);
        objectArray[13] = this.getDs0BundleId(managedObject2);
        objectArray[14] = this.getVc12TtpId(managedObject2);
        slotMo = new StructImpl(aal2PathNames, objectArray);
        return slotMo;
    }

    private String getPptType(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        String string = "";
        if (managedObject.getType().equals("J1PhysPathTerm")) {
            string = "J1PhysPathTerm";
        } else if (managedObject.getType().equals("E1PhysPathTerm")) {
            string = "E1PhysPathTerm";
        } else if (managedObject.getType().equals("T1PhysPathTerm")) {
            string = "T1PhysPathTerm";
        } else if (managedObject.getType().equals("Vc4Ttp")) {
            string = "Vc4Ttp";
        } else if (managedObject.getType().equals("Sts3CspeTtp")) {
            string = "Sts3CspeTtp";
        } else if (managedObject.getType().equals("E1Ttp")) {
            string = "E1Ttp";
        } else if (managedObject.getType().equals("E1Ttp")) {
            string = "E1Ttp";
        } else if (managedObject.getType().equals("T1Ttp")) {
            string = "T1Ttp";
        } else if (managedObject.getType().equals("Ds0Bundle")) {
            string = "Ds0Bundle";
        } else if (managedObject.getType().equals("T3PhysPathTerm")) {
            string = "T3PhysPathTerm";
        } else if (managedObject.getType().equals("E3PhysPathTerm")) {
            string = "E3PhysPathTerm";
        } else if (managedObject.getType().equals("HgTtp")) {
            string = "HgTtp";
        } else if (managedObject.getType().equals("ImaGroup")) {
            ManagedObject[] managedObjectArray = ((ImaGroupMo)managedObject).getPhysicalPortList(coordinator);
            if (managedObjectArray.length > 0) {
                string = this.getPptType(coordinator, managedObjectArray[0]);
            }
        } else {
            throw new ImpossibleCollectAtmInfoException(this.getClass().getName() + "getPptType, unknown physical path termination " + managedObject.getType());
        }
        return string;
    }

    private Integer getLineNo(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        Integer n = new Integer(0);
        if (managedObject.getType().equals("J1PhysPathTerm")) {
            n = new Integer(((J1PhysPathTermMo)managedObject).getLineNo(coordinator));
        } else if (managedObject.getType().equals("E1PhysPathTerm")) {
            n = new Integer(((E1PhysPathTermMo)managedObject).getLineNo(coordinator));
        } else if (managedObject.getType().equals("T1PhysPathTerm")) {
            n = new Integer(((T1PhysPathTermMo)managedObject).getLineNo(coordinator));
        } else if (managedObject.getType().equals("T3PhysPathTerm")) {
            n = new Integer(((T3PhysPathTermMo)managedObject).getLineNo(coordinator));
        } else if (managedObject.getType().equals("E3PhysPathTerm")) {
            n = new Integer(((E3PhysPathTermMo)managedObject).getLineNo(coordinator));
        } else if (managedObject.getType().equals("Vc4Ttp")) {
            ManagedObject managedObject2 = managedObject.getParent();
            n = new Integer(((Os155SpiTtpMo)managedObject2).getLineNo(coordinator));
        } else if (managedObject.getType().equals("E1Ttp")) {
            ManagedObject managedObject3 = managedObject.getParent();
            n = new Integer(managedObject3.getNamingAttributeValue());
        } else if (managedObject.getType().equals("T1Ttp")) {
            ManagedObject managedObject4 = managedObject.getParent();
            n = new Integer(managedObject4.getNamingAttributeValue());
        } else if (managedObject.getType().equals("Ds0Bundle")) {
            n = this.getLineNo(coordinator, managedObject.getParent());
        } else if (managedObject.getType().equals("Sts3CspeTtp")) {
            ManagedObject managedObject5 = managedObject.getParent();
            n = new Integer(((Os155SpiTtpMo)managedObject5).getLineNo(coordinator));
        } else if (managedObject.getType().equals("HgTtp")) {
            ManagedObject managedObject6 = managedObject.getParent().getParent().getParent();
            n = new Integer(((Os155SpiTtpMo)managedObject).getLineNo(coordinator));
        } else if (managedObject.getType().equals("ImaGroup")) {
            n = new Integer(0);
        } else {
            throw new ImpossibleCollectAtmInfoException(this.getClass().getName() + "getLineNo, unknown physical path termination " + managedObject.getType());
        }
        return n;
    }

    private String getBoardType(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        ManagedObject managedObject2;
        ManagedObject managedObject3;
        ManagedObject managedObject4;
        String string = "";
        ManagedObject managedObject5 = null;
        if (managedObject.getType().equals("J1PhysPathTerm") || managedObject.getType().equals("E1PhysPathTerm") || managedObject.getType().equals("T1PhysPathTerm")) {
            managedObject5 = managedObject.getParent();
            if (managedObject5.getType().equals("ExchangeTerminal")) {
                string = managedObject5.getParent().getType().equals("Cbu") ? "Cbu" : this.getEtType(coordinator, managedObject5);
            }
        } else if (managedObject.getType().equals("Vc4Ttp")) {
            ManagedObject managedObject6 = managedObject.getParent();
            managedObject5 = managedObject6.getParent();
            if (managedObject5.getType().equals("ExchangeTerminal")) {
                string = this.getEtType(coordinator, managedObject5);
            }
        } else if (managedObject.getType().equals("Sts3CspeTtp")) {
            ManagedObject managedObject7 = managedObject.getParent();
            managedObject5 = managedObject7.getParent();
            if (managedObject5.getType().equals("ExchangeTerminal")) {
                string = this.getEtType(coordinator, managedObject5);
            }
        } else if (managedObject.getType().equals("E1Ttp")) {
            ManagedObject managedObject8 = managedObject.getParent();
            ManagedObject managedObject9 = managedObject8.getParent();
            ManagedObject managedObject10 = managedObject9.getParent();
            managedObject5 = managedObject10.getParent();
            if (managedObject5.getType().equals("ExchangeTerminal")) {
                string = this.getEtType(coordinator, managedObject5);
            }
        } else if (managedObject.getType().equals("T1Ttp")) {
            ManagedObject managedObject11 = managedObject.getParent();
            ManagedObject managedObject12 = managedObject11.getParent();
            ManagedObject managedObject13 = managedObject12.getParent();
            managedObject5 = managedObject13.getParent();
            if (managedObject5.getType().equals("ExchangeTerminal")) {
                string = this.getEtType(coordinator, managedObject5);
            }
        } else if (managedObject.getType().equals("Ds0Bundle")) {
            ManagedObject managedObject14;
            ManagedObject managedObject15;
            ManagedObject managedObject16;
            ManagedObject managedObject17 = managedObject.getParent();
            if (managedObject17 instanceof PDHPhysPathTermInfo) {
                managedObject5 = managedObject17.getParent();
                if (managedObject5.getType().equals("ExchangeTerminal")) {
                    string = this.getEtType(coordinator, managedObject5);
                }
            } else if (managedObject17.getType().equals("E1Ttp")) {
                ManagedObject managedObject18 = managedObject17.getParent();
                ManagedObject managedObject19 = managedObject18.getParent();
                ManagedObject managedObject20 = managedObject19.getParent();
                managedObject5 = managedObject20.getParent();
                if (managedObject5.getType().equals("ExchangeTerminal")) {
                    string = this.getEtType(coordinator, managedObject5);
                }
            } else if (managedObject17.getType().equals("T1Ttp") && (managedObject5 = (managedObject16 = (managedObject15 = (managedObject14 = managedObject17.getParent()).getParent()).getParent()).getParent()).getType().equals("ExchangeTerminal")) {
                string = this.getEtType(coordinator, managedObject5);
            }
        } else if (managedObject.getType().equals("E3PhysPathTerm")) {
            managedObject5 = managedObject.getParent();
            if (managedObject5.getType().equals("ExchangeTerminal")) {
                string = this.getEtType(coordinator, managedObject5);
            }
        } else if (managedObject.getType().equals("T3PhysPathTerm")) {
            managedObject5 = managedObject.getParent();
            if (managedObject5.getType().equals("ExchangeTerminal")) {
                string = this.getEtType(coordinator, managedObject5);
            }
        } else if (managedObject.getType().equals("ImaGroup")) {
            ManagedObject[] managedObjectArray = ((ImaGroupMo)managedObject).getPhysicalPortList(coordinator);
            string = managedObjectArray.length > 0 ? this.getBoardType(coordinator, managedObjectArray[0]) : "ImaGroup";
        } else if (managedObject.getType().equals("HgTtp") && (managedObject5 = (managedObject4 = (managedObject3 = (managedObject2 = managedObject.getParent()).getParent()).getParent()).getParent()).getType().equals("ExchangeTerminal")) {
            string = this.getEtType(coordinator, managedObject5);
        }
        if (string == "") {
            throw new ImpossibleCollectAtmInfoException(this.getClass().getName() + "getBoardType, unknown physical path termination " + managedObject.getType());
        }
        return string;
    }

    private ManagedObject getMoBoard(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        Object object = null;
        if (managedObject.getType().equals("J1PhysPathTerm")) {
            object = managedObject.getParent();
        } else if (managedObject.getType().equals("E1PhysPathTerm")) {
            object = managedObject.getParent();
        } else if (managedObject.getType().equals("T1PhysPathTerm")) {
            object = managedObject.getParent();
        } else if (managedObject.getType().equals("T3PhysPathTerm")) {
            object = managedObject.getParent();
        } else if (managedObject.getType().equals("E3PhysPathTerm")) {
            object = managedObject.getParent();
        } else if (managedObject.getType().equals("Vc4Ttp")) {
            ManagedObject managedObject2 = managedObject.getParent();
            object = managedObject2.getParent();
        } else if (managedObject.getType().equals("E1Ttp")) {
            ManagedObject managedObject3 = managedObject.getParent();
            ManagedObject managedObject4 = managedObject3.getParent();
            ManagedObject managedObject5 = managedObject4.getParent();
            object = managedObject5.getParent();
        } else if (managedObject.getType().equals("HgTtp")) {
            ManagedObject managedObject6 = managedObject.getParent();
            ManagedObject managedObject7 = managedObject6.getParent();
            ManagedObject managedObject8 = managedObject7.getParent();
            object = managedObject8.getParent();
        } else if (managedObject.getType().equals("Ds0Bundle")) {
            ManagedObject managedObject9 = managedObject.getParent();
            if (managedObject9 instanceof PDHPhysPathTermInfo) {
                object = managedObject9.getParent();
            } else if (managedObject9.getType().equals("E1Ttp")) {
                ManagedObject managedObject10 = managedObject9.getParent();
                ManagedObject managedObject11 = managedObject10.getParent();
                ManagedObject managedObject12 = managedObject11.getParent();
                object = managedObject12.getParent();
            } else if (managedObject9.getType().equals("T1Ttp")) {
                ManagedObject managedObject13 = managedObject9.getParent();
                ManagedObject managedObject14 = managedObject13.getParent();
                ManagedObject managedObject15 = managedObject14.getParent();
                object = managedObject15.getParent();
            } else if (managedObject9.getType().equals("HgTtp")) {
                ManagedObject managedObject16 = managedObject9.getParent();
                ManagedObject managedObject17 = managedObject16.getParent();
                ManagedObject managedObject18 = managedObject17.getParent();
                object = managedObject18.getParent();
            }
        } else if (managedObject.getType().equals("Sts3CspeTtp")) {
            ManagedObject managedObject19 = managedObject.getParent();
            object = managedObject19.getParent();
        } else if (managedObject.getType().equals("T1Ttp")) {
            ManagedObject managedObject20 = managedObject.getParent();
            ManagedObject managedObject21 = managedObject20.getParent();
            ManagedObject managedObject22 = managedObject21.getParent();
            object = managedObject22.getParent();
        } else if (managedObject.getType().equals("ImaGroup")) {
            ManagedObject[] managedObjectArray = ((ImaGroupMo)managedObject).getPhysicalPortList(coordinator);
            object = managedObjectArray.length > 0 ? this.getMoBoard(coordinator, managedObjectArray[0]) : null;
        } else {
            throw new ImpossibleCollectAtmInfoException(this.getClass().getName() + "getMoBoard, unknown physical path termination " + managedObject.getType());
        }
        return object;
    }

    private String getEtType(Coordinator coordinator, ManagedObject managedObject) throws MoAccessException {
        StructImpl structImpl = (StructImpl)managedObject.getAttribute("description", coordinator);
        return (String)structImpl.getValue("etType");
    }

    private String getSts1SpeTtpId(ManagedObject managedObject) {
        ManagedObject managedObject2 = managedObject;
        String string = "";
        if (managedObject2.getType().equals("Ds0Bundle")) {
            managedObject2 = managedObject2.getParent();
        }
        if (managedObject2.getType().equals("T1Ttp")) {
            managedObject2 = managedObject2.getParent();
        }
        if (managedObject2.getType().equals("Vt15Ttp")) {
            managedObject2 = managedObject2.getParent();
        }
        if (managedObject2.getType().equals("Sts1SpeTtp")) {
            string = managedObject2.getNamingAttributeValue();
        }
        return string;
    }

    private String getVc12TtpId(ManagedObject managedObject) {
        ManagedObject managedObject2 = managedObject;
        String string = "";
        if (managedObject2.getType().equals("Ds0Bundle")) {
            managedObject2 = managedObject2.getParent();
        }
        if (managedObject2.getType().equals("E1Ttp")) {
            managedObject2 = managedObject2.getParent();
        }
        if (managedObject2.getType().equals("Vc12Ttp")) {
            string = managedObject2.getNamingAttributeValue();
        }
        return string;
    }

    private String getDs0BundleId(ManagedObject managedObject) {
        ManagedObject managedObject2 = managedObject;
        String string = "";
        if (managedObject2.getType().equals("Ds0Bundle")) {
            string = managedObject2.getNamingAttributeValue();
        }
        return string;
    }
}

