/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.atm.atm;

import java.util.ArrayList;
import java.util.Map;
import se.ericsson.cello.atm.atm.AtmPortMo;
import se.ericsson.cello.atm.atm.ImaGroupMoImpl;
import se.ericsson.cello.atm.terminations.Ds0BundleMoImpl;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationHandler;
import se.ericsson.cello.indications.fropxy.MaoFroIndicationSubscriber;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.managedelement.PhysPathTermRepository;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.MaoFroTypeConverter;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.PmData;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.maofro.framework.StructParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.AttrMissingAtCreateException;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.pdhsdhtrans.AtmPortBuildIF;
import se.ericsson.cello.pdhsdhtrans.TrafficReservable;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.transaction.Coordinator;

public class AtmPortMoImpl
extends CelloMao
implements AtmPortMo,
AtmPortBuildIF {
    private MaoFroIndicationHandler indicationHandler = null;
    private FroProxy atmPortProxy = null;
    private static PhysPathTermRepository terms = null;
    private MoData data;
    private static final int MO_DATA_REVISION_30 = 3000;
    private static final int MO_DATA_REVISION_35 = 3500;
    private static final int MO_DATA_REVISION_51 = 5100;
    private static final int MO_DATA_REVISION_LATEST = 5100;
    protected static final String ATM_PORT_FRO_ID = "atmPortFroId";
    protected static final String AET_ATMPORTMI_SERVER_ID = "usesFroId";
    protected static final String AET_ATMPORTMI_SERVER_TYPE = "usesType";
    protected static final String AET_ATMPORTMI_VPI = "vpi";
    protected static final String AET_ATMPORTMI_VCI = "vci";
    protected static final String AET_ATMPORTMI_PTI = "pti";
    private static final String[] VALUE_OF_LAST_CELL_WITH_UNEXP_NAME = new String[]{"vpi", "vci", "pti"};
    private static final boolean DEFAULT_HEC_CORRECTION_MODE = true;
    private static final String DEFAULT_USER_LABEL = "";
    public static final int DEFAULT_LOOPBACK_DETECTION = 0;
    private static final int SERVERTYPE_PHYPORT = 1;
    private static final int SERVERTYPE_DS0BUNDLE = 2;
    private static final int SERVERTYPE_IMAGROUP = 3;
    static /* synthetic */ Class class$java$lang$String;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"TransportNetwork");
        MoAttributeValidator.checkIdentity((String)"AtmPort", (String)string);
        ManagedObject managedObject3 = AtmPortMoImpl.checkAndGetUses(attrList);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)DEFAULT_USER_LABEL, (String)"AtmPort", (int)128, (int)0);
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"hecCorrectionMode", (AttrList)attrList, (boolean)false, (boolean)true, (String)"AtmPort");
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"loopbackDetection", (AttrList)attrList, (boolean)false, (int)0, (int)0, (int)1, (String)"AtmPort");
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"AtmPort");
        return new AtmPortMoImpl(managedObject, managedObject3, string2, bl, n, string, coordinator, initialMaoContext, froProxy, maoFroIndicationHandler);
    }

    private AtmPortMoImpl(ManagedObject managedObject, ManagedObject managedObject2, String string, boolean bl, int n, String string2, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoAccessException {
        super(managedObject, "AtmPort", string2, coordinator, initialMaoContext);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.atmPortProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data.setRevision(5100);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string));
        int n2 = 1;
        int n3 = 0;
        ((TrafficReservable)managedObject2).trafficReserve(coordinator, (ManagedObject)this);
        n3 = ((TrafficReservable)managedObject2).getFroId(coordinator);
        if (((TrafficReservable)managedObject2).getType().equals("Ds0Bundle")) {
            n2 = 2;
        }
        if (((TrafficReservable)managedObject2).getType().equals("ImaGroup")) {
            n2 = 3;
        }
        int n4 = MaoFroTypeConverter.boolean2int((boolean)bl);
        int n5 = this.createAtmPortFro(coordinator, n3, n2, n4, n);
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n5));
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, n5);
    }

    public AtmPortMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy, MaoFroIndicationHandler maoFroIndicationHandler) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.atmPortProxy = froProxy;
        this.indicationHandler = maoFroIndicationHandler;
        this.data = moData;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(5100);
        moDataRecoveryHelper.assertAttribute("froId");
        moDataRecoveryHelper.assertAttribute("userLabel");
        this.indicationHandler.registerForNotifications(null, (MaoFroIndicationSubscriber)this, ((IntegerAttribute)this.data.getAttribute("froId")).getValue(null));
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        MoIterator moIterator = this.getChildren();
        if (moIterator != null && moIterator.size() > 0) {
            throw new MoHasChildrenException((ManagedObject)this);
        }
        ManagedObject managedObject = (ManagedObject)this.getAttribute("uses", coordinator);
        if (managedObject != null) {
            ((TrafficReservable)managedObject).trafficRelease(coordinator, (ManagedObject)this);
        }
        this.atmPortProxy.delete(coordinator, this.getAtmPortFroId(coordinator), null);
        this.indicationHandler.deregisterForNotifications(coordinator, this.getAtmPortFroId(coordinator));
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public int getAtmPortFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }

    public String getAtmPortId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("AtmPortId", coordinator);
    }

    public int getPmTransmittedAtmCells(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmTransmittedAtmCells", coordinator);
    }

    public int getPmReceivedAtmCells(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmReceivedAtmCells", coordinator);
    }

    public Struct getValueOfLastCellWithUnexp(Coordinator coordinator) throws MoAccessException {
        return (Struct)this.getAttribute("valueOfLastCellWithUnexp", coordinator);
    }

    public ManagedObject getUses(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("uses", coordinator);
    }

    public void setUses(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("uses", managedObject, coordinator);
    }

    public int getPmSecondsWithUnexp(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmSecondsWithUnexp", coordinator);
    }

    public boolean getHecCorrectionMode(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("hecCorrectionMode", coordinator);
    }

    public int getLoopbackDetection(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("loopbackDetection", coordinator);
    }

    public void setLoopbackDetection(int n, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("loopbackDetection", new Integer(n), coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = this.atmPortProxy.getAttributes(coordinator, this.getAtmPortFroId(coordinator));
        PmData pmData = this.atmPortProxy.getPmAttributes(coordinator, this.getAtmPortFroId(coordinator));
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("froId")) {
                objectArray[i] = new Integer(((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("loopbackDetection")) {
                signedIntParameter = (SignedIntParameter)map.get("loopbackDetection");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("uses")) {
                int n = ((SignedIntParameter)map.get(AET_ATMPORTMI_SERVER_TYPE)).getValue();
                int n2 = ((SignedIntParameter)map.get(AET_ATMPORTMI_SERVER_ID)).getValue();
                ManagedObjectBase managedObjectBase = null;
                switch (n) {
                    case 2: {
                        managedObjectBase = Ds0BundleMoImpl.lookupInstance(n2, coordinator);
                        break;
                    }
                    case 3: {
                        managedObjectBase = ImaGroupMoImpl.lookupInstance(n2, coordinator);
                        break;
                    }
                    default: {
                        PhysPathTermRepository physPathTermRepository = AtmPortMoImpl.getPhysPathTermRepository();
                        managedObjectBase = physPathTermRepository.lookupInstance(n2, coordinator);
                    }
                }
                if (managedObjectBase == null) {
                    MessageLog.traceError(this.getClass(), (String)("getAttributes uses: corresponding froId=" + n2 + " not found in MO of type=" + n));
                }
                objectArray[i] = managedObjectBase;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("hecCorrectionMode")) {
                signedIntParameter = (SignedIntParameter)map.get("hecCorrectionMode");
                objectArray[i] = MaoFroTypeConverter.int2boolean((int)signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                signedIntParameter = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                signedIntParameter = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmTransmittedAtmCells")) {
                objectArray[i] = new Integer(pmData.getValue("pmTransmittedAtmCells"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmReceivedAtmCells")) {
                objectArray[i] = new Integer(pmData.getValue("pmReceivedAtmCells"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmSecondsWithUnexp")) {
                objectArray[i] = new Integer(pmData.getValue("pmSecondsWithUnexp"));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("valueOfLastCellWithUnexp")) {
                signedIntParameter = (StructParameter)pmData.get("valueOfLastCellWithUnexp");
                objectArray[i] = this.getValueOfLastCellWithUnexp((StructParameter)signedIntParameter);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "AtmPort");
        }
        return objectArray;
    }

    private ManagedObject findMo(String string, int n, Coordinator coordinator) throws MoAccessException {
        ManagedObject managedObject = null;
        MoIterator moIterator = this.getMaoContext().getMoAccessor().lookupType(string);
        while (moIterator != null && moIterator.hasMoreElements()) {
            managedObject = moIterator.nextMo();
            if (((TrafficReservable)managedObject).getFroId(coordinator) != n) continue;
            return managedObject;
        }
        return null;
    }

    public String getType() {
        return "AtmPort";
    }

    private Struct getValueOfLastCellWithUnexp(StructParameter structParameter) throws MoAccessException {
        StructImpl structImpl = null;
        if (structParameter != null) {
            Object[] objectArray = new Object[]{new Integer(((SignedIntParameter)structParameter.get(AET_ATMPORTMI_VPI)).getValue()), new Integer(((SignedIntParameter)structParameter.get(AET_ATMPORTMI_VCI)).getValue()), new Integer(((SignedIntParameter)structParameter.get(AET_ATMPORTMI_PTI)).getValue())};
            structImpl = new StructImpl(VALUE_OF_LAST_CELL_WITH_UNEXP_NAME, objectArray);
        }
        return structImpl;
    }

    private static ManagedObject checkAndGetUses(AttrList attrList) throws MoAccessException {
        int n = attrList.indexOf("uses");
        if (n == -1) {
            throw new AttrMissingAtCreateException("uses", "AtmPort");
        }
        if (!(attrList.getValue(n) instanceof TrafficReservable)) {
            throw new WrongAttributeTypeException("uses", "AtmPort");
        }
        ManagedObject managedObject = (ManagedObject)attrList.getValue(n);
        attrList.removeElementAt(n);
        return managedObject;
    }

    private int createAtmPortFro(Coordinator coordinator, int n, int n2, int n3, int n4) throws MoAccessException {
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        arrayList.add(new SignedIntParameter(AET_ATMPORTMI_SERVER_ID, n));
        arrayList.add(new SignedIntParameter("hecCorrectionMode", n3));
        arrayList.add(new SignedIntParameter(AET_ATMPORTMI_SERVER_TYPE, n2));
        arrayList.add(new SignedIntParameter("loopbackDetection", n4));
        FroData froData = this.atmPortProxy.create(coordinator, arrayList);
        this.indicationHandler.registerForNotifications(coordinator, (MaoFroIndicationSubscriber)this, froData.getFroId());
        return froData.getFroId();
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            ManagedObject managedObject;
            ArrayList<SignedIntParameter> arrayList;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? AtmPortMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "AtmPort");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"AtmPort", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("loopbackDetection")) {
                arrayList = new ArrayList<SignedIntParameter>();
                managedObject = (ManagedObject)this.getAttribute("uses", coordinator);
                int n2 = 1;
                n = 0;
                n = ((TrafficReservable)managedObject).getFroId(coordinator);
                if (((TrafficReservable)managedObject).getType().equals("Ds0Bundle")) {
                    n2 = 2;
                }
                if (((TrafficReservable)managedObject).getType().equals("ImaGroup")) {
                    n2 = 3;
                }
                arrayList.add(new SignedIntParameter(AET_ATMPORTMI_SERVER_ID, n));
                arrayList.add(new SignedIntParameter(AET_ATMPORTMI_SERVER_TYPE, n2));
                arrayList.add(new SignedIntParameter("loopbackDetection", ((Integer)objectArray[i]).intValue()));
                if (arrayList.size() > 0) {
                    this.atmPortProxy.setAttributes(coordinator, this.getAtmPortFroId(coordinator), arrayList);
                }
                this.sendNotification("loopbackDetection", (Integer)objectArray[i], coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("uses")) {
                arrayList = new ArrayList();
                managedObject = (ManagedObject)objectArray[i];
                ManagedObject managedObject2 = (ManagedObject)this.getAttribute("uses", coordinator);
                n = (Integer)this.getAttribute("loopbackDetection", coordinator);
                if (!(managedObject instanceof TrafficReservable)) {
                    throw new WrongAttributeTypeException("uses", "AtmPort");
                }
                if (managedObject2.equals(managedObject)) continue;
                ((TrafficReservable)managedObject2).trafficRelease(coordinator, (ManagedObject)this);
                int n3 = 1;
                int n4 = 0;
                n4 = ((TrafficReservable)managedObject).getFroId(coordinator);
                if (((TrafficReservable)managedObject).getType().equals("Ds0Bundle")) {
                    n3 = 2;
                }
                if (((TrafficReservable)managedObject).getType().equals("ImaGroup")) {
                    n3 = 3;
                }
                arrayList.add(new SignedIntParameter(AET_ATMPORTMI_SERVER_ID, n4));
                arrayList.add(new SignedIntParameter(AET_ATMPORTMI_SERVER_TYPE, n3));
                arrayList.add(new SignedIntParameter("loopbackDetection", n));
                if (arrayList.size() > 0) {
                    this.atmPortProxy.setAttributes(coordinator, this.getAtmPortFroId(coordinator), arrayList);
                }
                if (((TrafficReservable)managedObject2).getType().equals("Ds0Bundle") || ((TrafficReservable)managedObject2).getType().equals("ImaGroup")) {
                    managedObject2.delete(coordinator);
                }
                ((TrafficReservable)managedObject).trafficReserve(coordinator, (ManagedObject)this);
                this.sendNotification("uses", (ManagedObject)objectArray[i], coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "AtmPort");
        }
    }

    private void sendNotification(String string, Object object, Coordinator coordinator) {
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        NotificationSender.instance().pushAVC((ManagedObject)this, stringArray, objectArray, coordinator);
    }

    private static PhysPathTermRepository getPhysPathTermRepository() {
        if (terms == null) {
            terms = (PhysPathTermRepository)ServiceLocatorFacade.getRepository().getService(PhysPathTermRepository.class);
        }
        return terms;
    }
}

