/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.atm.atm;

import java.util.ArrayList;
import java.util.Map;
import se.ericsson.cello.atm.atm.AtmTrafficDescriptorMo;
import se.ericsson.cello.atm.atm.AtmTrafficDescriptorMoImpl;
import se.ericsson.cello.atm.atm.VclTpMo;
import se.ericsson.cello.atm.atm.VpcTpMoImpl;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.AttrValueNotUniqueException;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConcurrentTransactionHandler;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.DynamicReserver;
import se.ericsson.cello.mao.DynamicallyReservable;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.MoReservedNotDeletableException;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.mao.ReservableImpl;
import se.ericsson.cello.mao.TransactionHandler;
import se.ericsson.cello.mao.TransactionalFroIdMap;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.FroRequestFailedException;
import se.ericsson.cello.moframework.InitialMaoContext;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class VclTpMoImpl
extends CelloMao
implements VclTpMo,
Reservable,
FroInfo,
DynamicReserver {
    private MoData data;
    private FroProxy genVcCpProxy;
    private static TransactionalFroIdMap froIds = new TransactionalFroIdMap((TransactionHandler)new ConcurrentTransactionHandler());
    private static final int MO_DATA_REVISION_60 = 6000;
    private static final int MO_DATA_REVISION_LATEST = 6000;
    private static final int AET_VCCPMI_ETE_LOOPBACK = 1;
    private static final int MAX_NO_VCL_TP_PER_NODE = 10000;
    private static final int MAX_NO_VCL_TP_PER_PARENT = 5000;
    private static final int MIN_EXTERNAL_VCI = 32;
    private static final int MAX_EXTERNAL_VCI = 65535;
    private static final boolean DEFAULT_COUNTER_ACTIVATION = false;
    protected static final String VCCP_FRO_ID = "vcCpFroId";
    protected static final String ATMTD_FRO_ID = "atmTDFroId";
    protected static final String VPCEP_FRO_ID = "vpCepFroId";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$se$ericsson$cello$atm$atm$AtmTrafficDescriptorMoImpl;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkIdentity((String)"VclTp", (String)string);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"VpcTp");
        MoAttributeValidator.checkNoOfSiblings((ManagedObject)managedObject, (String)"VclTp", (int)5000);
        MoAttributeValidator.checkCardinality((String)"VclTp", (int)10000);
        int n = MoAttributeValidator.checkAndGetIntegerAttribute((String)"externalVci", (AttrList)attrList, (boolean)true, (int)0, (int)32, (int)65535, (String)"VclTp");
        VclTpMoImpl.checkExternalVciUniqueness(managedObject, n, coordinator);
        boolean bl = MoAttributeValidator.checkAndGetBooleanAttribute((String)"counterActivation", (AttrList)attrList, (boolean)false, (boolean)false, (String)"VclTp");
        AtmTrafficDescriptorMoImpl atmTrafficDescriptorMoImpl = (AtmTrafficDescriptorMoImpl)MoAttributeValidator.checkAndGetReferenceAttribute((String)"atmTrafficDescriptorId", (AttrList)attrList, (boolean)true, (Class)AtmTrafficDescriptorMo.class, (String)"VclTp");
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)"", (String)"VclTp", (int)128, (int)0);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"VclTp");
        return new VclTpMoImpl(managedObject, string2, n, atmTrafficDescriptorMoImpl, bl, string, coordinator, initialMaoContext, froProxy);
    }

    private VclTpMoImpl(ManagedObject managedObject, String string, int n, AtmTrafficDescriptorMoImpl atmTrafficDescriptorMoImpl, boolean bl, String string2, Coordinator coordinator, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoAccessException {
        super(managedObject, "VclTp", string2, coordinator, initialMaoContext);
        this.genVcCpProxy = froProxy;
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        atmTrafficDescriptorMoImpl.reserve(this, coordinator);
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        arrayList.add(new SignedIntParameter("externalVci", n));
        arrayList.add(new SignedIntParameter(VPCEP_FRO_ID, ((VpcTpMoImpl)managedObject).getVpcTpFroId(coordinator)));
        arrayList.add(new SignedIntParameter(ATMTD_FRO_ID, atmTrafficDescriptorMoImpl.getFroId(coordinator)));
        FroData froData = this.genVcCpProxy.create(coordinator, arrayList);
        froIds.put(froData.getFroId(), (ManagedObject)this, coordinator);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string));
        this.data.registerPersistentAttr((Attribute)new ReferenceAttribute("reservedBy", true));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute(VCCP_FRO_ID, false, froData.getFroId()));
        this.data.registerPersistentAttr((Attribute)new BooleanAttribute("counterActivation", true, bl));
        this.data.setRevision(6000);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        if (this.getAttribute("reservedBy", coordinator) != null) {
            throw new MoReservedNotDeletableException("VclTp");
        }
        AtmTrafficDescriptorMoImpl atmTrafficDescriptorMoImpl = (AtmTrafficDescriptorMoImpl)this.getAttribute("atmTrafficDescriptorId", coordinator);
        atmTrafficDescriptorMoImpl.release(this, coordinator);
        this.genVcCpProxy.delete(coordinator, this.getFroId(coordinator), null);
        froIds.remove(this.getFroId(coordinator), coordinator);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public VclTpMoImpl(MoData moData, InitialMaoContext initialMaoContext, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName(), initialMaoContext);
        this.data = moData;
        this.genVcCpProxy = froProxy;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(6000);
        moDataRecoveryHelper.assertAttribute(VCCP_FRO_ID);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("reservedBy");
        moDataRecoveryHelper.assertAttribute("counterActivation");
        froIds.put(((IntegerAttribute)this.data.getAttribute(VCCP_FRO_ID)).getValue(null), (ManagedObject)this);
    }

    public void recoverReservations() throws MoAccessException {
        ManagedObject managedObject = (ManagedObject)this.getAttribute("atmTrafficDescriptorId", null);
        if (managedObject != null && managedObject instanceof DynamicallyReservable) {
            ((DynamicallyReservable)managedObject).recoverReservation((ManagedObject)this);
        }
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("userLabel", coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    public int getAvailabilityStatus(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("availabilityStatus", coordinator);
    }

    public boolean getCounterActivation(Coordinator coordinator) throws MoAccessException {
        return (Boolean)this.getAttribute("counterActivation", coordinator);
    }

    public void setCounterActivation(boolean bl, Coordinator coordinator) throws MoAccessException {
        Boolean bl2 = bl;
        this.setAttribute("counterActivation", bl2, coordinator);
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public String getVclTpId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute("VclTpId", coordinator);
    }

    public int getExternalVci(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("externalVci", coordinator);
    }

    public ManagedObject getReservedBy(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("reservedBy", coordinator);
    }

    public int getPmReceivedAtmCells(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmReceivedAtmCells", coordinator);
    }

    public int getPmTransmittedAtmCells(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("pmTransmittedAtmCells", coordinator);
    }

    public int[] getPmBwUtilizationTx(Coordinator coordinator) throws MoAccessException {
        return (int[])this.getAttribute("pmBwUtilizationTx", coordinator);
    }

    public int[] getPmBwUtilizationRx(Coordinator coordinator) throws MoAccessException {
        return (int[])this.getAttribute("pmBwUtilizationRx", coordinator);
    }

    public ManagedObject getAtmTrafficDescriptorId(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("atmTrafficDescriptorId", coordinator);
    }

    public void setAtmTrafficDescriptorId(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("atmTrafficDescriptorId", managedObject, coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = null;
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            Integer[] integerArray;
            Object object;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("reservedBy")) {
                objectArray[i] = ((ReferenceAttribute)this.data.getAttribute("reservedBy")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                map = this.getAttrFromRes(map, coordinator);
                object = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(object.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("availabilityStatus")) {
                map = this.getAttrFromRes(map, coordinator);
                object = (SignedIntParameter)map.get("availabilityStatus");
                objectArray[i] = new Integer(object.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("counterActivation")) {
                objectArray[i] = ((BooleanAttribute)this.data.getAttribute("counterActivation")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("externalVci")) {
                map = this.getAttrFromRes(map, coordinator);
                object = (SignedIntParameter)map.get("externalVci");
                objectArray[i] = new Integer(object.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("atmTrafficDescriptorId")) {
                map = this.getAttrFromRes(map, coordinator);
                object = (SignedIntParameter)map.get(ATMTD_FRO_ID);
                objectArray[i] = AtmTrafficDescriptorMoImpl.lookupInstance(object.getValue(), coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch atmTrafficDescriptorId reference ", "VclTp", "atmTrafficDescriptorId");
            }
            if (stringArray[i].equalsIgnoreCase("pmTransmittedAtmCells")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmTransmittedAtmCells", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmReceivedAtmCells")) {
                objectArray[i] = new Integer(super.getPmAttribute("pmReceivedAtmCells", coordinator));
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmBwUtilizationTx")) {
                object = super.getPmIntArrayAttribute("pmBwUtilizationTx", coordinator);
                integerArray = new Integer[((SignedIntParameter)object).length];
                for (n = 0; n < ((SignedIntParameter)object).length; ++n) {
                    integerArray[n] = new Integer((int)object[n]);
                }
                objectArray[i] = integerArray;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("pmBwUtilizationRx")) {
                object = super.getPmIntArrayAttribute("pmBwUtilizationRx", coordinator);
                integerArray = new Integer[((SignedIntParameter)object).length];
                for (n = 0; n < ((SignedIntParameter)object).length; ++n) {
                    integerArray[n] = new Integer((int)object[n]);
                }
                objectArray[i] = integerArray;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("currentPmRegister")) {
                objectArray[i] = super.getCurrentPmRegister(coordinator);
                continue;
            }
            throw new NoSuchAttributeException(stringArray[i], "VclTp");
        }
        return objectArray;
    }

    private Map getAttrFromRes(Map map, Coordinator coordinator) throws MoAccessException {
        if (map == null) {
            return this.getVcAttributes(coordinator);
        }
        return map;
    }

    private Map getVcAttributes(Coordinator coordinator) throws MoAccessException {
        Map map = this.genVcCpProxy.getAttributes(coordinator, this.getFroId(coordinator));
        return map;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? VclTpMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "VclTp");
                }
                MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"VclTp", (int)128, (int)0);
                ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("atmTrafficDescriptorId")) {
                if (!objectArray[i].getClass().equals(class$se$ericsson$cello$atm$atm$AtmTrafficDescriptorMoImpl == null ? VclTpMoImpl.class$("se.ericsson.cello.atm.atm.AtmTrafficDescriptorMoImpl") : class$se$ericsson$cello$atm$atm$AtmTrafficDescriptorMoImpl)) {
                    throw new WrongAttributeTypeException("atmTrafficDescriptorId", "VclTp");
                }
                AtmTrafficDescriptorMoImpl atmTrafficDescriptorMoImpl = (AtmTrafficDescriptorMoImpl)this.getAttribute("atmTrafficDescriptorId", coordinator);
                atmTrafficDescriptorMoImpl.release(this, coordinator);
                AtmTrafficDescriptorMoImpl atmTrafficDescriptorMoImpl2 = (AtmTrafficDescriptorMoImpl)objectArray[i];
                atmTrafficDescriptorMoImpl2.reserve(this, coordinator);
                arrayList.add(new SignedIntParameter(ATMTD_FRO_ID, atmTrafficDescriptorMoImpl2.getFroId(coordinator)));
                String[] stringArray2 = new String[]{stringArray[i]};
                Object[] objectArray2 = new Object[]{objectArray[i]};
                NotificationSender.instance().pushAVC((ManagedObject)this, stringArray2, objectArray2, coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("counterActivation")) {
                boolean bl = (Boolean)objectArray[i];
                if (objectArray[i] instanceof Boolean) {
                    boolean bl2 = ((BooleanAttribute)this.data.getAttribute("counterActivation")).getValue(coordinator);
                    if (bl == bl2) continue;
                    ((BooleanAttribute)this.data.getAttribute("counterActivation")).setValue(bl);
                    super.setPdfCounterActivation(bl, coordinator);
                    continue;
                }
                throw new WrongAttributeTypeException("counterActivation", "VclTp");
            }
            throw new NoSuchAttributeException(stringArray[i], "VclTp");
        }
        if (arrayList.size() > 0) {
            this.genVcCpProxy.setAttributes(coordinator, this.getFroId(coordinator), arrayList);
        }
    }

    public boolean actionEteLoopBack(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        try {
            this.genVcCpProxy.actionWithCfm(null, this.getFroId(coordinator), 1, null);
        }
        catch (FroRequestFailedException froRequestFailedException) {
            return false;
        }
        return true;
    }

    public void reserve(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.reserve((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public void release(ManagedObject managedObject, Coordinator coordinator) throws MoAccessException {
        ReservableImpl.release((ManagedObject)managedObject, (Coordinator)coordinator, (MoData)this.data, (String)"reservedBy");
    }

    public String getType() {
        return "VclTp";
    }

    public String[] getCurrentPmRegister(Coordinator coordinator) throws MoAccessException {
        return super.getCurrentPmRegister(coordinator);
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute(VCCP_FRO_ID)).getValue(coordinator);
    }

    private static void checkExternalVciUniqueness(ManagedObject managedObject, int n, Coordinator coordinator) throws MoAccessException {
        MoIterator moIterator = managedObject.getChildren();
        while (moIterator.hasMoreElements()) {
            Integer n2;
            ManagedObject managedObject2 = moIterator.nextMo();
            if (!managedObject2.getType().equals("VclTp") || n != (n2 = (Integer)managedObject2.getAttribute("externalVci", coordinator))) continue;
            throw new AttrValueNotUniqueException("externalVci externalVci is not Unique within the Virtual Path", "VclTp");
        }
    }

    public static VclTpMoImpl lookupInstance(int n, Coordinator coordinator) throws TransactionRequiredException {
        return (VclTpMoImpl)froIds.get(n, coordinator);
    }

    public boolean hasPdfActivationAttribute() throws MoAccessException {
        return true;
    }
}

