/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.atm.terminations;

import java.util.ArrayList;
import java.util.Map;
import se.ericsson.cello.atm.terminations.Ds0BundleMo;
import se.ericsson.cello.atm.terminations.Ds0BundleMoImpl;
import se.ericsson.cello.atm.terminations.TdmCrossConnectionMo;
import se.ericsson.cello.managedelement.MoDataRecoveryHelper;
import se.ericsson.cello.mao.CelloMao;
import se.ericsson.cello.mao.ConfigurationMismatchException;
import se.ericsson.cello.mao.FroInfo;
import se.ericsson.cello.mao.MoAttributeValidator;
import se.ericsson.cello.mao.OperationNotAllowedException;
import se.ericsson.cello.maofro.framework.FroData;
import se.ericsson.cello.maofro.framework.FroProxy;
import se.ericsson.cello.maofro.framework.SignedIntParameter;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.NoSuchAttributeException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.WrongAttributeTypeException;
import se.ericsson.cello.transaction.Coordinator;

public class TdmCrossConnectionMoImpl
extends CelloMao
implements TdmCrossConnectionMo,
FroInfo {
    private MoData data;
    private FroProxy genTdmCcProxy;
    protected static final String DS0BUNDLE_FRO_ID_A = "ds0BundleFroIdA";
    protected static final String DS0BUNDLE_FRO_ID_B = "ds0BundleFroIdB";
    private static final String DEFAULT_USERLABEL = "";
    private static final int MAX_NR_TDMCC = 1500;
    private static String[] Ds0BundleMoClassName = new String[]{"se.ericsson.cello.atm.terminations.Ds0BundleMoImpl"};
    private static final int MO_DATA_REVISION_51 = 5100;
    private static final int MO_DATA_REVISION_LATEST = 5100;
    static /* synthetic */ Class class$java$lang$String;

    public static synchronized ManagedObject create(ManagedObject managedObject, AttrList attrList, String string, ManagedObject managedObject2, Coordinator coordinator, FroProxy froProxy) throws MoAccessException {
        MoAttributeValidator.checkTransaction((Coordinator)coordinator);
        MoAttributeValidator.checkParent((ManagedObject)managedObject, (String)"TransportNetwork");
        MoAttributeValidator.checkIdentity((String)"TdmCrossConnection", (String)string);
        MoAttributeValidator.checkCardinality((String)"TdmCrossConnection", (int)1500);
        String string2 = MoAttributeValidator.checkAndGetStringAttributeWithLength((String)"userLabel", (AttrList)attrList, (boolean)false, (String)DEFAULT_USERLABEL, (String)"TdmCrossConnection", (int)128, (int)0);
        Ds0BundleMoImpl ds0BundleMoImpl = (Ds0BundleMoImpl)MoAttributeValidator.checkAndGetReferenceAttribute((String)"ds0BundleMoRefA", (AttrList)attrList, (boolean)true, (String[])Ds0BundleMoClassName, (String)"TdmCrossConnection");
        Ds0BundleMoImpl ds0BundleMoImpl2 = (Ds0BundleMoImpl)MoAttributeValidator.checkAndGetReferenceAttribute((String)"ds0BundleMoRefB", (AttrList)attrList, (boolean)true, (String[])Ds0BundleMoClassName, (String)"TdmCrossConnection");
        TdmCrossConnectionMoImpl.checkDs0BundleRelation(ds0BundleMoImpl, ds0BundleMoImpl2, coordinator);
        MoAttributeValidator.checkOtherAttributes((AttrList)attrList, (String)"TdmCrossConnection");
        return new TdmCrossConnectionMoImpl(managedObject, string, string2, ds0BundleMoImpl, ds0BundleMoImpl2, coordinator, froProxy);
    }

    private TdmCrossConnectionMoImpl(ManagedObject managedObject, String string, String string2, Ds0BundleMoImpl ds0BundleMoImpl, Ds0BundleMoImpl ds0BundleMoImpl2, Coordinator coordinator, FroProxy froProxy) throws MoAccessException {
        super(managedObject, "TdmCrossConnection", string, coordinator);
        this.data = new MoData(this.getLocalDistinguishedName(), this.getType(), true, coordinator);
        this.genTdmCcProxy = froProxy;
        ds0BundleMoImpl.reserve(this, coordinator);
        ds0BundleMoImpl2.reserve(this, coordinator);
        int n = this.createTdmCcFro(coordinator, ds0BundleMoImpl, ds0BundleMoImpl2);
        this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, string2));
        this.data.registerPersistentAttr((Attribute)new IntegerAttribute("froId", false, n));
        this.data.setRevision(5100);
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
    }

    public TdmCrossConnectionMoImpl(MoData moData, FroProxy froProxy) throws MoNameAlreadyTakenException {
        super(moData.getLocalDistinguishedName());
        this.data = moData;
        this.genTdmCcProxy = froProxy;
        MoDataRecoveryHelper moDataRecoveryHelper = new MoDataRecoveryHelper(this.data, (ManagedObject)this);
        moDataRecoveryHelper.assertMoDataRevision(5100);
        moDataRecoveryHelper.assertAttribute("userLabel");
        moDataRecoveryHelper.assertAttribute("froId");
    }

    private int createTdmCcFro(Coordinator coordinator, Ds0BundleMoImpl ds0BundleMoImpl, Ds0BundleMoImpl ds0BundleMoImpl2) throws MoAccessException {
        ArrayList<SignedIntParameter> arrayList = new ArrayList<SignedIntParameter>();
        arrayList.add(new SignedIntParameter(DS0BUNDLE_FRO_ID_A, ds0BundleMoImpl.getFroId(coordinator)));
        arrayList.add(new SignedIntParameter(DS0BUNDLE_FRO_ID_B, ds0BundleMoImpl2.getFroId(coordinator)));
        FroData froData = this.genTdmCcProxy.create(coordinator, arrayList);
        return froData.getFroId();
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        Ds0BundleMo ds0BundleMo = (Ds0BundleMo)this.getAttribute("ds0BundleMoRefA", coordinator);
        ds0BundleMo.release(this, coordinator);
        Ds0BundleMo ds0BundleMo2 = (Ds0BundleMo)this.getAttribute("ds0BundleMoRefB", coordinator);
        ds0BundleMo2.release(this, coordinator);
        this.genTdmCcProxy.delete(coordinator, this.getFroId(coordinator), null);
        super.delete(coordinator);
        this.data.delete(coordinator);
    }

    public String getTdmCrossConnectionId(Coordinator coordinator) throws MoAccessException {
        return (String)this.getAttribute(this.getType() + "Id", coordinator);
    }

    public ManagedObject getDs0BundleMoRefB(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("ds0BundleMoRefB", coordinator);
    }

    public ManagedObject getDs0BundleMoRefA(Coordinator coordinator) throws MoAccessException {
        return (ManagedObject)this.getAttribute("ds0BundleMoRefA", coordinator);
    }

    public Object getAttribute(String string, Coordinator coordinator) throws MoAccessException, NoSuchAttributeException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = this.getAttributes(stringArray, coordinator);
        return objectArray[0];
    }

    public Object[] getAttributes(String[] stringArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        Object[] objectArray = new Object[stringArray.length];
        Map map = this.genTdmCcProxy.getAttributes(coordinator, this.getFroId(coordinator));
        for (int i = 0; i < stringArray.length; ++i) {
            SignedIntParameter signedIntParameter;
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                objectArray[i] = ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase(this.getType() + "Id")) {
                objectArray[i] = super.getNamingAttributeValue();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("operationalState")) {
                signedIntParameter = (SignedIntParameter)map.get("operationalState");
                objectArray[i] = new Integer(signedIntParameter.getValue());
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("ds0BundleMoRefA")) {
                signedIntParameter = (SignedIntParameter)map.get(DS0BUNDLE_FRO_ID_A);
                objectArray[i] = Ds0BundleMoImpl.lookupInstance(signedIntParameter.getValue(), coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch ds0BundleMoRefA reference ", "TdmCrossConnection", "ds0BundleMoRefA");
            }
            if (stringArray[i].equalsIgnoreCase("ds0BundleMoRefB")) {
                signedIntParameter = (SignedIntParameter)map.get(DS0BUNDLE_FRO_ID_B);
                objectArray[i] = Ds0BundleMoImpl.lookupInstance(signedIntParameter.getValue(), coordinator);
                if (objectArray[i] != null) continue;
                throw new ConfigurationMismatchException("Failed to fetch ds0BundleMoRefB reference ", "TdmCrossConnection", "ds0BundleMoRefB");
            }
            throw new NoSuchAttributeException(stringArray[i], "TdmCrossConnection");
        }
        return objectArray;
    }

    public void setAttribute(String string, Object object, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        String[] stringArray = new String[]{string};
        Object[] objectArray = new Object[]{object};
        this.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(String[] stringArray, Object[] objectArray, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("userLabel")) {
                if (!objectArray[i].getClass().equals(class$java$lang$String == null ? TdmCrossConnectionMoImpl.class$("java.lang.String") : class$java$lang$String)) {
                    throw new WrongAttributeTypeException("userLabel", "TdmCrossConnection");
                }
            } else {
                throw new NoSuchAttributeException(stringArray[i], "TdmCrossConnection");
            }
            MoAttributeValidator.checkStringWithLength((String)((String)objectArray[i]), (String)"userLabel", (String)"TdmCrossConnection", (int)128, (int)0);
            ((StringAttribute)this.data.getAttribute("userLabel")).setValue((String)objectArray[i]);
        }
    }

    public int getOperationalState(Coordinator coordinator) throws MoAccessException {
        return (Integer)this.getAttribute("operationalState", coordinator);
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.setAttribute("userLabel", string, coordinator);
    }

    private static void checkDs0BundleRelation(Ds0BundleMo ds0BundleMo, Ds0BundleMo ds0BundleMo2, Coordinator coordinator) throws MoAccessException {
        if (ds0BundleMo == ds0BundleMo2) {
            throw new OperationNotAllowedException("ds0BundleMoRefA and ds0BundleMoRefB can not refer to the same object", "TdmCrossConnection");
        }
        if (!ds0BundleMo.getTdmMode(coordinator) || !ds0BundleMo2.getTdmMode(coordinator)) {
            throw new OperationNotAllowedException("tdmMode must be enabled for ds0BundleMoRefA and ds0BundleMoRefB", "TdmCrossConnection");
        }
    }

    public String getType() {
        return "TdmCrossConnection";
    }

    public int getFroId(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((IntegerAttribute)this.data.getAttribute("froId")).getValue(coordinator);
    }
}

